package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAntChainContractContent invokes the baas.CreateAntChainContractContent API synchronously
// api document: https://help.aliyun.com/api/baas/createantchaincontractcontent.html
func (client *Client) CreateAntChainContractContent(request *CreateAntChainContractContentRequest) (response *CreateAntChainContractContentResponse, err error) {
	response = CreateCreateAntChainContractContentResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAntChainContractContentWithChan invokes the baas.CreateAntChainContractContent API asynchronously
// api document: https://help.aliyun.com/api/baas/createantchaincontractcontent.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateAntChainContractContentWithChan(request *CreateAntChainContractContentRequest) (<-chan *CreateAntChainContractContentResponse, <-chan error) {
	responseChan := make(chan *CreateAntChainContractContentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAntChainContractContent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAntChainContractContentWithCallback invokes the baas.CreateAntChainContractContent API asynchronously
// api document: https://help.aliyun.com/api/baas/createantchaincontractcontent.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateAntChainContractContentWithCallback(request *CreateAntChainContractContentRequest, callback func(response *CreateAntChainContractContentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAntChainContractContentResponse
		var err error
		defer close(result)
		response, err = client.CreateAntChainContractContent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAntChainContractContentRequest is the request struct for api CreateAntChainContractContent
type CreateAntChainContractContentRequest struct {
	*requests.RpcRequest
	Content         string           `position:"Body" name:"Content"`
	ParentContentId string           `position:"Body" name:"ParentContentId"`
	ProjectId       string           `position:"Body" name:"ProjectId"`
	ContentName     string           `position:"Body" name:"ContentName"`
	IsDirectory     requests.Boolean `position:"Body" name:"IsDirectory"`
}

// CreateAntChainContractContentResponse is the response struct for api CreateAntChainContractContent
type CreateAntChainContractContentResponse struct {
	*responses.BaseResponse
	RequestId string                                `json:"RequestId" xml:"RequestId"`
	Result    ResultInCreateAntChainContractContent `json:"Result" xml:"Result"`
}

// CreateCreateAntChainContractContentRequest creates a request to invoke CreateAntChainContractContent API
func CreateCreateAntChainContractContentRequest() (request *CreateAntChainContractContentRequest) {
	request = &CreateAntChainContractContentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "CreateAntChainContractContent", "baas", "openAPI")
	return
}

// CreateCreateAntChainContractContentResponse creates a response to parse from CreateAntChainContractContent response
func CreateCreateAntChainContractContentResponse() (response *CreateAntChainContractContentResponse) {
	response = &CreateAntChainContractContentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
