/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2023 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * XenodreambuieV2
 * @reference
 *https://fractalforums.org/share-a-fractal/22/new-mandelbulb-variant/5083

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_xenodreambuie_v2.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 XenodreambuieV2Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL t; // temp
	if (fractal->transformCommon.functionEnabledPFalse
			&& aux->i >= fractal->transformCommon.startIterationsP
			&& aux->i < fractal->transformCommon.stopIterationsP)
	{
		if (fractal->transformCommon.functionEnabledCxFalse) z.x = fabs(z.x);
		if (fractal->transformCommon.functionEnabledCyFalse) z.y = fabs(z.y);
		if (fractal->transformCommon.functionEnabledCzFalse) z.z = fabs(z.z);
		z += fractal->transformCommon.offsetA000;

		if (fractal->transformCommon.functionEnabledTFalse)
		{
			aux->r = length(z);
		}
	}

	if (!fractal->transformCommon.functionEnabledSwFalse)
		t = asin(z.z / aux->r);
	else
		t = acos(z.z / aux->r);
	REAL th =
		(t + fractal->bulb.betaAngleOffset) * fractal->bulb.power * fractal->transformCommon.scaleA1;
	REAL ph = (atan2(z.y, z.x) + fractal->bulb.alphaAngleOffset) * fractal->bulb.power
						* fractal->transformCommon.scaleB1;

	REAL rp = pow(aux->r, fractal->bulb.power - fractal->transformCommon.offset1);

	if (aux->i >= fractal->transformCommon.startIterationsX
			&& aux->i < fractal->transformCommon.stopIterationsX)
	{
		if (native_cos(th) < 0.0f) ph = ph + M_PI_F;
	}

	aux->DE = rp * aux->DE * fabs(fractal->bulb.power) + 1.0f;
	rp *= aux->r;

	// polar to cartesian
	t = native_cos(th);
	z.x = t * native_cos(ph) * rp;
	z.y = t * native_sin(ph) * rp;
	z.z = native_sin(th) * rp;

	if (fractal->transformCommon.functionEnabledBxFalse) z.x = fabs(z.x);
	if (fractal->transformCommon.functionEnabledByFalse) z.y = fabs(z.y);
	if (fractal->transformCommon.functionEnabledBzFalse)
		z.y = min(z.y, fractal->transformCommon.offset0 - z.y);

	z += fractal->transformCommon.offset000;

	z *= fractal->transformCommon.scaleC1;
	aux->DE *= fabs(fractal->transformCommon.scaleC1);

	if (fractal->analyticDE.enabledFalse)
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
	return z;
}