package deploymentmanager

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// DeploymentMode enumerates the values for deployment mode.
type DeploymentMode string

const (
	// Complete ...
	Complete DeploymentMode = "Complete"
	// Incremental ...
	Incremental DeploymentMode = "Incremental"
)

// PossibleDeploymentModeValues returns an array of possible values for the DeploymentMode const type.
func PossibleDeploymentModeValues() []DeploymentMode {
	return []DeploymentMode{Complete, Incremental}
}

// StepType enumerates the values for step type.
type StepType string

const (
	// StepTypeStepProperties ...
	StepTypeStepProperties StepType = "StepProperties"
	// StepTypeWait ...
	StepTypeWait StepType = "Wait"
)

// PossibleStepTypeValues returns an array of possible values for the StepType const type.
func PossibleStepTypeValues() []StepType {
	return []StepType{StepTypeStepProperties, StepTypeWait}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeAuthentication ...
	TypeAuthentication Type = "Authentication"
	// TypeSas ...
	TypeSas Type = "Sas"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeAuthentication, TypeSas}
}
