package compute

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessLevel enumerates the values for access level.
type AccessLevel string

const (
	// None ...
	None AccessLevel = "None"
	// Read ...
	Read AccessLevel = "Read"
)

// PossibleAccessLevelValues returns an array of possible values for the AccessLevel const type.
func PossibleAccessLevelValues() []AccessLevel {
	return []AccessLevel{None, Read}
}

// CachingTypes enumerates the values for caching types.
type CachingTypes string

const (
	// CachingTypesNone ...
	CachingTypesNone CachingTypes = "None"
	// CachingTypesReadOnly ...
	CachingTypesReadOnly CachingTypes = "ReadOnly"
	// CachingTypesReadWrite ...
	CachingTypesReadWrite CachingTypes = "ReadWrite"
)

// PossibleCachingTypesValues returns an array of possible values for the CachingTypes const type.
func PossibleCachingTypesValues() []CachingTypes {
	return []CachingTypes{CachingTypesNone, CachingTypesReadOnly, CachingTypesReadWrite}
}

// ComponentNames enumerates the values for component names.
type ComponentNames string

const (
	// MicrosoftWindowsShellSetup ...
	MicrosoftWindowsShellSetup ComponentNames = "Microsoft-Windows-Shell-Setup"
)

// PossibleComponentNamesValues returns an array of possible values for the ComponentNames const type.
func PossibleComponentNamesValues() []ComponentNames {
	return []ComponentNames{MicrosoftWindowsShellSetup}
}

// DiskCreateOption enumerates the values for disk create option.
type DiskCreateOption string

const (
	// Attach ...
	Attach DiskCreateOption = "Attach"
	// Copy ...
	Copy DiskCreateOption = "Copy"
	// Empty ...
	Empty DiskCreateOption = "Empty"
	// FromImage ...
	FromImage DiskCreateOption = "FromImage"
	// Import ...
	Import DiskCreateOption = "Import"
	// Restore ...
	Restore DiskCreateOption = "Restore"
)

// PossibleDiskCreateOptionValues returns an array of possible values for the DiskCreateOption const type.
func PossibleDiskCreateOptionValues() []DiskCreateOption {
	return []DiskCreateOption{Attach, Copy, Empty, FromImage, Import, Restore}
}

// DiskCreateOptionTypes enumerates the values for disk create option types.
type DiskCreateOptionTypes string

const (
	// DiskCreateOptionTypesAttach ...
	DiskCreateOptionTypesAttach DiskCreateOptionTypes = "Attach"
	// DiskCreateOptionTypesEmpty ...
	DiskCreateOptionTypesEmpty DiskCreateOptionTypes = "Empty"
	// DiskCreateOptionTypesFromImage ...
	DiskCreateOptionTypesFromImage DiskCreateOptionTypes = "FromImage"
)

// PossibleDiskCreateOptionTypesValues returns an array of possible values for the DiskCreateOptionTypes const type.
func PossibleDiskCreateOptionTypesValues() []DiskCreateOptionTypes {
	return []DiskCreateOptionTypes{DiskCreateOptionTypesAttach, DiskCreateOptionTypesEmpty, DiskCreateOptionTypesFromImage}
}

// InstanceViewTypes enumerates the values for instance view types.
type InstanceViewTypes string

const (
	// InstanceView ...
	InstanceView InstanceViewTypes = "instanceView"
)

// PossibleInstanceViewTypesValues returns an array of possible values for the InstanceViewTypes const type.
func PossibleInstanceViewTypesValues() []InstanceViewTypes {
	return []InstanceViewTypes{InstanceView}
}

// IntervalInMins enumerates the values for interval in mins.
type IntervalInMins string

const (
	// FiveMins ...
	FiveMins IntervalInMins = "FiveMins"
	// SixtyMins ...
	SixtyMins IntervalInMins = "SixtyMins"
	// ThirtyMins ...
	ThirtyMins IntervalInMins = "ThirtyMins"
	// ThreeMins ...
	ThreeMins IntervalInMins = "ThreeMins"
)

// PossibleIntervalInMinsValues returns an array of possible values for the IntervalInMins const type.
func PossibleIntervalInMinsValues() []IntervalInMins {
	return []IntervalInMins{FiveMins, SixtyMins, ThirtyMins, ThreeMins}
}

// IPVersion enumerates the values for ip version.
type IPVersion string

const (
	// IPv4 ...
	IPv4 IPVersion = "IPv4"
	// IPv6 ...
	IPv6 IPVersion = "IPv6"
)

// PossibleIPVersionValues returns an array of possible values for the IPVersion const type.
func PossibleIPVersionValues() []IPVersion {
	return []IPVersion{IPv4, IPv6}
}

// MaintenanceOperationResultCodeTypes enumerates the values for maintenance operation result code types.
type MaintenanceOperationResultCodeTypes string

const (
	// MaintenanceOperationResultCodeTypesMaintenanceAborted ...
	MaintenanceOperationResultCodeTypesMaintenanceAborted MaintenanceOperationResultCodeTypes = "MaintenanceAborted"
	// MaintenanceOperationResultCodeTypesMaintenanceCompleted ...
	MaintenanceOperationResultCodeTypesMaintenanceCompleted MaintenanceOperationResultCodeTypes = "MaintenanceCompleted"
	// MaintenanceOperationResultCodeTypesNone ...
	MaintenanceOperationResultCodeTypesNone MaintenanceOperationResultCodeTypes = "None"
	// MaintenanceOperationResultCodeTypesRetryLater ...
	MaintenanceOperationResultCodeTypesRetryLater MaintenanceOperationResultCodeTypes = "RetryLater"
)

// PossibleMaintenanceOperationResultCodeTypesValues returns an array of possible values for the MaintenanceOperationResultCodeTypes const type.
func PossibleMaintenanceOperationResultCodeTypesValues() []MaintenanceOperationResultCodeTypes {
	return []MaintenanceOperationResultCodeTypes{MaintenanceOperationResultCodeTypesMaintenanceAborted, MaintenanceOperationResultCodeTypesMaintenanceCompleted, MaintenanceOperationResultCodeTypesNone, MaintenanceOperationResultCodeTypesRetryLater}
}

// OperatingSystemStateTypes enumerates the values for operating system state types.
type OperatingSystemStateTypes string

const (
	// Generalized ...
	Generalized OperatingSystemStateTypes = "Generalized"
	// Specialized ...
	Specialized OperatingSystemStateTypes = "Specialized"
)

// PossibleOperatingSystemStateTypesValues returns an array of possible values for the OperatingSystemStateTypes const type.
func PossibleOperatingSystemStateTypesValues() []OperatingSystemStateTypes {
	return []OperatingSystemStateTypes{Generalized, Specialized}
}

// OperatingSystemTypes enumerates the values for operating system types.
type OperatingSystemTypes string

const (
	// Linux ...
	Linux OperatingSystemTypes = "Linux"
	// Windows ...
	Windows OperatingSystemTypes = "Windows"
)

// PossibleOperatingSystemTypesValues returns an array of possible values for the OperatingSystemTypes const type.
func PossibleOperatingSystemTypesValues() []OperatingSystemTypes {
	return []OperatingSystemTypes{Linux, Windows}
}

// PassNames enumerates the values for pass names.
type PassNames string

const (
	// OobeSystem ...
	OobeSystem PassNames = "OobeSystem"
)

// PossiblePassNamesValues returns an array of possible values for the PassNames const type.
func PossiblePassNamesValues() []PassNames {
	return []PassNames{OobeSystem}
}

// ProtocolTypes enumerates the values for protocol types.
type ProtocolTypes string

const (
	// HTTP ...
	HTTP ProtocolTypes = "Http"
	// HTTPS ...
	HTTPS ProtocolTypes = "Https"
)

// PossibleProtocolTypesValues returns an array of possible values for the ProtocolTypes const type.
func PossibleProtocolTypesValues() []ProtocolTypes {
	return []ProtocolTypes{HTTP, HTTPS}
}

// ProximityPlacementGroupType enumerates the values for proximity placement group type.
type ProximityPlacementGroupType string

const (
	// Standard ...
	Standard ProximityPlacementGroupType = "Standard"
	// Ultra ...
	Ultra ProximityPlacementGroupType = "Ultra"
)

// PossibleProximityPlacementGroupTypeValues returns an array of possible values for the ProximityPlacementGroupType const type.
func PossibleProximityPlacementGroupTypeValues() []ProximityPlacementGroupType {
	return []ProximityPlacementGroupType{Standard, Ultra}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeNone ...
	ResourceIdentityTypeNone ResourceIdentityType = "None"
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
	// ResourceIdentityTypeSystemAssignedUserAssigned ...
	ResourceIdentityTypeSystemAssignedUserAssigned ResourceIdentityType = "SystemAssigned, UserAssigned"
	// ResourceIdentityTypeUserAssigned ...
	ResourceIdentityTypeUserAssigned ResourceIdentityType = "UserAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeNone, ResourceIdentityTypeSystemAssigned, ResourceIdentityTypeSystemAssignedUserAssigned, ResourceIdentityTypeUserAssigned}
}

// RollingUpgradeActionType enumerates the values for rolling upgrade action type.
type RollingUpgradeActionType string

const (
	// Cancel ...
	Cancel RollingUpgradeActionType = "Cancel"
	// Start ...
	Start RollingUpgradeActionType = "Start"
)

// PossibleRollingUpgradeActionTypeValues returns an array of possible values for the RollingUpgradeActionType const type.
func PossibleRollingUpgradeActionTypeValues() []RollingUpgradeActionType {
	return []RollingUpgradeActionType{Cancel, Start}
}

// RollingUpgradeStatusCode enumerates the values for rolling upgrade status code.
type RollingUpgradeStatusCode string

const (
	// Cancelled ...
	Cancelled RollingUpgradeStatusCode = "Cancelled"
	// Completed ...
	Completed RollingUpgradeStatusCode = "Completed"
	// Faulted ...
	Faulted RollingUpgradeStatusCode = "Faulted"
	// RollingForward ...
	RollingForward RollingUpgradeStatusCode = "RollingForward"
)

// PossibleRollingUpgradeStatusCodeValues returns an array of possible values for the RollingUpgradeStatusCode const type.
func PossibleRollingUpgradeStatusCodeValues() []RollingUpgradeStatusCode {
	return []RollingUpgradeStatusCode{Cancelled, Completed, Faulted, RollingForward}
}

// SettingNames enumerates the values for setting names.
type SettingNames string

const (
	// AutoLogon ...
	AutoLogon SettingNames = "AutoLogon"
	// FirstLogonCommands ...
	FirstLogonCommands SettingNames = "FirstLogonCommands"
)

// PossibleSettingNamesValues returns an array of possible values for the SettingNames const type.
func PossibleSettingNamesValues() []SettingNames {
	return []SettingNames{AutoLogon, FirstLogonCommands}
}

// SnapshotStorageAccountTypes enumerates the values for snapshot storage account types.
type SnapshotStorageAccountTypes string

const (
	// PremiumLRS ...
	PremiumLRS SnapshotStorageAccountTypes = "Premium_LRS"
	// StandardLRS ...
	StandardLRS SnapshotStorageAccountTypes = "Standard_LRS"
	// StandardZRS ...
	StandardZRS SnapshotStorageAccountTypes = "Standard_ZRS"
)

// PossibleSnapshotStorageAccountTypesValues returns an array of possible values for the SnapshotStorageAccountTypes const type.
func PossibleSnapshotStorageAccountTypesValues() []SnapshotStorageAccountTypes {
	return []SnapshotStorageAccountTypes{PremiumLRS, StandardLRS, StandardZRS}
}

// StatusLevelTypes enumerates the values for status level types.
type StatusLevelTypes string

const (
	// Error ...
	Error StatusLevelTypes = "Error"
	// Info ...
	Info StatusLevelTypes = "Info"
	// Warning ...
	Warning StatusLevelTypes = "Warning"
)

// PossibleStatusLevelTypesValues returns an array of possible values for the StatusLevelTypes const type.
func PossibleStatusLevelTypesValues() []StatusLevelTypes {
	return []StatusLevelTypes{Error, Info, Warning}
}

// StorageAccountTypes enumerates the values for storage account types.
type StorageAccountTypes string

const (
	// StorageAccountTypesPremiumLRS ...
	StorageAccountTypesPremiumLRS StorageAccountTypes = "Premium_LRS"
	// StorageAccountTypesStandardLRS ...
	StorageAccountTypesStandardLRS StorageAccountTypes = "Standard_LRS"
	// StorageAccountTypesStandardSSDLRS ...
	StorageAccountTypesStandardSSDLRS StorageAccountTypes = "StandardSSD_LRS"
)

// PossibleStorageAccountTypesValues returns an array of possible values for the StorageAccountTypes const type.
func PossibleStorageAccountTypesValues() []StorageAccountTypes {
	return []StorageAccountTypes{StorageAccountTypesPremiumLRS, StorageAccountTypesStandardLRS, StorageAccountTypesStandardSSDLRS}
}

// UpgradeMode enumerates the values for upgrade mode.
type UpgradeMode string

const (
	// Automatic ...
	Automatic UpgradeMode = "Automatic"
	// Manual ...
	Manual UpgradeMode = "Manual"
	// Rolling ...
	Rolling UpgradeMode = "Rolling"
)

// PossibleUpgradeModeValues returns an array of possible values for the UpgradeMode const type.
func PossibleUpgradeModeValues() []UpgradeMode {
	return []UpgradeMode{Automatic, Manual, Rolling}
}

// UpgradeOperationInvoker enumerates the values for upgrade operation invoker.
type UpgradeOperationInvoker string

const (
	// Platform ...
	Platform UpgradeOperationInvoker = "Platform"
	// Unknown ...
	Unknown UpgradeOperationInvoker = "Unknown"
	// User ...
	User UpgradeOperationInvoker = "User"
)

// PossibleUpgradeOperationInvokerValues returns an array of possible values for the UpgradeOperationInvoker const type.
func PossibleUpgradeOperationInvokerValues() []UpgradeOperationInvoker {
	return []UpgradeOperationInvoker{Platform, Unknown, User}
}

// UpgradeState enumerates the values for upgrade state.
type UpgradeState string

const (
	// UpgradeStateCancelled ...
	UpgradeStateCancelled UpgradeState = "Cancelled"
	// UpgradeStateCompleted ...
	UpgradeStateCompleted UpgradeState = "Completed"
	// UpgradeStateFaulted ...
	UpgradeStateFaulted UpgradeState = "Faulted"
	// UpgradeStateRollingForward ...
	UpgradeStateRollingForward UpgradeState = "RollingForward"
)

// PossibleUpgradeStateValues returns an array of possible values for the UpgradeState const type.
func PossibleUpgradeStateValues() []UpgradeState {
	return []UpgradeState{UpgradeStateCancelled, UpgradeStateCompleted, UpgradeStateFaulted, UpgradeStateRollingForward}
}

// VirtualMachineEvictionPolicyTypes enumerates the values for virtual machine eviction policy types.
type VirtualMachineEvictionPolicyTypes string

const (
	// Deallocate ...
	Deallocate VirtualMachineEvictionPolicyTypes = "Deallocate"
	// Delete ...
	Delete VirtualMachineEvictionPolicyTypes = "Delete"
)

// PossibleVirtualMachineEvictionPolicyTypesValues returns an array of possible values for the VirtualMachineEvictionPolicyTypes const type.
func PossibleVirtualMachineEvictionPolicyTypesValues() []VirtualMachineEvictionPolicyTypes {
	return []VirtualMachineEvictionPolicyTypes{Deallocate, Delete}
}

// VirtualMachinePriorityTypes enumerates the values for virtual machine priority types.
type VirtualMachinePriorityTypes string

const (
	// Low ...
	Low VirtualMachinePriorityTypes = "Low"
	// Regular ...
	Regular VirtualMachinePriorityTypes = "Regular"
)

// PossibleVirtualMachinePriorityTypesValues returns an array of possible values for the VirtualMachinePriorityTypes const type.
func PossibleVirtualMachinePriorityTypesValues() []VirtualMachinePriorityTypes {
	return []VirtualMachinePriorityTypes{Low, Regular}
}

// VirtualMachineScaleSetSkuScaleType enumerates the values for virtual machine scale set sku scale type.
type VirtualMachineScaleSetSkuScaleType string

const (
	// VirtualMachineScaleSetSkuScaleTypeAutomatic ...
	VirtualMachineScaleSetSkuScaleTypeAutomatic VirtualMachineScaleSetSkuScaleType = "Automatic"
	// VirtualMachineScaleSetSkuScaleTypeNone ...
	VirtualMachineScaleSetSkuScaleTypeNone VirtualMachineScaleSetSkuScaleType = "None"
)

// PossibleVirtualMachineScaleSetSkuScaleTypeValues returns an array of possible values for the VirtualMachineScaleSetSkuScaleType const type.
func PossibleVirtualMachineScaleSetSkuScaleTypeValues() []VirtualMachineScaleSetSkuScaleType {
	return []VirtualMachineScaleSetSkuScaleType{VirtualMachineScaleSetSkuScaleTypeAutomatic, VirtualMachineScaleSetSkuScaleTypeNone}
}

// VirtualMachineSizeTypes enumerates the values for virtual machine size types.
type VirtualMachineSizeTypes string

const (
	// BasicA0 ...
	BasicA0 VirtualMachineSizeTypes = "Basic_A0"
	// BasicA1 ...
	BasicA1 VirtualMachineSizeTypes = "Basic_A1"
	// BasicA2 ...
	BasicA2 VirtualMachineSizeTypes = "Basic_A2"
	// BasicA3 ...
	BasicA3 VirtualMachineSizeTypes = "Basic_A3"
	// BasicA4 ...
	BasicA4 VirtualMachineSizeTypes = "Basic_A4"
	// StandardA0 ...
	StandardA0 VirtualMachineSizeTypes = "Standard_A0"
	// StandardA1 ...
	StandardA1 VirtualMachineSizeTypes = "Standard_A1"
	// StandardA10 ...
	StandardA10 VirtualMachineSizeTypes = "Standard_A10"
	// StandardA11 ...
	StandardA11 VirtualMachineSizeTypes = "Standard_A11"
	// StandardA1V2 ...
	StandardA1V2 VirtualMachineSizeTypes = "Standard_A1_v2"
	// StandardA2 ...
	StandardA2 VirtualMachineSizeTypes = "Standard_A2"
	// StandardA2mV2 ...
	StandardA2mV2 VirtualMachineSizeTypes = "Standard_A2m_v2"
	// StandardA2V2 ...
	StandardA2V2 VirtualMachineSizeTypes = "Standard_A2_v2"
	// StandardA3 ...
	StandardA3 VirtualMachineSizeTypes = "Standard_A3"
	// StandardA4 ...
	StandardA4 VirtualMachineSizeTypes = "Standard_A4"
	// StandardA4mV2 ...
	StandardA4mV2 VirtualMachineSizeTypes = "Standard_A4m_v2"
	// StandardA4V2 ...
	StandardA4V2 VirtualMachineSizeTypes = "Standard_A4_v2"
	// StandardA5 ...
	StandardA5 VirtualMachineSizeTypes = "Standard_A5"
	// StandardA6 ...
	StandardA6 VirtualMachineSizeTypes = "Standard_A6"
	// StandardA7 ...
	StandardA7 VirtualMachineSizeTypes = "Standard_A7"
	// StandardA8 ...
	StandardA8 VirtualMachineSizeTypes = "Standard_A8"
	// StandardA8mV2 ...
	StandardA8mV2 VirtualMachineSizeTypes = "Standard_A8m_v2"
	// StandardA8V2 ...
	StandardA8V2 VirtualMachineSizeTypes = "Standard_A8_v2"
	// StandardA9 ...
	StandardA9 VirtualMachineSizeTypes = "Standard_A9"
	// StandardB1ms ...
	StandardB1ms VirtualMachineSizeTypes = "Standard_B1ms"
	// StandardB1s ...
	StandardB1s VirtualMachineSizeTypes = "Standard_B1s"
	// StandardB2ms ...
	StandardB2ms VirtualMachineSizeTypes = "Standard_B2ms"
	// StandardB2s ...
	StandardB2s VirtualMachineSizeTypes = "Standard_B2s"
	// StandardB4ms ...
	StandardB4ms VirtualMachineSizeTypes = "Standard_B4ms"
	// StandardB8ms ...
	StandardB8ms VirtualMachineSizeTypes = "Standard_B8ms"
	// StandardD1 ...
	StandardD1 VirtualMachineSizeTypes = "Standard_D1"
	// StandardD11 ...
	StandardD11 VirtualMachineSizeTypes = "Standard_D11"
	// StandardD11V2 ...
	StandardD11V2 VirtualMachineSizeTypes = "Standard_D11_v2"
	// StandardD12 ...
	StandardD12 VirtualMachineSizeTypes = "Standard_D12"
	// StandardD12V2 ...
	StandardD12V2 VirtualMachineSizeTypes = "Standard_D12_v2"
	// StandardD13 ...
	StandardD13 VirtualMachineSizeTypes = "Standard_D13"
	// StandardD13V2 ...
	StandardD13V2 VirtualMachineSizeTypes = "Standard_D13_v2"
	// StandardD14 ...
	StandardD14 VirtualMachineSizeTypes = "Standard_D14"
	// StandardD14V2 ...
	StandardD14V2 VirtualMachineSizeTypes = "Standard_D14_v2"
	// StandardD15V2 ...
	StandardD15V2 VirtualMachineSizeTypes = "Standard_D15_v2"
	// StandardD16sV3 ...
	StandardD16sV3 VirtualMachineSizeTypes = "Standard_D16s_v3"
	// StandardD16V3 ...
	StandardD16V3 VirtualMachineSizeTypes = "Standard_D16_v3"
	// StandardD1V2 ...
	StandardD1V2 VirtualMachineSizeTypes = "Standard_D1_v2"
	// StandardD2 ...
	StandardD2 VirtualMachineSizeTypes = "Standard_D2"
	// StandardD2sV3 ...
	StandardD2sV3 VirtualMachineSizeTypes = "Standard_D2s_v3"
	// StandardD2V2 ...
	StandardD2V2 VirtualMachineSizeTypes = "Standard_D2_v2"
	// StandardD2V3 ...
	StandardD2V3 VirtualMachineSizeTypes = "Standard_D2_v3"
	// StandardD3 ...
	StandardD3 VirtualMachineSizeTypes = "Standard_D3"
	// StandardD32sV3 ...
	StandardD32sV3 VirtualMachineSizeTypes = "Standard_D32s_v3"
	// StandardD32V3 ...
	StandardD32V3 VirtualMachineSizeTypes = "Standard_D32_v3"
	// StandardD3V2 ...
	StandardD3V2 VirtualMachineSizeTypes = "Standard_D3_v2"
	// StandardD4 ...
	StandardD4 VirtualMachineSizeTypes = "Standard_D4"
	// StandardD4sV3 ...
	StandardD4sV3 VirtualMachineSizeTypes = "Standard_D4s_v3"
	// StandardD4V2 ...
	StandardD4V2 VirtualMachineSizeTypes = "Standard_D4_v2"
	// StandardD4V3 ...
	StandardD4V3 VirtualMachineSizeTypes = "Standard_D4_v3"
	// StandardD5V2 ...
	StandardD5V2 VirtualMachineSizeTypes = "Standard_D5_v2"
	// StandardD64sV3 ...
	StandardD64sV3 VirtualMachineSizeTypes = "Standard_D64s_v3"
	// StandardD64V3 ...
	StandardD64V3 VirtualMachineSizeTypes = "Standard_D64_v3"
	// StandardD8sV3 ...
	StandardD8sV3 VirtualMachineSizeTypes = "Standard_D8s_v3"
	// StandardD8V3 ...
	StandardD8V3 VirtualMachineSizeTypes = "Standard_D8_v3"
	// StandardDS1 ...
	StandardDS1 VirtualMachineSizeTypes = "Standard_DS1"
	// StandardDS11 ...
	StandardDS11 VirtualMachineSizeTypes = "Standard_DS11"
	// StandardDS11V2 ...
	StandardDS11V2 VirtualMachineSizeTypes = "Standard_DS11_v2"
	// StandardDS12 ...
	StandardDS12 VirtualMachineSizeTypes = "Standard_DS12"
	// StandardDS12V2 ...
	StandardDS12V2 VirtualMachineSizeTypes = "Standard_DS12_v2"
	// StandardDS13 ...
	StandardDS13 VirtualMachineSizeTypes = "Standard_DS13"
	// StandardDS132V2 ...
	StandardDS132V2 VirtualMachineSizeTypes = "Standard_DS13-2_v2"
	// StandardDS134V2 ...
	StandardDS134V2 VirtualMachineSizeTypes = "Standard_DS13-4_v2"
	// StandardDS13V2 ...
	StandardDS13V2 VirtualMachineSizeTypes = "Standard_DS13_v2"
	// StandardDS14 ...
	StandardDS14 VirtualMachineSizeTypes = "Standard_DS14"
	// StandardDS144V2 ...
	StandardDS144V2 VirtualMachineSizeTypes = "Standard_DS14-4_v2"
	// StandardDS148V2 ...
	StandardDS148V2 VirtualMachineSizeTypes = "Standard_DS14-8_v2"
	// StandardDS14V2 ...
	StandardDS14V2 VirtualMachineSizeTypes = "Standard_DS14_v2"
	// StandardDS15V2 ...
	StandardDS15V2 VirtualMachineSizeTypes = "Standard_DS15_v2"
	// StandardDS1V2 ...
	StandardDS1V2 VirtualMachineSizeTypes = "Standard_DS1_v2"
	// StandardDS2 ...
	StandardDS2 VirtualMachineSizeTypes = "Standard_DS2"
	// StandardDS2V2 ...
	StandardDS2V2 VirtualMachineSizeTypes = "Standard_DS2_v2"
	// StandardDS3 ...
	StandardDS3 VirtualMachineSizeTypes = "Standard_DS3"
	// StandardDS3V2 ...
	StandardDS3V2 VirtualMachineSizeTypes = "Standard_DS3_v2"
	// StandardDS4 ...
	StandardDS4 VirtualMachineSizeTypes = "Standard_DS4"
	// StandardDS4V2 ...
	StandardDS4V2 VirtualMachineSizeTypes = "Standard_DS4_v2"
	// StandardDS5V2 ...
	StandardDS5V2 VirtualMachineSizeTypes = "Standard_DS5_v2"
	// StandardE16sV3 ...
	StandardE16sV3 VirtualMachineSizeTypes = "Standard_E16s_v3"
	// StandardE16V3 ...
	StandardE16V3 VirtualMachineSizeTypes = "Standard_E16_v3"
	// StandardE2sV3 ...
	StandardE2sV3 VirtualMachineSizeTypes = "Standard_E2s_v3"
	// StandardE2V3 ...
	StandardE2V3 VirtualMachineSizeTypes = "Standard_E2_v3"
	// StandardE3216V3 ...
	StandardE3216V3 VirtualMachineSizeTypes = "Standard_E32-16_v3"
	// StandardE328sV3 ...
	StandardE328sV3 VirtualMachineSizeTypes = "Standard_E32-8s_v3"
	// StandardE32sV3 ...
	StandardE32sV3 VirtualMachineSizeTypes = "Standard_E32s_v3"
	// StandardE32V3 ...
	StandardE32V3 VirtualMachineSizeTypes = "Standard_E32_v3"
	// StandardE4sV3 ...
	StandardE4sV3 VirtualMachineSizeTypes = "Standard_E4s_v3"
	// StandardE4V3 ...
	StandardE4V3 VirtualMachineSizeTypes = "Standard_E4_v3"
	// StandardE6416sV3 ...
	StandardE6416sV3 VirtualMachineSizeTypes = "Standard_E64-16s_v3"
	// StandardE6432sV3 ...
	StandardE6432sV3 VirtualMachineSizeTypes = "Standard_E64-32s_v3"
	// StandardE64sV3 ...
	StandardE64sV3 VirtualMachineSizeTypes = "Standard_E64s_v3"
	// StandardE64V3 ...
	StandardE64V3 VirtualMachineSizeTypes = "Standard_E64_v3"
	// StandardE8sV3 ...
	StandardE8sV3 VirtualMachineSizeTypes = "Standard_E8s_v3"
	// StandardE8V3 ...
	StandardE8V3 VirtualMachineSizeTypes = "Standard_E8_v3"
	// StandardF1 ...
	StandardF1 VirtualMachineSizeTypes = "Standard_F1"
	// StandardF16 ...
	StandardF16 VirtualMachineSizeTypes = "Standard_F16"
	// StandardF16s ...
	StandardF16s VirtualMachineSizeTypes = "Standard_F16s"
	// StandardF16sV2 ...
	StandardF16sV2 VirtualMachineSizeTypes = "Standard_F16s_v2"
	// StandardF1s ...
	StandardF1s VirtualMachineSizeTypes = "Standard_F1s"
	// StandardF2 ...
	StandardF2 VirtualMachineSizeTypes = "Standard_F2"
	// StandardF2s ...
	StandardF2s VirtualMachineSizeTypes = "Standard_F2s"
	// StandardF2sV2 ...
	StandardF2sV2 VirtualMachineSizeTypes = "Standard_F2s_v2"
	// StandardF32sV2 ...
	StandardF32sV2 VirtualMachineSizeTypes = "Standard_F32s_v2"
	// StandardF4 ...
	StandardF4 VirtualMachineSizeTypes = "Standard_F4"
	// StandardF4s ...
	StandardF4s VirtualMachineSizeTypes = "Standard_F4s"
	// StandardF4sV2 ...
	StandardF4sV2 VirtualMachineSizeTypes = "Standard_F4s_v2"
	// StandardF64sV2 ...
	StandardF64sV2 VirtualMachineSizeTypes = "Standard_F64s_v2"
	// StandardF72sV2 ...
	StandardF72sV2 VirtualMachineSizeTypes = "Standard_F72s_v2"
	// StandardF8 ...
	StandardF8 VirtualMachineSizeTypes = "Standard_F8"
	// StandardF8s ...
	StandardF8s VirtualMachineSizeTypes = "Standard_F8s"
	// StandardF8sV2 ...
	StandardF8sV2 VirtualMachineSizeTypes = "Standard_F8s_v2"
	// StandardG1 ...
	StandardG1 VirtualMachineSizeTypes = "Standard_G1"
	// StandardG2 ...
	StandardG2 VirtualMachineSizeTypes = "Standard_G2"
	// StandardG3 ...
	StandardG3 VirtualMachineSizeTypes = "Standard_G3"
	// StandardG4 ...
	StandardG4 VirtualMachineSizeTypes = "Standard_G4"
	// StandardG5 ...
	StandardG5 VirtualMachineSizeTypes = "Standard_G5"
	// StandardGS1 ...
	StandardGS1 VirtualMachineSizeTypes = "Standard_GS1"
	// StandardGS2 ...
	StandardGS2 VirtualMachineSizeTypes = "Standard_GS2"
	// StandardGS3 ...
	StandardGS3 VirtualMachineSizeTypes = "Standard_GS3"
	// StandardGS4 ...
	StandardGS4 VirtualMachineSizeTypes = "Standard_GS4"
	// StandardGS44 ...
	StandardGS44 VirtualMachineSizeTypes = "Standard_GS4-4"
	// StandardGS48 ...
	StandardGS48 VirtualMachineSizeTypes = "Standard_GS4-8"
	// StandardGS5 ...
	StandardGS5 VirtualMachineSizeTypes = "Standard_GS5"
	// StandardGS516 ...
	StandardGS516 VirtualMachineSizeTypes = "Standard_GS5-16"
	// StandardGS58 ...
	StandardGS58 VirtualMachineSizeTypes = "Standard_GS5-8"
	// StandardH16 ...
	StandardH16 VirtualMachineSizeTypes = "Standard_H16"
	// StandardH16m ...
	StandardH16m VirtualMachineSizeTypes = "Standard_H16m"
	// StandardH16mr ...
	StandardH16mr VirtualMachineSizeTypes = "Standard_H16mr"
	// StandardH16r ...
	StandardH16r VirtualMachineSizeTypes = "Standard_H16r"
	// StandardH8 ...
	StandardH8 VirtualMachineSizeTypes = "Standard_H8"
	// StandardH8m ...
	StandardH8m VirtualMachineSizeTypes = "Standard_H8m"
	// StandardL16s ...
	StandardL16s VirtualMachineSizeTypes = "Standard_L16s"
	// StandardL32s ...
	StandardL32s VirtualMachineSizeTypes = "Standard_L32s"
	// StandardL4s ...
	StandardL4s VirtualMachineSizeTypes = "Standard_L4s"
	// StandardL8s ...
	StandardL8s VirtualMachineSizeTypes = "Standard_L8s"
	// StandardM12832ms ...
	StandardM12832ms VirtualMachineSizeTypes = "Standard_M128-32ms"
	// StandardM12864ms ...
	StandardM12864ms VirtualMachineSizeTypes = "Standard_M128-64ms"
	// StandardM128ms ...
	StandardM128ms VirtualMachineSizeTypes = "Standard_M128ms"
	// StandardM128s ...
	StandardM128s VirtualMachineSizeTypes = "Standard_M128s"
	// StandardM6416ms ...
	StandardM6416ms VirtualMachineSizeTypes = "Standard_M64-16ms"
	// StandardM6432ms ...
	StandardM6432ms VirtualMachineSizeTypes = "Standard_M64-32ms"
	// StandardM64ms ...
	StandardM64ms VirtualMachineSizeTypes = "Standard_M64ms"
	// StandardM64s ...
	StandardM64s VirtualMachineSizeTypes = "Standard_M64s"
	// StandardNC12 ...
	StandardNC12 VirtualMachineSizeTypes = "Standard_NC12"
	// StandardNC12sV2 ...
	StandardNC12sV2 VirtualMachineSizeTypes = "Standard_NC12s_v2"
	// StandardNC12sV3 ...
	StandardNC12sV3 VirtualMachineSizeTypes = "Standard_NC12s_v3"
	// StandardNC24 ...
	StandardNC24 VirtualMachineSizeTypes = "Standard_NC24"
	// StandardNC24r ...
	StandardNC24r VirtualMachineSizeTypes = "Standard_NC24r"
	// StandardNC24rsV2 ...
	StandardNC24rsV2 VirtualMachineSizeTypes = "Standard_NC24rs_v2"
	// StandardNC24rsV3 ...
	StandardNC24rsV3 VirtualMachineSizeTypes = "Standard_NC24rs_v3"
	// StandardNC24sV2 ...
	StandardNC24sV2 VirtualMachineSizeTypes = "Standard_NC24s_v2"
	// StandardNC24sV3 ...
	StandardNC24sV3 VirtualMachineSizeTypes = "Standard_NC24s_v3"
	// StandardNC6 ...
	StandardNC6 VirtualMachineSizeTypes = "Standard_NC6"
	// StandardNC6sV2 ...
	StandardNC6sV2 VirtualMachineSizeTypes = "Standard_NC6s_v2"
	// StandardNC6sV3 ...
	StandardNC6sV3 VirtualMachineSizeTypes = "Standard_NC6s_v3"
	// StandardND12s ...
	StandardND12s VirtualMachineSizeTypes = "Standard_ND12s"
	// StandardND24rs ...
	StandardND24rs VirtualMachineSizeTypes = "Standard_ND24rs"
	// StandardND24s ...
	StandardND24s VirtualMachineSizeTypes = "Standard_ND24s"
	// StandardND6s ...
	StandardND6s VirtualMachineSizeTypes = "Standard_ND6s"
	// StandardNV12 ...
	StandardNV12 VirtualMachineSizeTypes = "Standard_NV12"
	// StandardNV24 ...
	StandardNV24 VirtualMachineSizeTypes = "Standard_NV24"
	// StandardNV6 ...
	StandardNV6 VirtualMachineSizeTypes = "Standard_NV6"
)

// PossibleVirtualMachineSizeTypesValues returns an array of possible values for the VirtualMachineSizeTypes const type.
func PossibleVirtualMachineSizeTypesValues() []VirtualMachineSizeTypes {
	return []VirtualMachineSizeTypes{BasicA0, BasicA1, BasicA2, BasicA3, BasicA4, StandardA0, StandardA1, StandardA10, StandardA11, StandardA1V2, StandardA2, StandardA2mV2, StandardA2V2, StandardA3, StandardA4, StandardA4mV2, StandardA4V2, StandardA5, StandardA6, StandardA7, StandardA8, StandardA8mV2, StandardA8V2, StandardA9, StandardB1ms, StandardB1s, StandardB2ms, StandardB2s, StandardB4ms, StandardB8ms, StandardD1, StandardD11, StandardD11V2, StandardD12, StandardD12V2, StandardD13, StandardD13V2, StandardD14, StandardD14V2, StandardD15V2, StandardD16sV3, StandardD16V3, StandardD1V2, StandardD2, StandardD2sV3, StandardD2V2, StandardD2V3, StandardD3, StandardD32sV3, StandardD32V3, StandardD3V2, StandardD4, StandardD4sV3, StandardD4V2, StandardD4V3, StandardD5V2, StandardD64sV3, StandardD64V3, StandardD8sV3, StandardD8V3, StandardDS1, StandardDS11, StandardDS11V2, StandardDS12, StandardDS12V2, StandardDS13, StandardDS132V2, StandardDS134V2, StandardDS13V2, StandardDS14, StandardDS144V2, StandardDS148V2, StandardDS14V2, StandardDS15V2, StandardDS1V2, StandardDS2, StandardDS2V2, StandardDS3, StandardDS3V2, StandardDS4, StandardDS4V2, StandardDS5V2, StandardE16sV3, StandardE16V3, StandardE2sV3, StandardE2V3, StandardE3216V3, StandardE328sV3, StandardE32sV3, StandardE32V3, StandardE4sV3, StandardE4V3, StandardE6416sV3, StandardE6432sV3, StandardE64sV3, StandardE64V3, StandardE8sV3, StandardE8V3, StandardF1, StandardF16, StandardF16s, StandardF16sV2, StandardF1s, StandardF2, StandardF2s, StandardF2sV2, StandardF32sV2, StandardF4, StandardF4s, StandardF4sV2, StandardF64sV2, StandardF72sV2, StandardF8, StandardF8s, StandardF8sV2, StandardG1, StandardG2, StandardG3, StandardG4, StandardG5, StandardGS1, StandardGS2, StandardGS3, StandardGS4, StandardGS44, StandardGS48, StandardGS5, StandardGS516, StandardGS58, StandardH16, StandardH16m, StandardH16mr, StandardH16r, StandardH8, StandardH8m, StandardL16s, StandardL32s, StandardL4s, StandardL8s, StandardM12832ms, StandardM12864ms, StandardM128ms, StandardM128s, StandardM6416ms, StandardM6432ms, StandardM64ms, StandardM64s, StandardNC12, StandardNC12sV2, StandardNC12sV3, StandardNC24, StandardNC24r, StandardNC24rsV2, StandardNC24rsV3, StandardNC24sV2, StandardNC24sV3, StandardNC6, StandardNC6sV2, StandardNC6sV3, StandardND12s, StandardND24rs, StandardND24s, StandardND6s, StandardNV12, StandardNV24, StandardNV6}
}
