/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.stickers;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import org.asamk.signal.manager.api.StickerPackId;
import org.asamk.signal.manager.storage.Database;
import org.asamk.signal.manager.storage.Utils;
import org.asamk.signal.manager.storage.stickers.StickerPack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StickerStore {
    private static final Logger logger = LoggerFactory.getLogger(StickerStore.class);
    private static final String TABLE_STICKER = "sticker";
    private final Database database;

    public static void createSql(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE sticker (\n  _id INTEGER PRIMARY KEY,\n  pack_id BLOB UNIQUE NOT NULL,\n  pack_key BLOB NOT NULL,\n  installed INTEGER NOT NULL DEFAULT FALSE\n) STRICT;\n");
        }
    }

    public StickerStore(Database database) {
        this.database = database;
    }

    /*
     * Exception decompiling
     */
    public List<StickerPack> getStickerPacks() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public StickerPack getStickerPack(StickerPackId packId) {
        String sql = "SELECT s._id, s.pack_id, s.pack_key, s.installed\nFROM %s s\nWHERE s.pack_id = ?\n".formatted(TABLE_STICKER);
        try (Connection connection = this.database.getConnection();){
            StickerPack stickerPack;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    statement.setBytes(1, packId.serialize());
                    stickerPack = Utils.executeQueryForOptional(statement, this::getStickerPackFromResultSet).orElse(null);
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return stickerPack;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from sticker store", e);
        }
    }

    public void addStickerPack(StickerPack stickerPack) {
        String sql = "INSERT INTO %s (pack_id, pack_key, installed)\nVALUES (?, ?, ?)\n".formatted(TABLE_STICKER);
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBytes(1, stickerPack.packId().serialize());
            statement.setBytes(2, stickerPack.packKey());
            statement.setBoolean(3, stickerPack.isInstalled());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update sticker store", e);
        }
    }

    public void updateStickerPackInstalled(StickerPackId stickerPackId, boolean installed) {
        String sql = "UPDATE %s\nSET installed = ?\nWHERE pack_id = ?\n".formatted(TABLE_STICKER);
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBytes(1, stickerPackId.serialize());
            statement.setBoolean(2, installed);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update sticker store", e);
        }
    }

    void addLegacyStickers(Collection<StickerPack> stickerPacks) {
        logger.debug("Migrating legacy stickers to database");
        long start = System.nanoTime();
        String sql = "INSERT INTO %s (pack_id, pack_key, installed)\nVALUES (?, ?, ?)\n".formatted(TABLE_STICKER);
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            try (PreparedStatement statement = connection.prepareStatement("DELETE FROM %s".formatted(TABLE_STICKER));){
                statement.executeUpdate();
            }
            statement = connection.prepareStatement(sql);
            try {
                for (StickerPack sticker : stickerPacks) {
                    statement.setBytes(1, sticker.packId().serialize());
                    statement.setBytes(2, sticker.packKey());
                    statement.setBoolean(3, sticker.isInstalled());
                    statement.executeUpdate();
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update sticker store", e);
        }
        logger.debug("Stickers migration took {}ms", (Object)((System.nanoTime() - start) / 1000000L));
    }

    private StickerPack getStickerPackFromResultSet(ResultSet resultSet) throws SQLException {
        long internalId = resultSet.getLong("_id");
        byte[] packId = resultSet.getBytes("pack_id");
        byte[] packKey = resultSet.getBytes("pack_key");
        boolean installed = resultSet.getBoolean("installed");
        return new StickerPack(internalId, StickerPackId.deserialize(packId), packKey, installed);
    }
}

