/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util;

import java.text.NumberFormat;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u001a\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0006\u00a8\u0006%"}, d2={"Lorg/signal/core/util/ByteSize;", "", "bytes", "", "(J)V", "getBytes", "()J", "inGibiBytes", "", "getInGibiBytes", "()F", "inKibiBytes", "getInKibiBytes", "inMebiBytes", "getInMebiBytes", "inTebiBytes", "getInTebiBytes", "inWholeBytes", "getInWholeBytes", "inWholeGibiBytes", "getInWholeGibiBytes", "inWholeKibiBytes", "getInWholeKibiBytes", "inWholeMebiBytes", "getInWholeMebiBytes", "inWholeTebiBytes", "getInWholeTebiBytes", "getLargestNonZeroValue", "Lkotlin/Pair;", "Lorg/signal/core/util/ByteSize$Size;", "toUnitString", "", "maxPlaces", "", "spaced", "", "Size", "core-util-jvm"})
public final class ByteSize {
    private final long bytes;

    public ByteSize(long bytes) {
        this.bytes = bytes;
    }

    public final long getBytes() {
        return this.bytes;
    }

    public final long getInWholeBytes() {
        return this.bytes;
    }

    public final long getInWholeKibiBytes() {
        return this.bytes / 1024L;
    }

    public final long getInWholeMebiBytes() {
        return this.getInWholeKibiBytes() / 1024L;
    }

    public final long getInWholeGibiBytes() {
        return this.getInWholeMebiBytes() / 1024L;
    }

    public final long getInWholeTebiBytes() {
        return this.getInWholeGibiBytes() / 1024L;
    }

    public final float getInKibiBytes() {
        return (float)this.bytes / 1024.0f;
    }

    public final float getInMebiBytes() {
        return this.getInKibiBytes() / 1024.0f;
    }

    public final float getInGibiBytes() {
        return this.getInMebiBytes() / 1024.0f;
    }

    public final float getInTebiBytes() {
        return this.getInGibiBytes() / 1024.0f;
    }

    @NotNull
    public final Pair<Float, Size> getLargestNonZeroValue() {
        return this.getInWholeTebiBytes() > 0L ? TuplesKt.to((Object)Float.valueOf(this.getInTebiBytes()), (Object)((Object)Size.TEBIBYTE)) : (this.getInWholeGibiBytes() > 0L ? TuplesKt.to((Object)Float.valueOf(this.getInGibiBytes()), (Object)((Object)Size.GIBIBYTE)) : (this.getInWholeMebiBytes() > 0L ? TuplesKt.to((Object)Float.valueOf(this.getInMebiBytes()), (Object)((Object)Size.MEBIBYTE)) : (this.getInWholeKibiBytes() > 0L ? TuplesKt.to((Object)Float.valueOf(this.getInKibiBytes()), (Object)((Object)Size.KIBIBYTE)) : TuplesKt.to((Object)Float.valueOf(this.getInWholeBytes()), (Object)((Object)Size.BYTE)))));
    }

    @NotNull
    public final String toUnitString(int maxPlaces, boolean spaced) {
        NumberFormat numberFormat;
        Pair<Float, Size> pair = this.getLargestNonZeroValue();
        float size = ((Number)pair.component1()).floatValue();
        Size unit = (Size)((Object)pair.component2());
        NumberFormat $this$toUnitString_u24lambda_u240 = numberFormat = NumberFormat.getInstance();
        boolean bl = false;
        $this$toUnitString_u24lambda_u240.setMinimumFractionDigits(0);
        $this$toUnitString_u24lambda_u240.setMaximumFractionDigits(switch (WhenMappings.$EnumSwitchMapping$0[unit.ordinal()]) {
            case 1, 2 -> 0;
            case 3 -> Math.min(1, maxPlaces);
            case 4, 5 -> Math.min(2, maxPlaces);
            default -> throw new NoWhenBranchMatchedException();
        });
        NumberFormat formatter = numberFormat;
        return formatter.format(Float.valueOf(size)) + (spaced ? " " : "") + unit.getLabel();
    }

    public static /* synthetic */ String toUnitString$default(ByteSize byteSize, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return byteSize.toUnitString(n, bl);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/signal/core/util/ByteSize$Size;", "", "label", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getLabel", "()Ljava/lang/String;", "BYTE", "KIBIBYTE", "MEBIBYTE", "GIBIBYTE", "TEBIBYTE", "core-util-jvm"})
    public static final class Size
    extends Enum<Size> {
        @NotNull
        private final String label;
        public static final /* enum */ Size BYTE = new Size("B");
        public static final /* enum */ Size KIBIBYTE = new Size("KB");
        public static final /* enum */ Size MEBIBYTE = new Size("MB");
        public static final /* enum */ Size GIBIBYTE = new Size("GB");
        public static final /* enum */ Size TEBIBYTE = new Size("TB");
        private static final /* synthetic */ Size[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Size(String label) {
            this.label = label;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        public static Size[] values() {
            return (Size[])$VALUES.clone();
        }

        public static Size valueOf(String value) {
            return Enum.valueOf(Size.class, value);
        }

        @NotNull
        public static EnumEntries<Size> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sizeArray = new Size[]{Size.BYTE, Size.KIBIBYTE, Size.MEBIBYTE, Size.GIBIBYTE, Size.TEBIBYTE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Size.values().length];
            try {
                nArray[Size.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Size.KIBIBYTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Size.MEBIBYTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Size.GIBIBYTE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Size.TEBIBYTE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

