/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.services;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import okio.ByteString;
import org.signal.cdsi.proto.ClientRequest;
import org.signal.cdsi.proto.ClientResponse;
import org.signal.core.util.logging.Log;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.net.CdsiLookupRequest;
import org.signal.libsignal.net.CdsiLookupResponse;
import org.signal.libsignal.net.Network;
import org.signal.libsignal.net.RetryLaterException;
import org.signal.libsignal.protocol.util.ByteUtil;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.whispersystems.signalservice.api.crypto.UnidentifiedAccess;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.exceptions.CdsiInvalidArgumentException;
import org.whispersystems.signalservice.api.push.exceptions.CdsiInvalidTokenException;
import org.whispersystems.signalservice.api.push.exceptions.CdsiResourceExhaustedException;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.services.CdsiSocket;
import org.whispersystems.signalservice.api.util.UuidUtil;
import org.whispersystems.signalservice.internal.ServiceResponse;
import org.whispersystems.signalservice.internal.configuration.SignalServiceConfiguration;

public final class CdsiV2Service {
    private static final String TAG = CdsiV2Service.class.getSimpleName();
    private static final UUID EMPTY_UUID = new UUID(0L, 0L);
    private static final int RESPONSE_ITEM_SIZE = 40;
    private final CdsiRequestHandler cdsiRequestHandler;

    public CdsiV2Service(SignalServiceConfiguration configuration, String mrEnclave, @Nullable Network network) {
        if (network != null) {
            this.cdsiRequestHandler = (username, password, request, tokenSaver) -> {
                try {
                    Log.i((String)TAG, (String)"Starting CDSI lookup via libsignal-net");
                    CompletableFuture cdsiRequest = network.cdsiLookup(username, password, CdsiV2Service.buildLibsignalRequest(request), tokenSaver);
                    return Single.fromFuture((Future)cdsiRequest).onErrorResumeNext(err -> {
                        if (err instanceof ExecutionException && err.getCause() != null) {
                            err = err.getCause();
                        }
                        return Single.error((Throwable)CdsiV2Service.mapLibsignalError(err));
                    }).map(CdsiV2Service::parseLibsignalResponse).toObservable();
                }
                catch (Exception exception) {
                    return Observable.error((Throwable)CdsiV2Service.mapLibsignalError(exception));
                }
            };
        } else {
            CdsiSocket cdsiSocket = new CdsiSocket(configuration, mrEnclave);
            this.cdsiRequestHandler = (username, password, request, tokenSaver) -> cdsiSocket.connect(username, password, CdsiV2Service.buildClientRequest(request), tokenSaver).map(CdsiV2Service::parseEntries);
        }
    }

    public Single<ServiceResponse<Response>> getRegisteredUsers(String username, String password, Request request, Consumer<byte[]> tokenSaver) {
        return this.cdsiRequestHandler.handleRequest(username, password, request, tokenSaver).collect(Collectors.toList()).flatMap(pages -> {
            HashMap<String, ResponseItem> all = new HashMap<String, ResponseItem>();
            int quotaUsed = 0;
            for (Response page : pages) {
                all.putAll(page.getResults());
                quotaUsed += page.getQuotaUsedDebugOnly();
            }
            return Single.just((Object)new Response(all, quotaUsed));
        }).map(result2 -> ServiceResponse.forResult(result2, 200, null)).onErrorReturn(error -> {
            if (error instanceof NonSuccessfulResponseCodeException) {
                int status = ((NonSuccessfulResponseCodeException)error).getCode();
                return ServiceResponse.forApplicationError(error, status, null);
            }
            return ServiceResponse.forUnknownError(error);
        });
    }

    private static Response parseEntries(ClientResponse clientResponse) {
        HashMap<String, ResponseItem> results = new HashMap<String, ResponseItem>();
        ByteBuffer parser = clientResponse.e164PniAciTriples.asByteBuffer();
        while (parser.remaining() >= 40) {
            String e164 = "+" + parser.getLong();
            UUID pniUuid = new UUID(parser.getLong(), parser.getLong());
            UUID aciUuid = new UUID(parser.getLong(), parser.getLong());
            if (pniUuid.equals(EMPTY_UUID)) continue;
            ServiceId.PNI pni = ServiceId.PNI.from(pniUuid);
            ServiceId.ACI aci = aciUuid.equals(EMPTY_UUID) ? null : ServiceId.ACI.from(aciUuid);
            results.put(e164, new ResponseItem(pni, Optional.ofNullable(aci)));
        }
        return new Response(results, clientResponse.debugPermitsUsed);
    }

    private static ClientRequest buildClientRequest(Request request) {
        List<Long> previousE164s = CdsiV2Service.parseAndSortE164Strings(request.previousE164s);
        List<Long> newE164s = CdsiV2Service.parseAndSortE164Strings(request.newE164s);
        List<Long> removedE164s = CdsiV2Service.parseAndSortE164Strings(request.removedE164s);
        ClientRequest.Builder builder = new ClientRequest.Builder().prevE164s(CdsiV2Service.toByteString(previousE164s)).newE164s(CdsiV2Service.toByteString(newE164s)).discardE164s(CdsiV2Service.toByteString(removedE164s)).aciUakPairs(CdsiV2Service.toByteString(request.serviceIds));
        if (request.token != null) {
            builder.token(ByteString.of((byte[])request.token));
        }
        return builder.build();
    }

    private static ByteString toByteString(List<Long> numbers) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (long number : numbers) {
            try {
                os.write(ByteUtil.longToByteArray((long)number));
            }
            catch (IOException e) {
                throw new AssertionError("Failed to write long to ByteString", e);
            }
        }
        return ByteString.of((byte[])os.toByteArray());
    }

    private static ByteString toByteString(Map<ServiceId, ProfileKey> serviceIds) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (Map.Entry<ServiceId, ProfileKey> entry : serviceIds.entrySet()) {
            try {
                os.write(UuidUtil.toByteArray(entry.getKey().getRawUuid()));
                os.write(UnidentifiedAccess.deriveAccessKeyFrom(entry.getValue()));
            }
            catch (IOException e) {
                throw new AssertionError("Failed to write long to ByteString", e);
            }
        }
        return ByteString.of((byte[])os.toByteArray());
    }

    private static CdsiLookupRequest buildLibsignalRequest(Request request) {
        HashMap serviceIds = new HashMap(request.serviceIds.size());
        request.serviceIds.forEach((key, value) -> serviceIds.put(key.getLibSignalServiceId(), value));
        return new CdsiLookupRequest(request.previousE164s, request.newE164s, serviceIds, false, Optional.ofNullable(request.token));
    }

    private static Response parseLibsignalResponse(CdsiLookupResponse response) {
        HashMap<String, ResponseItem> responses = new HashMap<String, ResponseItem>(response.entries().size());
        response.entries().forEach((key, value) -> responses.put((String)key, new ResponseItem(new ServiceId.PNI(value.pni), Optional.ofNullable(value.aci).map(ServiceId.ACI::new))));
        return new Response(responses, response.debugPermitsUsed);
    }

    private static Throwable mapLibsignalError(Throwable lookupError) {
        if (lookupError instanceof org.signal.libsignal.net.CdsiInvalidTokenException) {
            return new CdsiInvalidTokenException();
        }
        if (lookupError instanceof RetryLaterException) {
            RetryLaterException e = (RetryLaterException)lookupError;
            return new CdsiResourceExhaustedException((int)e.duration.getSeconds());
        }
        if (lookupError instanceof IllegalArgumentException) {
            return new CdsiInvalidArgumentException();
        }
        return lookupError;
    }

    private static List<Long> parseAndSortE164Strings(Collection<String> e164s) {
        return e164s.stream().map(Long::parseLong).sorted().collect(Collectors.toList());
    }

    private static interface CdsiRequestHandler {
        public Observable<Response> handleRequest(String var1, String var2, Request var3, Consumer<byte[]> var4);
    }

    public static final class Request {
        final Set<String> previousE164s;
        final Set<String> newE164s;
        final Set<String> removedE164s;
        final Map<ServiceId, ProfileKey> serviceIds;
        final byte[] token;

        public Request(Set<String> previousE164s, Set<String> newE164s, Map<ServiceId, ProfileKey> serviceIds, Optional<byte[]> token) {
            if (previousE164s.size() > 0 && !token.isPresent()) {
                throw new IllegalArgumentException("You must have a token if you have previousE164s!");
            }
            this.previousE164s = previousE164s;
            this.newE164s = newE164s;
            this.removedE164s = Collections.emptySet();
            this.serviceIds = serviceIds;
            this.token = token.orElse(null);
        }

        public int serviceIdSize() {
            return this.previousE164s.size() + this.newE164s.size() + this.removedE164s.size() + this.serviceIds.size();
        }
    }

    public static final class ResponseItem {
        private final ServiceId.PNI pni;
        private final Optional<ServiceId.ACI> aci;

        public ResponseItem(ServiceId.PNI pni, Optional<ServiceId.ACI> aci) {
            this.pni = pni;
            this.aci = aci;
        }

        public ServiceId.PNI getPni() {
            return this.pni;
        }

        public Optional<ServiceId.ACI> getAci() {
            return this.aci;
        }

        public boolean hasAci() {
            return this.aci.isPresent();
        }
    }

    public static final class Response {
        private final Map<String, ResponseItem> results;
        private final int quotaUsed;

        public Response(Map<String, ResponseItem> results, int quoteUsed) {
            this.results = results;
            this.quotaUsed = quoteUsed;
        }

        public Map<String, ResponseItem> getResults() {
            return this.results;
        }

        public int getQuotaUsedDebugOnly() {
            return this.quotaUsed;
        }
    }
}

