/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.services;

import io.reactivex.rxjava3.core.Observable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionSpec;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.signal.cdsi.proto.ClientRequest;
import org.signal.cdsi.proto.ClientResponse;
import org.signal.core.util.Base64;
import org.signal.libsignal.attest.AttestationDataException;
import org.signal.libsignal.attest.AttestationFailedException;
import org.signal.libsignal.cds2.Cds2Client;
import org.signal.libsignal.protocol.logging.Log;
import org.signal.libsignal.protocol.util.Pair;
import org.signal.libsignal.sgxsession.SgxCommunicationFailureException;
import org.whispersystems.signalservice.api.push.TrustStore;
import org.whispersystems.signalservice.api.push.exceptions.CdsiInvalidArgumentException;
import org.whispersystems.signalservice.api.push.exceptions.CdsiInvalidTokenException;
import org.whispersystems.signalservice.api.push.exceptions.CdsiResourceExhaustedException;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.util.Tls12SocketFactory;
import org.whispersystems.signalservice.api.util.TlsProxySocketFactory;
import org.whispersystems.signalservice.internal.configuration.SignalCdsiUrl;
import org.whispersystems.signalservice.internal.configuration.SignalProxy;
import org.whispersystems.signalservice.internal.configuration.SignalServiceConfiguration;
import org.whispersystems.signalservice.internal.push.CdsiResourceExhaustedResponse;
import org.whispersystems.signalservice.internal.util.BlacklistingTrustManager;
import org.whispersystems.signalservice.internal.util.Hex;
import org.whispersystems.signalservice.internal.util.JsonUtil;
import org.whispersystems.signalservice.internal.util.Util;

final class CdsiSocket {
    private static final String TAG = CdsiSocket.class.getSimpleName();
    private final SignalCdsiUrl cdsiUrl;
    private final OkHttpClient okhttp;
    private final String mrEnclave;
    private Cds2Client client;

    CdsiSocket(SignalServiceConfiguration configuration, String mrEnclave) {
        this.cdsiUrl = CdsiSocket.chooseUrl(configuration.getSignalCdsiUrls());
        this.mrEnclave = mrEnclave;
        Pair<SSLSocketFactory, X509TrustManager> socketFactory = CdsiSocket.createTlsSocketFactory(this.cdsiUrl.getTrustStore());
        Optional<List<ConnectionSpec>> connectionSpecs = this.cdsiUrl.getConnectionSpecs();
        OkHttpClient.Builder builder = new OkHttpClient.Builder().sslSocketFactory((SSLSocketFactory)new Tls12SocketFactory((SSLSocketFactory)socketFactory.first()), (X509TrustManager)socketFactory.second()).connectionSpecs(connectionSpecs.orElse(Util.immutableList(ConnectionSpec.RESTRICTED_TLS))).retryOnConnectionFailure(false).readTimeout(30L, TimeUnit.SECONDS).connectTimeout(30L, TimeUnit.SECONDS);
        for (Interceptor interceptor : configuration.getNetworkInterceptors()) {
            builder.addInterceptor(interceptor);
        }
        if (configuration.getSignalProxy().isPresent()) {
            SignalProxy proxy = configuration.getSignalProxy().get();
            builder.socketFactory((SocketFactory)new TlsProxySocketFactory(proxy.getHost(), proxy.getPort(), configuration.getDns()));
        }
        this.okhttp = builder.build();
    }

    Observable<ClientResponse> connect(String username, String password, final ClientRequest clientRequest, final Consumer<byte[]> tokenSaver) {
        return Observable.create(emitter -> {
            final AtomicReference<Stage> stage = new AtomicReference<Stage>(Stage.WAITING_TO_INITIALIZE);
            String url = String.format("%s/v1/%s/discovery", this.cdsiUrl.getUrl(), this.mrEnclave);
            Request.Builder request = new Request.Builder().url(url).addHeader("Authorization", CdsiSocket.basicAuth(username, password));
            if (this.cdsiUrl.getHostHeader().isPresent()) {
                request.addHeader("Host", this.cdsiUrl.getHostHeader().get());
                Log.w((String)TAG, (String)("Using alternate host: " + this.cdsiUrl.getHostHeader().get()));
            }
            WebSocket webSocket = this.okhttp.newWebSocket(request.build(), new WebSocketListener(this){
                final /* synthetic */ CdsiSocket this$0;
                {
                    this.this$0 = this$0;
                }

                public void onOpen(WebSocket webSocket, Response response) {
                    Log.d((String)TAG, (String)"[onOpen]");
                    stage.set(Stage.WAITING_FOR_CONNECTION);
                }

                public void onMessage(WebSocket webSocket, ByteString bytes) {
                    Log.d((String)TAG, (String)("[onMessage] stage: " + String.valueOf(stage.get())));
                    try {
                        switch (((Stage)((Object)stage.get())).ordinal()) {
                            case 0: {
                                throw new IOException("Received a message before we were open!");
                            }
                            case 1: {
                                this.this$0.client = new Cds2Client(Hex.fromStringCondensed(this.this$0.mrEnclave), bytes.toByteArray(), Instant.now());
                                Log.d((String)TAG, (String)"[onMessage] Sending initial handshake...");
                                webSocket.send(ByteString.of((byte[])this.this$0.client.initialRequest()));
                                stage.set(Stage.WAITING_FOR_HANDSHAKE);
                                break;
                            }
                            case 2: {
                                this.this$0.client.completeHandshake(bytes.toByteArray());
                                Log.d((String)TAG, (String)"[onMessage] Handshake read success.");
                                Log.d((String)TAG, (String)"[onMessage] Sending data...");
                                byte[] ciphertextBytes = this.this$0.client.establishedSend(clientRequest.encode());
                                webSocket.send(ByteString.of((byte[])ciphertextBytes));
                                Log.d((String)TAG, (String)"[onMessage] Data sent.");
                                stage.set(Stage.WAITING_FOR_TOKEN);
                                break;
                            }
                            case 3: {
                                ClientResponse tokenResponse = (ClientResponse)((Object)ClientResponse.ADAPTER.decode(this.this$0.client.establishedRecv(bytes.toByteArray())));
                                if (tokenResponse.token.size() == 0) {
                                    throw new IOException("No token! Cannot continue!");
                                }
                                tokenSaver.accept(tokenResponse.token.toByteArray());
                                Log.d((String)TAG, (String)"[onMessage] Sending token ack...");
                                webSocket.send(ByteString.of((byte[])this.this$0.client.establishedSend(new ClientRequest.Builder().tokenAck(true).build().encode())));
                                stage.set(Stage.WAITING_FOR_RESPONSE);
                                break;
                            }
                            case 5: {
                                emitter.onNext((Object)((ClientResponse)((Object)ClientResponse.ADAPTER.decode(this.this$0.client.establishedRecv(bytes.toByteArray())))));
                                break;
                            }
                            case 6: {
                                Log.w((String)TAG, (String)"[onMessage] Received a message after the websocket closed! Ignoring.");
                                break;
                            }
                            case 7: {
                                Log.w((String)TAG, (String)"[onMessage] Received a message after we entered the failure state! Ignoring.");
                                webSocket.close(1000, "OK");
                            }
                        }
                    }
                    catch (IOException | AttestationDataException | AttestationFailedException | SgxCommunicationFailureException e) {
                        Log.w((String)TAG, (Throwable)e);
                        webSocket.close(1000, "OK");
                        emitter.tryOnError(e);
                    }
                }

                public void onClosing(WebSocket webSocket, int code, String reason) {
                    Log.i((String)TAG, (String)("[onClosing] code: " + code + ", reason: " + reason));
                    if (code == 1000) {
                        emitter.onComplete();
                        stage.set(Stage.CLOSED);
                    } else {
                        Log.w((String)TAG, (String)("Remote side is closing with non-normal code " + code));
                        webSocket.close(1000, "Remote closed with code " + code);
                        stage.set(Stage.FAILED);
                        if (code == 4003) {
                            emitter.tryOnError((Throwable)new CdsiInvalidArgumentException());
                        } else if (code == 4008) {
                            try {
                                CdsiResourceExhaustedResponse response = JsonUtil.fromJsonResponse(reason, CdsiResourceExhaustedResponse.class);
                                emitter.tryOnError((Throwable)new CdsiResourceExhaustedException(response.getRetryAfter()));
                            }
                            catch (IOException e) {
                                Log.w((String)TAG, (String)"Failed to parse the retry_after!");
                                emitter.tryOnError((Throwable)new NonSuccessfulResponseCodeException(code));
                            }
                        } else if (code == 4101) {
                            emitter.tryOnError((Throwable)new CdsiInvalidTokenException());
                        } else {
                            emitter.tryOnError((Throwable)new NonSuccessfulResponseCodeException(code));
                        }
                    }
                }

                public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                    Log.w((String)TAG, (String)("[onFailure] response? " + (response != null)), (Throwable)t);
                    emitter.tryOnError(t);
                    stage.set(Stage.FAILED);
                    webSocket.close(1000, "OK");
                }
            });
            emitter.setCancellable(() -> webSocket.close(1000, "OK"));
        });
    }

    private static String basicAuth(String username, String password) {
        return "Basic " + Base64.encodeWithPadding((byte[])(username + ":" + password).getBytes(StandardCharsets.UTF_8));
    }

    private static Pair<SSLSocketFactory, X509TrustManager> createTlsSocketFactory(TrustStore trustStore) {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            TrustManager[] trustManagers = BlacklistingTrustManager.createFor(trustStore);
            context.init(null, trustManagers, null);
            return new Pair((Object)context.getSocketFactory(), (Object)((X509TrustManager)trustManagers[0]));
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static SignalCdsiUrl chooseUrl(SignalCdsiUrl[] urls) {
        return urls[(int)(Math.random() * (double)urls.length)];
    }

    private static enum Stage {
        INIT,
        WAITING_FOR_CONNECTION,
        WAITING_FOR_HANDSHAKE,
        WAITING_FOR_TOKEN,
        WAITING_TO_INITIALIZE,
        WAITING_FOR_RESPONSE,
        CLOSED,
        FAILED;

    }
}

