/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.message;

import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.InvalidVersionException;
import org.signal.libsignal.protocol.message.CiphertextMessage;
import org.signal.libsignal.protocol.message.DecryptionErrorMessage;

public final class PlaintextContent
implements CiphertextMessage,
NativeHandleGuard.Owner {
    private final long unsafeHandle;

    protected void finalize() {
        Native.PlaintextContent_Destroy(this.unsafeHandle);
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }

    private PlaintextContent(long unsafeHandle) {
        this.unsafeHandle = unsafeHandle;
    }

    public PlaintextContent(DecryptionErrorMessage message) {
        try (NativeHandleGuard messageGuard = new NativeHandleGuard(message);){
            this.unsafeHandle = Native.PlaintextContent_FromDecryptionErrorMessage(messageGuard.nativeHandle());
        }
    }

    public PlaintextContent(byte[] serialized) throws InvalidMessageException, InvalidVersionException {
        this.unsafeHandle = FilterExceptions.filterExceptions(InvalidMessageException.class, InvalidVersionException.class, () -> Native.PlaintextContent_Deserialize(serialized));
    }

    @Override
    public byte[] serialize() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = FilterExceptions.filterExceptions(() -> Native.PlaintextContent_GetSerialized(guard.nativeHandle()));
            return byArray;
        }
    }

    @Override
    public int getType() {
        return 8;
    }

    public byte[] getBody() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = FilterExceptions.filterExceptions(() -> Native.PlaintextContent_GetBody(guard.nativeHandle()));
            return byArray;
        }
    }
}

