# Test data for deep learning-based face detection and face recognition

This directory contains images and labels for the unit tests of deep learning-based face detection and face recognition.

## Data in `./detection`

- `cascades_labels.txt`: contains the ground truth generated by [libfacedetection](https://github.com/ShiqiYu/libfacedetection) from the images under `../cascadeandhog/images`. The format is as follows:
    - image_name_1
    - number_of_faces_in_image_1
    - face_1_in_image_1: `x, y, w, h, x0, y0, x1, y1, x2, y2, x3, y3, x4, y4`
    - face_2_in_image_1: ...
    - ...
    - image_name_2
    - number_of_faces_in_image_2
    - face_1_in_image_2: ...
    - ...

    where `x, y, w, h` stands for the top-left coordinates and the width and height of the bounding box, `x0, y0` stands for the coordinates of the pupile of the right eye, `x1, y1` stands for the left eye, `x2, y2` stands for the coordinates of the nose tip, `x3, y3` and `x4, y4` stands for the coordinates of right and left corner of the mouth.

## Data in `./recognition`

- `*.jpg`: these images can be found on [LFW dataset](http://vis-www.cs.umass.edu/lfw/).
- `cascades_label.txt`: contains two pairs (same and different identities) for the recognition unit test. The format is as follows:
    - image_name_1 image_name_2 label

    where `label` is either 0 or 1, and `0` means same identity, `1` means different identities.