// Code generated by go-swagger; DO NOT EDIT.

package iam_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// IamServiceDeleteOrganizationMembershipReader is a Reader for the IamServiceDeleteOrganizationMembership structure.
type IamServiceDeleteOrganizationMembershipReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IamServiceDeleteOrganizationMembershipReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIamServiceDeleteOrganizationMembershipOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIamServiceDeleteOrganizationMembershipDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIamServiceDeleteOrganizationMembershipOK creates a IamServiceDeleteOrganizationMembershipOK with default headers values
func NewIamServiceDeleteOrganizationMembershipOK() *IamServiceDeleteOrganizationMembershipOK {
	return &IamServiceDeleteOrganizationMembershipOK{}
}

/*
IamServiceDeleteOrganizationMembershipOK describes a response with status code 200, with default header values.

A successful response.
*/
type IamServiceDeleteOrganizationMembershipOK struct {
	Payload models.HashicorpCloudIamDeleteOrganizationMembershipResponse
}

// IsSuccess returns true when this iam service delete organization membership o k response has a 2xx status code
func (o *IamServiceDeleteOrganizationMembershipOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this iam service delete organization membership o k response has a 3xx status code
func (o *IamServiceDeleteOrganizationMembershipOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this iam service delete organization membership o k response has a 4xx status code
func (o *IamServiceDeleteOrganizationMembershipOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this iam service delete organization membership o k response has a 5xx status code
func (o *IamServiceDeleteOrganizationMembershipOK) IsServerError() bool {
	return false
}

// IsCode returns true when this iam service delete organization membership o k response a status code equal to that given
func (o *IamServiceDeleteOrganizationMembershipOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the iam service delete organization membership o k response
func (o *IamServiceDeleteOrganizationMembershipOK) Code() int {
	return 200
}

func (o *IamServiceDeleteOrganizationMembershipOK) Error() string {
	return fmt.Sprintf("[DELETE /iam/2019-12-10/organizations/{organization_id}/user-principals/{user_principal_id}][%d] iamServiceDeleteOrganizationMembershipOK  %+v", 200, o.Payload)
}

func (o *IamServiceDeleteOrganizationMembershipOK) String() string {
	return fmt.Sprintf("[DELETE /iam/2019-12-10/organizations/{organization_id}/user-principals/{user_principal_id}][%d] iamServiceDeleteOrganizationMembershipOK  %+v", 200, o.Payload)
}

func (o *IamServiceDeleteOrganizationMembershipOK) GetPayload() models.HashicorpCloudIamDeleteOrganizationMembershipResponse {
	return o.Payload
}

func (o *IamServiceDeleteOrganizationMembershipOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewIamServiceDeleteOrganizationMembershipDefault creates a IamServiceDeleteOrganizationMembershipDefault with default headers values
func NewIamServiceDeleteOrganizationMembershipDefault(code int) *IamServiceDeleteOrganizationMembershipDefault {
	return &IamServiceDeleteOrganizationMembershipDefault{
		_statusCode: code,
	}
}

/*
IamServiceDeleteOrganizationMembershipDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type IamServiceDeleteOrganizationMembershipDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this iam service delete organization membership default response has a 2xx status code
func (o *IamServiceDeleteOrganizationMembershipDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this iam service delete organization membership default response has a 3xx status code
func (o *IamServiceDeleteOrganizationMembershipDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this iam service delete organization membership default response has a 4xx status code
func (o *IamServiceDeleteOrganizationMembershipDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this iam service delete organization membership default response has a 5xx status code
func (o *IamServiceDeleteOrganizationMembershipDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this iam service delete organization membership default response a status code equal to that given
func (o *IamServiceDeleteOrganizationMembershipDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the iam service delete organization membership default response
func (o *IamServiceDeleteOrganizationMembershipDefault) Code() int {
	return o._statusCode
}

func (o *IamServiceDeleteOrganizationMembershipDefault) Error() string {
	return fmt.Sprintf("[DELETE /iam/2019-12-10/organizations/{organization_id}/user-principals/{user_principal_id}][%d] IamService_DeleteOrganizationMembership default  %+v", o._statusCode, o.Payload)
}

func (o *IamServiceDeleteOrganizationMembershipDefault) String() string {
	return fmt.Sprintf("[DELETE /iam/2019-12-10/organizations/{organization_id}/user-principals/{user_principal_id}][%d] IamService_DeleteOrganizationMembership default  %+v", o._statusCode, o.Payload)
}

func (o *IamServiceDeleteOrganizationMembershipDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *IamServiceDeleteOrganizationMembershipDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
