Generate empty interfaces when using (empty_module_interface_if_absent)

  $ cat >dune-project <<EOF
  > (lang dune 3.0)
  > EOF

Executables

  $ cat >main.ml <<EOF
  > module D = Dep
  > EOF

  $ touch dep.ml

  $ cat >dune <<EOF
  > (executable (name main) (empty_module_interface_if_absent))
  > EOF

  $ dune build ./main.exe

  $ cat _build/default/dep.mli
  (* Auto-generated by Dune *)

Libraries

  $ cat >dune <<EOF
  > (library (name l) (modules a b) (empty_module_interface_if_absent))
  > EOF

  $ touch a.ml b.ml

  $ dune build

  $ cat _build/default/a.mli
  (* Auto-generated by Dune *)
  $ cat _build/default/b.mli
  (* Auto-generated by Dune *)

Version check

  $ cat >dune-project <<EOF
  > (lang dune 2.9)
  > EOF

  $ dune build
  File "dune", line 1, characters 32-66:
  1 | (library (name l) (modules a b) (empty_module_interface_if_absent))
                                      ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
  Error: 'empty_module_interface_if_absent' is only available since version 3.0
  of the dune language. Please update your dune-project file to have (lang dune
  3.0).
  [1]

Check that interfaces are *not* generated if field is not used

  $ cat >dune <<EOF
  > (lang dune 3.0)
  > EOF

  $ cat >dune <<EOF
  > (library (name l) (modules a b))
  > EOF

  $ touch a.mli

  $ dune build

  $ test -f _build/default/a.mli

  $ test ! -f _build/default/b.mli
