/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.sitemap.internal;

import com.google.common.collect.MapMaker;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.Sse;
import javax.ws.rs.sse.SseEventSink;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.i18n.TimeZoneProvider;
import org.openhab.core.io.rest.JSONResponse;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.SseBroadcaster;
import org.openhab.core.io.rest.core.item.EnrichedItemDTOMapper;
import org.openhab.core.io.rest.sitemap.SitemapSubscriptionService;
import org.openhab.core.io.rest.sitemap.internal.JerseyResponseBuilderUtils;
import org.openhab.core.io.rest.sitemap.internal.MappingDTO;
import org.openhab.core.io.rest.sitemap.internal.PageDTO;
import org.openhab.core.io.rest.sitemap.internal.ServerAliveEvent;
import org.openhab.core.io.rest.sitemap.internal.SitemapDTO;
import org.openhab.core.io.rest.sitemap.internal.SitemapEvent;
import org.openhab.core.io.rest.sitemap.internal.SitemapWidgetEvent;
import org.openhab.core.io.rest.sitemap.internal.SseSinkInfo;
import org.openhab.core.io.rest.sitemap.internal.WidgetDTO;
import org.openhab.core.items.GenericItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.events.GroupItemStateChangedEvent;
import org.openhab.core.items.events.ItemEvent;
import org.openhab.core.items.events.ItemStateChangedEvent;
import org.openhab.core.library.types.HSBType;
import org.openhab.core.model.sitemap.SitemapProvider;
import org.openhab.core.model.sitemap.sitemap.Button;
import org.openhab.core.model.sitemap.sitemap.ButtonDefinition;
import org.openhab.core.model.sitemap.sitemap.Buttongrid;
import org.openhab.core.model.sitemap.sitemap.Chart;
import org.openhab.core.model.sitemap.sitemap.ColorArray;
import org.openhab.core.model.sitemap.sitemap.Colortemperaturepicker;
import org.openhab.core.model.sitemap.sitemap.Condition;
import org.openhab.core.model.sitemap.sitemap.Frame;
import org.openhab.core.model.sitemap.sitemap.IconRule;
import org.openhab.core.model.sitemap.sitemap.Image;
import org.openhab.core.model.sitemap.sitemap.Input;
import org.openhab.core.model.sitemap.sitemap.LinkableWidget;
import org.openhab.core.model.sitemap.sitemap.Mapping;
import org.openhab.core.model.sitemap.sitemap.Mapview;
import org.openhab.core.model.sitemap.sitemap.Selection;
import org.openhab.core.model.sitemap.sitemap.Setpoint;
import org.openhab.core.model.sitemap.sitemap.Sitemap;
import org.openhab.core.model.sitemap.sitemap.Slider;
import org.openhab.core.model.sitemap.sitemap.Switch;
import org.openhab.core.model.sitemap.sitemap.Video;
import org.openhab.core.model.sitemap.sitemap.VisibilityRule;
import org.openhab.core.model.sitemap.sitemap.Webview;
import org.openhab.core.model.sitemap.sitemap.Widget;
import org.openhab.core.types.State;
import org.openhab.core.ui.items.ItemUIRegistry;
import org.openhab.core.util.ColorUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="sitemaps")
@RolesAllowed(value={"user", "administrator"})
@Tag(name="sitemaps")
@Component(service={RESTResource.class, EventSubscriber.class})
@JaxrsResource
@JaxrsName(value="sitemaps")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class SitemapResource
implements RESTResource,
SitemapSubscriptionService.SitemapSubscriptionCallback,
SseBroadcaster.Listener<SseSinkInfo>,
EventSubscriber {
    private final Logger logger = LoggerFactory.getLogger(SitemapResource.class);
    public static final String PATH_SITEMAPS = "sitemaps";
    private static final String SEGMENT_EVENTS = "events";
    private static final String X_ACCEL_BUFFERING_HEADER = "X-Accel-Buffering";
    private static final long TIMEOUT_IN_MS = 30000L;
    private SseBroadcaster<@NonNull SseSinkInfo> broadcaster;
    @Context
    @NonNullByDefault(value={})
    UriInfo uriInfo;
    @Context
    @NonNullByDefault(value={})
    HttpServletRequest request;
    @Context
    @NonNullByDefault(value={})
    HttpServletResponse response;
    @Context
    @NonNullByDefault(value={})
    Sse sse;
    private final ItemUIRegistry itemUIRegistry;
    private final SitemapSubscriptionService subscriptions;
    private final LocaleService localeService;
    private final TimeZoneProvider timeZoneProvider;
    private final List<SitemapProvider> sitemapProviders = new ArrayList<SitemapProvider>();
    private final Map<String, SseSinkInfo> knownSubscriptions = new MapMaker().weakValues().makeMap();
    private final ScheduledExecutorService scheduler = ThreadPoolManager.getScheduledPool((String)"common");
    private @Nullable ScheduledFuture<?> cleanSubscriptionsJob;
    private Set<BlockingStateChangeListener> stateChangeListeners = new CopyOnWriteArraySet<BlockingStateChangeListener>();

    @Activate
    public SitemapResource(@Reference ItemUIRegistry itemUIRegistry, @Reference LocaleService localeService, @Reference TimeZoneProvider timeZoneProvider, @Reference SitemapSubscriptionService subscriptions) {
        this.itemUIRegistry = itemUIRegistry;
        this.localeService = localeService;
        this.timeZoneProvider = timeZoneProvider;
        this.subscriptions = subscriptions;
        this.broadcaster = new SseBroadcaster();
        this.broadcaster.addListener((SseBroadcaster.Listener)this);
        this.cleanSubscriptionsJob = this.scheduler.scheduleAtFixedRate(() -> {
            this.logger.debug("Run clean SSE subscriptions job");
            subscriptions.checkAliveClients();
        }, 1L, 2L, TimeUnit.MINUTES);
    }

    @Deactivate
    protected void deactivate() {
        ScheduledFuture<?> job = this.cleanSubscriptionsJob;
        if (job != null && !job.isCancelled()) {
            this.logger.debug("Cancel clean SSE subscriptions job");
            job.cancel(true);
            this.cleanSubscriptionsJob = null;
        }
        this.broadcaster.removeListener((SseBroadcaster.Listener)this);
        this.broadcaster.close();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addSitemapProvider(SitemapProvider provider) {
        this.sitemapProviders.add(provider);
    }

    public void removeSitemapProvider(SitemapProvider provider) {
        this.sitemapProviders.remove(provider);
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(operationId="getSitemaps", summary="Get all available sitemaps.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SitemapDTO.class)))})})
    public Response getSitemaps() {
        this.logger.debug("Received HTTP GET request from IP {} at '{}'", (Object)this.request.getRemoteAddr(), (Object)this.uriInfo.getPath());
        Collection<SitemapDTO> responseObject = this.getSitemapBeans(this.uriInfo.getAbsolutePathBuilder().build(new Object[0]));
        return Response.ok(responseObject).build();
    }

    @GET
    @Path(value="/{sitemapname: [a-zA-Z_0-9]+}")
    @Produces(value={"application/json"})
    @Operation(operationId="getSitemapByName", summary="Get sitemap by name.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SitemapDTO.class))})})
    public Response getSitemapData(@Context HttpHeaders headers, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="sitemapname") @Parameter(description="sitemap name") String sitemapname, @QueryParam(value="type") String type, @QueryParam(value="jsoncallback") @DefaultValue(value="callback") String callback, @QueryParam(value="includeHidden") @Parameter(description="include hidden widgets") boolean includeHiddenWidgets) {
        Locale locale = this.localeService.getLocale(language);
        this.logger.debug("Received HTTP GET request from IP {} at '{}' for media type '{}'.", new Object[]{this.request.getRemoteAddr(), this.uriInfo.getPath(), type});
        URI uri = this.uriInfo.getBaseUriBuilder().build(new Object[0]);
        SitemapDTO responseObject = this.getSitemapBean(sitemapname, uri, locale, includeHiddenWidgets, false);
        return Response.ok((Object)responseObject).build();
    }

    @GET
    @Path(value="/{sitemapname: [a-zA-Z_0-9]+}/*")
    @Produces(value={"application/json"})
    @Operation(operationId="pollDataForSitemap", summary="Polls the data for a whole sitemap. Not recommended due to potentially high traffic.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SitemapDTO.class))}), @ApiResponse(responseCode="404", description="Sitemap with requested name does not exist"), @ApiResponse(responseCode="400", description="Invalid subscription id has been provided.")})
    public Response getSitemapData(@Context HttpHeaders headers, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="sitemapname") @Parameter(description="sitemap name") String sitemapname, @QueryParam(value="subscriptionid") @Parameter(description="subscriptionid") @Nullable String subscriptionId, @QueryParam(value="includeHidden") @Parameter(description="include hidden widgets") boolean includeHiddenWidgets) {
        Locale locale = this.localeService.getLocale(language);
        this.logger.debug("Received HTTP GET request from IP {} at '{}'", (Object)this.request.getRemoteAddr(), (Object)this.uriInfo.getPath());
        if (subscriptionId != null) {
            try {
                this.subscriptions.updateSubscriptionLocation(subscriptionId, sitemapname, null);
            }
            catch (IllegalArgumentException e) {
                return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)e.getMessage());
            }
        }
        boolean timeout = false;
        if (headers.getRequestHeader("X-Atmosphere-Transport") != null) {
            timeout = this.blockUntilChangeOccurs(sitemapname, null);
        }
        SitemapDTO responseObject = this.getSitemapBean(sitemapname, this.uriInfo.getBaseUriBuilder().build(new Object[0]), locale, includeHiddenWidgets, timeout);
        return Response.ok((Object)responseObject).build();
    }

    @GET
    @Path(value="/{sitemapname: [a-zA-Z_0-9]+}/{pageid: [a-zA-Z_0-9]+}")
    @Produces(value={"application/json"})
    @Operation(operationId="pollDataForPage", summary="Polls the data for one page of a sitemap.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=PageDTO.class))}), @ApiResponse(responseCode="404", description="Sitemap with requested name does not exist or page does not exist, or page refers to a non-linkable widget"), @ApiResponse(responseCode="400", description="Invalid subscription id has been provided.")})
    public Response getPageData(@Context HttpHeaders headers, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="sitemapname") @Parameter(description="sitemap name") String sitemapname, @PathParam(value="pageid") @Parameter(description="page id") String pageId, @QueryParam(value="subscriptionid") @Parameter(description="subscriptionid") @Nullable String subscriptionId, @QueryParam(value="includeHidden") @Parameter(description="include hidden widgets") boolean includeHiddenWidgets) {
        Locale locale = this.localeService.getLocale(language);
        this.logger.debug("Received HTTP GET request from IP {} at '{}'", (Object)this.request.getRemoteAddr(), (Object)this.uriInfo.getPath());
        if (subscriptionId != null) {
            try {
                this.subscriptions.updateSubscriptionLocation(subscriptionId, sitemapname, pageId);
            }
            catch (IllegalArgumentException e) {
                return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)e.getMessage());
            }
        }
        boolean timeout = false;
        if (headers.getRequestHeader("X-Atmosphere-Transport") != null) {
            timeout = this.blockUntilChangeOccurs(sitemapname, pageId);
        }
        PageDTO responseObject = this.getPageBean(sitemapname, pageId, this.uriInfo.getBaseUriBuilder().build(new Object[0]), locale, timeout, includeHiddenWidgets);
        return Response.ok((Object)responseObject).build();
    }

    @POST
    @Path(value="events/subscribe")
    @Produces(value={"application/json"})
    @Operation(operationId="createSitemapEventSubscription", summary="Creates a sitemap event subscription.", responses={@ApiResponse(responseCode="201", description="Subscription created."), @ApiResponse(responseCode="503", description="Subscriptions limit reached.")})
    public Object createEventSubscription() {
        this.logger.debug("Received HTTP POST request from IP {} at '{}'", (Object)this.request.getRemoteAddr(), (Object)this.uriInfo.getPath());
        String subscriptionId = this.subscriptions.createSubscription(this);
        if (subscriptionId == null) {
            return JSONResponse.createResponse((Response.StatusType)Response.Status.SERVICE_UNAVAILABLE, null, (String)"Max number of subscriptions is reached.");
        }
        SseSinkInfo sinkInfo = new SseSinkInfo(subscriptionId, this.subscriptions);
        this.knownSubscriptions.put(subscriptionId, sinkInfo);
        URI uri = this.uriInfo.getBaseUriBuilder().path(PATH_SITEMAPS).path(SEGMENT_EVENTS).path(subscriptionId).build(new Object[0]);
        this.logger.debug("Client from IP {} requested new subscription => got id {}.", (Object)this.request.getRemoteAddr(), (Object)subscriptionId);
        return JerseyResponseBuilderUtils.created(uri.toASCIIString());
    }

    @GET
    @Path(value="events/{subscriptionid: [a-zA-Z_0-9-]+}/*")
    @Produces(value={"text/event-stream"})
    @Operation(operationId="getSitemapEvents", summary="Get sitemap events for a whole sitemap. Not recommended due to potentially high traffic.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Missing sitemap parameter, or sitemap not linked successfully to the subscription."), @ApiResponse(responseCode="404", description="Subscription not found.")})
    public void getSitemapEvents(@Context SseEventSink sseEventSink, @Context HttpServletResponse response, @PathParam(value="subscriptionid") @Parameter(description="subscription id") String subscriptionId, @QueryParam(value="sitemap") @Parameter(description="sitemap name") @Nullable String sitemapname) {
        this.getSitemapEvents(sseEventSink, response, subscriptionId, sitemapname, null, true);
    }

    @GET
    @Path(value="events/{subscriptionid: [a-zA-Z_0-9-]+}")
    @Produces(value={"text/event-stream"})
    @Operation(operationId="getSitemapEvents", summary="Get sitemap events.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Missing sitemap or page parameter, or page not linked successfully to the subscription."), @ApiResponse(responseCode="404", description="Subscription not found.")})
    public void getSitemapEvents(@Context SseEventSink sseEventSink, @Context HttpServletResponse response, @PathParam(value="subscriptionid") @Parameter(description="subscription id") String subscriptionId, @QueryParam(value="sitemap") @Parameter(description="sitemap name") @Nullable String sitemapname, @QueryParam(value="pageid") @Parameter(description="page id") @Nullable String pageId) {
        this.getSitemapEvents(sseEventSink, response, subscriptionId, sitemapname, pageId, false);
        this.logger.debug("Received HTTP GET request from IP {} at '{}' for sitemap {} and page {}", new Object[]{this.request.getRemoteAddr(), this.uriInfo.getPath(), sitemapname, pageId});
    }

    private void getSitemapEvents(SseEventSink sseEventSink, HttpServletResponse response, String subscriptionId, @Nullable String sitemapname, @Nullable String pageId, boolean subscribeToWholeSitemap) {
        SseSinkInfo sinkInfo = this.knownSubscriptions.get(subscriptionId);
        if (sinkInfo == null) {
            this.logger.debug("Subscription id {} does not exist.", (Object)subscriptionId);
            response.setStatus(Response.Status.NOT_FOUND.getStatusCode());
            return;
        }
        if (sitemapname != null && (subscribeToWholeSitemap || pageId != null)) {
            this.subscriptions.updateSubscriptionLocation(subscriptionId, sitemapname, pageId);
        }
        if (this.subscriptions.getSitemapName(subscriptionId) == null || this.subscriptions.getPageId(subscriptionId) == null && !subscribeToWholeSitemap) {
            this.logger.debug("Subscription id {} is not yet linked to a sitemap (or sitemap and page).", (Object)subscriptionId);
            response.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
            return;
        }
        this.logger.debug("Client from IP {} requested sitemap event stream for subscription {}.", (Object)this.request.getRemoteAddr(), (Object)subscriptionId);
        response.addHeader(X_ACCEL_BUFFERING_HEADER, "no");
        this.broadcaster.add(sseEventSink, (Object)sinkInfo);
    }

    private PageDTO getPageBean(String sitemapName, String pageId, URI uri, Locale locale, boolean timeout, boolean includeHidden) {
        Sitemap sitemap = this.getSitemap(sitemapName);
        if (sitemap != null) {
            if (pageId.equals(sitemap.getName())) {
                EList children = this.itemUIRegistry.getChildren(sitemap);
                return this.createPageBean(sitemapName, sitemap.getLabel(), sitemap.getIcon(), sitemap.getName(), (EList<Widget>)children, false, this.isLeaf((EList<Widget>)children), uri, locale, timeout, includeHidden);
            }
            Widget pageWidget = this.itemUIRegistry.getWidget(sitemap, pageId);
            if (pageWidget instanceof LinkableWidget) {
                LinkableWidget widget = (LinkableWidget)pageWidget;
                EList children = this.itemUIRegistry.getChildren(widget);
                PageDTO pageBean = this.createPageBean(sitemapName, this.itemUIRegistry.getLabel(pageWidget), this.itemUIRegistry.getCategory(pageWidget), pageId, (EList<Widget>)children, false, this.isLeaf((EList<Widget>)children), uri, locale, timeout, includeHidden);
                EObject parentPage = pageWidget.eContainer();
                while (parentPage instanceof Frame) {
                    parentPage = parentPage.eContainer();
                }
                if (parentPage instanceof Widget) {
                    Widget parentPageWidget = (Widget)parentPage;
                    String parentId = this.itemUIRegistry.getWidgetId(parentPageWidget);
                    pageBean.parent = this.getPageBean(sitemapName, parentId, uri, locale, timeout, includeHidden);
                    pageBean.parent.widgets = null;
                    pageBean.parent.parent = null;
                } else if (parentPage instanceof Sitemap) {
                    pageBean.parent = this.getPageBean(sitemapName, sitemap.getName(), uri, locale, timeout, includeHidden);
                    pageBean.parent.widgets = null;
                }
                return pageBean;
            }
            if (this.logger.isDebugEnabled()) {
                if (pageWidget == null) {
                    this.logger.debug("Received HTTP GET request at '{}' for the unknown page id '{}'.", (Object)uri, (Object)pageId);
                } else {
                    this.logger.debug("Received HTTP GET request at '{}' for the page id '{}'. This id refers to a non-linkable widget and is therefore no valid page id.", (Object)uri, (Object)pageId);
                }
            }
            throw new WebApplicationException(404);
        }
        this.logger.info("Received HTTP GET request at '{}' for the unknown sitemap '{}'.", (Object)uri, (Object)sitemapName);
        throw new WebApplicationException(404);
    }

    public Collection<SitemapDTO> getSitemapBeans(URI uri) {
        LinkedList<SitemapDTO> beans = new LinkedList<SitemapDTO>();
        HashSet<String> names = new HashSet<String>();
        this.logger.debug("Received HTTP GET request at '{}'.", (Object)UriBuilder.fromUri((URI)uri).build(new Object[0]).toASCIIString());
        for (SitemapProvider provider : this.sitemapProviders) {
            for (String modelName : provider.getSitemapNames()) {
                Sitemap sitemap = provider.getSitemap(modelName);
                if (sitemap == null) continue;
                if (!names.contains(modelName)) {
                    names.add(modelName);
                    SitemapDTO bean = new SitemapDTO();
                    bean.name = modelName;
                    bean.icon = sitemap.getIcon();
                    bean.label = sitemap.getLabel();
                    bean.link = UriBuilder.fromUri((URI)uri).path(bean.name).build(new Object[0]).toASCIIString();
                    bean.homepage = new PageDTO();
                    bean.homepage.link = bean.link + "/" + sitemap.getName();
                    beans.add(bean);
                    continue;
                }
                this.logger.warn("Found duplicate sitemap name '{}' - ignoring it. Please check your configuration.", (Object)modelName);
            }
        }
        return beans;
    }

    private SitemapDTO getSitemapBean(String sitemapname, URI uri, Locale locale, boolean includeHiddenWidgets, boolean timeout) {
        Sitemap sitemap = this.getSitemap(sitemapname);
        if (sitemap != null) {
            return this.createSitemapBean(sitemapname, sitemap, uri, locale, includeHiddenWidgets, timeout);
        }
        this.logger.info("Received HTTP GET request at '{}' for the unknown sitemap '{}'.", (Object)this.uriInfo.getPath(), (Object)sitemapname);
        throw new WebApplicationException(404);
    }

    private SitemapDTO createSitemapBean(String sitemapName, Sitemap sitemap, URI uri, Locale locale, boolean includeHiddenWidgets, boolean timeout) {
        SitemapDTO bean = new SitemapDTO();
        bean.name = sitemapName;
        bean.icon = sitemap.getIcon();
        bean.label = sitemap.getLabel();
        bean.link = UriBuilder.fromUri((URI)uri).path(PATH_SITEMAPS).path(bean.name).build(new Object[0]).toASCIIString();
        bean.homepage = this.createPageBean(sitemap.getName(), sitemap.getLabel(), sitemap.getIcon(), sitemap.getName(), (EList<Widget>)this.itemUIRegistry.getChildren(sitemap), true, false, uri, locale, timeout, includeHiddenWidgets);
        return bean;
    }

    private PageDTO createPageBean(String sitemapName, @Nullable String title, @Nullable String icon, String pageId, @Nullable EList<Widget> children, boolean drillDown, boolean isLeaf, URI uri, Locale locale, boolean timeout, boolean includeHiddenWidgets) {
        PageDTO bean = new PageDTO();
        bean.timeout = timeout;
        bean.id = pageId;
        bean.title = title;
        bean.icon = icon;
        bean.leaf = isLeaf;
        bean.link = UriBuilder.fromUri((URI)uri).path(PATH_SITEMAPS).path(sitemapName).path(pageId).build(new Object[0]).toASCIIString();
        if (children != null) {
            for (Widget widget : children) {
                String widgetId;
                WidgetDTO subWidget = this.createWidgetBean(sitemapName, widget, drillDown, uri, widgetId = this.itemUIRegistry.getWidgetId(widget), locale, includeHiddenWidgets);
                if (subWidget == null) continue;
                bean.widgets.add(subWidget);
            }
        } else {
            bean.widgets = null;
        }
        return bean;
    }

    private @Nullable WidgetDTO createWidgetBean(String sitemapName, Widget widget, boolean drillDown, URI uri, String widgetId, Locale locale, boolean evenIfHidden) {
        if (!evenIfHidden && !this.itemUIRegistry.getVisiblity(widget)) {
            return null;
        }
        WidgetDTO bean = new WidgetDTO();
        State itemState = null;
        if (widget.getItem() != null) {
            try {
                Item item = this.itemUIRegistry.getItem(widget.getItem());
                itemState = item.getState();
                String widgetTypeName = widget.eClass().getInstanceTypeName().substring(widget.eClass().getInstanceTypeName().lastIndexOf(".") + 1);
                boolean isMapview = "mapview".equalsIgnoreCase(widgetTypeName);
                Predicate<Item> itemFilter = i -> "Location".equals(i.getType());
                bean.item = EnrichedItemDTOMapper.map((Item)item, (boolean)isMapview, itemFilter, (UriBuilder)UriBuilder.fromUri((URI)uri).path("items/{itemName}"), (Locale)locale, (ZoneId)this.timeZoneProvider.getTimeZone());
                bean.state = this.itemUIRegistry.getState(widget).toFullString();
                if (bean.state != null && bean.state.equals(bean.item.state)) {
                    bean.state = null;
                }
            }
            catch (ItemNotFoundException e) {
                this.logger.debug("{}", (Object)e.getMessage());
            }
        }
        bean.widgetId = widgetId;
        bean.icon = this.itemUIRegistry.getCategory(widget);
        bean.staticIcon = widget.getStaticIcon() != null || !widget.getIconRules().isEmpty();
        bean.labelcolor = SitemapResource.convertItemValueColor(this.itemUIRegistry.getLabelColor(widget), itemState);
        bean.valuecolor = SitemapResource.convertItemValueColor(this.itemUIRegistry.getValueColor(widget), itemState);
        bean.iconcolor = SitemapResource.convertItemValueColor(this.itemUIRegistry.getIconColor(widget), itemState);
        bean.label = this.itemUIRegistry.getLabel(widget);
        bean.labelSource = this.itemUIRegistry.getLabelSource(widget).toString();
        bean.pattern = this.itemUIRegistry.getFormatPattern(widget);
        bean.unit = this.itemUIRegistry.getUnitForWidget(widget);
        bean.type = widget.eClass().getName();
        bean.visibility = this.itemUIRegistry.getVisiblity(widget);
        if (widget instanceof LinkableWidget) {
            LinkableWidget linkableWidget = (LinkableWidget)widget;
            EList children = this.itemUIRegistry.getChildren(linkableWidget);
            if (widget instanceof Frame || widget instanceof Buttongrid) {
                for (Widget child : children) {
                    String wID;
                    WidgetDTO subWidget = this.createWidgetBean(sitemapName, child, drillDown, uri, wID = this.itemUIRegistry.getWidgetId(child), locale, evenIfHidden);
                    if (subWidget == null) continue;
                    bean.widgets.add(subWidget);
                }
            } else if (!children.isEmpty()) {
                String pageName = this.itemUIRegistry.getWidgetId((Widget)linkableWidget);
                bean.linkedPage = this.createPageBean(sitemapName, this.itemUIRegistry.getLabel(widget), this.itemUIRegistry.getCategory(widget), pageName, (EList<Widget>)(drillDown ? children : null), drillDown, this.isLeaf((EList<Widget>)children), uri, locale, false, evenIfHidden);
            }
        }
        if (widget instanceof Switch) {
            Switch switchWidget = (Switch)widget;
            for (Mapping mapping : switchWidget.getMappings()) {
                MappingDTO mappingBean = new MappingDTO();
                mappingBean.command = mapping.getCmd();
                mappingBean.releaseCommand = mapping.getReleaseCmd();
                mappingBean.label = mapping.getLabel();
                mappingBean.icon = mapping.getIcon();
                bean.mappings.add(mappingBean);
            }
        }
        if (widget instanceof Selection) {
            Selection selectionWidget = (Selection)widget;
            for (Mapping mapping : selectionWidget.getMappings()) {
                MappingDTO mappingBean = new MappingDTO();
                mappingBean.command = mapping.getCmd();
                mappingBean.label = mapping.getLabel();
                bean.mappings.add(mappingBean);
            }
        }
        if (widget instanceof Input) {
            Input inputWidget = (Input)widget;
            bean.inputHint = inputWidget.getInputHint();
        }
        if (widget instanceof Slider) {
            Slider sliderWidget = (Slider)widget;
            bean.switchSupport = sliderWidget.isSwitchEnabled();
            bean.releaseOnly = sliderWidget.isReleaseOnly();
            bean.minValue = sliderWidget.getMinValue();
            bean.maxValue = sliderWidget.getMaxValue();
            bean.step = sliderWidget.getStep();
        }
        if (widget instanceof Image) {
            Image imageWidget = (Image)widget;
            bean.url = this.buildProxyUrl(sitemapName, widget, uri);
            if (imageWidget.getRefresh() > 0) {
                bean.refresh = imageWidget.getRefresh();
            }
        }
        if (widget instanceof Video) {
            Video videoWidget = (Video)widget;
            if (videoWidget.getEncoding() != null) {
                bean.encoding = videoWidget.getEncoding();
            }
            bean.url = videoWidget.getEncoding() != null && videoWidget.getEncoding().toLowerCase().contains("hls") ? videoWidget.getUrl() : this.buildProxyUrl(sitemapName, (Widget)videoWidget, uri);
        }
        if (widget instanceof Webview) {
            Webview webViewWidget = (Webview)widget;
            bean.url = webViewWidget.getUrl();
            bean.height = webViewWidget.getHeight();
        }
        if (widget instanceof Mapview) {
            Mapview mapViewWidget = (Mapview)widget;
            bean.height = mapViewWidget.getHeight();
        }
        if (widget instanceof Chart) {
            Chart chartWidget = (Chart)widget;
            bean.service = chartWidget.getService();
            bean.period = chartWidget.getPeriod();
            bean.legend = chartWidget.getLegend();
            bean.forceAsItem = chartWidget.getForceAsItem();
            bean.yAxisDecimalPattern = chartWidget.getYAxisDecimalPattern();
            if (chartWidget.getRefresh() > 0) {
                bean.refresh = chartWidget.getRefresh();
            }
        }
        if (widget instanceof Setpoint) {
            Setpoint setpointWidget = (Setpoint)widget;
            bean.minValue = setpointWidget.getMinValue();
            bean.maxValue = setpointWidget.getMaxValue();
            bean.step = setpointWidget.getStep();
        }
        if (widget instanceof Colortemperaturepicker) {
            Colortemperaturepicker colortemperaturepickerWidget = (Colortemperaturepicker)widget;
            bean.minValue = colortemperaturepickerWidget.getMinValue();
            bean.maxValue = colortemperaturepickerWidget.getMaxValue();
        }
        if (widget instanceof Buttongrid) {
            Buttongrid buttonGridWidget = (Buttongrid)widget;
            for (ButtonDefinition button : buttonGridWidget.getButtons()) {
                MappingDTO mappingBean = new MappingDTO();
                mappingBean.row = button.getRow();
                mappingBean.column = button.getColumn();
                mappingBean.command = button.getCmd();
                mappingBean.label = button.getLabel();
                mappingBean.icon = button.getIcon();
                bean.mappings.add(mappingBean);
            }
        }
        if (widget instanceof Button) {
            Button buttonWidget = (Button)widget;
            if (widget.getIcon() == null && widget.getStaticIcon() == null && widget.getIconRules().isEmpty()) {
                bean.icon = null;
                bean.staticIcon = null;
            }
            bean.label = widget.getLabel() != null ? widget.getLabel() : buttonWidget.getCmd();
            bean.labelSource = ItemUIRegistry.WidgetLabelSource.SITEMAP_WIDGET.toString();
            bean.pattern = null;
            bean.unit = null;
            bean.row = buttonWidget.getRow();
            bean.column = buttonWidget.getColumn();
            bean.command = buttonWidget.getCmd();
            bean.releaseCommand = buttonWidget.getReleaseCmd();
            bean.stateless = buttonWidget.isStateless();
        }
        return bean;
    }

    public static @Nullable String convertItemValueColor(@Nullable String color, @Nullable State itemState) {
        if ("itemValue".equals(color)) {
            if (itemState instanceof HSBType) {
                HSBType hsbState = (HSBType)itemState;
                return "#" + Integer.toHexString(ColorUtil.hsbTosRgb((HSBType)hsbState)).substring(2);
            }
            return null;
        }
        return color;
    }

    private String buildProxyUrl(String sitemapName, Widget widget, URI uri) {
        String wId = this.itemUIRegistry.getWidgetId(widget);
        StringBuilder sb = new StringBuilder();
        sb.append(uri.getScheme()).append("://").append(uri.getHost());
        if (uri.getPort() >= 0) {
            sb.append(":").append(uri.getPort());
        }
        sb.append("/proxy?sitemap=").append(sitemapName).append("&widgetId=").append(wId);
        return sb.toString();
    }

    private boolean isLeaf(EList<Widget> children) {
        for (Widget w : children) {
            LinkableWidget linkableWidget;
            Buttongrid grid;
            Frame frame;
            if (!(w instanceof Frame ? this.isLeaf((EList<Widget>)(frame = (Frame)w).getChildren()) : (w instanceof Buttongrid ? this.isLeaf((EList<Widget>)(grid = (Buttongrid)w).getChildren()) : w instanceof LinkableWidget && !this.itemUIRegistry.getChildren(linkableWidget = (LinkableWidget)w).isEmpty()))) continue;
            return false;
        }
        return true;
    }

    private @Nullable Sitemap getSitemap(String sitemapname) {
        for (SitemapProvider provider : this.sitemapProviders) {
            Sitemap sitemap = provider.getSitemap(sitemapname);
            if (sitemap == null) continue;
            return sitemap;
        }
        return null;
    }

    private boolean blockUntilChangeOccurs(String sitemapname, @Nullable String pageId) {
        EList<Widget> widgets = this.subscriptions.collectWidgets(sitemapname, pageId);
        if (widgets.isEmpty()) {
            return false;
        }
        return this.waitForChanges((List<Widget>)widgets);
    }

    private boolean waitForChanges(List<Widget> widgets) {
        long startTime = new Date().getTime();
        boolean timeout = false;
        Set<String> items = this.getAllItems(widgets).stream().map(Item::getName).collect(Collectors.toSet());
        BlockingStateChangeListener listener = new BlockingStateChangeListener(items);
        this.stateChangeListeners.add(listener);
        this.logger.debug("Waiting for changes on {} items from {} widgets", (Object)items.size(), (Object)widgets.size());
        while (!listener.hasChanged() && !timeout) {
            timeout = new Date().getTime() - startTime > 30000L;
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                timeout = true;
                break;
            }
        }
        this.stateChangeListeners.remove(listener);
        return timeout;
    }

    private Set<GenericItem> getAllItems(List<Widget> widgets) {
        HashSet<GenericItem> items = new HashSet<GenericItem>();
        for (Widget widget : widgets) {
            boolean skipWidget = false;
            if (widget instanceof Chart) {
                Chart chartWidget = (Chart)widget;
                skipWidget = chartWidget.getRefresh() > 0;
            }
            String itemName = widget.getItem();
            if (!skipWidget && itemName != null) {
                try {
                    Item item = this.itemUIRegistry.getItem(itemName);
                    if (item instanceof GenericItem) {
                        GenericItem genericItem = (GenericItem)item;
                        items.add(genericItem);
                    }
                }
                catch (ItemNotFoundException item) {
                    // empty catch block
                }
            }
            if (widget instanceof Frame) {
                Frame frame = (Frame)widget;
                items.addAll(this.getAllItems((List<Widget>)frame.getChildren()));
            } else if (widget instanceof Buttongrid) {
                Buttongrid grid = (Buttongrid)widget;
                items.addAll(this.getAllItems((List<Widget>)grid.getChildren()));
            }
            items.addAll(this.getItemsInIconCond((EList<IconRule>)widget.getIconRules()));
            items.addAll(this.getItemsInVisibilityCond((EList<VisibilityRule>)widget.getVisibility()));
            items.addAll(this.getItemsInColorCond((EList<ColorArray>)widget.getLabelColor()));
            items.addAll(this.getItemsInColorCond((EList<ColorArray>)widget.getValueColor()));
            items.addAll(this.getItemsInColorCond((EList<ColorArray>)widget.getIconColor()));
        }
        return items;
    }

    private Set<GenericItem> getItemsInVisibilityCond(EList<VisibilityRule> ruleList) {
        HashSet<GenericItem> items = new HashSet<GenericItem>();
        for (VisibilityRule rule : ruleList) {
            this.getItemsInConditions((EList<Condition>)rule.getConditions(), items);
        }
        return items;
    }

    private Set<GenericItem> getItemsInColorCond(EList<ColorArray> colorList) {
        HashSet<GenericItem> items = new HashSet<GenericItem>();
        for (ColorArray rule : colorList) {
            this.getItemsInConditions((EList<Condition>)rule.getConditions(), items);
        }
        return items;
    }

    private Set<GenericItem> getItemsInIconCond(EList<IconRule> ruleList) {
        HashSet<GenericItem> items = new HashSet<GenericItem>();
        for (IconRule rule : ruleList) {
            this.getItemsInConditions((EList<Condition>)rule.getConditions(), items);
        }
        return items;
    }

    private void getItemsInConditions(@Nullable EList<Condition> conditions, Set<GenericItem> items) {
        if (conditions != null) {
            for (Condition condition : conditions) {
                String itemName = condition.getItem();
                if (itemName == null) continue;
                try {
                    Item item = this.itemUIRegistry.getItem(itemName);
                    if (!(item instanceof GenericItem)) continue;
                    GenericItem genericItem = (GenericItem)item;
                    items.add(genericItem);
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    public Set<String> getSubscribedEventTypes() {
        return Set.of(ItemStateChangedEvent.TYPE, GroupItemStateChangedEvent.TYPE);
    }

    public void receive(Event event) {
        if (event instanceof ItemEvent) {
            ItemEvent itemEvent = (ItemEvent)event;
            String itemName = itemEvent.getItemName();
            this.stateChangeListeners.forEach(l -> l.itemChanged(itemName));
        }
    }

    @Override
    public void onEvent(SitemapEvent event) {
        Sse sse = this.sse;
        if (sse == null) {
            this.logger.trace("broadcast skipped (no one listened since activation)");
            return;
        }
        OutboundSseEvent outboundSseEvent = sse.newEventBuilder().name("event").mediaType(MediaType.APPLICATION_JSON_TYPE).data((Object)event).build();
        this.broadcaster.sendIf(outboundSseEvent, info -> {
            String sitemapName = sitemapEvent.sitemapName;
            String pageId = sitemapEvent.pageId;
            if (sitemapName != null && sitemapName.equals(this.subscriptions.getSitemapName(info.subscriptionId)) && Objects.equals(pageId, this.subscriptions.getPageId(info.subscriptionId))) {
                if (this.logger.isDebugEnabled()) {
                    if (event instanceof SitemapWidgetEvent) {
                        SitemapWidgetEvent widgetEvent = (SitemapWidgetEvent)event;
                        this.logger.debug("Sent sitemap event for widget {} to subscription {}.", (Object)widgetEvent.widgetId, (Object)info.subscriptionId);
                    } else if (event instanceof ServerAliveEvent) {
                        this.logger.debug("Sent alive event to subscription {}.", (Object)info.subscriptionId);
                    }
                }
                return true;
            }
            return false;
        });
    }

    @Override
    public void onRelease(String subscriptionId) {
        this.logger.debug("SSE connection for subscription {} has been released.", (Object)subscriptionId);
        this.broadcaster.closeAndRemoveIf(info -> info.subscriptionId.equals(subscriptionId));
        this.knownSubscriptions.remove(subscriptionId);
    }

    public void sseEventSinkRemoved(SseEventSink sink, SseSinkInfo info) {
        this.logger.debug("SSE connection for subscription {} has been closed.", (Object)info.subscriptionId);
        this.subscriptions.removeSubscription(info.subscriptionId);
        this.knownSubscriptions.remove(info.subscriptionId);
    }

    private static class BlockingStateChangeListener {
        private final Set<String> items;
        private boolean changed = false;

        public BlockingStateChangeListener(Set<String> items) {
            this.items = items;
        }

        public void itemChanged(String item) {
            if (this.items.contains(item)) {
                this.changed = true;
            }
        }

        public boolean hasChanged() {
            return this.changed;
        }
    }
}

