/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.management.codec;

import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.karaf.scr.management.ServiceComponentRuntimeMBean;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.component.runtime.dto.SatisfiedReferenceDTO;
import org.osgi.service.component.runtime.dto.UnsatisfiedReferenceDTO;

public class JmxSvcReference {
    public static final CompositeType SVC_REFERENCE = JmxSvcReference.createReferenceType();
    public static final TabularType SVC_REFERENCE_TABLE = JmxSvcReference.createReferenceTableType();
    private final CompositeData data;

    public JmxSvcReference(SatisfiedReferenceDTO reference) {
        try {
            String[] itemNames = ServiceComponentRuntimeMBean.SVC_REFERENCE;
            Object[] itemValues = new Object[itemNames.length];
            itemValues[0] = reference.name;
            itemValues[1] = reference.target;
            itemValues[2] = JmxSvcReference.getBoundServices(reference.boundServices);
            this.data = new CompositeDataSupport(SVC_REFERENCE, itemNames, itemValues);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form feature open data", e);
        }
    }

    public JmxSvcReference(UnsatisfiedReferenceDTO reference) {
        try {
            String[] itemNames = ServiceComponentRuntimeMBean.SVC_REFERENCE;
            Object[] itemValues = new Object[itemNames.length];
            itemValues[0] = reference.name;
            itemValues[1] = reference.target;
            itemValues[2] = JmxSvcReference.getBoundServices(reference.targetServices);
            this.data = new CompositeDataSupport(SVC_REFERENCE, itemNames, itemValues);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form feature open data", e);
        }
    }

    public CompositeData asCompositeData() {
        return this.data;
    }

    public static TabularData tableFrom(SatisfiedReferenceDTO[] references) {
        TabularDataSupport table = new TabularDataSupport(SVC_REFERENCE_TABLE);
        if (references != null) {
            for (SatisfiedReferenceDTO reference : references) {
                table.put(new JmxSvcReference(reference).asCompositeData());
            }
        }
        return table;
    }

    public static TabularData tableFrom(UnsatisfiedReferenceDTO[] references) {
        TabularDataSupport table = new TabularDataSupport(SVC_REFERENCE_TABLE);
        if (references != null) {
            for (UnsatisfiedReferenceDTO reference : references) {
                table.put(new JmxSvcReference(reference).asCompositeData());
            }
        }
        return table;
    }

    private static CompositeType createReferenceType() {
        try {
            String description = "This type encapsulates Scr references";
            String[] itemNames = ServiceComponentRuntimeMBean.SVC_REFERENCE;
            OpenType[] itemTypes = new OpenType[itemNames.length];
            String[] itemDescriptions = new String[itemNames.length];
            itemTypes[0] = SimpleType.STRING;
            itemTypes[1] = SimpleType.STRING;
            itemTypes[2] = new ArrayType(1, SimpleType.LONG);
            itemDescriptions[0] = "The name of the reference";
            itemDescriptions[1] = "The target of the reference";
            itemDescriptions[2] = "The bound services";
            return new CompositeType("Reference", description, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build reference type", e);
        }
    }

    private static TabularType createReferenceTableType() {
        try {
            return new TabularType("References", "The table of all references", SVC_REFERENCE, new String[]{"Name"});
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build references table type", e);
        }
    }

    private static Long[] getBoundServices(ServiceReferenceDTO[] references) {
        if (references == null || references.length == 0) {
            return new Long[0];
        }
        Long[] ids = new Long[references.length];
        for (int i = 0; i < references.length; ++i) {
            ids[i] = references[i].id;
        }
        return ids;
    }
}

