/***************************************************************************
 *      Mechanized Assault and Exploration Reloaded Projectfile            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef game_logic_automjobsH
#define game_logic_automjobsH

#include "utility/position.h"

class cClient;
class cClientMoveJob;
class cVehicle;

class cAutoMJob
{
private:
	cPosition lastDestination; // last destination generated by the AI.
	// needed to check if the move job was changed from outside the AI (i.e. by the player)
	cClient& client;
	cVehicle& vehicle; // the vehicle the auto move job belongs to
	bool finished;     // true when the job can be deleted

	// the operation point of the surveyor
	// the surveyor tries to stay near this coordinates
	cPosition operationPoint;
	bool playerMJob; //the player has changed the move job

private:
	float calcScoreDistToOtherSurveyor (const std::vector<cAutoMJob*>& jobs, const cPosition& position, float e) const;

	float calcFactor (const cPosition& position, const std::vector<cAutoMJob*>& jobs);
	void planNextMove (const std::vector<cAutoMJob*>& jobs);
	void planLongMove (const std::vector<cAutoMJob*>& jobs);
	void changeOP();

public:
	cAutoMJob (cClient& client, cVehicle& vehicle);

	void doAutoMove (const std::vector<cAutoMJob*>& jobs);
	void stop();
	bool isFinished() const { return finished; }
	cVehicle& getVehicle() { return vehicle; }
};

#endif  // game_logic_automjobsH
