/*  job_setupcrossings.cpp
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#include "job_setupcrossings.h"
#include "functions.h"
#include "files.h"
#include "crossing.h"

using namespace std;

namespace Reduze {

// register job types at JobFactory
namespace {
JobProxy<SetupCrossings> dummy;
}

void SetupCrossings::run_serial() {
	Files* files = Files::instance();
	if (files->crossings_loaded()) {
		WARNING("Cannot perform job setup_crossing since crossings" //
				<< " already loaded");
		return;
	}
	const map<string, Kinematics*>& all = files->all_kinematics();
	map<string, OrderedCrossings> crossings;
	for (map<string, Kinematics*>::const_iterator k = all.begin();
			k != all.end(); ++k) {
		const string& name = k->first;
		const Kinematics* kin = k->second;
		LOGX("\nSetting up crossings for kinematics '" << name << "'");
		OrderedCrossings crs(kin);
		crs.construct_crossings();
		crossings.insert(make_pair(name, crs));
		*files->crossings(name) = crs;
	}
	LOGX("\nSaving crossings.");
	files->save_crossings(crossings);
}

bool SetupCrossings::find_dependencies(const set<string>& outothers, //
		list<string>& in, list<string>& out, list<Job*>& auxjobs) {
	out.push_back(Files::instance()->get_filename_crossings());
	return true;
}

std::string SetupCrossings::get_description() const {
	std::stringstream s;
	s << "setup crossings";
	return s.str();
}

} // namespace Reduze

