/*  job_relatesymanzik.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifndef JOB_RELATESYMANZIK_H_
#define JOB_RELATESYMANZIK_H_

#include "job.h"

namespace Reduze {

/// determines equivalences based on Symanzik polynomials
class RelateSymanzik: public Reduze::Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("relate_symanzik");
		s.set_short_description("Identifies integrals.");
		s.set_long_description("Job to identify equivalent integrals"
				" based on their Symanzik polynomials U and F.");
		s.add_option("input_file", true, "string", ""
				"Name of input file containing integrals to relate.");
		s.add_option("output_file", true, "string", ""
				"Name of output file for generated equations.");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}
	RelateSymanzik() {
		add_auto_options();
	}
	virtual ~RelateSymanzik() {
	}
	virtual void run_serial();
	virtual bool find_dependencies(const std::set<std::string>&,//
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;
protected:
	virtual void add_auto_options() {
		add_auto_io("input_file", input_file_);
		add_auto_io("output_file", output_file_);
	}
	virtual void init();
private:
	std::string input_file_, output_file_;
};

}

#endif /* JOB_RELATESYMANZIK_H_ */
