// Code generated by sdkgen. DO NOT EDIT.

// nolint
package privatelink

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	privatelink "github.com/yandex-cloud/go-genproto/yandex/cloud/vpc/v1/privatelink"
)

//revive:disable

// PrivateEndpointServiceClient is a privatelink.PrivateEndpointServiceClient with
// lazy GRPC connection initialization.
type PrivateEndpointServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements privatelink.PrivateEndpointServiceClient
func (c *PrivateEndpointServiceClient) Create(ctx context.Context, in *privatelink.CreatePrivateEndpointRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return privatelink.NewPrivateEndpointServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements privatelink.PrivateEndpointServiceClient
func (c *PrivateEndpointServiceClient) Delete(ctx context.Context, in *privatelink.DeletePrivateEndpointRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return privatelink.NewPrivateEndpointServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements privatelink.PrivateEndpointServiceClient
func (c *PrivateEndpointServiceClient) Get(ctx context.Context, in *privatelink.GetPrivateEndpointRequest, opts ...grpc.CallOption) (*privatelink.PrivateEndpoint, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return privatelink.NewPrivateEndpointServiceClient(conn).Get(ctx, in, opts...)
}

// List implements privatelink.PrivateEndpointServiceClient
func (c *PrivateEndpointServiceClient) List(ctx context.Context, in *privatelink.ListPrivateEndpointsRequest, opts ...grpc.CallOption) (*privatelink.ListPrivateEndpointsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return privatelink.NewPrivateEndpointServiceClient(conn).List(ctx, in, opts...)
}

type PrivateEndpointIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *PrivateEndpointServiceClient
	request *privatelink.ListPrivateEndpointsRequest

	items []*privatelink.PrivateEndpoint
}

func (c *PrivateEndpointServiceClient) PrivateEndpointIterator(ctx context.Context, req *privatelink.ListPrivateEndpointsRequest, opts ...grpc.CallOption) *PrivateEndpointIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &PrivateEndpointIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *PrivateEndpointIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.PrivateEndpoints
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *PrivateEndpointIterator) Take(size int64) ([]*privatelink.PrivateEndpoint, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*privatelink.PrivateEndpoint

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *PrivateEndpointIterator) TakeAll() ([]*privatelink.PrivateEndpoint, error) {
	return it.Take(0)
}

func (it *PrivateEndpointIterator) Value() *privatelink.PrivateEndpoint {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *PrivateEndpointIterator) Error() error {
	return it.err
}

// ListOperations implements privatelink.PrivateEndpointServiceClient
func (c *PrivateEndpointServiceClient) ListOperations(ctx context.Context, in *privatelink.ListPrivateEndpointOperationsRequest, opts ...grpc.CallOption) (*privatelink.ListPrivateEndpointOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return privatelink.NewPrivateEndpointServiceClient(conn).ListOperations(ctx, in, opts...)
}

type PrivateEndpointOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *PrivateEndpointServiceClient
	request *privatelink.ListPrivateEndpointOperationsRequest

	items []*operation.Operation
}

func (c *PrivateEndpointServiceClient) PrivateEndpointOperationsIterator(ctx context.Context, req *privatelink.ListPrivateEndpointOperationsRequest, opts ...grpc.CallOption) *PrivateEndpointOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &PrivateEndpointOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *PrivateEndpointOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *PrivateEndpointOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *PrivateEndpointOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *PrivateEndpointOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *PrivateEndpointOperationsIterator) Error() error {
	return it.err
}

// Update implements privatelink.PrivateEndpointServiceClient
func (c *PrivateEndpointServiceClient) Update(ctx context.Context, in *privatelink.UpdatePrivateEndpointRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return privatelink.NewPrivateEndpointServiceClient(conn).Update(ctx, in, opts...)
}
