// Code generated by sdkgen. DO NOT EDIT.

// nolint
package postgresql

import (
	"context"

	"google.golang.org/grpc"

	postgresql "github.com/yandex-cloud/go-genproto/yandex/cloud/mdb/postgresql/v1"
)

//revive:disable

// BackupRetentionPolicyServiceClient is a postgresql.BackupRetentionPolicyServiceClient with
// lazy GRPC connection initialization.
type BackupRetentionPolicyServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements postgresql.BackupRetentionPolicyServiceClient
func (c *BackupRetentionPolicyServiceClient) Create(ctx context.Context, in *postgresql.CreateBackupRetentionPolicyRequest, opts ...grpc.CallOption) (*postgresql.CreateBackupRetentionPolicyResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return postgresql.NewBackupRetentionPolicyServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements postgresql.BackupRetentionPolicyServiceClient
func (c *BackupRetentionPolicyServiceClient) Delete(ctx context.Context, in *postgresql.DeleteBackupRetentionPolicyRequest, opts ...grpc.CallOption) (*postgresql.DeleteBackupRetentionPolicyResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return postgresql.NewBackupRetentionPolicyServiceClient(conn).Delete(ctx, in, opts...)
}

// List implements postgresql.BackupRetentionPolicyServiceClient
func (c *BackupRetentionPolicyServiceClient) List(ctx context.Context, in *postgresql.ListBackupRetentionPoliciesRequest, opts ...grpc.CallOption) (*postgresql.ListBackupRetentionPoliciesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return postgresql.NewBackupRetentionPolicyServiceClient(conn).List(ctx, in, opts...)
}

type BackupRetentionPolicyIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *BackupRetentionPolicyServiceClient
	request *postgresql.ListBackupRetentionPoliciesRequest

	items []*postgresql.BackupRetentionPolicy
}

func (c *BackupRetentionPolicyServiceClient) BackupRetentionPolicyIterator(ctx context.Context, req *postgresql.ListBackupRetentionPoliciesRequest, opts ...grpc.CallOption) *BackupRetentionPolicyIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &BackupRetentionPolicyIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *BackupRetentionPolicyIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Policies
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *BackupRetentionPolicyIterator) Take(size int64) ([]*postgresql.BackupRetentionPolicy, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*postgresql.BackupRetentionPolicy

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *BackupRetentionPolicyIterator) TakeAll() ([]*postgresql.BackupRetentionPolicy, error) {
	return it.Take(0)
}

func (it *BackupRetentionPolicyIterator) Value() *postgresql.BackupRetentionPolicy {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *BackupRetentionPolicyIterator) Error() error {
	return it.err
}
