// Code generated by sdkgen. DO NOT EDIT.

// nolint
package logging

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	logging "github.com/yandex-cloud/go-genproto/yandex/cloud/logging/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// LogGroupServiceClient is a logging.LogGroupServiceClient with
// lazy GRPC connection initialization.
type LogGroupServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements logging.LogGroupServiceClient
func (c *LogGroupServiceClient) Create(ctx context.Context, in *logging.CreateLogGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return logging.NewLogGroupServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements logging.LogGroupServiceClient
func (c *LogGroupServiceClient) Delete(ctx context.Context, in *logging.DeleteLogGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return logging.NewLogGroupServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements logging.LogGroupServiceClient
func (c *LogGroupServiceClient) Get(ctx context.Context, in *logging.GetLogGroupRequest, opts ...grpc.CallOption) (*logging.LogGroup, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return logging.NewLogGroupServiceClient(conn).Get(ctx, in, opts...)
}

// List implements logging.LogGroupServiceClient
func (c *LogGroupServiceClient) List(ctx context.Context, in *logging.ListLogGroupsRequest, opts ...grpc.CallOption) (*logging.ListLogGroupsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return logging.NewLogGroupServiceClient(conn).List(ctx, in, opts...)
}

type LogGroupIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *LogGroupServiceClient
	request *logging.ListLogGroupsRequest

	items []*logging.LogGroup
}

func (c *LogGroupServiceClient) LogGroupIterator(ctx context.Context, req *logging.ListLogGroupsRequest, opts ...grpc.CallOption) *LogGroupIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &LogGroupIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *LogGroupIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Groups
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *LogGroupIterator) Take(size int64) ([]*logging.LogGroup, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*logging.LogGroup

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *LogGroupIterator) TakeAll() ([]*logging.LogGroup, error) {
	return it.Take(0)
}

func (it *LogGroupIterator) Value() *logging.LogGroup {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *LogGroupIterator) Error() error {
	return it.err
}

// ListAccessBindings implements logging.LogGroupServiceClient
func (c *LogGroupServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return logging.NewLogGroupServiceClient(conn).ListAccessBindings(ctx, in, opts...)
}

type LogGroupAccessBindingsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *LogGroupServiceClient
	request *access.ListAccessBindingsRequest

	items []*access.AccessBinding
}

func (c *LogGroupServiceClient) LogGroupAccessBindingsIterator(ctx context.Context, req *access.ListAccessBindingsRequest, opts ...grpc.CallOption) *LogGroupAccessBindingsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &LogGroupAccessBindingsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *LogGroupAccessBindingsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListAccessBindings(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.AccessBindings
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *LogGroupAccessBindingsIterator) Take(size int64) ([]*access.AccessBinding, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*access.AccessBinding

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *LogGroupAccessBindingsIterator) TakeAll() ([]*access.AccessBinding, error) {
	return it.Take(0)
}

func (it *LogGroupAccessBindingsIterator) Value() *access.AccessBinding {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *LogGroupAccessBindingsIterator) Error() error {
	return it.err
}

// ListOperations implements logging.LogGroupServiceClient
func (c *LogGroupServiceClient) ListOperations(ctx context.Context, in *logging.ListOperationsRequest, opts ...grpc.CallOption) (*logging.ListOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return logging.NewLogGroupServiceClient(conn).ListOperations(ctx, in, opts...)
}

type LogGroupOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *LogGroupServiceClient
	request *logging.ListOperationsRequest

	items []*operation.Operation
}

func (c *LogGroupServiceClient) LogGroupOperationsIterator(ctx context.Context, req *logging.ListOperationsRequest, opts ...grpc.CallOption) *LogGroupOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &LogGroupOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *LogGroupOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *LogGroupOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *LogGroupOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *LogGroupOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *LogGroupOperationsIterator) Error() error {
	return it.err
}

// ListResources implements logging.LogGroupServiceClient
func (c *LogGroupServiceClient) ListResources(ctx context.Context, in *logging.ListResourcesRequest, opts ...grpc.CallOption) (*logging.ListResourcesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return logging.NewLogGroupServiceClient(conn).ListResources(ctx, in, opts...)
}

type LogGroupResourcesIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *LogGroupServiceClient
	request *logging.ListResourcesRequest

	items []*logging.LogGroupResource
}

func (c *LogGroupServiceClient) LogGroupResourcesIterator(ctx context.Context, req *logging.ListResourcesRequest, opts ...grpc.CallOption) *LogGroupResourcesIterator {
	var pageSize int64
	const defaultPageSize = 1000

	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &LogGroupResourcesIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *LogGroupResourcesIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started {
		return false
	}
	it.started = true

	response, err := it.client.ListResources(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Resources
	return len(it.items) > 0
}

func (it *LogGroupResourcesIterator) Take(size int64) ([]*logging.LogGroupResource, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*logging.LogGroupResource

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *LogGroupResourcesIterator) TakeAll() ([]*logging.LogGroupResource, error) {
	return it.Take(0)
}

func (it *LogGroupResourcesIterator) Value() *logging.LogGroupResource {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *LogGroupResourcesIterator) Error() error {
	return it.err
}

// SetAccessBindings implements logging.LogGroupServiceClient
func (c *LogGroupServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return logging.NewLogGroupServiceClient(conn).SetAccessBindings(ctx, in, opts...)
}

// Stats implements logging.LogGroupServiceClient
func (c *LogGroupServiceClient) Stats(ctx context.Context, in *logging.GetLogGroupStatsRequest, opts ...grpc.CallOption) (*logging.GetLogGroupStatsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return logging.NewLogGroupServiceClient(conn).Stats(ctx, in, opts...)
}

// Update implements logging.LogGroupServiceClient
func (c *LogGroupServiceClient) Update(ctx context.Context, in *logging.UpdateLogGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return logging.NewLogGroupServiceClient(conn).Update(ctx, in, opts...)
}

// UpdateAccessBindings implements logging.LogGroupServiceClient
func (c *LogGroupServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return logging.NewLogGroupServiceClient(conn).UpdateAccessBindings(ctx, in, opts...)
}
