// Code generated by sdkgen. DO NOT EDIT.

// nolint
package api

import (
	"context"

	"google.golang.org/grpc"

	api "github.com/yandex-cloud/go-genproto/yandex/cloud/loadtesting/api/v1"
	regression "github.com/yandex-cloud/go-genproto/yandex/cloud/loadtesting/api/v1/regression"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// RegressionDashboardServiceClient is a api.RegressionDashboardServiceClient with
// lazy GRPC connection initialization.
type RegressionDashboardServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements api.RegressionDashboardServiceClient
func (c *RegressionDashboardServiceClient) Create(ctx context.Context, in *api.CreateRegressionDashboardRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return api.NewRegressionDashboardServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements api.RegressionDashboardServiceClient
func (c *RegressionDashboardServiceClient) Delete(ctx context.Context, in *api.DeleteRegressionDashboardRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return api.NewRegressionDashboardServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements api.RegressionDashboardServiceClient
func (c *RegressionDashboardServiceClient) Get(ctx context.Context, in *api.GetRegressionDashboardRequest, opts ...grpc.CallOption) (*regression.Dashboard, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return api.NewRegressionDashboardServiceClient(conn).Get(ctx, in, opts...)
}

// List implements api.RegressionDashboardServiceClient
func (c *RegressionDashboardServiceClient) List(ctx context.Context, in *api.ListRegressionDashboardsRequest, opts ...grpc.CallOption) (*api.ListRegressionDashboardsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return api.NewRegressionDashboardServiceClient(conn).List(ctx, in, opts...)
}

type RegressionDashboardIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *RegressionDashboardServiceClient
	request *api.ListRegressionDashboardsRequest

	items []*regression.Dashboard
}

func (c *RegressionDashboardServiceClient) RegressionDashboardIterator(ctx context.Context, req *api.ListRegressionDashboardsRequest, opts ...grpc.CallOption) *RegressionDashboardIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &RegressionDashboardIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *RegressionDashboardIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Dashboards
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *RegressionDashboardIterator) Take(size int64) ([]*regression.Dashboard, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*regression.Dashboard

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *RegressionDashboardIterator) TakeAll() ([]*regression.Dashboard, error) {
	return it.Take(0)
}

func (it *RegressionDashboardIterator) Value() *regression.Dashboard {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *RegressionDashboardIterator) Error() error {
	return it.err
}

// Update implements api.RegressionDashboardServiceClient
func (c *RegressionDashboardServiceClient) Update(ctx context.Context, in *api.UpdateRegressionDashboardRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return api.NewRegressionDashboardServiceClient(conn).Update(ctx, in, opts...)
}
