// Code generated by sdkgen. DO NOT EDIT.

// nolint
package dns

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	dns "github.com/yandex-cloud/go-genproto/yandex/cloud/dns/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// DnsZoneServiceClient is a dns.DnsZoneServiceClient with
// lazy GRPC connection initialization.
type DnsZoneServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements dns.DnsZoneServiceClient
func (c *DnsZoneServiceClient) Create(ctx context.Context, in *dns.CreateDnsZoneRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dns.NewDnsZoneServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements dns.DnsZoneServiceClient
func (c *DnsZoneServiceClient) Delete(ctx context.Context, in *dns.DeleteDnsZoneRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dns.NewDnsZoneServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements dns.DnsZoneServiceClient
func (c *DnsZoneServiceClient) Get(ctx context.Context, in *dns.GetDnsZoneRequest, opts ...grpc.CallOption) (*dns.DnsZone, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dns.NewDnsZoneServiceClient(conn).Get(ctx, in, opts...)
}

// GetRecordSet implements dns.DnsZoneServiceClient
func (c *DnsZoneServiceClient) GetRecordSet(ctx context.Context, in *dns.GetDnsZoneRecordSetRequest, opts ...grpc.CallOption) (*dns.RecordSet, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dns.NewDnsZoneServiceClient(conn).GetRecordSet(ctx, in, opts...)
}

// List implements dns.DnsZoneServiceClient
func (c *DnsZoneServiceClient) List(ctx context.Context, in *dns.ListDnsZonesRequest, opts ...grpc.CallOption) (*dns.ListDnsZonesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dns.NewDnsZoneServiceClient(conn).List(ctx, in, opts...)
}

type DnsZoneIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *DnsZoneServiceClient
	request *dns.ListDnsZonesRequest

	items []*dns.DnsZone
}

func (c *DnsZoneServiceClient) DnsZoneIterator(ctx context.Context, req *dns.ListDnsZonesRequest, opts ...grpc.CallOption) *DnsZoneIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &DnsZoneIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *DnsZoneIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.DnsZones
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *DnsZoneIterator) Take(size int64) ([]*dns.DnsZone, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*dns.DnsZone

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *DnsZoneIterator) TakeAll() ([]*dns.DnsZone, error) {
	return it.Take(0)
}

func (it *DnsZoneIterator) Value() *dns.DnsZone {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *DnsZoneIterator) Error() error {
	return it.err
}

// ListAccessBindings implements dns.DnsZoneServiceClient
func (c *DnsZoneServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dns.NewDnsZoneServiceClient(conn).ListAccessBindings(ctx, in, opts...)
}

type DnsZoneAccessBindingsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *DnsZoneServiceClient
	request *access.ListAccessBindingsRequest

	items []*access.AccessBinding
}

func (c *DnsZoneServiceClient) DnsZoneAccessBindingsIterator(ctx context.Context, req *access.ListAccessBindingsRequest, opts ...grpc.CallOption) *DnsZoneAccessBindingsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &DnsZoneAccessBindingsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *DnsZoneAccessBindingsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListAccessBindings(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.AccessBindings
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *DnsZoneAccessBindingsIterator) Take(size int64) ([]*access.AccessBinding, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*access.AccessBinding

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *DnsZoneAccessBindingsIterator) TakeAll() ([]*access.AccessBinding, error) {
	return it.Take(0)
}

func (it *DnsZoneAccessBindingsIterator) Value() *access.AccessBinding {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *DnsZoneAccessBindingsIterator) Error() error {
	return it.err
}

// ListOperations implements dns.DnsZoneServiceClient
func (c *DnsZoneServiceClient) ListOperations(ctx context.Context, in *dns.ListDnsZoneOperationsRequest, opts ...grpc.CallOption) (*dns.ListDnsZoneOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dns.NewDnsZoneServiceClient(conn).ListOperations(ctx, in, opts...)
}

type DnsZoneOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *DnsZoneServiceClient
	request *dns.ListDnsZoneOperationsRequest

	items []*operation.Operation
}

func (c *DnsZoneServiceClient) DnsZoneOperationsIterator(ctx context.Context, req *dns.ListDnsZoneOperationsRequest, opts ...grpc.CallOption) *DnsZoneOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &DnsZoneOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *DnsZoneOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *DnsZoneOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *DnsZoneOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *DnsZoneOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *DnsZoneOperationsIterator) Error() error {
	return it.err
}

// ListRecordSets implements dns.DnsZoneServiceClient
func (c *DnsZoneServiceClient) ListRecordSets(ctx context.Context, in *dns.ListDnsZoneRecordSetsRequest, opts ...grpc.CallOption) (*dns.ListDnsZoneRecordSetsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dns.NewDnsZoneServiceClient(conn).ListRecordSets(ctx, in, opts...)
}

type DnsZoneRecordSetsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *DnsZoneServiceClient
	request *dns.ListDnsZoneRecordSetsRequest

	items []*dns.RecordSet
}

func (c *DnsZoneServiceClient) DnsZoneRecordSetsIterator(ctx context.Context, req *dns.ListDnsZoneRecordSetsRequest, opts ...grpc.CallOption) *DnsZoneRecordSetsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &DnsZoneRecordSetsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *DnsZoneRecordSetsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListRecordSets(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.RecordSets
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *DnsZoneRecordSetsIterator) Take(size int64) ([]*dns.RecordSet, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*dns.RecordSet

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *DnsZoneRecordSetsIterator) TakeAll() ([]*dns.RecordSet, error) {
	return it.Take(0)
}

func (it *DnsZoneRecordSetsIterator) Value() *dns.RecordSet {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *DnsZoneRecordSetsIterator) Error() error {
	return it.err
}

// SetAccessBindings implements dns.DnsZoneServiceClient
func (c *DnsZoneServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dns.NewDnsZoneServiceClient(conn).SetAccessBindings(ctx, in, opts...)
}

// Update implements dns.DnsZoneServiceClient
func (c *DnsZoneServiceClient) Update(ctx context.Context, in *dns.UpdateDnsZoneRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dns.NewDnsZoneServiceClient(conn).Update(ctx, in, opts...)
}

// UpdateAccessBindings implements dns.DnsZoneServiceClient
func (c *DnsZoneServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dns.NewDnsZoneServiceClient(conn).UpdateAccessBindings(ctx, in, opts...)
}

// UpdatePrivateNetworks implements dns.DnsZoneServiceClient
func (c *DnsZoneServiceClient) UpdatePrivateNetworks(ctx context.Context, in *dns.UpdateDnsZonePrivateNetworksRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dns.NewDnsZoneServiceClient(conn).UpdatePrivateNetworks(ctx, in, opts...)
}

// UpdateRecordSets implements dns.DnsZoneServiceClient
func (c *DnsZoneServiceClient) UpdateRecordSets(ctx context.Context, in *dns.UpdateRecordSetsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dns.NewDnsZoneServiceClient(conn).UpdateRecordSets(ctx, in, opts...)
}

// UpsertRecordSets implements dns.DnsZoneServiceClient
func (c *DnsZoneServiceClient) UpsertRecordSets(ctx context.Context, in *dns.UpsertRecordSetsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dns.NewDnsZoneServiceClient(conn).UpsertRecordSets(ctx, in, opts...)
}
