// Code generated by sdkgen. DO NOT EDIT.

// nolint
package billing

import (
	"context"

	"google.golang.org/grpc"

	billing "github.com/yandex-cloud/go-genproto/yandex/cloud/billing/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// CustomerServiceClient is a billing.CustomerServiceClient with
// lazy GRPC connection initialization.
type CustomerServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Activate implements billing.CustomerServiceClient
func (c *CustomerServiceClient) Activate(ctx context.Context, in *billing.ActivateCustomerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return billing.NewCustomerServiceClient(conn).Activate(ctx, in, opts...)
}

// CreateResellerServed implements billing.CustomerServiceClient
func (c *CustomerServiceClient) CreateResellerServed(ctx context.Context, in *billing.CreateResellerServedCustomerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return billing.NewCustomerServiceClient(conn).CreateResellerServed(ctx, in, opts...)
}

// Invite implements billing.CustomerServiceClient
func (c *CustomerServiceClient) Invite(ctx context.Context, in *billing.InviteCustomerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return billing.NewCustomerServiceClient(conn).Invite(ctx, in, opts...)
}

// List implements billing.CustomerServiceClient
func (c *CustomerServiceClient) List(ctx context.Context, in *billing.ListCustomersRequest, opts ...grpc.CallOption) (*billing.ListCustomersResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return billing.NewCustomerServiceClient(conn).List(ctx, in, opts...)
}

type CustomerIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *CustomerServiceClient
	request *billing.ListCustomersRequest

	items []*billing.Customer
}

func (c *CustomerServiceClient) CustomerIterator(ctx context.Context, req *billing.ListCustomersRequest, opts ...grpc.CallOption) *CustomerIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &CustomerIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *CustomerIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Customers
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *CustomerIterator) Take(size int64) ([]*billing.Customer, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*billing.Customer

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *CustomerIterator) TakeAll() ([]*billing.Customer, error) {
	return it.Take(0)
}

func (it *CustomerIterator) Value() *billing.Customer {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *CustomerIterator) Error() error {
	return it.err
}

// Suspend implements billing.CustomerServiceClient
func (c *CustomerServiceClient) Suspend(ctx context.Context, in *billing.SuspendCustomerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return billing.NewCustomerServiceClient(conn).Suspend(ctx, in, opts...)
}
