// Code generated by sdkgen. DO NOT EDIT.

// nolint
package audittrails

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	audittrails "github.com/yandex-cloud/go-genproto/yandex/cloud/audittrails/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// TrailServiceClient is a audittrails.TrailServiceClient with
// lazy GRPC connection initialization.
type TrailServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements audittrails.TrailServiceClient
func (c *TrailServiceClient) Create(ctx context.Context, in *audittrails.CreateTrailRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return audittrails.NewTrailServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements audittrails.TrailServiceClient
func (c *TrailServiceClient) Delete(ctx context.Context, in *audittrails.DeleteTrailRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return audittrails.NewTrailServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements audittrails.TrailServiceClient
func (c *TrailServiceClient) Get(ctx context.Context, in *audittrails.GetTrailRequest, opts ...grpc.CallOption) (*audittrails.Trail, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return audittrails.NewTrailServiceClient(conn).Get(ctx, in, opts...)
}

// List implements audittrails.TrailServiceClient
func (c *TrailServiceClient) List(ctx context.Context, in *audittrails.ListTrailsRequest, opts ...grpc.CallOption) (*audittrails.ListTrailsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return audittrails.NewTrailServiceClient(conn).List(ctx, in, opts...)
}

type TrailIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *TrailServiceClient
	request *audittrails.ListTrailsRequest

	items []*audittrails.Trail
}

func (c *TrailServiceClient) TrailIterator(ctx context.Context, req *audittrails.ListTrailsRequest, opts ...grpc.CallOption) *TrailIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &TrailIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *TrailIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Trails
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *TrailIterator) Take(size int64) ([]*audittrails.Trail, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*audittrails.Trail

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *TrailIterator) TakeAll() ([]*audittrails.Trail, error) {
	return it.Take(0)
}

func (it *TrailIterator) Value() *audittrails.Trail {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *TrailIterator) Error() error {
	return it.err
}

// ListAccessBindings implements audittrails.TrailServiceClient
func (c *TrailServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return audittrails.NewTrailServiceClient(conn).ListAccessBindings(ctx, in, opts...)
}

type TrailAccessBindingsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *TrailServiceClient
	request *access.ListAccessBindingsRequest

	items []*access.AccessBinding
}

func (c *TrailServiceClient) TrailAccessBindingsIterator(ctx context.Context, req *access.ListAccessBindingsRequest, opts ...grpc.CallOption) *TrailAccessBindingsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &TrailAccessBindingsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *TrailAccessBindingsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListAccessBindings(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.AccessBindings
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *TrailAccessBindingsIterator) Take(size int64) ([]*access.AccessBinding, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*access.AccessBinding

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *TrailAccessBindingsIterator) TakeAll() ([]*access.AccessBinding, error) {
	return it.Take(0)
}

func (it *TrailAccessBindingsIterator) Value() *access.AccessBinding {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *TrailAccessBindingsIterator) Error() error {
	return it.err
}

// ListOperations implements audittrails.TrailServiceClient
func (c *TrailServiceClient) ListOperations(ctx context.Context, in *audittrails.ListTrailOperationsRequest, opts ...grpc.CallOption) (*audittrails.ListTrailOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return audittrails.NewTrailServiceClient(conn).ListOperations(ctx, in, opts...)
}

type TrailOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *TrailServiceClient
	request *audittrails.ListTrailOperationsRequest

	items []*operation.Operation
}

func (c *TrailServiceClient) TrailOperationsIterator(ctx context.Context, req *audittrails.ListTrailOperationsRequest, opts ...grpc.CallOption) *TrailOperationsIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &TrailOperationsIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *TrailOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *TrailOperationsIterator) Take(size int64) ([]*operation.Operation, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*operation.Operation

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *TrailOperationsIterator) TakeAll() ([]*operation.Operation, error) {
	return it.Take(0)
}

func (it *TrailOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *TrailOperationsIterator) Error() error {
	return it.err
}

// SetAccessBindings implements audittrails.TrailServiceClient
func (c *TrailServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return audittrails.NewTrailServiceClient(conn).SetAccessBindings(ctx, in, opts...)
}

// Update implements audittrails.TrailServiceClient
func (c *TrailServiceClient) Update(ctx context.Context, in *audittrails.UpdateTrailRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return audittrails.NewTrailServiceClient(conn).Update(ctx, in, opts...)
}

// UpdateAccessBindings implements audittrails.TrailServiceClient
func (c *TrailServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return audittrails.NewTrailServiceClient(conn).UpdateAccessBindings(ctx, in, opts...)
}
