// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v3.21.12
// source: yandex/cloud/apploadbalancer/v1/backend_group.proto

package apploadbalancer

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A load balancing mode resource.
// For details about the concept, see
// [documentation](/docs/application-load-balancer/concepts/backend-group#balancing-mode).
type LoadBalancingMode int32

const (
	// Round robin load balancing mode.
	//
	// All endpoints of the backend take their turns to receive requests attributed to the backend.
	LoadBalancingMode_ROUND_ROBIN LoadBalancingMode = 0
	// Random load balancing mode. Default value.
	//
	// For a request attributed to the backend, an endpoint that receives it is picked at random.
	LoadBalancingMode_RANDOM LoadBalancingMode = 1
	// Least request load balancing mode.
	//
	// To pick an endpoint that receives a request attributed to the backend, the power of two choices algorithm is used;
	// that is, two endpoints are picked at random, and the request is sent to the one which has the fewest active
	// requests.
	LoadBalancingMode_LEAST_REQUEST LoadBalancingMode = 2
	// Maglev hashing load balancing mode.
	//
	// Each endpoint is hashed, and a hash table with 65537 rows is filled accordingly, so that every endpoint occupies
	// the same amount of rows. An attribute of each request is also hashed by the same function (if session affinity is
	// enabled for the backend group, the attribute to hash is specified in session affinity configuration). The row
	// with the same number as the resulting value is looked up in the table to determine the endpoint that receives
	// the request.
	//
	// If the backend group with session affinity enabled contains more than one backend with positive weight, endpoints
	// for backends with `MAGLEV_HASH` load balancing mode are picked at `RANDOM` instead.
	LoadBalancingMode_MAGLEV_HASH LoadBalancingMode = 3
)

// Enum value maps for LoadBalancingMode.
var (
	LoadBalancingMode_name = map[int32]string{
		0: "ROUND_ROBIN",
		1: "RANDOM",
		2: "LEAST_REQUEST",
		3: "MAGLEV_HASH",
	}
	LoadBalancingMode_value = map[string]int32{
		"ROUND_ROBIN":   0,
		"RANDOM":        1,
		"LEAST_REQUEST": 2,
		"MAGLEV_HASH":   3,
	}
)

func (x LoadBalancingMode) Enum() *LoadBalancingMode {
	p := new(LoadBalancingMode)
	*p = x
	return p
}

func (x LoadBalancingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoadBalancingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_enumTypes[0].Descriptor()
}

func (LoadBalancingMode) Type() protoreflect.EnumType {
	return &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_enumTypes[0]
}

func (x LoadBalancingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoadBalancingMode.Descriptor instead.
func (LoadBalancingMode) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP(), []int{0}
}

// A backend group resource.
// For details about the concept, see [documentation](/docs/application-load-balancer/concepts/backend-group).
type BackendGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the backend group. Generated at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the backend group. The name is unique within the folder. The string length in characters is 3-63.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the backend group. The string is 0-256 characters long.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// ID of the folder that the backend group belongs to.
	FolderId string `protobuf:"bytes,4,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Backend group labels as `key:value` pairs.
	// For details about the concept, see [documentation](/docs/overview/concepts/services#labels).
	// The maximum number of labels is 64.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Backends that the backend group consists of.
	//
	// Types that are assignable to Backend:
	//
	//	*BackendGroup_Http
	//	*BackendGroup_Grpc
	//	*BackendGroup_Stream
	Backend isBackendGroup_Backend `protobuf_oneof:"backend"`
	// Creation timestamp.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
}

func (x *BackendGroup) Reset() {
	*x = BackendGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackendGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackendGroup) ProtoMessage() {}

func (x *BackendGroup) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackendGroup.ProtoReflect.Descriptor instead.
func (*BackendGroup) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP(), []int{0}
}

func (x *BackendGroup) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *BackendGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BackendGroup) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *BackendGroup) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *BackendGroup) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (m *BackendGroup) GetBackend() isBackendGroup_Backend {
	if m != nil {
		return m.Backend
	}
	return nil
}

func (x *BackendGroup) GetHttp() *HttpBackendGroup {
	if x, ok := x.GetBackend().(*BackendGroup_Http); ok {
		return x.Http
	}
	return nil
}

func (x *BackendGroup) GetGrpc() *GrpcBackendGroup {
	if x, ok := x.GetBackend().(*BackendGroup_Grpc); ok {
		return x.Grpc
	}
	return nil
}

func (x *BackendGroup) GetStream() *StreamBackendGroup {
	if x, ok := x.GetBackend().(*BackendGroup_Stream); ok {
		return x.Stream
	}
	return nil
}

func (x *BackendGroup) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

type isBackendGroup_Backend interface {
	isBackendGroup_Backend()
}

type BackendGroup_Http struct {
	// List of HTTP backends that the backend group consists of.
	Http *HttpBackendGroup `protobuf:"bytes,6,opt,name=http,proto3,oneof"`
}

type BackendGroup_Grpc struct {
	// List of gRPC backends that the backend group consists of.
	Grpc *GrpcBackendGroup `protobuf:"bytes,7,opt,name=grpc,proto3,oneof"`
}

type BackendGroup_Stream struct {
	// List of stream (TCP) backends that the backend group consists of.
	Stream *StreamBackendGroup `protobuf:"bytes,10,opt,name=stream,proto3,oneof"`
}

func (*BackendGroup_Http) isBackendGroup_Backend() {}

func (*BackendGroup_Grpc) isBackendGroup_Backend() {}

func (*BackendGroup_Stream) isBackendGroup_Backend() {}

// A stream (TCP) backend group resource.
type StreamBackendGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of stream (TCP) backends.
	Backends []*StreamBackend `protobuf:"bytes,1,rep,name=backends,proto3" json:"backends,omitempty"`
	// Session affinity configuration for the backend group.
	//
	// For details about the concept, see
	// [documentation](/docs/application-load-balancer/concepts/backend-group#session-affinity).
	//
	// If session affinity is configured, the backend group should contain exactly one active backend (i.e. with positive
	// [HttpBackend.backend_weight]), its [HttpBackend.backend_type] should be [TargetGroupsBackend], and its
	// [LoadBalancingConfig.load_balancing_mode] should be `MAGLEV_HASH`. If any of these conditions are not met, session
	// affinity will not work.
	//
	// Types that are assignable to SessionAffinity:
	//
	//	*StreamBackendGroup_Connection
	SessionAffinity isStreamBackendGroup_SessionAffinity `protobuf_oneof:"session_affinity"`
}

func (x *StreamBackendGroup) Reset() {
	*x = StreamBackendGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamBackendGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamBackendGroup) ProtoMessage() {}

func (x *StreamBackendGroup) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamBackendGroup.ProtoReflect.Descriptor instead.
func (*StreamBackendGroup) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP(), []int{1}
}

func (x *StreamBackendGroup) GetBackends() []*StreamBackend {
	if x != nil {
		return x.Backends
	}
	return nil
}

func (m *StreamBackendGroup) GetSessionAffinity() isStreamBackendGroup_SessionAffinity {
	if m != nil {
		return m.SessionAffinity
	}
	return nil
}

func (x *StreamBackendGroup) GetConnection() *ConnectionSessionAffinity {
	if x, ok := x.GetSessionAffinity().(*StreamBackendGroup_Connection); ok {
		return x.Connection
	}
	return nil
}

type isStreamBackendGroup_SessionAffinity interface {
	isStreamBackendGroup_SessionAffinity()
}

type StreamBackendGroup_Connection struct {
	// Connection-based session affinity configuration.
	//
	// For now, a connection is defined only by an IP address of the client.
	Connection *ConnectionSessionAffinity `protobuf:"bytes,2,opt,name=connection,proto3,oneof"`
}

func (*StreamBackendGroup_Connection) isStreamBackendGroup_SessionAffinity() {}

// An HTTP backend group resource.
type HttpBackendGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of HTTP backends.
	Backends []*HttpBackend `protobuf:"bytes,1,rep,name=backends,proto3" json:"backends,omitempty"`
	// Session affinity configuration for the backend group.
	//
	// For details about the concept, see
	// [documentation](/docs/application-load-balancer/concepts/backend-group#session-affinity).
	//
	// If session affinity is configured, the backend group should contain exactly one active backend (i.e. with positive
	// [HttpBackend.backend_weight]), its [HttpBackend.backend_type] should be [TargetGroupsBackend], and its
	// [LoadBalancingConfig.load_balancing_mode] should be `MAGLEV_HASH`. If any of these conditions are not met, session
	// affinity will not work.
	//
	// Types that are assignable to SessionAffinity:
	//
	//	*HttpBackendGroup_Connection
	//	*HttpBackendGroup_Header
	//	*HttpBackendGroup_Cookie
	SessionAffinity isHttpBackendGroup_SessionAffinity `protobuf_oneof:"session_affinity"`
}

func (x *HttpBackendGroup) Reset() {
	*x = HttpBackendGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpBackendGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpBackendGroup) ProtoMessage() {}

func (x *HttpBackendGroup) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpBackendGroup.ProtoReflect.Descriptor instead.
func (*HttpBackendGroup) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP(), []int{2}
}

func (x *HttpBackendGroup) GetBackends() []*HttpBackend {
	if x != nil {
		return x.Backends
	}
	return nil
}

func (m *HttpBackendGroup) GetSessionAffinity() isHttpBackendGroup_SessionAffinity {
	if m != nil {
		return m.SessionAffinity
	}
	return nil
}

func (x *HttpBackendGroup) GetConnection() *ConnectionSessionAffinity {
	if x, ok := x.GetSessionAffinity().(*HttpBackendGroup_Connection); ok {
		return x.Connection
	}
	return nil
}

func (x *HttpBackendGroup) GetHeader() *HeaderSessionAffinity {
	if x, ok := x.GetSessionAffinity().(*HttpBackendGroup_Header); ok {
		return x.Header
	}
	return nil
}

func (x *HttpBackendGroup) GetCookie() *CookieSessionAffinity {
	if x, ok := x.GetSessionAffinity().(*HttpBackendGroup_Cookie); ok {
		return x.Cookie
	}
	return nil
}

type isHttpBackendGroup_SessionAffinity interface {
	isHttpBackendGroup_SessionAffinity()
}

type HttpBackendGroup_Connection struct {
	// Connection-based session affinity configuration.
	//
	// For now, a connection is defined only by an IP address of the client.
	Connection *ConnectionSessionAffinity `protobuf:"bytes,2,opt,name=connection,proto3,oneof"`
}

type HttpBackendGroup_Header struct {
	// HTTP-header-field-based session affinity configuration.
	Header *HeaderSessionAffinity `protobuf:"bytes,3,opt,name=header,proto3,oneof"`
}

type HttpBackendGroup_Cookie struct {
	// Cookie-based session affinity configuration.
	Cookie *CookieSessionAffinity `protobuf:"bytes,4,opt,name=cookie,proto3,oneof"`
}

func (*HttpBackendGroup_Connection) isHttpBackendGroup_SessionAffinity() {}

func (*HttpBackendGroup_Header) isHttpBackendGroup_SessionAffinity() {}

func (*HttpBackendGroup_Cookie) isHttpBackendGroup_SessionAffinity() {}

// A gRPC backend group resource.
type GrpcBackendGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of gRPC backends.
	Backends []*GrpcBackend `protobuf:"bytes,1,rep,name=backends,proto3" json:"backends,omitempty"`
	// Session affinity configuration for the backend group.
	//
	// For details about the concept, see
	// [documentation](/docs/application-load-balancer/concepts/backend-group#session-affinity).
	//
	// If session affinity is configured, the backend group should contain exactly one active backend (i.e. with positive
	// [GrpcBackend.backend_weight]), and its [LoadBalancingConfig.load_balancing_mode] should be `MAGLEV_HASH`. If any of
	// these conditions are not met, session affinity will not work.
	//
	// Types that are assignable to SessionAffinity:
	//
	//	*GrpcBackendGroup_Connection
	//	*GrpcBackendGroup_Header
	//	*GrpcBackendGroup_Cookie
	SessionAffinity isGrpcBackendGroup_SessionAffinity `protobuf_oneof:"session_affinity"`
}

func (x *GrpcBackendGroup) Reset() {
	*x = GrpcBackendGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GrpcBackendGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GrpcBackendGroup) ProtoMessage() {}

func (x *GrpcBackendGroup) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GrpcBackendGroup.ProtoReflect.Descriptor instead.
func (*GrpcBackendGroup) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP(), []int{3}
}

func (x *GrpcBackendGroup) GetBackends() []*GrpcBackend {
	if x != nil {
		return x.Backends
	}
	return nil
}

func (m *GrpcBackendGroup) GetSessionAffinity() isGrpcBackendGroup_SessionAffinity {
	if m != nil {
		return m.SessionAffinity
	}
	return nil
}

func (x *GrpcBackendGroup) GetConnection() *ConnectionSessionAffinity {
	if x, ok := x.GetSessionAffinity().(*GrpcBackendGroup_Connection); ok {
		return x.Connection
	}
	return nil
}

func (x *GrpcBackendGroup) GetHeader() *HeaderSessionAffinity {
	if x, ok := x.GetSessionAffinity().(*GrpcBackendGroup_Header); ok {
		return x.Header
	}
	return nil
}

func (x *GrpcBackendGroup) GetCookie() *CookieSessionAffinity {
	if x, ok := x.GetSessionAffinity().(*GrpcBackendGroup_Cookie); ok {
		return x.Cookie
	}
	return nil
}

type isGrpcBackendGroup_SessionAffinity interface {
	isGrpcBackendGroup_SessionAffinity()
}

type GrpcBackendGroup_Connection struct {
	// Connection-based session affinity configuration.
	//
	// For now, a connection is defined only by an IP address of the client.
	Connection *ConnectionSessionAffinity `protobuf:"bytes,2,opt,name=connection,proto3,oneof"`
}

type GrpcBackendGroup_Header struct {
	// HTTP-header-field-based session affinity configuration.
	Header *HeaderSessionAffinity `protobuf:"bytes,3,opt,name=header,proto3,oneof"`
}

type GrpcBackendGroup_Cookie struct {
	// Cookie-based session affinity configuration.
	Cookie *CookieSessionAffinity `protobuf:"bytes,4,opt,name=cookie,proto3,oneof"`
}

func (*GrpcBackendGroup_Connection) isGrpcBackendGroup_SessionAffinity() {}

func (*GrpcBackendGroup_Header) isGrpcBackendGroup_SessionAffinity() {}

func (*GrpcBackendGroup_Cookie) isGrpcBackendGroup_SessionAffinity() {}

// A resource for HTTP-header-field-based session affinity configuration.
type HeaderSessionAffinity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the HTTP header field that is used for session affinity.
	HeaderName string `protobuf:"bytes,1,opt,name=header_name,json=headerName,proto3" json:"header_name,omitempty"`
}

func (x *HeaderSessionAffinity) Reset() {
	*x = HeaderSessionAffinity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HeaderSessionAffinity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeaderSessionAffinity) ProtoMessage() {}

func (x *HeaderSessionAffinity) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeaderSessionAffinity.ProtoReflect.Descriptor instead.
func (*HeaderSessionAffinity) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP(), []int{4}
}

func (x *HeaderSessionAffinity) GetHeaderName() string {
	if x != nil {
		return x.HeaderName
	}
	return ""
}

// A resource for cookie-based session affinity configuration.
type CookieSessionAffinity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the cookie that is used for session affinity.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Maximum age of cookies that are generated for sessions.
	//
	// If set to `0`, session cookies are used, which are stored by clients in temporary memory and are deleted
	// on client restarts.
	//
	// If not set, the balancer does not generate cookies and only uses incoming ones for establishing session affinity.
	Ttl *durationpb.Duration `protobuf:"bytes,2,opt,name=ttl,proto3" json:"ttl,omitempty"`
}

func (x *CookieSessionAffinity) Reset() {
	*x = CookieSessionAffinity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CookieSessionAffinity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CookieSessionAffinity) ProtoMessage() {}

func (x *CookieSessionAffinity) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CookieSessionAffinity.ProtoReflect.Descriptor instead.
func (*CookieSessionAffinity) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP(), []int{5}
}

func (x *CookieSessionAffinity) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CookieSessionAffinity) GetTtl() *durationpb.Duration {
	if x != nil {
		return x.Ttl
	}
	return nil
}

// A resource for connection-based session affinity configuration.
type ConnectionSessionAffinity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies whether an IP address of the client is used to define a connection for session affinity.
	SourceIp bool `protobuf:"varint,1,opt,name=source_ip,json=sourceIp,proto3" json:"source_ip,omitempty"`
}

func (x *ConnectionSessionAffinity) Reset() {
	*x = ConnectionSessionAffinity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectionSessionAffinity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionSessionAffinity) ProtoMessage() {}

func (x *ConnectionSessionAffinity) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionSessionAffinity.ProtoReflect.Descriptor instead.
func (*ConnectionSessionAffinity) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP(), []int{6}
}

func (x *ConnectionSessionAffinity) GetSourceIp() bool {
	if x != nil {
		return x.SourceIp
	}
	return false
}

// A load balancing configuration resource.
type LoadBalancingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Threshold for panic mode.
	//
	// If percentage of healthy backends in the group drops below threshold,
	// panic mode will be activated and traffic will be routed to all backends, regardless of their health check status.
	// This helps to avoid overloading healthy backends.
	// For details about panic mode, see [documentation](/docs/application-load-balancer/concepts/backend-group#panic-mode).
	//
	// If the value is `0`, panic mode will never be activated and traffic is routed only to healthy backends at all times.
	//
	// Default value: `0`.
	PanicThreshold int64 `protobuf:"varint,1,opt,name=panic_threshold,json=panicThreshold,proto3" json:"panic_threshold,omitempty"`
	// Percentage of traffic that a load balancer node sends to healthy backends in its availability zone.
	// The rest is divided equally between other zones. For details about zone-aware routing, see
	// [documentation](/docs/application-load-balancer/concepts/backend-group#locality).
	//
	// If there are no healthy backends in an availability zone, all the traffic is divided between other zones.
	//
	// If [strict_locality] is `true`, the specified value is ignored.
	// A load balancer node sends all the traffic within its availability zone, regardless of backends' health.
	//
	// Default value: `0`.
	LocalityAwareRoutingPercent int64 `protobuf:"varint,2,opt,name=locality_aware_routing_percent,json=localityAwareRoutingPercent,proto3" json:"locality_aware_routing_percent,omitempty"`
	// Specifies whether a load balancer node should only send traffic to backends in its availability zone,
	// regardless of their health, and ignore backends in other zones.
	//
	// If set to `true` and there are no healthy backends in the zone, the node in this zone will respond
	// to incoming traffic with errors.
	// For details about strict locality, see [documentation](/docs/application-load-balancer/concepts/backend-group#locality).
	//
	// If `strict_locality` is `true`, the value specified in [locality_aware_routing_percent] is ignored.
	//
	// Default value: `false`.
	StrictLocality bool `protobuf:"varint,3,opt,name=strict_locality,json=strictLocality,proto3" json:"strict_locality,omitempty"`
	// Load balancing mode for the backend.
	//
	// For details about load balancing modes, see
	// [documentation](/docs/application-load-balancer/concepts/backend-group#balancing-mode).
	Mode LoadBalancingMode `protobuf:"varint,4,opt,name=mode,proto3,enum=yandex.cloud.apploadbalancer.v1.LoadBalancingMode" json:"mode,omitempty"`
}

func (x *LoadBalancingConfig) Reset() {
	*x = LoadBalancingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadBalancingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadBalancingConfig) ProtoMessage() {}

func (x *LoadBalancingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadBalancingConfig.ProtoReflect.Descriptor instead.
func (*LoadBalancingConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP(), []int{7}
}

func (x *LoadBalancingConfig) GetPanicThreshold() int64 {
	if x != nil {
		return x.PanicThreshold
	}
	return 0
}

func (x *LoadBalancingConfig) GetLocalityAwareRoutingPercent() int64 {
	if x != nil {
		return x.LocalityAwareRoutingPercent
	}
	return 0
}

func (x *LoadBalancingConfig) GetStrictLocality() bool {
	if x != nil {
		return x.StrictLocality
	}
	return false
}

func (x *LoadBalancingConfig) GetMode() LoadBalancingMode {
	if x != nil {
		return x.Mode
	}
	return LoadBalancingMode_ROUND_ROBIN
}

// A stream (TCP) backend resource.
type StreamBackend struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the backend.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Backend weight. Traffic is distributed between backends of a backend group according to their weights.
	//
	// Weights must be set either for all backends in a group or for none of them.
	// Setting no weights is the same as setting equal non-zero weights for all backends.
	//
	// If the weight is non-positive, traffic is not sent to the backend.
	BackendWeight *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=backend_weight,json=backendWeight,proto3" json:"backend_weight,omitempty"`
	// Load balancing configuration for the backend.
	LoadBalancingConfig *LoadBalancingConfig `protobuf:"bytes,3,opt,name=load_balancing_config,json=loadBalancingConfig,proto3" json:"load_balancing_config,omitempty"`
	// Port used by all targets to receive traffic.
	Port int64 `protobuf:"varint,4,opt,name=port,proto3" json:"port,omitempty"`
	// Reference to targets that belong to the backend.
	//
	// Types that are assignable to BackendType:
	//
	//	*StreamBackend_TargetGroups
	BackendType isStreamBackend_BackendType `protobuf_oneof:"backend_type"`
	// Health checks to perform on targets from target groups.
	// For details about health checking, see [documentation](/docs/application-load-balancer/concepts/backend-group#health-checks).
	//
	// If no health checks are specified, active health checking is not performed.
	Healthchecks []*HealthCheck `protobuf:"bytes,6,rep,name=healthchecks,proto3" json:"healthchecks,omitempty"`
	// Settings for TLS connections between load balancer nodes and backend targets.
	//
	// If specified, the load balancer establishes TLS-encrypted TCP connections with targets and compares received
	// certificates with the one specified in [BackendTls.validation_context].
	// If not specified, the load balancer establishes unencrypted TCP connections with targets.
	Tls *BackendTls `protobuf:"bytes,7,opt,name=tls,proto3" json:"tls,omitempty"`
	// If set, proxy protocol will be enabled for this backend.
	EnableProxyProtocol bool `protobuf:"varint,8,opt,name=enable_proxy_protocol,json=enableProxyProtocol,proto3" json:"enable_proxy_protocol,omitempty"`
	// If a backend host becomes unhealthy (as determined by the configured health checks),
	// keep connections to the failed host.
	KeepConnectionsOnHostHealthFailure bool `protobuf:"varint,9,opt,name=keep_connections_on_host_health_failure,json=keepConnectionsOnHostHealthFailure,proto3" json:"keep_connections_on_host_health_failure,omitempty"`
}

func (x *StreamBackend) Reset() {
	*x = StreamBackend{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamBackend) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamBackend) ProtoMessage() {}

func (x *StreamBackend) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamBackend.ProtoReflect.Descriptor instead.
func (*StreamBackend) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP(), []int{8}
}

func (x *StreamBackend) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StreamBackend) GetBackendWeight() *wrapperspb.Int64Value {
	if x != nil {
		return x.BackendWeight
	}
	return nil
}

func (x *StreamBackend) GetLoadBalancingConfig() *LoadBalancingConfig {
	if x != nil {
		return x.LoadBalancingConfig
	}
	return nil
}

func (x *StreamBackend) GetPort() int64 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (m *StreamBackend) GetBackendType() isStreamBackend_BackendType {
	if m != nil {
		return m.BackendType
	}
	return nil
}

func (x *StreamBackend) GetTargetGroups() *TargetGroupsBackend {
	if x, ok := x.GetBackendType().(*StreamBackend_TargetGroups); ok {
		return x.TargetGroups
	}
	return nil
}

func (x *StreamBackend) GetHealthchecks() []*HealthCheck {
	if x != nil {
		return x.Healthchecks
	}
	return nil
}

func (x *StreamBackend) GetTls() *BackendTls {
	if x != nil {
		return x.Tls
	}
	return nil
}

func (x *StreamBackend) GetEnableProxyProtocol() bool {
	if x != nil {
		return x.EnableProxyProtocol
	}
	return false
}

func (x *StreamBackend) GetKeepConnectionsOnHostHealthFailure() bool {
	if x != nil {
		return x.KeepConnectionsOnHostHealthFailure
	}
	return false
}

type isStreamBackend_BackendType interface {
	isStreamBackend_BackendType()
}

type StreamBackend_TargetGroups struct {
	// Target groups that belong to the backend. For details about target groups, see
	// [documentation](/docs/application-load-balancer/concepts/target-group).
	TargetGroups *TargetGroupsBackend `protobuf:"bytes,5,opt,name=target_groups,json=targetGroups,proto3,oneof"`
}

func (*StreamBackend_TargetGroups) isStreamBackend_BackendType() {}

// An HTTP backend resource.
type HttpBackend struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the backend.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Backend weight. Traffic is distributed between backends of a backend group according to their weights.
	//
	// Weights must be set either for all backends in a group or for none of them.
	// Setting no weights is the same as setting equal non-zero weights for all backends.
	//
	// If the weight is non-positive, traffic is not sent to the backend.
	BackendWeight *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=backend_weight,json=backendWeight,proto3" json:"backend_weight,omitempty"`
	// Load balancing configuration for the backend.
	LoadBalancingConfig *LoadBalancingConfig `protobuf:"bytes,3,opt,name=load_balancing_config,json=loadBalancingConfig,proto3" json:"load_balancing_config,omitempty"`
	// Port used by all targets to receive traffic.
	Port int64 `protobuf:"varint,4,opt,name=port,proto3" json:"port,omitempty"`
	// Reference to targets that belong to the backend.
	//
	// A backend may be a set of target groups or an Object Storage bucket. For details about backend types, see
	// [documentation](/docs/application-load-balancer/concepts/backend-group#types).
	//
	// Types that are assignable to BackendType:
	//
	//	*HttpBackend_TargetGroups
	//	*HttpBackend_StorageBucket
	BackendType isHttpBackend_BackendType `protobuf_oneof:"backend_type"`
	// Health checks to perform on targets from target groups.
	// For details about health checking, see [documentation](/docs/application-load-balancer/concepts/backend-group#health-checks).
	//
	// If no health checks are specified, active health checking is not performed.
	Healthchecks []*HealthCheck `protobuf:"bytes,6,rep,name=healthchecks,proto3" json:"healthchecks,omitempty"`
	// Settings for TLS connections between load balancer nodes and backend targets.
	//
	// If specified, the load balancer establishes HTTPS (HTTP over TLS) connections with targets
	// and compares received certificates with the one specified in [BackendTls.validation_context].
	// If not specified, the load balancer establishes unencrypted HTTP connections with targets.
	Tls *BackendTls `protobuf:"bytes,7,opt,name=tls,proto3" json:"tls,omitempty"`
	// Enables HTTP/2 usage in connections between load balancer nodes and backend targets.
	//
	// Default value: `false`, HTTP/1.1 is used.
	UseHttp2 bool `protobuf:"varint,8,opt,name=use_http2,json=useHttp2,proto3" json:"use_http2,omitempty"`
}

func (x *HttpBackend) Reset() {
	*x = HttpBackend{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpBackend) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpBackend) ProtoMessage() {}

func (x *HttpBackend) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpBackend.ProtoReflect.Descriptor instead.
func (*HttpBackend) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP(), []int{9}
}

func (x *HttpBackend) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HttpBackend) GetBackendWeight() *wrapperspb.Int64Value {
	if x != nil {
		return x.BackendWeight
	}
	return nil
}

func (x *HttpBackend) GetLoadBalancingConfig() *LoadBalancingConfig {
	if x != nil {
		return x.LoadBalancingConfig
	}
	return nil
}

func (x *HttpBackend) GetPort() int64 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (m *HttpBackend) GetBackendType() isHttpBackend_BackendType {
	if m != nil {
		return m.BackendType
	}
	return nil
}

func (x *HttpBackend) GetTargetGroups() *TargetGroupsBackend {
	if x, ok := x.GetBackendType().(*HttpBackend_TargetGroups); ok {
		return x.TargetGroups
	}
	return nil
}

func (x *HttpBackend) GetStorageBucket() *StorageBucketBackend {
	if x, ok := x.GetBackendType().(*HttpBackend_StorageBucket); ok {
		return x.StorageBucket
	}
	return nil
}

func (x *HttpBackend) GetHealthchecks() []*HealthCheck {
	if x != nil {
		return x.Healthchecks
	}
	return nil
}

func (x *HttpBackend) GetTls() *BackendTls {
	if x != nil {
		return x.Tls
	}
	return nil
}

func (x *HttpBackend) GetUseHttp2() bool {
	if x != nil {
		return x.UseHttp2
	}
	return false
}

type isHttpBackend_BackendType interface {
	isHttpBackend_BackendType()
}

type HttpBackend_TargetGroups struct {
	// Target groups that belong to the backend. For details about target groups, see
	// [documentation](/docs/application-load-balancer/concepts/target-group).
	TargetGroups *TargetGroupsBackend `protobuf:"bytes,5,opt,name=target_groups,json=targetGroups,proto3,oneof"`
}

type HttpBackend_StorageBucket struct {
	// Object Storage bucket to use as the backend. For details about buckets, see
	// [documentation](/docs/storage/concepts/bucket).
	//
	// If a bucket is used as a backend, the list of bucket objects and the objects themselves must be publicly
	// accessible. For instructions, see [documentation](/docs/storage/operations/buckets/bucket-availability).
	StorageBucket *StorageBucketBackend `protobuf:"bytes,9,opt,name=storage_bucket,json=storageBucket,proto3,oneof"`
}

func (*HttpBackend_TargetGroups) isHttpBackend_BackendType() {}

func (*HttpBackend_StorageBucket) isHttpBackend_BackendType() {}

// A gRPC backend resource.
type GrpcBackend struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the backend.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Backend weight. Traffic is distributed between backends of a backend group according to their weights.
	//
	// Weights must be set either for all backends of a group or for none of them.
	// Setting no weights is the same as setting equal non-zero weights for all backends.
	//
	// If the weight is non-positive, traffic is not sent to the backend.
	BackendWeight *wrapperspb.Int64Value `protobuf:"bytes,2,opt,name=backend_weight,json=backendWeight,proto3" json:"backend_weight,omitempty"`
	// Load balancing configuration for the backend.
	LoadBalancingConfig *LoadBalancingConfig `protobuf:"bytes,3,opt,name=load_balancing_config,json=loadBalancingConfig,proto3" json:"load_balancing_config,omitempty"`
	// Port used by all targets to receive traffic.
	Port int64 `protobuf:"varint,4,opt,name=port,proto3" json:"port,omitempty"`
	// Reference to targets that belong to the backend. For now, targets are referenced via target groups.
	//
	// Types that are assignable to BackendType:
	//
	//	*GrpcBackend_TargetGroups
	BackendType isGrpcBackend_BackendType `protobuf_oneof:"backend_type"`
	// Health checks to perform on targets from target groups.
	// For details about health checking, see [documentation](/docs/application-load-balancer/concepts/backend-group#health-checks).
	//
	// If no health checks are specified, active health checking is not performed.
	Healthchecks []*HealthCheck `protobuf:"bytes,7,rep,name=healthchecks,proto3" json:"healthchecks,omitempty"`
	// Settings for TLS connections between load balancer nodes and backend targets.
	//
	// If specified, the load balancer establishes HTTPS (HTTP over TLS) connections with targets
	// and compares received certificates with the one specified in [BackendTls.validation_context].
	// If not specified, the load balancer establishes unencrypted HTTP connections with targets.
	Tls *BackendTls `protobuf:"bytes,8,opt,name=tls,proto3" json:"tls,omitempty"`
}

func (x *GrpcBackend) Reset() {
	*x = GrpcBackend{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GrpcBackend) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GrpcBackend) ProtoMessage() {}

func (x *GrpcBackend) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GrpcBackend.ProtoReflect.Descriptor instead.
func (*GrpcBackend) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP(), []int{10}
}

func (x *GrpcBackend) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GrpcBackend) GetBackendWeight() *wrapperspb.Int64Value {
	if x != nil {
		return x.BackendWeight
	}
	return nil
}

func (x *GrpcBackend) GetLoadBalancingConfig() *LoadBalancingConfig {
	if x != nil {
		return x.LoadBalancingConfig
	}
	return nil
}

func (x *GrpcBackend) GetPort() int64 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (m *GrpcBackend) GetBackendType() isGrpcBackend_BackendType {
	if m != nil {
		return m.BackendType
	}
	return nil
}

func (x *GrpcBackend) GetTargetGroups() *TargetGroupsBackend {
	if x, ok := x.GetBackendType().(*GrpcBackend_TargetGroups); ok {
		return x.TargetGroups
	}
	return nil
}

func (x *GrpcBackend) GetHealthchecks() []*HealthCheck {
	if x != nil {
		return x.Healthchecks
	}
	return nil
}

func (x *GrpcBackend) GetTls() *BackendTls {
	if x != nil {
		return x.Tls
	}
	return nil
}

type isGrpcBackend_BackendType interface {
	isGrpcBackend_BackendType()
}

type GrpcBackend_TargetGroups struct {
	// Target groups that belong to the backend.
	TargetGroups *TargetGroupsBackend `protobuf:"bytes,5,opt,name=target_groups,json=targetGroups,proto3,oneof"`
}

func (*GrpcBackend_TargetGroups) isGrpcBackend_BackendType() {}

// A resource for target groups that belong to the backend.
type TargetGroupsBackend struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of ID's of target groups that belong to the backend.
	//
	// To get the ID's of all available target groups, make a [TargetGroupService.List] request.
	TargetGroupIds []string `protobuf:"bytes,1,rep,name=target_group_ids,json=targetGroupIds,proto3" json:"target_group_ids,omitempty"`
}

func (x *TargetGroupsBackend) Reset() {
	*x = TargetGroupsBackend{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TargetGroupsBackend) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetGroupsBackend) ProtoMessage() {}

func (x *TargetGroupsBackend) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetGroupsBackend.ProtoReflect.Descriptor instead.
func (*TargetGroupsBackend) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP(), []int{11}
}

func (x *TargetGroupsBackend) GetTargetGroupIds() []string {
	if x != nil {
		return x.TargetGroupIds
	}
	return nil
}

// Transport settings to be used instead of the settings configured per-cluster
type PlaintextTransportSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PlaintextTransportSettings) Reset() {
	*x = PlaintextTransportSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlaintextTransportSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlaintextTransportSettings) ProtoMessage() {}

func (x *PlaintextTransportSettings) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlaintextTransportSettings.ProtoReflect.Descriptor instead.
func (*PlaintextTransportSettings) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP(), []int{12}
}

// Transport settings to be used instead of the settings configured per-cluster
type SecureTransportSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// SNI string for TLS connections.
	Sni string `protobuf:"bytes,1,opt,name=sni,proto3" json:"sni,omitempty"`
	// Validation context for backend TLS connections.
	ValidationContext *ValidationContext `protobuf:"bytes,3,opt,name=validation_context,json=validationContext,proto3" json:"validation_context,omitempty"`
}

func (x *SecureTransportSettings) Reset() {
	*x = SecureTransportSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecureTransportSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecureTransportSettings) ProtoMessage() {}

func (x *SecureTransportSettings) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecureTransportSettings.ProtoReflect.Descriptor instead.
func (*SecureTransportSettings) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP(), []int{13}
}

func (x *SecureTransportSettings) GetSni() string {
	if x != nil {
		return x.Sni
	}
	return ""
}

func (x *SecureTransportSettings) GetValidationContext() *ValidationContext {
	if x != nil {
		return x.ValidationContext
	}
	return nil
}

// A resource for backend TLS settings.
type BackendTls struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Server Name Indication (SNI) string for TLS connections.
	Sni string `protobuf:"bytes,1,opt,name=sni,proto3" json:"sni,omitempty"`
	// Validation context for TLS connections.
	ValidationContext *ValidationContext `protobuf:"bytes,3,opt,name=validation_context,json=validationContext,proto3" json:"validation_context,omitempty"`
}

func (x *BackendTls) Reset() {
	*x = BackendTls{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackendTls) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackendTls) ProtoMessage() {}

func (x *BackendTls) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackendTls.ProtoReflect.Descriptor instead.
func (*BackendTls) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP(), []int{14}
}

func (x *BackendTls) GetSni() string {
	if x != nil {
		return x.Sni
	}
	return ""
}

func (x *BackendTls) GetValidationContext() *ValidationContext {
	if x != nil {
		return x.ValidationContext
	}
	return nil
}

// A resource for Object Storage bucket used as a backend. For details about the concept,
// see [documentation](/docs/storage/concepts/bucket).
type StorageBucketBackend struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
}

func (x *StorageBucketBackend) Reset() {
	*x = StorageBucketBackend{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StorageBucketBackend) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StorageBucketBackend) ProtoMessage() {}

func (x *StorageBucketBackend) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StorageBucketBackend.ProtoReflect.Descriptor instead.
func (*StorageBucketBackend) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP(), []int{15}
}

func (x *StorageBucketBackend) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

// A health check resource.
// For details about the concept, see [documentation](/docs/application-load-balancer/concepts/backend-group#health-checks).
type HealthCheck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Health check timeout.
	//
	// The timeout is the time allowed for the target to respond to a check.
	// If the target doesn't respond in time, the check is considered failed.
	Timeout *durationpb.Duration `protobuf:"bytes,1,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// Base interval between consecutive health checks.
	Interval              *durationpb.Duration `protobuf:"bytes,2,opt,name=interval,proto3" json:"interval,omitempty"`
	IntervalJitterPercent float64              `protobuf:"fixed64,3,opt,name=interval_jitter_percent,json=intervalJitterPercent,proto3" json:"interval_jitter_percent,omitempty"`
	// Number of consecutive successful health checks required to mark an unhealthy target as healthy.
	//
	// Both `0` and `1` values amount to one successful check required.
	//
	// The value is ignored when a load balancer is initialized; a target is marked healthy after one successful check.
	//
	// Default value: `0`.
	HealthyThreshold int64 `protobuf:"varint,4,opt,name=healthy_threshold,json=healthyThreshold,proto3" json:"healthy_threshold,omitempty"`
	// Number of consecutive failed health checks required to mark a healthy target as unhealthy.
	//
	// Both `0` and `1` values amount to one unsuccessful check required.
	//
	// The value is ignored if a health check is failed due to an HTTP `503 Service Unavailable` response from the target
	// (not applicable to TCP stream health checks). The target is immediately marked unhealthy.
	//
	// Default value: `0`.
	UnhealthyThreshold int64 `protobuf:"varint,5,opt,name=unhealthy_threshold,json=unhealthyThreshold,proto3" json:"unhealthy_threshold,omitempty"`
	// Port used for health checks.
	//
	// If not specified, the backend port ([HttpBackend.port] or [GrpcBackend.port]) is used for health checks.
	HealthcheckPort int64 `protobuf:"varint,6,opt,name=healthcheck_port,json=healthcheckPort,proto3" json:"healthcheck_port,omitempty"`
	// Protocol-specific health check settings.
	//
	// The protocols of the backend and of its health check may differ,
	// e.g. a gRPC health check may be specified for an HTTP backend.
	//
	// Types that are assignable to Healthcheck:
	//
	//	*HealthCheck_Stream
	//	*HealthCheck_Http
	//	*HealthCheck_Grpc
	Healthcheck isHealthCheck_Healthcheck `protobuf_oneof:"healthcheck"`
	// Optional transport protocol for health checks.
	// When not set, health checks use the same protocol as the proxied traffic.
	// Use this when health checks' protocol settings differ from their backend, e.g. plaintext health checks for a TLS backend.
	//
	// Types that are assignable to TransportSettings:
	//
	//	*HealthCheck_Plaintext
	//	*HealthCheck_Tls
	TransportSettings isHealthCheck_TransportSettings `protobuf_oneof:"transport_settings"`
}

func (x *HealthCheck) Reset() {
	*x = HealthCheck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HealthCheck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthCheck) ProtoMessage() {}

func (x *HealthCheck) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthCheck.ProtoReflect.Descriptor instead.
func (*HealthCheck) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP(), []int{16}
}

func (x *HealthCheck) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *HealthCheck) GetInterval() *durationpb.Duration {
	if x != nil {
		return x.Interval
	}
	return nil
}

func (x *HealthCheck) GetIntervalJitterPercent() float64 {
	if x != nil {
		return x.IntervalJitterPercent
	}
	return 0
}

func (x *HealthCheck) GetHealthyThreshold() int64 {
	if x != nil {
		return x.HealthyThreshold
	}
	return 0
}

func (x *HealthCheck) GetUnhealthyThreshold() int64 {
	if x != nil {
		return x.UnhealthyThreshold
	}
	return 0
}

func (x *HealthCheck) GetHealthcheckPort() int64 {
	if x != nil {
		return x.HealthcheckPort
	}
	return 0
}

func (m *HealthCheck) GetHealthcheck() isHealthCheck_Healthcheck {
	if m != nil {
		return m.Healthcheck
	}
	return nil
}

func (x *HealthCheck) GetStream() *HealthCheck_StreamHealthCheck {
	if x, ok := x.GetHealthcheck().(*HealthCheck_Stream); ok {
		return x.Stream
	}
	return nil
}

func (x *HealthCheck) GetHttp() *HealthCheck_HttpHealthCheck {
	if x, ok := x.GetHealthcheck().(*HealthCheck_Http); ok {
		return x.Http
	}
	return nil
}

func (x *HealthCheck) GetGrpc() *HealthCheck_GrpcHealthCheck {
	if x, ok := x.GetHealthcheck().(*HealthCheck_Grpc); ok {
		return x.Grpc
	}
	return nil
}

func (m *HealthCheck) GetTransportSettings() isHealthCheck_TransportSettings {
	if m != nil {
		return m.TransportSettings
	}
	return nil
}

func (x *HealthCheck) GetPlaintext() *PlaintextTransportSettings {
	if x, ok := x.GetTransportSettings().(*HealthCheck_Plaintext); ok {
		return x.Plaintext
	}
	return nil
}

func (x *HealthCheck) GetTls() *SecureTransportSettings {
	if x, ok := x.GetTransportSettings().(*HealthCheck_Tls); ok {
		return x.Tls
	}
	return nil
}

type isHealthCheck_Healthcheck interface {
	isHealthCheck_Healthcheck()
}

type HealthCheck_Stream struct {
	// TCP stream health check settings.
	Stream *HealthCheck_StreamHealthCheck `protobuf:"bytes,7,opt,name=stream,proto3,oneof"`
}

type HealthCheck_Http struct {
	// HTTP health check settings.
	Http *HealthCheck_HttpHealthCheck `protobuf:"bytes,8,opt,name=http,proto3,oneof"`
}

type HealthCheck_Grpc struct {
	// gRPC health check settings.
	Grpc *HealthCheck_GrpcHealthCheck `protobuf:"bytes,9,opt,name=grpc,proto3,oneof"`
}

func (*HealthCheck_Stream) isHealthCheck_Healthcheck() {}

func (*HealthCheck_Http) isHealthCheck_Healthcheck() {}

func (*HealthCheck_Grpc) isHealthCheck_Healthcheck() {}

type isHealthCheck_TransportSettings interface {
	isHealthCheck_TransportSettings()
}

type HealthCheck_Plaintext struct {
	Plaintext *PlaintextTransportSettings `protobuf:"bytes,10,opt,name=plaintext,proto3,oneof"`
}

type HealthCheck_Tls struct {
	Tls *SecureTransportSettings `protobuf:"bytes,11,opt,name=tls,proto3,oneof"`
}

func (*HealthCheck_Plaintext) isHealthCheck_TransportSettings() {}

func (*HealthCheck_Tls) isHealthCheck_TransportSettings() {}

// A resource for TCP stream health check settings.
type HealthCheck_StreamHealthCheck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Message sent to targets during TCP data transfer.
	//
	// If not specified, no data is sent to the target.
	Send *Payload `protobuf:"bytes,1,opt,name=send,proto3" json:"send,omitempty"`
	// Data that must be contained in the messages received from targets for a successful health check.
	//
	// If not specified, no messages are expected from targets, and those that are received are not checked.
	Receive *Payload `protobuf:"bytes,2,opt,name=receive,proto3" json:"receive,omitempty"`
}

func (x *HealthCheck_StreamHealthCheck) Reset() {
	*x = HealthCheck_StreamHealthCheck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HealthCheck_StreamHealthCheck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthCheck_StreamHealthCheck) ProtoMessage() {}

func (x *HealthCheck_StreamHealthCheck) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthCheck_StreamHealthCheck.ProtoReflect.Descriptor instead.
func (*HealthCheck_StreamHealthCheck) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP(), []int{16, 0}
}

func (x *HealthCheck_StreamHealthCheck) GetSend() *Payload {
	if x != nil {
		return x.Send
	}
	return nil
}

func (x *HealthCheck_StreamHealthCheck) GetReceive() *Payload {
	if x != nil {
		return x.Receive
	}
	return nil
}

// A resource for HTTP health check settings.
type HealthCheck_HttpHealthCheck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value for the HTTP/1.1 `Host` header or the HTTP/2 `:authority` pseudo-header used in requests to targets.
	Host string `protobuf:"bytes,1,opt,name=host,proto3" json:"host,omitempty"`
	// HTTP path used in requests to targets: request URI for HTTP/1.1 request line
	// or value for the HTTP/2 `:path` pseudo-header.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// Enables HTTP/2 usage in health checks.
	//
	// Default value: `false`, HTTP/1.1 is used.
	UseHttp2 bool `protobuf:"varint,3,opt,name=use_http2,json=useHttp2,proto3" json:"use_http2,omitempty"`
	// A list of HTTP response statuses considered healthy.
	// By default only 200 HTTP status code considered healthy.
	ExpectedStatuses []int64 `protobuf:"varint,4,rep,packed,name=expected_statuses,json=expectedStatuses,proto3" json:"expected_statuses,omitempty"`
}

func (x *HealthCheck_HttpHealthCheck) Reset() {
	*x = HealthCheck_HttpHealthCheck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HealthCheck_HttpHealthCheck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthCheck_HttpHealthCheck) ProtoMessage() {}

func (x *HealthCheck_HttpHealthCheck) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthCheck_HttpHealthCheck.ProtoReflect.Descriptor instead.
func (*HealthCheck_HttpHealthCheck) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP(), []int{16, 1}
}

func (x *HealthCheck_HttpHealthCheck) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *HealthCheck_HttpHealthCheck) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *HealthCheck_HttpHealthCheck) GetUseHttp2() bool {
	if x != nil {
		return x.UseHttp2
	}
	return false
}

func (x *HealthCheck_HttpHealthCheck) GetExpectedStatuses() []int64 {
	if x != nil {
		return x.ExpectedStatuses
	}
	return nil
}

// A resource for gRPC health check settings.
type HealthCheck_GrpcHealthCheck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the gRPC service to be checked.
	//
	// If not specified, overall health is checked.
	//
	// For details about the concept, see [GRPC Health Checking Protocol](https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
}

func (x *HealthCheck_GrpcHealthCheck) Reset() {
	*x = HealthCheck_GrpcHealthCheck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HealthCheck_GrpcHealthCheck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthCheck_GrpcHealthCheck) ProtoMessage() {}

func (x *HealthCheck_GrpcHealthCheck) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthCheck_GrpcHealthCheck.ProtoReflect.Descriptor instead.
func (*HealthCheck_GrpcHealthCheck) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP(), []int{16, 2}
}

func (x *HealthCheck_GrpcHealthCheck) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

var File_yandex_cloud_apploadbalancer_v1_backend_group_proto protoreflect.FileDescriptor

var file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDesc = []byte{
	0x0a, 0x33, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2f, 0x76,
	0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e,
	0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c,
	0x61, 0x6e, 0x63, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x6c, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1d, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xac, 0x04, 0x0a, 0x0c, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x51, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e,
	0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x47, 0x0a, 0x04, 0x68, 0x74, 0x74, 0x70, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x42, 0x61, 0x63, 0x6b,
	0x65, 0x6e, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x48, 0x00, 0x52, 0x04, 0x68, 0x74, 0x74, 0x70,
	0x12, 0x47, 0x0a, 0x04, 0x67, 0x72, 0x70, 0x63, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x72, 0x70, 0x63, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x48, 0x00, 0x52, 0x04, 0x67, 0x72, 0x70, 0x63, 0x12, 0x4d, 0x0a, 0x06, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x48, 0x00,
	0x52, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x39, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x41, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x09,
	0x0a, 0x07, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x4a, 0x04, 0x08, 0x08, 0x10, 0x09, 0x22,
	0xd2, 0x01, 0x0a, 0x12, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e,
	0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x4a, 0x0a, 0x08, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e,
	0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62,
	0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x52, 0x08, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e,
	0x64, 0x73, 0x12, 0x5c, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c,
	0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x79, 0x48, 0x00, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x12, 0x0a, 0x10, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x66, 0x66, 0x69,
	0x6e, 0x69, 0x74, 0x79, 0x22, 0xf2, 0x02, 0x0a, 0x10, 0x48, 0x74, 0x74, 0x70, 0x42, 0x61, 0x63,
	0x6b, 0x65, 0x6e, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x48, 0x0a, 0x08, 0x62, 0x61, 0x63,
	0x6b, 0x65, 0x6e, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f,
	0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74,
	0x74, 0x70, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x52, 0x08, 0x62, 0x61, 0x63, 0x6b, 0x65,
	0x6e, 0x64, 0x73, 0x12, 0x5c, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e,
	0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x50, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x06, 0x68, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x12, 0x50, 0x0a, 0x06, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x06, 0x63,
	0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x42, 0x12, 0x0a, 0x10, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x61, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x22, 0xf2, 0x02, 0x0a, 0x10, 0x47, 0x72,
	0x70, 0x63, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x48,
	0x0a, 0x08, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x72, 0x70, 0x63, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x52, 0x08,
	0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x73, 0x12, 0x5c, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c,
	0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x48, 0x00,
	0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x50, 0x0a, 0x06, 0x63, 0x6f, 0x6f, 0x6b,
	0x69, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62,
	0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6f, 0x6b, 0x69,
	0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79,
	0x48, 0x00, 0x52, 0x06, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x42, 0x12, 0x0a, 0x10, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x22, 0x43,
	0x0a, 0x15, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x41,
	0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x12, 0x2a, 0x0a, 0x0b, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x09, 0x8a, 0xc8,
	0x31, 0x05, 0x31, 0x2d, 0x32, 0x35, 0x36, 0x52, 0x0a, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4e,
	0x61, 0x6d, 0x65, 0x22, 0x63, 0x0a, 0x15, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x12, 0x1d, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x09, 0x8a, 0xc8, 0x31, 0x05,
	0x31, 0x2d, 0x32, 0x35, 0x36, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x03, 0x74,
	0x74, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x22, 0x38, 0x0a, 0x19, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x66, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x69, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x49, 0x70, 0x22, 0x8a, 0x02, 0x0a, 0x13, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e,
	0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x32, 0x0a, 0x0f, 0x70, 0x61,
	0x6e, 0x69, 0x63, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x42, 0x09, 0xfa, 0xc7, 0x31, 0x05, 0x30, 0x2d, 0x31, 0x30, 0x30, 0x52, 0x0e,
	0x70, 0x61, 0x6e, 0x69, 0x63, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x4e,
	0x0a, 0x1e, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x61, 0x77, 0x61, 0x72, 0x65,
	0x5f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x09, 0xfa, 0xc7, 0x31, 0x05, 0x30, 0x2d, 0x31, 0x30,
	0x30, 0x52, 0x1b, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x41, 0x77, 0x61, 0x72, 0x65,
	0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x27,
	0x0a, 0x0f, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x4c,
	0x6f, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x46, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x22,
	0xa1, 0x05, 0x0a, 0x0d, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e,
	0x64, 0x12, 0x34, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x20, 0xf2, 0xc7, 0x31, 0x1c, 0x5b, 0x61, 0x2d, 0x7a, 0x5d, 0x5b, 0x2d, 0x61, 0x2d, 0x7a, 0x30,
	0x2d, 0x39, 0x5d, 0x7b, 0x31, 0x2c, 0x36, 0x31, 0x7d, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39,
	0x5d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x65,
	0x6e, 0x64, 0x5f, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x62, 0x61,
	0x63, 0x6b, 0x65, 0x6e, 0x64, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x68, 0x0a, 0x15, 0x6c,
	0x6f, 0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61,
	0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x61,
	0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x13, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1f, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x03, 0x42, 0x0b, 0xfa, 0xc7, 0x31, 0x07, 0x30, 0x2d, 0x36, 0x35, 0x35, 0x33, 0x35,
	0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x5b, 0x0a, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x42, 0x61, 0x63, 0x6b,
	0x65, 0x6e, 0x64, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x12, 0x50, 0x0a, 0x0c, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x68, 0x65,
	0x63, 0x6b, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x0c, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63,
	0x68, 0x65, 0x63, 0x6b, 0x73, 0x12, 0x3d, 0x0a, 0x03, 0x74, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x54, 0x6c, 0x73, 0x52,
	0x03, 0x74, 0x6c, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70,
	0x72, 0x6f, 0x78, 0x79, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x13, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x53, 0x0a, 0x27, 0x6b, 0x65, 0x65, 0x70,
	0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x6f, 0x6e, 0x5f,
	0x68, 0x6f, 0x73, 0x74, 0x5f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x66, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x22, 0x6b, 0x65, 0x65, 0x70, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4f, 0x6e, 0x48, 0x6f, 0x73, 0x74,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x42, 0x14, 0x0a,
	0x0c, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x12, 0x04, 0xc0,
	0xc1, 0x31, 0x01, 0x22, 0x97, 0x05, 0x0a, 0x0b, 0x48, 0x74, 0x74, 0x70, 0x42, 0x61, 0x63, 0x6b,
	0x65, 0x6e, 0x64, 0x12, 0x38, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x24, 0xe8, 0xc7, 0x31, 0x01, 0xf2, 0xc7, 0x31, 0x1c, 0x5b, 0x61, 0x2d, 0x7a, 0x5d,
	0x5b, 0x2d, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x7b, 0x31, 0x2c, 0x36, 0x31, 0x7d, 0x5b,
	0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39, 0x5d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x42, 0x0a,
	0x0e, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0d, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x57, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x12, 0x68, 0x0a, 0x15, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x13, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1f, 0x0a, 0x04, 0x70,
	0x6f, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x42, 0x0b, 0xfa, 0xc7, 0x31, 0x07, 0x30,
	0x2d, 0x36, 0x35, 0x35, 0x33, 0x35, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x5b, 0x0a, 0x0d,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x5e, 0x0a, 0x0e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x50, 0x0a, 0x0c, 0x68, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x0c, 0x68,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x12, 0x3d, 0x0a, 0x03, 0x74,
	0x6c, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65,
	0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62,
	0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x65,
	0x6e, 0x64, 0x54, 0x6c, 0x73, 0x52, 0x03, 0x74, 0x6c, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x75, 0x73,
	0x65, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x32, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x75,
	0x73, 0x65, 0x48, 0x74, 0x74, 0x70, 0x32, 0x42, 0x14, 0x0a, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x12, 0x04, 0xc0, 0xc1, 0x31, 0x01, 0x22, 0xa0, 0x04,
	0x0a, 0x0b, 0x47, 0x72, 0x70, 0x63, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x12, 0x38, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe8, 0xc7, 0x31,
	0x01, 0xf2, 0xc7, 0x31, 0x1c, 0x5b, 0x61, 0x2d, 0x7a, 0x5d, 0x5b, 0x2d, 0x61, 0x2d, 0x7a, 0x30,
	0x2d, 0x39, 0x5d, 0x7b, 0x31, 0x2c, 0x36, 0x31, 0x7d, 0x5b, 0x61, 0x2d, 0x7a, 0x30, 0x2d, 0x39,
	0x5d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x65,
	0x6e, 0x64, 0x5f, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x62, 0x61,
	0x63, 0x6b, 0x65, 0x6e, 0x64, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x68, 0x0a, 0x15, 0x6c,
	0x6f, 0x61, 0x64, 0x5f, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61,
	0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x61,
	0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x13, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1f, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x03, 0x42, 0x0b, 0xfa, 0xc7, 0x31, 0x07, 0x30, 0x2d, 0x36, 0x35, 0x35, 0x33, 0x35,
	0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x5b, 0x0a, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x42, 0x61, 0x63, 0x6b,
	0x65, 0x6e, 0x64, 0x48, 0x00, 0x52, 0x0c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x12, 0x50, 0x0a, 0x0c, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x68, 0x65,
	0x63, 0x6b, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x0c, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63,
	0x68, 0x65, 0x63, 0x6b, 0x73, 0x12, 0x3d, 0x0a, 0x03, 0x74, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x54, 0x6c, 0x73, 0x52,
	0x03, 0x74, 0x6c, 0x73, 0x42, 0x14, 0x0a, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x04, 0xc0, 0xc1, 0x31, 0x01, 0x4a, 0x04, 0x08, 0x06, 0x10, 0x07,
	0x22, 0x47, 0x0a, 0x13, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x12, 0x30, 0x0a, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x06, 0x82, 0xc8, 0x31, 0x02, 0x3e, 0x30, 0x52, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x73, 0x22, 0x1c, 0x0a, 0x1a, 0x50, 0x6c, 0x61,
	0x69, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x94, 0x01, 0x0a, 0x17, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x6e, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x73, 0x6e, 0x69, 0x12, 0x61, 0x0a, 0x12, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x11, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4a, 0x04, 0x08, 0x02, 0x10, 0x03, 0x22, 0x87,
	0x01, 0x0a, 0x0a, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x54, 0x6c, 0x73, 0x12, 0x10, 0x0a,
	0x03, 0x73, 0x6e, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x73, 0x6e, 0x69, 0x12,
	0x61, 0x0a, 0x12, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f,
	0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52,
	0x11, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x4a, 0x04, 0x08, 0x02, 0x10, 0x03, 0x22, 0x34, 0x0a, 0x14, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64,
	0x12, 0x1c, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x22, 0x96,
	0x09, 0x0a, 0x0b, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x39,
	0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01,
	0x52, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x3b, 0x0a, 0x08, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52, 0x08, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x36, 0x0a, 0x17, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76,
	0x61, 0x6c, 0x5f, 0x6a, 0x69, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x15, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61,
	0x6c, 0x4a, 0x69, 0x74, 0x74, 0x65, 0x72, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x2b,
	0x0a, 0x11, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x68, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x79, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x2f, 0x0a, 0x13, 0x75,
	0x6e, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f,
	0x6c, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x75, 0x6e, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x79, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x36, 0x0a, 0x10,
	0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x70, 0x6f, 0x72, 0x74,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x42, 0x0b, 0xfa, 0xc7, 0x31, 0x07, 0x30, 0x2d, 0x36, 0x35,
	0x35, 0x33, 0x35, 0x52, 0x0f, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x68, 0x65, 0x63, 0x6b,
	0x50, 0x6f, 0x72, 0x74, 0x12, 0x58, 0x0a, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e,
	0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x48, 0x00, 0x52, 0x06, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x52,
	0x0a, 0x04, 0x68, 0x74, 0x74, 0x70, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c,
	0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x48, 0x00, 0x52, 0x04, 0x68, 0x74,
	0x74, 0x70, 0x12, 0x52, 0x0a, 0x04, 0x67, 0x72, 0x70, 0x63, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3c, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x2e, 0x47,
	0x72, 0x70, 0x63, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x48, 0x00,
	0x52, 0x04, 0x67, 0x72, 0x70, 0x63, 0x12, 0x5b, 0x0a, 0x09, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64,
	0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x69,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x48, 0x01, 0x52, 0x09, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x12, 0x4c, 0x0a, 0x03, 0x74, 0x6c, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f,
	0x72, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x48, 0x01, 0x52, 0x03, 0x74, 0x6c,
	0x73, 0x1a, 0x95, 0x01, 0x0a, 0x11, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x3c, 0x0a, 0x04, 0x73, 0x65, 0x6e, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52,
	0x04, 0x73, 0x65, 0x6e, 0x64, 0x12, 0x42, 0x0a, 0x07, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c,
	0x61, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x52, 0x07, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x1a, 0x9a, 0x01, 0x0a, 0x0f, 0x48, 0x74,
	0x74, 0x70, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x12, 0x0a,
	0x04, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x68, 0x6f, 0x73,
	0x74, 0x12, 0x18, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x04, 0xe8, 0xc7, 0x31, 0x01, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x1b, 0x0a, 0x09, 0x75,
	0x73, 0x65, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x32, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08,
	0x75, 0x73, 0x65, 0x48, 0x74, 0x74, 0x70, 0x32, 0x12, 0x3c, 0x0a, 0x11, 0x65, 0x78, 0x70, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x03, 0x42, 0x0f, 0xfa, 0xc7, 0x31, 0x07, 0x31, 0x30, 0x30, 0x2d, 0x35, 0x39, 0x39,
	0x90, 0xc8, 0x31, 0x01, 0x52, 0x10, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x1a, 0x34, 0x0a, 0x0f, 0x47, 0x72, 0x70, 0x63, 0x48, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x42, 0x13, 0x0a, 0x0b,
	0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x04, 0xc0, 0xc1, 0x31,
	0x01, 0x42, 0x14, 0x0a, 0x12, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2a, 0x54, 0x0a, 0x11, 0x4c, 0x6f, 0x61, 0x64, 0x42,
	0x61, 0x6c, 0x61, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x0f, 0x0a, 0x0b,
	0x52, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x52, 0x4f, 0x42, 0x49, 0x4e, 0x10, 0x00, 0x12, 0x0a, 0x0a,
	0x06, 0x52, 0x41, 0x4e, 0x44, 0x4f, 0x4d, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x4c, 0x45, 0x41,
	0x53, 0x54, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b,
	0x4d, 0x41, 0x47, 0x4c, 0x45, 0x56, 0x5f, 0x48, 0x41, 0x53, 0x48, 0x10, 0x03, 0x42, 0x7a, 0x0a,
	0x23, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x5a, 0x53, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6f,
	0x2d, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x62, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x3b, 0x61, 0x70, 0x70, 0x6c, 0x6f, 0x61,
	0x64, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescOnce sync.Once
	file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescData = file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDesc
)

func file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescGZIP() []byte {
	file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescData = protoimpl.X.CompressGZIP(file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescData)
	})
	return file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDescData
}

var file_yandex_cloud_apploadbalancer_v1_backend_group_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes = make([]protoimpl.MessageInfo, 21)
var file_yandex_cloud_apploadbalancer_v1_backend_group_proto_goTypes = []any{
	(LoadBalancingMode)(0),                // 0: yandex.cloud.apploadbalancer.v1.LoadBalancingMode
	(*BackendGroup)(nil),                  // 1: yandex.cloud.apploadbalancer.v1.BackendGroup
	(*StreamBackendGroup)(nil),            // 2: yandex.cloud.apploadbalancer.v1.StreamBackendGroup
	(*HttpBackendGroup)(nil),              // 3: yandex.cloud.apploadbalancer.v1.HttpBackendGroup
	(*GrpcBackendGroup)(nil),              // 4: yandex.cloud.apploadbalancer.v1.GrpcBackendGroup
	(*HeaderSessionAffinity)(nil),         // 5: yandex.cloud.apploadbalancer.v1.HeaderSessionAffinity
	(*CookieSessionAffinity)(nil),         // 6: yandex.cloud.apploadbalancer.v1.CookieSessionAffinity
	(*ConnectionSessionAffinity)(nil),     // 7: yandex.cloud.apploadbalancer.v1.ConnectionSessionAffinity
	(*LoadBalancingConfig)(nil),           // 8: yandex.cloud.apploadbalancer.v1.LoadBalancingConfig
	(*StreamBackend)(nil),                 // 9: yandex.cloud.apploadbalancer.v1.StreamBackend
	(*HttpBackend)(nil),                   // 10: yandex.cloud.apploadbalancer.v1.HttpBackend
	(*GrpcBackend)(nil),                   // 11: yandex.cloud.apploadbalancer.v1.GrpcBackend
	(*TargetGroupsBackend)(nil),           // 12: yandex.cloud.apploadbalancer.v1.TargetGroupsBackend
	(*PlaintextTransportSettings)(nil),    // 13: yandex.cloud.apploadbalancer.v1.PlaintextTransportSettings
	(*SecureTransportSettings)(nil),       // 14: yandex.cloud.apploadbalancer.v1.SecureTransportSettings
	(*BackendTls)(nil),                    // 15: yandex.cloud.apploadbalancer.v1.BackendTls
	(*StorageBucketBackend)(nil),          // 16: yandex.cloud.apploadbalancer.v1.StorageBucketBackend
	(*HealthCheck)(nil),                   // 17: yandex.cloud.apploadbalancer.v1.HealthCheck
	nil,                                   // 18: yandex.cloud.apploadbalancer.v1.BackendGroup.LabelsEntry
	(*HealthCheck_StreamHealthCheck)(nil), // 19: yandex.cloud.apploadbalancer.v1.HealthCheck.StreamHealthCheck
	(*HealthCheck_HttpHealthCheck)(nil),   // 20: yandex.cloud.apploadbalancer.v1.HealthCheck.HttpHealthCheck
	(*HealthCheck_GrpcHealthCheck)(nil),   // 21: yandex.cloud.apploadbalancer.v1.HealthCheck.GrpcHealthCheck
	(*timestamppb.Timestamp)(nil),         // 22: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),           // 23: google.protobuf.Duration
	(*wrapperspb.Int64Value)(nil),         // 24: google.protobuf.Int64Value
	(*ValidationContext)(nil),             // 25: yandex.cloud.apploadbalancer.v1.ValidationContext
	(*Payload)(nil),                       // 26: yandex.cloud.apploadbalancer.v1.Payload
}
var file_yandex_cloud_apploadbalancer_v1_backend_group_proto_depIdxs = []int32{
	18, // 0: yandex.cloud.apploadbalancer.v1.BackendGroup.labels:type_name -> yandex.cloud.apploadbalancer.v1.BackendGroup.LabelsEntry
	3,  // 1: yandex.cloud.apploadbalancer.v1.BackendGroup.http:type_name -> yandex.cloud.apploadbalancer.v1.HttpBackendGroup
	4,  // 2: yandex.cloud.apploadbalancer.v1.BackendGroup.grpc:type_name -> yandex.cloud.apploadbalancer.v1.GrpcBackendGroup
	2,  // 3: yandex.cloud.apploadbalancer.v1.BackendGroup.stream:type_name -> yandex.cloud.apploadbalancer.v1.StreamBackendGroup
	22, // 4: yandex.cloud.apploadbalancer.v1.BackendGroup.created_at:type_name -> google.protobuf.Timestamp
	9,  // 5: yandex.cloud.apploadbalancer.v1.StreamBackendGroup.backends:type_name -> yandex.cloud.apploadbalancer.v1.StreamBackend
	7,  // 6: yandex.cloud.apploadbalancer.v1.StreamBackendGroup.connection:type_name -> yandex.cloud.apploadbalancer.v1.ConnectionSessionAffinity
	10, // 7: yandex.cloud.apploadbalancer.v1.HttpBackendGroup.backends:type_name -> yandex.cloud.apploadbalancer.v1.HttpBackend
	7,  // 8: yandex.cloud.apploadbalancer.v1.HttpBackendGroup.connection:type_name -> yandex.cloud.apploadbalancer.v1.ConnectionSessionAffinity
	5,  // 9: yandex.cloud.apploadbalancer.v1.HttpBackendGroup.header:type_name -> yandex.cloud.apploadbalancer.v1.HeaderSessionAffinity
	6,  // 10: yandex.cloud.apploadbalancer.v1.HttpBackendGroup.cookie:type_name -> yandex.cloud.apploadbalancer.v1.CookieSessionAffinity
	11, // 11: yandex.cloud.apploadbalancer.v1.GrpcBackendGroup.backends:type_name -> yandex.cloud.apploadbalancer.v1.GrpcBackend
	7,  // 12: yandex.cloud.apploadbalancer.v1.GrpcBackendGroup.connection:type_name -> yandex.cloud.apploadbalancer.v1.ConnectionSessionAffinity
	5,  // 13: yandex.cloud.apploadbalancer.v1.GrpcBackendGroup.header:type_name -> yandex.cloud.apploadbalancer.v1.HeaderSessionAffinity
	6,  // 14: yandex.cloud.apploadbalancer.v1.GrpcBackendGroup.cookie:type_name -> yandex.cloud.apploadbalancer.v1.CookieSessionAffinity
	23, // 15: yandex.cloud.apploadbalancer.v1.CookieSessionAffinity.ttl:type_name -> google.protobuf.Duration
	0,  // 16: yandex.cloud.apploadbalancer.v1.LoadBalancingConfig.mode:type_name -> yandex.cloud.apploadbalancer.v1.LoadBalancingMode
	24, // 17: yandex.cloud.apploadbalancer.v1.StreamBackend.backend_weight:type_name -> google.protobuf.Int64Value
	8,  // 18: yandex.cloud.apploadbalancer.v1.StreamBackend.load_balancing_config:type_name -> yandex.cloud.apploadbalancer.v1.LoadBalancingConfig
	12, // 19: yandex.cloud.apploadbalancer.v1.StreamBackend.target_groups:type_name -> yandex.cloud.apploadbalancer.v1.TargetGroupsBackend
	17, // 20: yandex.cloud.apploadbalancer.v1.StreamBackend.healthchecks:type_name -> yandex.cloud.apploadbalancer.v1.HealthCheck
	15, // 21: yandex.cloud.apploadbalancer.v1.StreamBackend.tls:type_name -> yandex.cloud.apploadbalancer.v1.BackendTls
	24, // 22: yandex.cloud.apploadbalancer.v1.HttpBackend.backend_weight:type_name -> google.protobuf.Int64Value
	8,  // 23: yandex.cloud.apploadbalancer.v1.HttpBackend.load_balancing_config:type_name -> yandex.cloud.apploadbalancer.v1.LoadBalancingConfig
	12, // 24: yandex.cloud.apploadbalancer.v1.HttpBackend.target_groups:type_name -> yandex.cloud.apploadbalancer.v1.TargetGroupsBackend
	16, // 25: yandex.cloud.apploadbalancer.v1.HttpBackend.storage_bucket:type_name -> yandex.cloud.apploadbalancer.v1.StorageBucketBackend
	17, // 26: yandex.cloud.apploadbalancer.v1.HttpBackend.healthchecks:type_name -> yandex.cloud.apploadbalancer.v1.HealthCheck
	15, // 27: yandex.cloud.apploadbalancer.v1.HttpBackend.tls:type_name -> yandex.cloud.apploadbalancer.v1.BackendTls
	24, // 28: yandex.cloud.apploadbalancer.v1.GrpcBackend.backend_weight:type_name -> google.protobuf.Int64Value
	8,  // 29: yandex.cloud.apploadbalancer.v1.GrpcBackend.load_balancing_config:type_name -> yandex.cloud.apploadbalancer.v1.LoadBalancingConfig
	12, // 30: yandex.cloud.apploadbalancer.v1.GrpcBackend.target_groups:type_name -> yandex.cloud.apploadbalancer.v1.TargetGroupsBackend
	17, // 31: yandex.cloud.apploadbalancer.v1.GrpcBackend.healthchecks:type_name -> yandex.cloud.apploadbalancer.v1.HealthCheck
	15, // 32: yandex.cloud.apploadbalancer.v1.GrpcBackend.tls:type_name -> yandex.cloud.apploadbalancer.v1.BackendTls
	25, // 33: yandex.cloud.apploadbalancer.v1.SecureTransportSettings.validation_context:type_name -> yandex.cloud.apploadbalancer.v1.ValidationContext
	25, // 34: yandex.cloud.apploadbalancer.v1.BackendTls.validation_context:type_name -> yandex.cloud.apploadbalancer.v1.ValidationContext
	23, // 35: yandex.cloud.apploadbalancer.v1.HealthCheck.timeout:type_name -> google.protobuf.Duration
	23, // 36: yandex.cloud.apploadbalancer.v1.HealthCheck.interval:type_name -> google.protobuf.Duration
	19, // 37: yandex.cloud.apploadbalancer.v1.HealthCheck.stream:type_name -> yandex.cloud.apploadbalancer.v1.HealthCheck.StreamHealthCheck
	20, // 38: yandex.cloud.apploadbalancer.v1.HealthCheck.http:type_name -> yandex.cloud.apploadbalancer.v1.HealthCheck.HttpHealthCheck
	21, // 39: yandex.cloud.apploadbalancer.v1.HealthCheck.grpc:type_name -> yandex.cloud.apploadbalancer.v1.HealthCheck.GrpcHealthCheck
	13, // 40: yandex.cloud.apploadbalancer.v1.HealthCheck.plaintext:type_name -> yandex.cloud.apploadbalancer.v1.PlaintextTransportSettings
	14, // 41: yandex.cloud.apploadbalancer.v1.HealthCheck.tls:type_name -> yandex.cloud.apploadbalancer.v1.SecureTransportSettings
	26, // 42: yandex.cloud.apploadbalancer.v1.HealthCheck.StreamHealthCheck.send:type_name -> yandex.cloud.apploadbalancer.v1.Payload
	26, // 43: yandex.cloud.apploadbalancer.v1.HealthCheck.StreamHealthCheck.receive:type_name -> yandex.cloud.apploadbalancer.v1.Payload
	44, // [44:44] is the sub-list for method output_type
	44, // [44:44] is the sub-list for method input_type
	44, // [44:44] is the sub-list for extension type_name
	44, // [44:44] is the sub-list for extension extendee
	0,  // [0:44] is the sub-list for field type_name
}

func init() { file_yandex_cloud_apploadbalancer_v1_backend_group_proto_init() }
func file_yandex_cloud_apploadbalancer_v1_backend_group_proto_init() {
	if File_yandex_cloud_apploadbalancer_v1_backend_group_proto != nil {
		return
	}
	file_yandex_cloud_apploadbalancer_v1_payload_proto_init()
	file_yandex_cloud_apploadbalancer_v1_tls_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*BackendGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*StreamBackendGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*HttpBackendGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*GrpcBackendGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*HeaderSessionAffinity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*CookieSessionAffinity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*ConnectionSessionAffinity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*LoadBalancingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*StreamBackend); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*HttpBackend); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*GrpcBackend); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*TargetGroupsBackend); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*PlaintextTransportSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*SecureTransportSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*BackendTls); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*StorageBucketBackend); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*HealthCheck); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*HealthCheck_StreamHealthCheck); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[19].Exporter = func(v any, i int) any {
			switch v := v.(*HealthCheck_HttpHealthCheck); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[20].Exporter = func(v any, i int) any {
			switch v := v.(*HealthCheck_GrpcHealthCheck); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[0].OneofWrappers = []any{
		(*BackendGroup_Http)(nil),
		(*BackendGroup_Grpc)(nil),
		(*BackendGroup_Stream)(nil),
	}
	file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[1].OneofWrappers = []any{
		(*StreamBackendGroup_Connection)(nil),
	}
	file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[2].OneofWrappers = []any{
		(*HttpBackendGroup_Connection)(nil),
		(*HttpBackendGroup_Header)(nil),
		(*HttpBackendGroup_Cookie)(nil),
	}
	file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[3].OneofWrappers = []any{
		(*GrpcBackendGroup_Connection)(nil),
		(*GrpcBackendGroup_Header)(nil),
		(*GrpcBackendGroup_Cookie)(nil),
	}
	file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[8].OneofWrappers = []any{
		(*StreamBackend_TargetGroups)(nil),
	}
	file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[9].OneofWrappers = []any{
		(*HttpBackend_TargetGroups)(nil),
		(*HttpBackend_StorageBucket)(nil),
	}
	file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[10].OneofWrappers = []any{
		(*GrpcBackend_TargetGroups)(nil),
	}
	file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes[16].OneofWrappers = []any{
		(*HealthCheck_Stream)(nil),
		(*HealthCheck_Http)(nil),
		(*HealthCheck_Grpc)(nil),
		(*HealthCheck_Plaintext)(nil),
		(*HealthCheck_Tls)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   21,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_apploadbalancer_v1_backend_group_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_apploadbalancer_v1_backend_group_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_apploadbalancer_v1_backend_group_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_apploadbalancer_v1_backend_group_proto_msgTypes,
	}.Build()
	File_yandex_cloud_apploadbalancer_v1_backend_group_proto = out.File
	file_yandex_cloud_apploadbalancer_v1_backend_group_proto_rawDesc = nil
	file_yandex_cloud_apploadbalancer_v1_backend_group_proto_goTypes = nil
	file_yandex_cloud_apploadbalancer_v1_backend_group_proto_depIdxs = nil
}
