package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeIspFlushCacheTasks invokes the alidns.DescribeIspFlushCacheTasks API synchronously
func (client *Client) DescribeIspFlushCacheTasks(request *DescribeIspFlushCacheTasksRequest) (response *DescribeIspFlushCacheTasksResponse, err error) {
	response = CreateDescribeIspFlushCacheTasksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeIspFlushCacheTasksWithChan invokes the alidns.DescribeIspFlushCacheTasks API asynchronously
func (client *Client) DescribeIspFlushCacheTasksWithChan(request *DescribeIspFlushCacheTasksRequest) (<-chan *DescribeIspFlushCacheTasksResponse, <-chan error) {
	responseChan := make(chan *DescribeIspFlushCacheTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeIspFlushCacheTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeIspFlushCacheTasksWithCallback invokes the alidns.DescribeIspFlushCacheTasks API asynchronously
func (client *Client) DescribeIspFlushCacheTasksWithCallback(request *DescribeIspFlushCacheTasksRequest, callback func(response *DescribeIspFlushCacheTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeIspFlushCacheTasksResponse
		var err error
		defer close(result)
		response, err = client.DescribeIspFlushCacheTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeIspFlushCacheTasksRequest is the request struct for api DescribeIspFlushCacheTasks
type DescribeIspFlushCacheTasksRequest struct {
	*requests.RpcRequest
	Isp          string           `position:"Query" name:"Isp"`
	DomainName   string           `position:"Query" name:"DomainName"`
	OrderBy      string           `position:"Query" name:"OrderBy"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
	UserClientIp string           `position:"Query" name:"UserClientIp"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	Lang         string           `position:"Query" name:"Lang"`
	Direction    string           `position:"Query" name:"Direction"`
}

// DescribeIspFlushCacheTasksResponse is the response struct for api DescribeIspFlushCacheTasks
type DescribeIspFlushCacheTasksResponse struct {
	*responses.BaseResponse
	PageSize           int                 `json:"PageSize" xml:"PageSize"`
	RequestId          string              `json:"RequestId" xml:"RequestId"`
	PageNumber         int                 `json:"PageNumber" xml:"PageNumber"`
	TotalPages         int                 `json:"TotalPages" xml:"TotalPages"`
	TotalItems         int                 `json:"TotalItems" xml:"TotalItems"`
	IspFlushCacheTasks []IspFlushCacheTask `json:"IspFlushCacheTasks" xml:"IspFlushCacheTasks"`
}

// CreateDescribeIspFlushCacheTasksRequest creates a request to invoke DescribeIspFlushCacheTasks API
func CreateDescribeIspFlushCacheTasksRequest() (request *DescribeIspFlushCacheTasksRequest) {
	request = &DescribeIspFlushCacheTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeIspFlushCacheTasks", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeIspFlushCacheTasksResponse creates a response to parse from DescribeIspFlushCacheTasks response
func CreateDescribeIspFlushCacheTasksResponse() (response *DescribeIspFlushCacheTasksResponse) {
	response = &DescribeIspFlushCacheTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
