package cmd

import (
	"os"
	"time"

	"github.com/bpicode/fritzctl/man"
	"github.com/spf13/cobra"
)

var docManCmd = &cobra.Command{
	Use:     "man",
	Short:   "Man page for this application",
	Long:    "Generate the man page(s) for this application.",
	Example: "fritzctl doc man | man /dev/stdin",
	RunE:    docMan,
}

func init() {
	docCmd.AddCommand(docManCmd)
}

func docMan(_ *cobra.Command, _ []string) error {
	err := man.Generate(RootCmd, &man.Options{
		Origin: man.Origin{
			Source: "Auto-generated by bpicode/fritzctl",
			Date:   time.Now(),
		},
		Header: man.Header{
			Title:   "fritzctl",
			Section: "1",
			Manual:  "fritzctl man page",
		},
		SeeAlso: []string{"kfritz(1)", "curl(1)"},
	}, os.Stdout)
	return err
}
