// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package storagegateway provides a client for AWS Storage Gateway.
package storagegateway

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opActivateGateway = "ActivateGateway"

// ActivateGatewayRequest generates a "aws/request.Request" representing the
// client's request for the ActivateGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ActivateGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ActivateGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ActivateGatewayRequest method.
//    req, resp := client.ActivateGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ActivateGateway
func (c *StorageGateway) ActivateGatewayRequest(input *ActivateGatewayInput) (req *request.Request, output *ActivateGatewayOutput) {
	op := &request.Operation{
		Name:       opActivateGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ActivateGatewayInput{}
	}

	output = &ActivateGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ActivateGateway API operation for AWS Storage Gateway.
//
// Activates the gateway you previously deployed on your host. For more information,
// see  Activate the AWS Storage Gateway (http://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedActivateGateway-common.html).
// In the activation process, you specify information such as the you want to
// use for storing snapshots, the time zone for scheduled snapshots the gateway
// snapshot schedule window, an activation key, and a name for your gateway.
// The activation process also associates your gateway with your account; for
// more information, see UpdateGatewayInformation.
//
// You must turn on the gateway VM before you can activate your gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ActivateGateway for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ActivateGateway
func (c *StorageGateway) ActivateGateway(input *ActivateGatewayInput) (*ActivateGatewayOutput, error) {
	req, out := c.ActivateGatewayRequest(input)
	return out, req.Send()
}

// ActivateGatewayWithContext is the same as ActivateGateway with the addition of
// the ability to pass a context and additional request options.
//
// See ActivateGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ActivateGatewayWithContext(ctx aws.Context, input *ActivateGatewayInput, opts ...request.Option) (*ActivateGatewayOutput, error) {
	req, out := c.ActivateGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddCache = "AddCache"

// AddCacheRequest generates a "aws/request.Request" representing the
// client's request for the AddCache operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddCache for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddCache method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddCacheRequest method.
//    req, resp := client.AddCacheRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddCache
func (c *StorageGateway) AddCacheRequest(input *AddCacheInput) (req *request.Request, output *AddCacheOutput) {
	op := &request.Operation{
		Name:       opAddCache,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddCacheInput{}
	}

	output = &AddCacheOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddCache API operation for AWS Storage Gateway.
//
// Configures one or more gateway local disks as cache for a cached-volume gateway.
// This operation is supported only for the gateway-cached volume architecture
// (see Storage Gateway Concepts (http://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html)).
//
// In the request, you specify the gateway Amazon Resource Name (ARN) to which
// you want to add cache, and one or more disk IDs that you want to configure
// as cache.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation AddCache for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddCache
func (c *StorageGateway) AddCache(input *AddCacheInput) (*AddCacheOutput, error) {
	req, out := c.AddCacheRequest(input)
	return out, req.Send()
}

// AddCacheWithContext is the same as AddCache with the addition of
// the ability to pass a context and additional request options.
//
// See AddCache for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) AddCacheWithContext(ctx aws.Context, input *AddCacheInput, opts ...request.Option) (*AddCacheOutput, error) {
	req, out := c.AddCacheRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddTagsToResource = "AddTagsToResource"

// AddTagsToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddTagsToResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddTagsToResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddTagsToResourceRequest method.
//    req, resp := client.AddTagsToResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddTagsToResource
func (c *StorageGateway) AddTagsToResourceRequest(input *AddTagsToResourceInput) (req *request.Request, output *AddTagsToResourceOutput) {
	op := &request.Operation{
		Name:       opAddTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToResourceInput{}
	}

	output = &AddTagsToResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddTagsToResource API operation for AWS Storage Gateway.
//
// Adds one or more tags to the specified resource. You use tags to add metadata
// to resources, which you can use to categorize these resources. For example,
// you can categorize resources by purpose, owner, environment, or team. Each
// tag consists of a key and a value, which you define. You can add tags to
// the following AWS Storage Gateway resources:
//
//    * Storage gateways of all types
//
//    * Storage Volumes
//
//    * Virtual Tapes
//
// You can create a maximum of 10 tags for each resource. Virtual tapes and
// storage volumes that are recovered to a new gateway maintain their tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation AddTagsToResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddTagsToResource
func (c *StorageGateway) AddTagsToResource(input *AddTagsToResourceInput) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	return out, req.Send()
}

// AddTagsToResourceWithContext is the same as AddTagsToResource with the addition of
// the ability to pass a context and additional request options.
//
// See AddTagsToResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) AddTagsToResourceWithContext(ctx aws.Context, input *AddTagsToResourceInput, opts ...request.Option) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddUploadBuffer = "AddUploadBuffer"

// AddUploadBufferRequest generates a "aws/request.Request" representing the
// client's request for the AddUploadBuffer operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddUploadBuffer for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddUploadBuffer method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddUploadBufferRequest method.
//    req, resp := client.AddUploadBufferRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddUploadBuffer
func (c *StorageGateway) AddUploadBufferRequest(input *AddUploadBufferInput) (req *request.Request, output *AddUploadBufferOutput) {
	op := &request.Operation{
		Name:       opAddUploadBuffer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddUploadBufferInput{}
	}

	output = &AddUploadBufferOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddUploadBuffer API operation for AWS Storage Gateway.
//
// Configures one or more gateway local disks as upload buffer for a specified
// gateway. This operation is supported for both the gateway-stored and gateway-cached
// volume architectures.
//
// In the request, you specify the gateway Amazon Resource Name (ARN) to which
// you want to add upload buffer, and one or more disk IDs that you want to
// configure as upload buffer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation AddUploadBuffer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddUploadBuffer
func (c *StorageGateway) AddUploadBuffer(input *AddUploadBufferInput) (*AddUploadBufferOutput, error) {
	req, out := c.AddUploadBufferRequest(input)
	return out, req.Send()
}

// AddUploadBufferWithContext is the same as AddUploadBuffer with the addition of
// the ability to pass a context and additional request options.
//
// See AddUploadBuffer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) AddUploadBufferWithContext(ctx aws.Context, input *AddUploadBufferInput, opts ...request.Option) (*AddUploadBufferOutput, error) {
	req, out := c.AddUploadBufferRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddWorkingStorage = "AddWorkingStorage"

// AddWorkingStorageRequest generates a "aws/request.Request" representing the
// client's request for the AddWorkingStorage operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddWorkingStorage for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddWorkingStorage method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddWorkingStorageRequest method.
//    req, resp := client.AddWorkingStorageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddWorkingStorage
func (c *StorageGateway) AddWorkingStorageRequest(input *AddWorkingStorageInput) (req *request.Request, output *AddWorkingStorageOutput) {
	op := &request.Operation{
		Name:       opAddWorkingStorage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddWorkingStorageInput{}
	}

	output = &AddWorkingStorageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddWorkingStorage API operation for AWS Storage Gateway.
//
// Configures one or more gateway local disks as working storage for a gateway.
// This operation is supported only for the gateway-stored volume architecture.
// This operation is deprecated in cached-volumes API version 20120630. Use
// AddUploadBuffer instead.
//
// Working storage is also referred to as upload buffer. You can also use the
// AddUploadBuffer operation to add upload buffer to a stored-volume gateway.
//
// In the request, you specify the gateway Amazon Resource Name (ARN) to which
// you want to add working storage, and one or more disk IDs that you want to
// configure as working storage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation AddWorkingStorage for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddWorkingStorage
func (c *StorageGateway) AddWorkingStorage(input *AddWorkingStorageInput) (*AddWorkingStorageOutput, error) {
	req, out := c.AddWorkingStorageRequest(input)
	return out, req.Send()
}

// AddWorkingStorageWithContext is the same as AddWorkingStorage with the addition of
// the ability to pass a context and additional request options.
//
// See AddWorkingStorage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) AddWorkingStorageWithContext(ctx aws.Context, input *AddWorkingStorageInput, opts ...request.Option) (*AddWorkingStorageOutput, error) {
	req, out := c.AddWorkingStorageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelArchival = "CancelArchival"

// CancelArchivalRequest generates a "aws/request.Request" representing the
// client's request for the CancelArchival operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CancelArchival for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CancelArchival method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CancelArchivalRequest method.
//    req, resp := client.CancelArchivalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CancelArchival
func (c *StorageGateway) CancelArchivalRequest(input *CancelArchivalInput) (req *request.Request, output *CancelArchivalOutput) {
	op := &request.Operation{
		Name:       opCancelArchival,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelArchivalInput{}
	}

	output = &CancelArchivalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelArchival API operation for AWS Storage Gateway.
//
// Cancels archiving of a virtual tape to the virtual tape shelf (VTS) after
// the archiving process is initiated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CancelArchival for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CancelArchival
func (c *StorageGateway) CancelArchival(input *CancelArchivalInput) (*CancelArchivalOutput, error) {
	req, out := c.CancelArchivalRequest(input)
	return out, req.Send()
}

// CancelArchivalWithContext is the same as CancelArchival with the addition of
// the ability to pass a context and additional request options.
//
// See CancelArchival for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) CancelArchivalWithContext(ctx aws.Context, input *CancelArchivalInput, opts ...request.Option) (*CancelArchivalOutput, error) {
	req, out := c.CancelArchivalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelRetrieval = "CancelRetrieval"

// CancelRetrievalRequest generates a "aws/request.Request" representing the
// client's request for the CancelRetrieval operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CancelRetrieval for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CancelRetrieval method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CancelRetrievalRequest method.
//    req, resp := client.CancelRetrievalRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CancelRetrieval
func (c *StorageGateway) CancelRetrievalRequest(input *CancelRetrievalInput) (req *request.Request, output *CancelRetrievalOutput) {
	op := &request.Operation{
		Name:       opCancelRetrieval,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelRetrievalInput{}
	}

	output = &CancelRetrievalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelRetrieval API operation for AWS Storage Gateway.
//
// Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to
// a gateway after the retrieval process is initiated. The virtual tape is returned
// to the VTS.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CancelRetrieval for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CancelRetrieval
func (c *StorageGateway) CancelRetrieval(input *CancelRetrievalInput) (*CancelRetrievalOutput, error) {
	req, out := c.CancelRetrievalRequest(input)
	return out, req.Send()
}

// CancelRetrievalWithContext is the same as CancelRetrieval with the addition of
// the ability to pass a context and additional request options.
//
// See CancelRetrieval for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) CancelRetrievalWithContext(ctx aws.Context, input *CancelRetrievalInput, opts ...request.Option) (*CancelRetrievalOutput, error) {
	req, out := c.CancelRetrievalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCachediSCSIVolume = "CreateCachediSCSIVolume"

// CreateCachediSCSIVolumeRequest generates a "aws/request.Request" representing the
// client's request for the CreateCachediSCSIVolume operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateCachediSCSIVolume for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateCachediSCSIVolume method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateCachediSCSIVolumeRequest method.
//    req, resp := client.CreateCachediSCSIVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateCachediSCSIVolume
func (c *StorageGateway) CreateCachediSCSIVolumeRequest(input *CreateCachediSCSIVolumeInput) (req *request.Request, output *CreateCachediSCSIVolumeOutput) {
	op := &request.Operation{
		Name:       opCreateCachediSCSIVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCachediSCSIVolumeInput{}
	}

	output = &CreateCachediSCSIVolumeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCachediSCSIVolume API operation for AWS Storage Gateway.
//
// Creates a cached volume on a specified cached gateway. This operation is
// supported only for the gateway-cached volume architecture.
//
// Cache storage must be allocated to the gateway before you can create a cached
// volume. Use the AddCache operation to add cache storage to a gateway.
//
// In the request, you must specify the gateway, size of the volume in bytes,
// the iSCSI target name, an IP address on which to expose the target, and a
// unique client token. In response, AWS Storage Gateway creates the volume
// and returns information about it. This information includes the volume Amazon
// Resource Name (ARN), its size, and the iSCSI target ARN that initiators can
// use to connect to the volume target.
//
// Optionally, you can provide the ARN for an existing volume as the SourceVolumeARN
// for this cached volume, which creates an exact copy of the existing volume’s
// latest recovery point. The VolumeSizeInBytes value must be equal to or larger
// than the size of the copied volume, in bytes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateCachediSCSIVolume for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateCachediSCSIVolume
func (c *StorageGateway) CreateCachediSCSIVolume(input *CreateCachediSCSIVolumeInput) (*CreateCachediSCSIVolumeOutput, error) {
	req, out := c.CreateCachediSCSIVolumeRequest(input)
	return out, req.Send()
}

// CreateCachediSCSIVolumeWithContext is the same as CreateCachediSCSIVolume with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCachediSCSIVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) CreateCachediSCSIVolumeWithContext(ctx aws.Context, input *CreateCachediSCSIVolumeInput, opts ...request.Option) (*CreateCachediSCSIVolumeOutput, error) {
	req, out := c.CreateCachediSCSIVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNFSFileShare = "CreateNFSFileShare"

// CreateNFSFileShareRequest generates a "aws/request.Request" representing the
// client's request for the CreateNFSFileShare operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateNFSFileShare for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateNFSFileShare method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateNFSFileShareRequest method.
//    req, resp := client.CreateNFSFileShareRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateNFSFileShare
func (c *StorageGateway) CreateNFSFileShareRequest(input *CreateNFSFileShareInput) (req *request.Request, output *CreateNFSFileShareOutput) {
	op := &request.Operation{
		Name:       opCreateNFSFileShare,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNFSFileShareInput{}
	}

	output = &CreateNFSFileShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNFSFileShare API operation for AWS Storage Gateway.
//
// Creates a file share on an existing file gateway. In Storage Gateway, a file
// share is a file system mount point backed by Amazon S3 cloud storage. Storage
// Gateway exposes file shares using a Network File System (NFS) interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateNFSFileShare for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateNFSFileShare
func (c *StorageGateway) CreateNFSFileShare(input *CreateNFSFileShareInput) (*CreateNFSFileShareOutput, error) {
	req, out := c.CreateNFSFileShareRequest(input)
	return out, req.Send()
}

// CreateNFSFileShareWithContext is the same as CreateNFSFileShare with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNFSFileShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) CreateNFSFileShareWithContext(ctx aws.Context, input *CreateNFSFileShareInput, opts ...request.Option) (*CreateNFSFileShareOutput, error) {
	req, out := c.CreateNFSFileShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSnapshot = "CreateSnapshot"

// CreateSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshot operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateSnapshot for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateSnapshot method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateSnapshotRequest method.
//    req, resp := client.CreateSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSnapshot
func (c *StorageGateway) CreateSnapshotRequest(input *CreateSnapshotInput) (req *request.Request, output *CreateSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotInput{}
	}

	output = &CreateSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSnapshot API operation for AWS Storage Gateway.
//
// Initiates a snapshot of a volume.
//
// AWS Storage Gateway provides the ability to back up point-in-time snapshots
// of your data to Amazon Simple Storage (S3) for durable off-site recovery,
// as well as import the data to an Amazon Elastic Block Store (EBS) volume
// in Amazon Elastic Compute Cloud (EC2). You can take snapshots of your gateway
// volume on a scheduled or ad-hoc basis. This API enables you to take ad-hoc
// snapshot. For more information, see Working With Snapshots in the AWS Storage
// Gateway Console (http://docs.aws.amazon.com/storagegateway/latest/userguide/WorkingWithSnapshots.html).
//
// In the CreateSnapshot request you identify the volume by providing its Amazon
// Resource Name (ARN). You must also provide description for the snapshot.
// When AWS Storage Gateway takes the snapshot of specified volume, the snapshot
// and description appears in the AWS Storage Gateway Console. In response,
// AWS Storage Gateway returns you a snapshot ID. You can use this snapshot
// ID to check the snapshot progress or later use it when you want to create
// a volume from a snapshot.
//
// To list or delete a snapshot, you must use the Amazon EC2 API. For more information,
// see DescribeSnapshots or DeleteSnapshot in the EC2 API reference (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Operations.html).
//
// Volume and snapshot IDs are changing to a longer length ID format. For more
// information, see the important note on the Welcome (http://docs.aws.amazon.com/storagegateway/latest/APIReference/Welcome.html)
// page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
//   * ErrCodeServiceUnavailableError "ServiceUnavailableError"
//   An internal server error has occurred because the service is unavailable.
//   For more information, see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSnapshot
func (c *StorageGateway) CreateSnapshot(input *CreateSnapshotInput) (*CreateSnapshotOutput, error) {
	req, out := c.CreateSnapshotRequest(input)
	return out, req.Send()
}

// CreateSnapshotWithContext is the same as CreateSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) CreateSnapshotWithContext(ctx aws.Context, input *CreateSnapshotInput, opts ...request.Option) (*CreateSnapshotOutput, error) {
	req, out := c.CreateSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSnapshotFromVolumeRecoveryPoint = "CreateSnapshotFromVolumeRecoveryPoint"

// CreateSnapshotFromVolumeRecoveryPointRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshotFromVolumeRecoveryPoint operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateSnapshotFromVolumeRecoveryPoint for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateSnapshotFromVolumeRecoveryPoint method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateSnapshotFromVolumeRecoveryPointRequest method.
//    req, resp := client.CreateSnapshotFromVolumeRecoveryPointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSnapshotFromVolumeRecoveryPoint
func (c *StorageGateway) CreateSnapshotFromVolumeRecoveryPointRequest(input *CreateSnapshotFromVolumeRecoveryPointInput) (req *request.Request, output *CreateSnapshotFromVolumeRecoveryPointOutput) {
	op := &request.Operation{
		Name:       opCreateSnapshotFromVolumeRecoveryPoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotFromVolumeRecoveryPointInput{}
	}

	output = &CreateSnapshotFromVolumeRecoveryPointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSnapshotFromVolumeRecoveryPoint API operation for AWS Storage Gateway.
//
// Initiates a snapshot of a gateway from a volume recovery point. This operation
// is supported only for the gateway-cached volume architecture.
//
// A volume recovery point is a point in time at which all data of the volume
// is consistent and from which you can create a snapshot. To get a list of
// volume recovery point for gateway-cached volumes, use ListVolumeRecoveryPoints.
//
// In the CreateSnapshotFromVolumeRecoveryPoint request, you identify the volume
// by providing its Amazon Resource Name (ARN). You must also provide a description
// for the snapshot. When AWS Storage Gateway takes a snapshot of the specified
// volume, the snapshot and its description appear in the AWS Storage Gateway
// console. In response, AWS Storage Gateway returns you a snapshot ID. You
// can use this snapshot ID to check the snapshot progress or later use it when
// you want to create a volume from a snapshot.
//
// To list or delete a snapshot, you must use the Amazon EC2 API. For more information,
// in Amazon Elastic Compute Cloud API Reference.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateSnapshotFromVolumeRecoveryPoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
//   * ErrCodeServiceUnavailableError "ServiceUnavailableError"
//   An internal server error has occurred because the service is unavailable.
//   For more information, see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSnapshotFromVolumeRecoveryPoint
func (c *StorageGateway) CreateSnapshotFromVolumeRecoveryPoint(input *CreateSnapshotFromVolumeRecoveryPointInput) (*CreateSnapshotFromVolumeRecoveryPointOutput, error) {
	req, out := c.CreateSnapshotFromVolumeRecoveryPointRequest(input)
	return out, req.Send()
}

// CreateSnapshotFromVolumeRecoveryPointWithContext is the same as CreateSnapshotFromVolumeRecoveryPoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSnapshotFromVolumeRecoveryPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) CreateSnapshotFromVolumeRecoveryPointWithContext(ctx aws.Context, input *CreateSnapshotFromVolumeRecoveryPointInput, opts ...request.Option) (*CreateSnapshotFromVolumeRecoveryPointOutput, error) {
	req, out := c.CreateSnapshotFromVolumeRecoveryPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStorediSCSIVolume = "CreateStorediSCSIVolume"

// CreateStorediSCSIVolumeRequest generates a "aws/request.Request" representing the
// client's request for the CreateStorediSCSIVolume operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateStorediSCSIVolume for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateStorediSCSIVolume method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateStorediSCSIVolumeRequest method.
//    req, resp := client.CreateStorediSCSIVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateStorediSCSIVolume
func (c *StorageGateway) CreateStorediSCSIVolumeRequest(input *CreateStorediSCSIVolumeInput) (req *request.Request, output *CreateStorediSCSIVolumeOutput) {
	op := &request.Operation{
		Name:       opCreateStorediSCSIVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStorediSCSIVolumeInput{}
	}

	output = &CreateStorediSCSIVolumeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStorediSCSIVolume API operation for AWS Storage Gateway.
//
// Creates a volume on a specified gateway. This operation is supported only
// for the gateway-stored volume architecture.
//
// The size of the volume to create is inferred from the disk size. You can
// choose to preserve existing data on the disk, create volume from an existing
// snapshot, or create an empty volume. If you choose to create an empty gateway
// volume, then any existing data on the disk is erased.
//
// In the request you must specify the gateway and the disk information on which
// you are creating the volume. In response, AWS Storage Gateway creates the
// volume and returns volume information such as the volume Amazon Resource
// Name (ARN), its size, and the iSCSI target ARN that initiators can use to
// connect to the volume target.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateStorediSCSIVolume for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateStorediSCSIVolume
func (c *StorageGateway) CreateStorediSCSIVolume(input *CreateStorediSCSIVolumeInput) (*CreateStorediSCSIVolumeOutput, error) {
	req, out := c.CreateStorediSCSIVolumeRequest(input)
	return out, req.Send()
}

// CreateStorediSCSIVolumeWithContext is the same as CreateStorediSCSIVolume with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStorediSCSIVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) CreateStorediSCSIVolumeWithContext(ctx aws.Context, input *CreateStorediSCSIVolumeInput, opts ...request.Option) (*CreateStorediSCSIVolumeOutput, error) {
	req, out := c.CreateStorediSCSIVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTapeWithBarcode = "CreateTapeWithBarcode"

// CreateTapeWithBarcodeRequest generates a "aws/request.Request" representing the
// client's request for the CreateTapeWithBarcode operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateTapeWithBarcode for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateTapeWithBarcode method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateTapeWithBarcodeRequest method.
//    req, resp := client.CreateTapeWithBarcodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapeWithBarcode
func (c *StorageGateway) CreateTapeWithBarcodeRequest(input *CreateTapeWithBarcodeInput) (req *request.Request, output *CreateTapeWithBarcodeOutput) {
	op := &request.Operation{
		Name:       opCreateTapeWithBarcode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTapeWithBarcodeInput{}
	}

	output = &CreateTapeWithBarcodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTapeWithBarcode API operation for AWS Storage Gateway.
//
// Creates a virtual tape by using your own barcode. You write data to the virtual
// tape and then archive the tape.
//
// Cache storage must be allocated to the gateway before you can create a virtual
// tape. Use the AddCache operation to add cache storage to a gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateTapeWithBarcode for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapeWithBarcode
func (c *StorageGateway) CreateTapeWithBarcode(input *CreateTapeWithBarcodeInput) (*CreateTapeWithBarcodeOutput, error) {
	req, out := c.CreateTapeWithBarcodeRequest(input)
	return out, req.Send()
}

// CreateTapeWithBarcodeWithContext is the same as CreateTapeWithBarcode with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTapeWithBarcode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) CreateTapeWithBarcodeWithContext(ctx aws.Context, input *CreateTapeWithBarcodeInput, opts ...request.Option) (*CreateTapeWithBarcodeOutput, error) {
	req, out := c.CreateTapeWithBarcodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTapes = "CreateTapes"

// CreateTapesRequest generates a "aws/request.Request" representing the
// client's request for the CreateTapes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateTapes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateTapes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateTapesRequest method.
//    req, resp := client.CreateTapesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapes
func (c *StorageGateway) CreateTapesRequest(input *CreateTapesInput) (req *request.Request, output *CreateTapesOutput) {
	op := &request.Operation{
		Name:       opCreateTapes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTapesInput{}
	}

	output = &CreateTapesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTapes API operation for AWS Storage Gateway.
//
// Creates one or more virtual tapes. You write data to the virtual tapes and
// then archive the tapes.
//
// Cache storage must be allocated to the gateway before you can create virtual
// tapes. Use the AddCache operation to add cache storage to a gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation CreateTapes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapes
func (c *StorageGateway) CreateTapes(input *CreateTapesInput) (*CreateTapesOutput, error) {
	req, out := c.CreateTapesRequest(input)
	return out, req.Send()
}

// CreateTapesWithContext is the same as CreateTapes with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTapes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) CreateTapesWithContext(ctx aws.Context, input *CreateTapesInput, opts ...request.Option) (*CreateTapesOutput, error) {
	req, out := c.CreateTapesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBandwidthRateLimit = "DeleteBandwidthRateLimit"

// DeleteBandwidthRateLimitRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBandwidthRateLimit operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteBandwidthRateLimit for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteBandwidthRateLimit method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteBandwidthRateLimitRequest method.
//    req, resp := client.DeleteBandwidthRateLimitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteBandwidthRateLimit
func (c *StorageGateway) DeleteBandwidthRateLimitRequest(input *DeleteBandwidthRateLimitInput) (req *request.Request, output *DeleteBandwidthRateLimitOutput) {
	op := &request.Operation{
		Name:       opDeleteBandwidthRateLimit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBandwidthRateLimitInput{}
	}

	output = &DeleteBandwidthRateLimitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBandwidthRateLimit API operation for AWS Storage Gateway.
//
// Deletes the bandwidth rate limits of a gateway. You can delete either the
// upload and download bandwidth rate limit, or you can delete both. If you
// delete only one of the limits, the other limit remains unchanged. To specify
// which gateway to work with, use the Amazon Resource Name (ARN) of the gateway
// in your request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteBandwidthRateLimit for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteBandwidthRateLimit
func (c *StorageGateway) DeleteBandwidthRateLimit(input *DeleteBandwidthRateLimitInput) (*DeleteBandwidthRateLimitOutput, error) {
	req, out := c.DeleteBandwidthRateLimitRequest(input)
	return out, req.Send()
}

// DeleteBandwidthRateLimitWithContext is the same as DeleteBandwidthRateLimit with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBandwidthRateLimit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DeleteBandwidthRateLimitWithContext(ctx aws.Context, input *DeleteBandwidthRateLimitInput, opts ...request.Option) (*DeleteBandwidthRateLimitOutput, error) {
	req, out := c.DeleteBandwidthRateLimitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteChapCredentials = "DeleteChapCredentials"

// DeleteChapCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteChapCredentials operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteChapCredentials for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteChapCredentials method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteChapCredentialsRequest method.
//    req, resp := client.DeleteChapCredentialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteChapCredentials
func (c *StorageGateway) DeleteChapCredentialsRequest(input *DeleteChapCredentialsInput) (req *request.Request, output *DeleteChapCredentialsOutput) {
	op := &request.Operation{
		Name:       opDeleteChapCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteChapCredentialsInput{}
	}

	output = &DeleteChapCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteChapCredentials API operation for AWS Storage Gateway.
//
// Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for
// a specified iSCSI target and initiator pair.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteChapCredentials for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteChapCredentials
func (c *StorageGateway) DeleteChapCredentials(input *DeleteChapCredentialsInput) (*DeleteChapCredentialsOutput, error) {
	req, out := c.DeleteChapCredentialsRequest(input)
	return out, req.Send()
}

// DeleteChapCredentialsWithContext is the same as DeleteChapCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteChapCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DeleteChapCredentialsWithContext(ctx aws.Context, input *DeleteChapCredentialsInput, opts ...request.Option) (*DeleteChapCredentialsOutput, error) {
	req, out := c.DeleteChapCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFileShare = "DeleteFileShare"

// DeleteFileShareRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFileShare operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteFileShare for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteFileShare method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteFileShareRequest method.
//    req, resp := client.DeleteFileShareRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteFileShare
func (c *StorageGateway) DeleteFileShareRequest(input *DeleteFileShareInput) (req *request.Request, output *DeleteFileShareOutput) {
	op := &request.Operation{
		Name:       opDeleteFileShare,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFileShareInput{}
	}

	output = &DeleteFileShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFileShare API operation for AWS Storage Gateway.
//
// Deletes a file share from a file gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteFileShare for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteFileShare
func (c *StorageGateway) DeleteFileShare(input *DeleteFileShareInput) (*DeleteFileShareOutput, error) {
	req, out := c.DeleteFileShareRequest(input)
	return out, req.Send()
}

// DeleteFileShareWithContext is the same as DeleteFileShare with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFileShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DeleteFileShareWithContext(ctx aws.Context, input *DeleteFileShareInput, opts ...request.Option) (*DeleteFileShareOutput, error) {
	req, out := c.DeleteFileShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGateway = "DeleteGateway"

// DeleteGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteGatewayRequest method.
//    req, resp := client.DeleteGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteGateway
func (c *StorageGateway) DeleteGatewayRequest(input *DeleteGatewayInput) (req *request.Request, output *DeleteGatewayOutput) {
	op := &request.Operation{
		Name:       opDeleteGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGatewayInput{}
	}

	output = &DeleteGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGateway API operation for AWS Storage Gateway.
//
// Deletes a gateway. To specify which gateway to delete, use the Amazon Resource
// Name (ARN) of the gateway in your request. The operation deletes the gateway;
// however, it does not delete the gateway virtual machine (VM) from your host
// computer.
//
// After you delete a gateway, you cannot reactivate it. Completed snapshots
// of the gateway volumes are not deleted upon deleting the gateway, however,
// pending snapshots will not complete. After you delete a gateway, your next
// step is to remove it from your environment.
//
// You no longer pay software charges after the gateway is deleted; however,
// your existing Amazon EBS snapshots persist and you will continue to be billed
// for these snapshots. You can choose to remove all remaining Amazon EBS snapshots
// by canceling your Amazon EC2 subscription.  If you prefer not to cancel your
// Amazon EC2 subscription, you can delete your snapshots using the Amazon EC2
// console. For more information, see the  AWS Storage Gateway Detail Page (http://aws.amazon.com/storagegateway).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteGateway for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteGateway
func (c *StorageGateway) DeleteGateway(input *DeleteGatewayInput) (*DeleteGatewayOutput, error) {
	req, out := c.DeleteGatewayRequest(input)
	return out, req.Send()
}

// DeleteGatewayWithContext is the same as DeleteGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DeleteGatewayWithContext(ctx aws.Context, input *DeleteGatewayInput, opts ...request.Option) (*DeleteGatewayOutput, error) {
	req, out := c.DeleteGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSnapshotSchedule = "DeleteSnapshotSchedule"

// DeleteSnapshotScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSnapshotSchedule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteSnapshotSchedule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteSnapshotSchedule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteSnapshotScheduleRequest method.
//    req, resp := client.DeleteSnapshotScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteSnapshotSchedule
func (c *StorageGateway) DeleteSnapshotScheduleRequest(input *DeleteSnapshotScheduleInput) (req *request.Request, output *DeleteSnapshotScheduleOutput) {
	op := &request.Operation{
		Name:       opDeleteSnapshotSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotScheduleInput{}
	}

	output = &DeleteSnapshotScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSnapshotSchedule API operation for AWS Storage Gateway.
//
// Deletes a snapshot of a volume.
//
// You can take snapshots of your gateway volumes on a scheduled or ad hoc basis.
// This API action enables you to delete a snapshot schedule for a volume. For
// more information, see Working with Snapshots (http://docs.aws.amazon.com/storagegateway/latest/userguide/WorkingWithSnapshots.html).
// In the DeleteSnapshotSchedule request, you identify the volume by providing
// its Amazon Resource Name (ARN).
//
// To list or delete a snapshot, you must use the Amazon EC2 API. in Amazon
// Elastic Compute Cloud API Reference.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteSnapshotSchedule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteSnapshotSchedule
func (c *StorageGateway) DeleteSnapshotSchedule(input *DeleteSnapshotScheduleInput) (*DeleteSnapshotScheduleOutput, error) {
	req, out := c.DeleteSnapshotScheduleRequest(input)
	return out, req.Send()
}

// DeleteSnapshotScheduleWithContext is the same as DeleteSnapshotSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSnapshotSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DeleteSnapshotScheduleWithContext(ctx aws.Context, input *DeleteSnapshotScheduleInput, opts ...request.Option) (*DeleteSnapshotScheduleOutput, error) {
	req, out := c.DeleteSnapshotScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTape = "DeleteTape"

// DeleteTapeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTape operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteTape for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteTape method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteTapeRequest method.
//    req, resp := client.DeleteTapeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTape
func (c *StorageGateway) DeleteTapeRequest(input *DeleteTapeInput) (req *request.Request, output *DeleteTapeOutput) {
	op := &request.Operation{
		Name:       opDeleteTape,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTapeInput{}
	}

	output = &DeleteTapeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTape API operation for AWS Storage Gateway.
//
// Deletes the specified virtual tape.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteTape for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTape
func (c *StorageGateway) DeleteTape(input *DeleteTapeInput) (*DeleteTapeOutput, error) {
	req, out := c.DeleteTapeRequest(input)
	return out, req.Send()
}

// DeleteTapeWithContext is the same as DeleteTape with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTape for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DeleteTapeWithContext(ctx aws.Context, input *DeleteTapeInput, opts ...request.Option) (*DeleteTapeOutput, error) {
	req, out := c.DeleteTapeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTapeArchive = "DeleteTapeArchive"

// DeleteTapeArchiveRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTapeArchive operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteTapeArchive for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteTapeArchive method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteTapeArchiveRequest method.
//    req, resp := client.DeleteTapeArchiveRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTapeArchive
func (c *StorageGateway) DeleteTapeArchiveRequest(input *DeleteTapeArchiveInput) (req *request.Request, output *DeleteTapeArchiveOutput) {
	op := &request.Operation{
		Name:       opDeleteTapeArchive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTapeArchiveInput{}
	}

	output = &DeleteTapeArchiveOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTapeArchive API operation for AWS Storage Gateway.
//
// Deletes the specified virtual tape from the virtual tape shelf (VTS).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteTapeArchive for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTapeArchive
func (c *StorageGateway) DeleteTapeArchive(input *DeleteTapeArchiveInput) (*DeleteTapeArchiveOutput, error) {
	req, out := c.DeleteTapeArchiveRequest(input)
	return out, req.Send()
}

// DeleteTapeArchiveWithContext is the same as DeleteTapeArchive with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTapeArchive for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DeleteTapeArchiveWithContext(ctx aws.Context, input *DeleteTapeArchiveInput, opts ...request.Option) (*DeleteTapeArchiveOutput, error) {
	req, out := c.DeleteTapeArchiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVolume = "DeleteVolume"

// DeleteVolumeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVolume operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteVolume for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteVolume method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteVolumeRequest method.
//    req, resp := client.DeleteVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteVolume
func (c *StorageGateway) DeleteVolumeRequest(input *DeleteVolumeInput) (req *request.Request, output *DeleteVolumeOutput) {
	op := &request.Operation{
		Name:       opDeleteVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVolumeInput{}
	}

	output = &DeleteVolumeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVolume API operation for AWS Storage Gateway.
//
// Deletes the specified gateway volume that you previously created using the
// CreateCachediSCSIVolume or CreateStorediSCSIVolume API. For gateway-stored
// volumes, the local disk that was configured as the storage volume is not
// deleted. You can reuse the local disk to create another storage volume.
//
// Before you delete a gateway volume, make sure there are no iSCSI connections
// to the volume you are deleting. You should also make sure there is no snapshot
// in progress. You can use the Amazon Elastic Compute Cloud (Amazon EC2) API
// to query snapshots on the volume you are deleting and check the snapshot
// status. For more information, go to DescribeSnapshots (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html)
// in the Amazon Elastic Compute Cloud API Reference.
//
// In the request, you must provide the Amazon Resource Name (ARN) of the storage
// volume you want to delete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DeleteVolume for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteVolume
func (c *StorageGateway) DeleteVolume(input *DeleteVolumeInput) (*DeleteVolumeOutput, error) {
	req, out := c.DeleteVolumeRequest(input)
	return out, req.Send()
}

// DeleteVolumeWithContext is the same as DeleteVolume with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DeleteVolumeWithContext(ctx aws.Context, input *DeleteVolumeInput, opts ...request.Option) (*DeleteVolumeOutput, error) {
	req, out := c.DeleteVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBandwidthRateLimit = "DescribeBandwidthRateLimit"

// DescribeBandwidthRateLimitRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBandwidthRateLimit operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeBandwidthRateLimit for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeBandwidthRateLimit method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeBandwidthRateLimitRequest method.
//    req, resp := client.DescribeBandwidthRateLimitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeBandwidthRateLimit
func (c *StorageGateway) DescribeBandwidthRateLimitRequest(input *DescribeBandwidthRateLimitInput) (req *request.Request, output *DescribeBandwidthRateLimitOutput) {
	op := &request.Operation{
		Name:       opDescribeBandwidthRateLimit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBandwidthRateLimitInput{}
	}

	output = &DescribeBandwidthRateLimitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBandwidthRateLimit API operation for AWS Storage Gateway.
//
// Returns the bandwidth rate limits of a gateway. By default, these limits
// are not set, which means no bandwidth rate limiting is in effect.
//
// This operation only returns a value for a bandwidth rate limit only if the
// limit is set. If no limits are set for the gateway, then this operation returns
// only the gateway ARN in the response body. To specify which gateway to describe,
// use the Amazon Resource Name (ARN) of the gateway in your request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeBandwidthRateLimit for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeBandwidthRateLimit
func (c *StorageGateway) DescribeBandwidthRateLimit(input *DescribeBandwidthRateLimitInput) (*DescribeBandwidthRateLimitOutput, error) {
	req, out := c.DescribeBandwidthRateLimitRequest(input)
	return out, req.Send()
}

// DescribeBandwidthRateLimitWithContext is the same as DescribeBandwidthRateLimit with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBandwidthRateLimit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeBandwidthRateLimitWithContext(ctx aws.Context, input *DescribeBandwidthRateLimitInput, opts ...request.Option) (*DescribeBandwidthRateLimitOutput, error) {
	req, out := c.DescribeBandwidthRateLimitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCache = "DescribeCache"

// DescribeCacheRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCache operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeCache for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeCache method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeCacheRequest method.
//    req, resp := client.DescribeCacheRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeCache
func (c *StorageGateway) DescribeCacheRequest(input *DescribeCacheInput) (req *request.Request, output *DescribeCacheOutput) {
	op := &request.Operation{
		Name:       opDescribeCache,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCacheInput{}
	}

	output = &DescribeCacheOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCache API operation for AWS Storage Gateway.
//
// Returns information about the cache of a gateway. This operation is supported
// only for the gateway-cached volume architecture.
//
// The response includes disk IDs that are configured as cache, and it includes
// the amount of cache allocated and used.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeCache for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeCache
func (c *StorageGateway) DescribeCache(input *DescribeCacheInput) (*DescribeCacheOutput, error) {
	req, out := c.DescribeCacheRequest(input)
	return out, req.Send()
}

// DescribeCacheWithContext is the same as DescribeCache with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCache for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeCacheWithContext(ctx aws.Context, input *DescribeCacheInput, opts ...request.Option) (*DescribeCacheOutput, error) {
	req, out := c.DescribeCacheRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCachediSCSIVolumes = "DescribeCachediSCSIVolumes"

// DescribeCachediSCSIVolumesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCachediSCSIVolumes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeCachediSCSIVolumes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeCachediSCSIVolumes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeCachediSCSIVolumesRequest method.
//    req, resp := client.DescribeCachediSCSIVolumesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeCachediSCSIVolumes
func (c *StorageGateway) DescribeCachediSCSIVolumesRequest(input *DescribeCachediSCSIVolumesInput) (req *request.Request, output *DescribeCachediSCSIVolumesOutput) {
	op := &request.Operation{
		Name:       opDescribeCachediSCSIVolumes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCachediSCSIVolumesInput{}
	}

	output = &DescribeCachediSCSIVolumesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCachediSCSIVolumes API operation for AWS Storage Gateway.
//
// Returns a description of the gateway volumes specified in the request. This
// operation is supported only for the gateway-cached volume architecture.
//
// The list of gateway volumes in the request must be from one gateway. In the
// response Amazon Storage Gateway returns volume information sorted by volume
// Amazon Resource Name (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeCachediSCSIVolumes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeCachediSCSIVolumes
func (c *StorageGateway) DescribeCachediSCSIVolumes(input *DescribeCachediSCSIVolumesInput) (*DescribeCachediSCSIVolumesOutput, error) {
	req, out := c.DescribeCachediSCSIVolumesRequest(input)
	return out, req.Send()
}

// DescribeCachediSCSIVolumesWithContext is the same as DescribeCachediSCSIVolumes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCachediSCSIVolumes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeCachediSCSIVolumesWithContext(ctx aws.Context, input *DescribeCachediSCSIVolumesInput, opts ...request.Option) (*DescribeCachediSCSIVolumesOutput, error) {
	req, out := c.DescribeCachediSCSIVolumesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeChapCredentials = "DescribeChapCredentials"

// DescribeChapCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeChapCredentials operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeChapCredentials for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeChapCredentials method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeChapCredentialsRequest method.
//    req, resp := client.DescribeChapCredentialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeChapCredentials
func (c *StorageGateway) DescribeChapCredentialsRequest(input *DescribeChapCredentialsInput) (req *request.Request, output *DescribeChapCredentialsOutput) {
	op := &request.Operation{
		Name:       opDescribeChapCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeChapCredentialsInput{}
	}

	output = &DescribeChapCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeChapCredentials API operation for AWS Storage Gateway.
//
// Returns an array of Challenge-Handshake Authentication Protocol (CHAP) credentials
// information for a specified iSCSI target, one for each target-initiator pair.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeChapCredentials for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeChapCredentials
func (c *StorageGateway) DescribeChapCredentials(input *DescribeChapCredentialsInput) (*DescribeChapCredentialsOutput, error) {
	req, out := c.DescribeChapCredentialsRequest(input)
	return out, req.Send()
}

// DescribeChapCredentialsWithContext is the same as DescribeChapCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeChapCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeChapCredentialsWithContext(ctx aws.Context, input *DescribeChapCredentialsInput, opts ...request.Option) (*DescribeChapCredentialsOutput, error) {
	req, out := c.DescribeChapCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGatewayInformation = "DescribeGatewayInformation"

// DescribeGatewayInformationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGatewayInformation operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeGatewayInformation for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeGatewayInformation method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeGatewayInformationRequest method.
//    req, resp := client.DescribeGatewayInformationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeGatewayInformation
func (c *StorageGateway) DescribeGatewayInformationRequest(input *DescribeGatewayInformationInput) (req *request.Request, output *DescribeGatewayInformationOutput) {
	op := &request.Operation{
		Name:       opDescribeGatewayInformation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGatewayInformationInput{}
	}

	output = &DescribeGatewayInformationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGatewayInformation API operation for AWS Storage Gateway.
//
// Returns metadata about a gateway such as its name, network interfaces, configured
// time zone, and the state (whether the gateway is running or not). To specify
// which gateway to describe, use the Amazon Resource Name (ARN) of the gateway
// in your request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeGatewayInformation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeGatewayInformation
func (c *StorageGateway) DescribeGatewayInformation(input *DescribeGatewayInformationInput) (*DescribeGatewayInformationOutput, error) {
	req, out := c.DescribeGatewayInformationRequest(input)
	return out, req.Send()
}

// DescribeGatewayInformationWithContext is the same as DescribeGatewayInformation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGatewayInformation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeGatewayInformationWithContext(ctx aws.Context, input *DescribeGatewayInformationInput, opts ...request.Option) (*DescribeGatewayInformationOutput, error) {
	req, out := c.DescribeGatewayInformationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMaintenanceStartTime = "DescribeMaintenanceStartTime"

// DescribeMaintenanceStartTimeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMaintenanceStartTime operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeMaintenanceStartTime for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeMaintenanceStartTime method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeMaintenanceStartTimeRequest method.
//    req, resp := client.DescribeMaintenanceStartTimeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeMaintenanceStartTime
func (c *StorageGateway) DescribeMaintenanceStartTimeRequest(input *DescribeMaintenanceStartTimeInput) (req *request.Request, output *DescribeMaintenanceStartTimeOutput) {
	op := &request.Operation{
		Name:       opDescribeMaintenanceStartTime,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMaintenanceStartTimeInput{}
	}

	output = &DescribeMaintenanceStartTimeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMaintenanceStartTime API operation for AWS Storage Gateway.
//
// Returns your gateway's weekly maintenance start time including the day and
// time of the week. Note that values are in terms of the gateway's time zone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeMaintenanceStartTime for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeMaintenanceStartTime
func (c *StorageGateway) DescribeMaintenanceStartTime(input *DescribeMaintenanceStartTimeInput) (*DescribeMaintenanceStartTimeOutput, error) {
	req, out := c.DescribeMaintenanceStartTimeRequest(input)
	return out, req.Send()
}

// DescribeMaintenanceStartTimeWithContext is the same as DescribeMaintenanceStartTime with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMaintenanceStartTime for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeMaintenanceStartTimeWithContext(ctx aws.Context, input *DescribeMaintenanceStartTimeInput, opts ...request.Option) (*DescribeMaintenanceStartTimeOutput, error) {
	req, out := c.DescribeMaintenanceStartTimeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNFSFileShares = "DescribeNFSFileShares"

// DescribeNFSFileSharesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNFSFileShares operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeNFSFileShares for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeNFSFileShares method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeNFSFileSharesRequest method.
//    req, resp := client.DescribeNFSFileSharesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeNFSFileShares
func (c *StorageGateway) DescribeNFSFileSharesRequest(input *DescribeNFSFileSharesInput) (req *request.Request, output *DescribeNFSFileSharesOutput) {
	op := &request.Operation{
		Name:       opDescribeNFSFileShares,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNFSFileSharesInput{}
	}

	output = &DescribeNFSFileSharesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNFSFileShares API operation for AWS Storage Gateway.
//
// Gets a description for one or more file shares from a file gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeNFSFileShares for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeNFSFileShares
func (c *StorageGateway) DescribeNFSFileShares(input *DescribeNFSFileSharesInput) (*DescribeNFSFileSharesOutput, error) {
	req, out := c.DescribeNFSFileSharesRequest(input)
	return out, req.Send()
}

// DescribeNFSFileSharesWithContext is the same as DescribeNFSFileShares with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNFSFileShares for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeNFSFileSharesWithContext(ctx aws.Context, input *DescribeNFSFileSharesInput, opts ...request.Option) (*DescribeNFSFileSharesOutput, error) {
	req, out := c.DescribeNFSFileSharesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSnapshotSchedule = "DescribeSnapshotSchedule"

// DescribeSnapshotScheduleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSnapshotSchedule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeSnapshotSchedule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeSnapshotSchedule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeSnapshotScheduleRequest method.
//    req, resp := client.DescribeSnapshotScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeSnapshotSchedule
func (c *StorageGateway) DescribeSnapshotScheduleRequest(input *DescribeSnapshotScheduleInput) (req *request.Request, output *DescribeSnapshotScheduleOutput) {
	op := &request.Operation{
		Name:       opDescribeSnapshotSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSnapshotScheduleInput{}
	}

	output = &DescribeSnapshotScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSnapshotSchedule API operation for AWS Storage Gateway.
//
// Describes the snapshot schedule for the specified gateway volume. The snapshot
// schedule information includes intervals at which snapshots are automatically
// initiated on the volume.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeSnapshotSchedule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeSnapshotSchedule
func (c *StorageGateway) DescribeSnapshotSchedule(input *DescribeSnapshotScheduleInput) (*DescribeSnapshotScheduleOutput, error) {
	req, out := c.DescribeSnapshotScheduleRequest(input)
	return out, req.Send()
}

// DescribeSnapshotScheduleWithContext is the same as DescribeSnapshotSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSnapshotSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeSnapshotScheduleWithContext(ctx aws.Context, input *DescribeSnapshotScheduleInput, opts ...request.Option) (*DescribeSnapshotScheduleOutput, error) {
	req, out := c.DescribeSnapshotScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStorediSCSIVolumes = "DescribeStorediSCSIVolumes"

// DescribeStorediSCSIVolumesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStorediSCSIVolumes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeStorediSCSIVolumes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeStorediSCSIVolumes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeStorediSCSIVolumesRequest method.
//    req, resp := client.DescribeStorediSCSIVolumesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeStorediSCSIVolumes
func (c *StorageGateway) DescribeStorediSCSIVolumesRequest(input *DescribeStorediSCSIVolumesInput) (req *request.Request, output *DescribeStorediSCSIVolumesOutput) {
	op := &request.Operation{
		Name:       opDescribeStorediSCSIVolumes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStorediSCSIVolumesInput{}
	}

	output = &DescribeStorediSCSIVolumesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStorediSCSIVolumes API operation for AWS Storage Gateway.
//
// Returns the description of the gateway volumes specified in the request.
// The list of gateway volumes in the request must be from one gateway. In the
// response Amazon Storage Gateway returns volume information sorted by volume
// ARNs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeStorediSCSIVolumes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeStorediSCSIVolumes
func (c *StorageGateway) DescribeStorediSCSIVolumes(input *DescribeStorediSCSIVolumesInput) (*DescribeStorediSCSIVolumesOutput, error) {
	req, out := c.DescribeStorediSCSIVolumesRequest(input)
	return out, req.Send()
}

// DescribeStorediSCSIVolumesWithContext is the same as DescribeStorediSCSIVolumes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStorediSCSIVolumes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeStorediSCSIVolumesWithContext(ctx aws.Context, input *DescribeStorediSCSIVolumesInput, opts ...request.Option) (*DescribeStorediSCSIVolumesOutput, error) {
	req, out := c.DescribeStorediSCSIVolumesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTapeArchives = "DescribeTapeArchives"

// DescribeTapeArchivesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTapeArchives operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTapeArchives for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTapeArchives method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTapeArchivesRequest method.
//    req, resp := client.DescribeTapeArchivesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeArchives
func (c *StorageGateway) DescribeTapeArchivesRequest(input *DescribeTapeArchivesInput) (req *request.Request, output *DescribeTapeArchivesOutput) {
	op := &request.Operation{
		Name:       opDescribeTapeArchives,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTapeArchivesInput{}
	}

	output = &DescribeTapeArchivesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTapeArchives API operation for AWS Storage Gateway.
//
// Returns a description of specified virtual tapes in the virtual tape shelf
// (VTS).
//
// If a specific TapeARN is not specified, AWS Storage Gateway returns a description
// of all virtual tapes found in the VTS associated with your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeTapeArchives for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeArchives
func (c *StorageGateway) DescribeTapeArchives(input *DescribeTapeArchivesInput) (*DescribeTapeArchivesOutput, error) {
	req, out := c.DescribeTapeArchivesRequest(input)
	return out, req.Send()
}

// DescribeTapeArchivesWithContext is the same as DescribeTapeArchives with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTapeArchives for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeTapeArchivesWithContext(ctx aws.Context, input *DescribeTapeArchivesInput, opts ...request.Option) (*DescribeTapeArchivesOutput, error) {
	req, out := c.DescribeTapeArchivesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeTapeArchivesPages iterates over the pages of a DescribeTapeArchives operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeTapeArchives method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeTapeArchives operation.
//    pageNum := 0
//    err := client.DescribeTapeArchivesPages(params,
//        func(page *DescribeTapeArchivesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) DescribeTapeArchivesPages(input *DescribeTapeArchivesInput, fn func(*DescribeTapeArchivesOutput, bool) bool) error {
	return c.DescribeTapeArchivesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeTapeArchivesPagesWithContext same as DescribeTapeArchivesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeTapeArchivesPagesWithContext(ctx aws.Context, input *DescribeTapeArchivesInput, fn func(*DescribeTapeArchivesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy DescribeTapeArchivesInput
			if input != nil {
				inCpy = *input
			}
			req, _ := c.DescribeTapeArchivesRequest(&inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeTapeArchivesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeTapeRecoveryPoints = "DescribeTapeRecoveryPoints"

// DescribeTapeRecoveryPointsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTapeRecoveryPoints operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTapeRecoveryPoints for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTapeRecoveryPoints method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTapeRecoveryPointsRequest method.
//    req, resp := client.DescribeTapeRecoveryPointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeRecoveryPoints
func (c *StorageGateway) DescribeTapeRecoveryPointsRequest(input *DescribeTapeRecoveryPointsInput) (req *request.Request, output *DescribeTapeRecoveryPointsOutput) {
	op := &request.Operation{
		Name:       opDescribeTapeRecoveryPoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTapeRecoveryPointsInput{}
	}

	output = &DescribeTapeRecoveryPointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTapeRecoveryPoints API operation for AWS Storage Gateway.
//
// Returns a list of virtual tape recovery points that are available for the
// specified gateway-VTL.
//
// A recovery point is a point-in-time view of a virtual tape at which all the
// data on the virtual tape is consistent. If your gateway crashes, virtual
// tapes that have recovery points can be recovered to a new gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeTapeRecoveryPoints for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeRecoveryPoints
func (c *StorageGateway) DescribeTapeRecoveryPoints(input *DescribeTapeRecoveryPointsInput) (*DescribeTapeRecoveryPointsOutput, error) {
	req, out := c.DescribeTapeRecoveryPointsRequest(input)
	return out, req.Send()
}

// DescribeTapeRecoveryPointsWithContext is the same as DescribeTapeRecoveryPoints with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTapeRecoveryPoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeTapeRecoveryPointsWithContext(ctx aws.Context, input *DescribeTapeRecoveryPointsInput, opts ...request.Option) (*DescribeTapeRecoveryPointsOutput, error) {
	req, out := c.DescribeTapeRecoveryPointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeTapeRecoveryPointsPages iterates over the pages of a DescribeTapeRecoveryPoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeTapeRecoveryPoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeTapeRecoveryPoints operation.
//    pageNum := 0
//    err := client.DescribeTapeRecoveryPointsPages(params,
//        func(page *DescribeTapeRecoveryPointsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) DescribeTapeRecoveryPointsPages(input *DescribeTapeRecoveryPointsInput, fn func(*DescribeTapeRecoveryPointsOutput, bool) bool) error {
	return c.DescribeTapeRecoveryPointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeTapeRecoveryPointsPagesWithContext same as DescribeTapeRecoveryPointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeTapeRecoveryPointsPagesWithContext(ctx aws.Context, input *DescribeTapeRecoveryPointsInput, fn func(*DescribeTapeRecoveryPointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy DescribeTapeRecoveryPointsInput
			if input != nil {
				inCpy = *input
			}
			req, _ := c.DescribeTapeRecoveryPointsRequest(&inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeTapeRecoveryPointsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeTapes = "DescribeTapes"

// DescribeTapesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTapes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTapes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTapes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTapesRequest method.
//    req, resp := client.DescribeTapesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapes
func (c *StorageGateway) DescribeTapesRequest(input *DescribeTapesInput) (req *request.Request, output *DescribeTapesOutput) {
	op := &request.Operation{
		Name:       opDescribeTapes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTapesInput{}
	}

	output = &DescribeTapesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTapes API operation for AWS Storage Gateway.
//
// Returns a description of the specified Amazon Resource Name (ARN) of virtual
// tapes. If a TapeARN is not specified, returns a description of all virtual
// tapes associated with the specified gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeTapes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapes
func (c *StorageGateway) DescribeTapes(input *DescribeTapesInput) (*DescribeTapesOutput, error) {
	req, out := c.DescribeTapesRequest(input)
	return out, req.Send()
}

// DescribeTapesWithContext is the same as DescribeTapes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTapes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeTapesWithContext(ctx aws.Context, input *DescribeTapesInput, opts ...request.Option) (*DescribeTapesOutput, error) {
	req, out := c.DescribeTapesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeTapesPages iterates over the pages of a DescribeTapes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeTapes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeTapes operation.
//    pageNum := 0
//    err := client.DescribeTapesPages(params,
//        func(page *DescribeTapesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) DescribeTapesPages(input *DescribeTapesInput, fn func(*DescribeTapesOutput, bool) bool) error {
	return c.DescribeTapesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeTapesPagesWithContext same as DescribeTapesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeTapesPagesWithContext(ctx aws.Context, input *DescribeTapesInput, fn func(*DescribeTapesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy DescribeTapesInput
			if input != nil {
				inCpy = *input
			}
			req, _ := c.DescribeTapesRequest(&inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeTapesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeUploadBuffer = "DescribeUploadBuffer"

// DescribeUploadBufferRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUploadBuffer operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeUploadBuffer for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeUploadBuffer method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeUploadBufferRequest method.
//    req, resp := client.DescribeUploadBufferRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeUploadBuffer
func (c *StorageGateway) DescribeUploadBufferRequest(input *DescribeUploadBufferInput) (req *request.Request, output *DescribeUploadBufferOutput) {
	op := &request.Operation{
		Name:       opDescribeUploadBuffer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUploadBufferInput{}
	}

	output = &DescribeUploadBufferOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUploadBuffer API operation for AWS Storage Gateway.
//
// Returns information about the upload buffer of a gateway. This operation
// is supported for both the gateway-stored and gateway-cached volume architectures.
//
// The response includes disk IDs that are configured as upload buffer space,
// and it includes the amount of upload buffer space allocated and used.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeUploadBuffer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeUploadBuffer
func (c *StorageGateway) DescribeUploadBuffer(input *DescribeUploadBufferInput) (*DescribeUploadBufferOutput, error) {
	req, out := c.DescribeUploadBufferRequest(input)
	return out, req.Send()
}

// DescribeUploadBufferWithContext is the same as DescribeUploadBuffer with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUploadBuffer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeUploadBufferWithContext(ctx aws.Context, input *DescribeUploadBufferInput, opts ...request.Option) (*DescribeUploadBufferOutput, error) {
	req, out := c.DescribeUploadBufferRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVTLDevices = "DescribeVTLDevices"

// DescribeVTLDevicesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVTLDevices operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeVTLDevices for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeVTLDevices method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeVTLDevicesRequest method.
//    req, resp := client.DescribeVTLDevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeVTLDevices
func (c *StorageGateway) DescribeVTLDevicesRequest(input *DescribeVTLDevicesInput) (req *request.Request, output *DescribeVTLDevicesOutput) {
	op := &request.Operation{
		Name:       opDescribeVTLDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeVTLDevicesInput{}
	}

	output = &DescribeVTLDevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVTLDevices API operation for AWS Storage Gateway.
//
// Returns a description of virtual tape library (VTL) devices for the specified
// gateway. In the response, AWS Storage Gateway returns VTL device information.
//
// The list of VTL devices must be from one gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeVTLDevices for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeVTLDevices
func (c *StorageGateway) DescribeVTLDevices(input *DescribeVTLDevicesInput) (*DescribeVTLDevicesOutput, error) {
	req, out := c.DescribeVTLDevicesRequest(input)
	return out, req.Send()
}

// DescribeVTLDevicesWithContext is the same as DescribeVTLDevices with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVTLDevices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeVTLDevicesWithContext(ctx aws.Context, input *DescribeVTLDevicesInput, opts ...request.Option) (*DescribeVTLDevicesOutput, error) {
	req, out := c.DescribeVTLDevicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeVTLDevicesPages iterates over the pages of a DescribeVTLDevices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeVTLDevices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeVTLDevices operation.
//    pageNum := 0
//    err := client.DescribeVTLDevicesPages(params,
//        func(page *DescribeVTLDevicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) DescribeVTLDevicesPages(input *DescribeVTLDevicesInput, fn func(*DescribeVTLDevicesOutput, bool) bool) error {
	return c.DescribeVTLDevicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeVTLDevicesPagesWithContext same as DescribeVTLDevicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeVTLDevicesPagesWithContext(ctx aws.Context, input *DescribeVTLDevicesInput, fn func(*DescribeVTLDevicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy DescribeVTLDevicesInput
			if input != nil {
				inCpy = *input
			}
			req, _ := c.DescribeVTLDevicesRequest(&inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeVTLDevicesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeWorkingStorage = "DescribeWorkingStorage"

// DescribeWorkingStorageRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkingStorage operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeWorkingStorage for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeWorkingStorage method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeWorkingStorageRequest method.
//    req, resp := client.DescribeWorkingStorageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeWorkingStorage
func (c *StorageGateway) DescribeWorkingStorageRequest(input *DescribeWorkingStorageInput) (req *request.Request, output *DescribeWorkingStorageOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkingStorage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkingStorageInput{}
	}

	output = &DescribeWorkingStorageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkingStorage API operation for AWS Storage Gateway.
//
// Returns information about the working storage of a gateway. This operation
// is supported only for the gateway-stored volume architecture. This operation
// is deprecated in cached-volumes API version (20120630). Use DescribeUploadBuffer
// instead.
//
// Working storage is also referred to as upload buffer. You can also use the
// DescribeUploadBuffer operation to add upload buffer to a stored-volume gateway.
//
// The response includes disk IDs that are configured as working storage, and
// it includes the amount of working storage allocated and used.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DescribeWorkingStorage for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeWorkingStorage
func (c *StorageGateway) DescribeWorkingStorage(input *DescribeWorkingStorageInput) (*DescribeWorkingStorageOutput, error) {
	req, out := c.DescribeWorkingStorageRequest(input)
	return out, req.Send()
}

// DescribeWorkingStorageWithContext is the same as DescribeWorkingStorage with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkingStorage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DescribeWorkingStorageWithContext(ctx aws.Context, input *DescribeWorkingStorageInput, opts ...request.Option) (*DescribeWorkingStorageOutput, error) {
	req, out := c.DescribeWorkingStorageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableGateway = "DisableGateway"

// DisableGatewayRequest generates a "aws/request.Request" representing the
// client's request for the DisableGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisableGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisableGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisableGatewayRequest method.
//    req, resp := client.DisableGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DisableGateway
func (c *StorageGateway) DisableGatewayRequest(input *DisableGatewayInput) (req *request.Request, output *DisableGatewayOutput) {
	op := &request.Operation{
		Name:       opDisableGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableGatewayInput{}
	}

	output = &DisableGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisableGateway API operation for AWS Storage Gateway.
//
// Disables a gateway when the gateway is no longer functioning. For example,
// if your gateway VM is damaged, you can disable the gateway so you can recover
// virtual tapes.
//
// Use this operation for a gateway-VTL that is not reachable or not functioning.
//
// Once a gateway is disabled it cannot be enabled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation DisableGateway for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DisableGateway
func (c *StorageGateway) DisableGateway(input *DisableGatewayInput) (*DisableGatewayOutput, error) {
	req, out := c.DisableGatewayRequest(input)
	return out, req.Send()
}

// DisableGatewayWithContext is the same as DisableGateway with the addition of
// the ability to pass a context and additional request options.
//
// See DisableGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) DisableGatewayWithContext(ctx aws.Context, input *DisableGatewayInput, opts ...request.Option) (*DisableGatewayOutput, error) {
	req, out := c.DisableGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFileShares = "ListFileShares"

// ListFileSharesRequest generates a "aws/request.Request" representing the
// client's request for the ListFileShares operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListFileShares for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListFileShares method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListFileSharesRequest method.
//    req, resp := client.ListFileSharesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListFileShares
func (c *StorageGateway) ListFileSharesRequest(input *ListFileSharesInput) (req *request.Request, output *ListFileSharesOutput) {
	op := &request.Operation{
		Name:       opListFileShares,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListFileSharesInput{}
	}

	output = &ListFileSharesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFileShares API operation for AWS Storage Gateway.
//
// Gets a list of the file shares for a specific file gateway, or the list of
// file shares that belong to the calling user account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListFileShares for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListFileShares
func (c *StorageGateway) ListFileShares(input *ListFileSharesInput) (*ListFileSharesOutput, error) {
	req, out := c.ListFileSharesRequest(input)
	return out, req.Send()
}

// ListFileSharesWithContext is the same as ListFileShares with the addition of
// the ability to pass a context and additional request options.
//
// See ListFileShares for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListFileSharesWithContext(ctx aws.Context, input *ListFileSharesInput, opts ...request.Option) (*ListFileSharesOutput, error) {
	req, out := c.ListFileSharesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGateways = "ListGateways"

// ListGatewaysRequest generates a "aws/request.Request" representing the
// client's request for the ListGateways operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListGateways for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListGateways method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListGatewaysRequest method.
//    req, resp := client.ListGatewaysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListGateways
func (c *StorageGateway) ListGatewaysRequest(input *ListGatewaysInput) (req *request.Request, output *ListGatewaysOutput) {
	op := &request.Operation{
		Name:       opListGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGatewaysInput{}
	}

	output = &ListGatewaysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGateways API operation for AWS Storage Gateway.
//
// Lists gateways owned by an AWS account in a region specified in the request.
// The returned list is ordered by gateway Amazon Resource Name (ARN).
//
// By default, the operation returns a maximum of 100 gateways. This operation
// supports pagination that allows you to optionally reduce the number of gateways
// returned in a response.
//
// If you have more gateways than are returned in a response (that is, the response
// returns only a truncated list of your gateways), the response contains a
// marker that you can specify in your next request to fetch the next page of
// gateways.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListGateways for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListGateways
func (c *StorageGateway) ListGateways(input *ListGatewaysInput) (*ListGatewaysOutput, error) {
	req, out := c.ListGatewaysRequest(input)
	return out, req.Send()
}

// ListGatewaysWithContext is the same as ListGateways with the addition of
// the ability to pass a context and additional request options.
//
// See ListGateways for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListGatewaysWithContext(ctx aws.Context, input *ListGatewaysInput, opts ...request.Option) (*ListGatewaysOutput, error) {
	req, out := c.ListGatewaysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGatewaysPages iterates over the pages of a ListGateways operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGateways method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGateways operation.
//    pageNum := 0
//    err := client.ListGatewaysPages(params,
//        func(page *ListGatewaysOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) ListGatewaysPages(input *ListGatewaysInput, fn func(*ListGatewaysOutput, bool) bool) error {
	return c.ListGatewaysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGatewaysPagesWithContext same as ListGatewaysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListGatewaysPagesWithContext(ctx aws.Context, input *ListGatewaysInput, fn func(*ListGatewaysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy ListGatewaysInput
			if input != nil {
				inCpy = *input
			}
			req, _ := c.ListGatewaysRequest(&inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListGatewaysOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListLocalDisks = "ListLocalDisks"

// ListLocalDisksRequest generates a "aws/request.Request" representing the
// client's request for the ListLocalDisks operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListLocalDisks for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListLocalDisks method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListLocalDisksRequest method.
//    req, resp := client.ListLocalDisksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListLocalDisks
func (c *StorageGateway) ListLocalDisksRequest(input *ListLocalDisksInput) (req *request.Request, output *ListLocalDisksOutput) {
	op := &request.Operation{
		Name:       opListLocalDisks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListLocalDisksInput{}
	}

	output = &ListLocalDisksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLocalDisks API operation for AWS Storage Gateway.
//
// Returns a list of the gateway's local disks. To specify which gateway to
// describe, you use the Amazon Resource Name (ARN) of the gateway in the body
// of the request.
//
// The request returns a list of all disks, specifying which are configured
// as working storage, cache storage, or stored volume or not configured at
// all. The response includes a DiskStatus field. This field can have a value
// of present (the disk is available to use), missing (the disk is no longer
// connected to the gateway), or mismatch (the disk node is occupied by a disk
// that has incorrect metadata or the disk content is corrupted).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListLocalDisks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListLocalDisks
func (c *StorageGateway) ListLocalDisks(input *ListLocalDisksInput) (*ListLocalDisksOutput, error) {
	req, out := c.ListLocalDisksRequest(input)
	return out, req.Send()
}

// ListLocalDisksWithContext is the same as ListLocalDisks with the addition of
// the ability to pass a context and additional request options.
//
// See ListLocalDisks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListLocalDisksWithContext(ctx aws.Context, input *ListLocalDisksInput, opts ...request.Option) (*ListLocalDisksOutput, error) {
	req, out := c.ListLocalDisksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTagsForResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTagsForResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTagsForResource
func (c *StorageGateway) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Storage Gateway.
//
// Lists the tags that have been added to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTagsForResource
func (c *StorageGateway) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTapes = "ListTapes"

// ListTapesRequest generates a "aws/request.Request" representing the
// client's request for the ListTapes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTapes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTapes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTapesRequest method.
//    req, resp := client.ListTapesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapes
func (c *StorageGateway) ListTapesRequest(input *ListTapesInput) (req *request.Request, output *ListTapesOutput) {
	op := &request.Operation{
		Name:       opListTapes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTapesInput{}
	}

	output = &ListTapesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTapes API operation for AWS Storage Gateway.
//
// Lists virtual tapes in your virtual tape library (VTL) and your virtual tape
// shelf (VTS). You specify the tapes to list by specifying one or more tape
// Amazon Resource Names (ARNs). If you don't specify a tape ARN, the operation
// lists all virtual tapes in both your VTL and VTS.
//
// This operation supports pagination. By default, the operation returns a maximum
// of up to 100 tapes. You can optionally specify the Limit parameter in the
// body to limit the number of tapes in the response. If the number of tapes
// returned in the response is truncated, the response includes a Marker element
// that you can use in your subsequent request to retrieve the next set of tapes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListTapes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapes
func (c *StorageGateway) ListTapes(input *ListTapesInput) (*ListTapesOutput, error) {
	req, out := c.ListTapesRequest(input)
	return out, req.Send()
}

// ListTapesWithContext is the same as ListTapes with the addition of
// the ability to pass a context and additional request options.
//
// See ListTapes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListTapesWithContext(ctx aws.Context, input *ListTapesInput, opts ...request.Option) (*ListTapesOutput, error) {
	req, out := c.ListTapesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVolumeInitiators = "ListVolumeInitiators"

// ListVolumeInitiatorsRequest generates a "aws/request.Request" representing the
// client's request for the ListVolumeInitiators operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListVolumeInitiators for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListVolumeInitiators method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListVolumeInitiatorsRequest method.
//    req, resp := client.ListVolumeInitiatorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumeInitiators
func (c *StorageGateway) ListVolumeInitiatorsRequest(input *ListVolumeInitiatorsInput) (req *request.Request, output *ListVolumeInitiatorsOutput) {
	op := &request.Operation{
		Name:       opListVolumeInitiators,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListVolumeInitiatorsInput{}
	}

	output = &ListVolumeInitiatorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVolumeInitiators API operation for AWS Storage Gateway.
//
// Lists iSCSI initiators that are connected to a volume. You can use this operation
// to determine whether a volume is being used or not.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListVolumeInitiators for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumeInitiators
func (c *StorageGateway) ListVolumeInitiators(input *ListVolumeInitiatorsInput) (*ListVolumeInitiatorsOutput, error) {
	req, out := c.ListVolumeInitiatorsRequest(input)
	return out, req.Send()
}

// ListVolumeInitiatorsWithContext is the same as ListVolumeInitiators with the addition of
// the ability to pass a context and additional request options.
//
// See ListVolumeInitiators for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListVolumeInitiatorsWithContext(ctx aws.Context, input *ListVolumeInitiatorsInput, opts ...request.Option) (*ListVolumeInitiatorsOutput, error) {
	req, out := c.ListVolumeInitiatorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVolumeRecoveryPoints = "ListVolumeRecoveryPoints"

// ListVolumeRecoveryPointsRequest generates a "aws/request.Request" representing the
// client's request for the ListVolumeRecoveryPoints operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListVolumeRecoveryPoints for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListVolumeRecoveryPoints method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListVolumeRecoveryPointsRequest method.
//    req, resp := client.ListVolumeRecoveryPointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumeRecoveryPoints
func (c *StorageGateway) ListVolumeRecoveryPointsRequest(input *ListVolumeRecoveryPointsInput) (req *request.Request, output *ListVolumeRecoveryPointsOutput) {
	op := &request.Operation{
		Name:       opListVolumeRecoveryPoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListVolumeRecoveryPointsInput{}
	}

	output = &ListVolumeRecoveryPointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVolumeRecoveryPoints API operation for AWS Storage Gateway.
//
// Lists the recovery points for a specified gateway. This operation is supported
// only for the gateway-cached volume architecture.
//
// Each gateway-cached volume has one recovery point. A volume recovery point
// is a point in time at which all data of the volume is consistent and from
// which you can create a snapshot. To create a snapshot from a volume recovery
// point use the CreateSnapshotFromVolumeRecoveryPoint operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListVolumeRecoveryPoints for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumeRecoveryPoints
func (c *StorageGateway) ListVolumeRecoveryPoints(input *ListVolumeRecoveryPointsInput) (*ListVolumeRecoveryPointsOutput, error) {
	req, out := c.ListVolumeRecoveryPointsRequest(input)
	return out, req.Send()
}

// ListVolumeRecoveryPointsWithContext is the same as ListVolumeRecoveryPoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListVolumeRecoveryPoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListVolumeRecoveryPointsWithContext(ctx aws.Context, input *ListVolumeRecoveryPointsInput, opts ...request.Option) (*ListVolumeRecoveryPointsOutput, error) {
	req, out := c.ListVolumeRecoveryPointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVolumes = "ListVolumes"

// ListVolumesRequest generates a "aws/request.Request" representing the
// client's request for the ListVolumes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListVolumes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListVolumes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListVolumesRequest method.
//    req, resp := client.ListVolumesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumes
func (c *StorageGateway) ListVolumesRequest(input *ListVolumesInput) (req *request.Request, output *ListVolumesOutput) {
	op := &request.Operation{
		Name:       opListVolumes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVolumesInput{}
	}

	output = &ListVolumesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVolumes API operation for AWS Storage Gateway.
//
// Lists the iSCSI stored volumes of a gateway. Results are sorted by volume
// ARN. The response includes only the volume ARNs. If you want additional volume
// information, use the DescribeStorediSCSIVolumes or the DescribeCachediSCSIVolumes
// API.
//
// The operation supports pagination. By default, the operation returns a maximum
// of up to 100 volumes. You can optionally specify the Limit field in the body
// to limit the number of volumes in the response. If the number of volumes
// returned in the response is truncated, the response includes a Marker field.
// You can use this Marker value in your subsequent request to retrieve the
// next set of volumes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ListVolumes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumes
func (c *StorageGateway) ListVolumes(input *ListVolumesInput) (*ListVolumesOutput, error) {
	req, out := c.ListVolumesRequest(input)
	return out, req.Send()
}

// ListVolumesWithContext is the same as ListVolumes with the addition of
// the ability to pass a context and additional request options.
//
// See ListVolumes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListVolumesWithContext(ctx aws.Context, input *ListVolumesInput, opts ...request.Option) (*ListVolumesOutput, error) {
	req, out := c.ListVolumesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVolumesPages iterates over the pages of a ListVolumes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVolumes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListVolumes operation.
//    pageNum := 0
//    err := client.ListVolumesPages(params,
//        func(page *ListVolumesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *StorageGateway) ListVolumesPages(input *ListVolumesInput, fn func(*ListVolumesOutput, bool) bool) error {
	return c.ListVolumesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVolumesPagesWithContext same as ListVolumesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ListVolumesPagesWithContext(ctx aws.Context, input *ListVolumesInput, fn func(*ListVolumesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy ListVolumesInput
			if input != nil {
				inCpy = *input
			}
			req, _ := c.ListVolumesRequest(&inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListVolumesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opRemoveTagsFromResource = "RemoveTagsFromResource"

// RemoveTagsFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemoveTagsFromResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemoveTagsFromResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemoveTagsFromResourceRequest method.
//    req, resp := client.RemoveTagsFromResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RemoveTagsFromResource
func (c *StorageGateway) RemoveTagsFromResourceRequest(input *RemoveTagsFromResourceInput) (req *request.Request, output *RemoveTagsFromResourceOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromResourceInput{}
	}

	output = &RemoveTagsFromResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveTagsFromResource API operation for AWS Storage Gateway.
//
// Removes one or more tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation RemoveTagsFromResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RemoveTagsFromResource
func (c *StorageGateway) RemoveTagsFromResource(input *RemoveTagsFromResourceInput) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	return out, req.Send()
}

// RemoveTagsFromResourceWithContext is the same as RemoveTagsFromResource with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTagsFromResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) RemoveTagsFromResourceWithContext(ctx aws.Context, input *RemoveTagsFromResourceInput, opts ...request.Option) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetCache = "ResetCache"

// ResetCacheRequest generates a "aws/request.Request" representing the
// client's request for the ResetCache operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ResetCache for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ResetCache method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ResetCacheRequest method.
//    req, resp := client.ResetCacheRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ResetCache
func (c *StorageGateway) ResetCacheRequest(input *ResetCacheInput) (req *request.Request, output *ResetCacheOutput) {
	op := &request.Operation{
		Name:       opResetCache,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetCacheInput{}
	}

	output = &ResetCacheOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResetCache API operation for AWS Storage Gateway.
//
// Resets all cache disks that have encountered a error and makes the disks
// available for reconfiguration as cache storage. If your cache disk encounters
// a error, the gateway prevents read and write operations on virtual tapes
// in the gateway. For example, an error can occur when a disk is corrupted
// or removed from the gateway. When a cache is reset, the gateway loses its
// cache storage. At this point you can reconfigure the disks as cache disks.
//
// If the cache disk you are resetting contains data that has not been uploaded
// to Amazon S3 yet, that data can be lost. After you reset cache disks, there
// will be no configured cache disks left in the gateway, so you must configure
// at least one new cache disk for your gateway to function properly.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ResetCache for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ResetCache
func (c *StorageGateway) ResetCache(input *ResetCacheInput) (*ResetCacheOutput, error) {
	req, out := c.ResetCacheRequest(input)
	return out, req.Send()
}

// ResetCacheWithContext is the same as ResetCache with the addition of
// the ability to pass a context and additional request options.
//
// See ResetCache for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ResetCacheWithContext(ctx aws.Context, input *ResetCacheInput, opts ...request.Option) (*ResetCacheOutput, error) {
	req, out := c.ResetCacheRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRetrieveTapeArchive = "RetrieveTapeArchive"

// RetrieveTapeArchiveRequest generates a "aws/request.Request" representing the
// client's request for the RetrieveTapeArchive operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RetrieveTapeArchive for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RetrieveTapeArchive method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RetrieveTapeArchiveRequest method.
//    req, resp := client.RetrieveTapeArchiveRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RetrieveTapeArchive
func (c *StorageGateway) RetrieveTapeArchiveRequest(input *RetrieveTapeArchiveInput) (req *request.Request, output *RetrieveTapeArchiveOutput) {
	op := &request.Operation{
		Name:       opRetrieveTapeArchive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RetrieveTapeArchiveInput{}
	}

	output = &RetrieveTapeArchiveOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RetrieveTapeArchive API operation for AWS Storage Gateway.
//
// Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a
// gateway-VTL. Virtual tapes archived in the VTS are not associated with any
// gateway. However after a tape is retrieved, it is associated with a gateway,
// even though it is also listed in the VTS.
//
// Once a tape is successfully retrieved to a gateway, it cannot be retrieved
// again to another gateway. You must archive the tape again before you can
// retrieve it to another gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation RetrieveTapeArchive for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RetrieveTapeArchive
func (c *StorageGateway) RetrieveTapeArchive(input *RetrieveTapeArchiveInput) (*RetrieveTapeArchiveOutput, error) {
	req, out := c.RetrieveTapeArchiveRequest(input)
	return out, req.Send()
}

// RetrieveTapeArchiveWithContext is the same as RetrieveTapeArchive with the addition of
// the ability to pass a context and additional request options.
//
// See RetrieveTapeArchive for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) RetrieveTapeArchiveWithContext(ctx aws.Context, input *RetrieveTapeArchiveInput, opts ...request.Option) (*RetrieveTapeArchiveOutput, error) {
	req, out := c.RetrieveTapeArchiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRetrieveTapeRecoveryPoint = "RetrieveTapeRecoveryPoint"

// RetrieveTapeRecoveryPointRequest generates a "aws/request.Request" representing the
// client's request for the RetrieveTapeRecoveryPoint operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RetrieveTapeRecoveryPoint for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RetrieveTapeRecoveryPoint method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RetrieveTapeRecoveryPointRequest method.
//    req, resp := client.RetrieveTapeRecoveryPointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RetrieveTapeRecoveryPoint
func (c *StorageGateway) RetrieveTapeRecoveryPointRequest(input *RetrieveTapeRecoveryPointInput) (req *request.Request, output *RetrieveTapeRecoveryPointOutput) {
	op := &request.Operation{
		Name:       opRetrieveTapeRecoveryPoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RetrieveTapeRecoveryPointInput{}
	}

	output = &RetrieveTapeRecoveryPointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RetrieveTapeRecoveryPoint API operation for AWS Storage Gateway.
//
// Retrieves the recovery point for the specified virtual tape.
//
// A recovery point is a point in time view of a virtual tape at which all the
// data on the tape is consistent. If your gateway crashes, virtual tapes that
// have recovery points can be recovered to a new gateway.
//
// The virtual tape can be retrieved to only one gateway. The retrieved tape
// is read-only. The virtual tape can be retrieved to only a gateway-VTL. There
// is no charge for retrieving recovery points.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation RetrieveTapeRecoveryPoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RetrieveTapeRecoveryPoint
func (c *StorageGateway) RetrieveTapeRecoveryPoint(input *RetrieveTapeRecoveryPointInput) (*RetrieveTapeRecoveryPointOutput, error) {
	req, out := c.RetrieveTapeRecoveryPointRequest(input)
	return out, req.Send()
}

// RetrieveTapeRecoveryPointWithContext is the same as RetrieveTapeRecoveryPoint with the addition of
// the ability to pass a context and additional request options.
//
// See RetrieveTapeRecoveryPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) RetrieveTapeRecoveryPointWithContext(ctx aws.Context, input *RetrieveTapeRecoveryPointInput, opts ...request.Option) (*RetrieveTapeRecoveryPointOutput, error) {
	req, out := c.RetrieveTapeRecoveryPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetLocalConsolePassword = "SetLocalConsolePassword"

// SetLocalConsolePasswordRequest generates a "aws/request.Request" representing the
// client's request for the SetLocalConsolePassword operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetLocalConsolePassword for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetLocalConsolePassword method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetLocalConsolePasswordRequest method.
//    req, resp := client.SetLocalConsolePasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/SetLocalConsolePassword
func (c *StorageGateway) SetLocalConsolePasswordRequest(input *SetLocalConsolePasswordInput) (req *request.Request, output *SetLocalConsolePasswordOutput) {
	op := &request.Operation{
		Name:       opSetLocalConsolePassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetLocalConsolePasswordInput{}
	}

	output = &SetLocalConsolePasswordOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SetLocalConsolePassword API operation for AWS Storage Gateway.
//
// Sets the password for your VM local console. When you log in to the local
// console for the first time, you log in to the VM with the default credentials.
// We recommend that you set a new password. You don't need to know the default
// password to set a new password.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation SetLocalConsolePassword for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/SetLocalConsolePassword
func (c *StorageGateway) SetLocalConsolePassword(input *SetLocalConsolePasswordInput) (*SetLocalConsolePasswordOutput, error) {
	req, out := c.SetLocalConsolePasswordRequest(input)
	return out, req.Send()
}

// SetLocalConsolePasswordWithContext is the same as SetLocalConsolePassword with the addition of
// the ability to pass a context and additional request options.
//
// See SetLocalConsolePassword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) SetLocalConsolePasswordWithContext(ctx aws.Context, input *SetLocalConsolePasswordInput, opts ...request.Option) (*SetLocalConsolePasswordOutput, error) {
	req, out := c.SetLocalConsolePasswordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opShutdownGateway = "ShutdownGateway"

// ShutdownGatewayRequest generates a "aws/request.Request" representing the
// client's request for the ShutdownGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ShutdownGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ShutdownGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ShutdownGatewayRequest method.
//    req, resp := client.ShutdownGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ShutdownGateway
func (c *StorageGateway) ShutdownGatewayRequest(input *ShutdownGatewayInput) (req *request.Request, output *ShutdownGatewayOutput) {
	op := &request.Operation{
		Name:       opShutdownGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ShutdownGatewayInput{}
	}

	output = &ShutdownGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ShutdownGateway API operation for AWS Storage Gateway.
//
// Shuts down a gateway. To specify which gateway to shut down, use the Amazon
// Resource Name (ARN) of the gateway in the body of your request.
//
// The operation shuts down the gateway service component running in the storage
// gateway's virtual machine (VM) and not the VM.
//
// If you want to shut down the VM, it is recommended that you first shut down
// the gateway component in the VM to avoid unpredictable conditions.
//
// After the gateway is shutdown, you cannot call any other API except StartGateway,
// DescribeGatewayInformation, and ListGateways. For more information, see ActivateGateway.
// Your applications cannot read from or write to the gateway's storage volumes,
// and there are no snapshots taken.
//
// When you make a shutdown request, you will get a 200 OK success response
// immediately. However, it might take some time for the gateway to shut down.
// You can call the DescribeGatewayInformation API to check the status. For
// more information, see ActivateGateway.
//
// If do not intend to use the gateway again, you must delete the gateway (using
// DeleteGateway) to no longer pay software charges associated with the gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation ShutdownGateway for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ShutdownGateway
func (c *StorageGateway) ShutdownGateway(input *ShutdownGatewayInput) (*ShutdownGatewayOutput, error) {
	req, out := c.ShutdownGatewayRequest(input)
	return out, req.Send()
}

// ShutdownGatewayWithContext is the same as ShutdownGateway with the addition of
// the ability to pass a context and additional request options.
//
// See ShutdownGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) ShutdownGatewayWithContext(ctx aws.Context, input *ShutdownGatewayInput, opts ...request.Option) (*ShutdownGatewayOutput, error) {
	req, out := c.ShutdownGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartGateway = "StartGateway"

// StartGatewayRequest generates a "aws/request.Request" representing the
// client's request for the StartGateway operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See StartGateway for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the StartGateway method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the StartGatewayRequest method.
//    req, resp := client.StartGatewayRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/StartGateway
func (c *StorageGateway) StartGatewayRequest(input *StartGatewayInput) (req *request.Request, output *StartGatewayOutput) {
	op := &request.Operation{
		Name:       opStartGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartGatewayInput{}
	}

	output = &StartGatewayOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartGateway API operation for AWS Storage Gateway.
//
// Starts a gateway that you previously shut down (see ShutdownGateway). After
// the gateway starts, you can then make other API calls, your applications
// can read from or write to the gateway's storage volumes and you will be able
// to take snapshot backups.
//
// When you make a request, you will get a 200 OK success response immediately.
// However, it might take some time for the gateway to be ready. You should
// call DescribeGatewayInformation and check the status before making any additional
// API calls. For more information, see ActivateGateway.
//
// To specify which gateway to start, use the Amazon Resource Name (ARN) of
// the gateway in your request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation StartGateway for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/StartGateway
func (c *StorageGateway) StartGateway(input *StartGatewayInput) (*StartGatewayOutput, error) {
	req, out := c.StartGatewayRequest(input)
	return out, req.Send()
}

// StartGatewayWithContext is the same as StartGateway with the addition of
// the ability to pass a context and additional request options.
//
// See StartGateway for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) StartGatewayWithContext(ctx aws.Context, input *StartGatewayInput, opts ...request.Option) (*StartGatewayOutput, error) {
	req, out := c.StartGatewayRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBandwidthRateLimit = "UpdateBandwidthRateLimit"

// UpdateBandwidthRateLimitRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBandwidthRateLimit operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateBandwidthRateLimit for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateBandwidthRateLimit method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateBandwidthRateLimitRequest method.
//    req, resp := client.UpdateBandwidthRateLimitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateBandwidthRateLimit
func (c *StorageGateway) UpdateBandwidthRateLimitRequest(input *UpdateBandwidthRateLimitInput) (req *request.Request, output *UpdateBandwidthRateLimitOutput) {
	op := &request.Operation{
		Name:       opUpdateBandwidthRateLimit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateBandwidthRateLimitInput{}
	}

	output = &UpdateBandwidthRateLimitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBandwidthRateLimit API operation for AWS Storage Gateway.
//
// Updates the bandwidth rate limits of a gateway. You can update both the upload
// and download bandwidth rate limit or specify only one of the two. If you
// don't set a bandwidth rate limit, the existing rate limit remains.
//
// By default, a gateway's bandwidth rate limits are not set. If you don't set
// any limit, the gateway does not have any limitations on its bandwidth usage
// and could potentially use the maximum available bandwidth.
//
// To specify which gateway to update, use the Amazon Resource Name (ARN) of
// the gateway in your request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateBandwidthRateLimit for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateBandwidthRateLimit
func (c *StorageGateway) UpdateBandwidthRateLimit(input *UpdateBandwidthRateLimitInput) (*UpdateBandwidthRateLimitOutput, error) {
	req, out := c.UpdateBandwidthRateLimitRequest(input)
	return out, req.Send()
}

// UpdateBandwidthRateLimitWithContext is the same as UpdateBandwidthRateLimit with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBandwidthRateLimit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) UpdateBandwidthRateLimitWithContext(ctx aws.Context, input *UpdateBandwidthRateLimitInput, opts ...request.Option) (*UpdateBandwidthRateLimitOutput, error) {
	req, out := c.UpdateBandwidthRateLimitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateChapCredentials = "UpdateChapCredentials"

// UpdateChapCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateChapCredentials operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateChapCredentials for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateChapCredentials method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateChapCredentialsRequest method.
//    req, resp := client.UpdateChapCredentialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateChapCredentials
func (c *StorageGateway) UpdateChapCredentialsRequest(input *UpdateChapCredentialsInput) (req *request.Request, output *UpdateChapCredentialsOutput) {
	op := &request.Operation{
		Name:       opUpdateChapCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateChapCredentialsInput{}
	}

	output = &UpdateChapCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateChapCredentials API operation for AWS Storage Gateway.
//
// Updates the Challenge-Handshake Authentication Protocol (CHAP) credentials
// for a specified iSCSI target. By default, a gateway does not have CHAP enabled;
// however, for added security, you might use it.
//
// When you update CHAP credentials, all existing connections on the target
// are closed and initiators must reconnect with the new credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateChapCredentials for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateChapCredentials
func (c *StorageGateway) UpdateChapCredentials(input *UpdateChapCredentialsInput) (*UpdateChapCredentialsOutput, error) {
	req, out := c.UpdateChapCredentialsRequest(input)
	return out, req.Send()
}

// UpdateChapCredentialsWithContext is the same as UpdateChapCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateChapCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) UpdateChapCredentialsWithContext(ctx aws.Context, input *UpdateChapCredentialsInput, opts ...request.Option) (*UpdateChapCredentialsOutput, error) {
	req, out := c.UpdateChapCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGatewayInformation = "UpdateGatewayInformation"

// UpdateGatewayInformationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGatewayInformation operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateGatewayInformation for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateGatewayInformation method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateGatewayInformationRequest method.
//    req, resp := client.UpdateGatewayInformationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateGatewayInformation
func (c *StorageGateway) UpdateGatewayInformationRequest(input *UpdateGatewayInformationInput) (req *request.Request, output *UpdateGatewayInformationOutput) {
	op := &request.Operation{
		Name:       opUpdateGatewayInformation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGatewayInformationInput{}
	}

	output = &UpdateGatewayInformationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGatewayInformation API operation for AWS Storage Gateway.
//
// Updates a gateway's metadata, which includes the gateway's name and time
// zone. To specify which gateway to update, use the Amazon Resource Name (ARN)
// of the gateway in your request.
//
// For Gateways activated after September 2, 2015, the gateway's ARN contains
// the gateway ID rather than the gateway name. However, changing the name of
// the gateway has no effect on the gateway's ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateGatewayInformation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateGatewayInformation
func (c *StorageGateway) UpdateGatewayInformation(input *UpdateGatewayInformationInput) (*UpdateGatewayInformationOutput, error) {
	req, out := c.UpdateGatewayInformationRequest(input)
	return out, req.Send()
}

// UpdateGatewayInformationWithContext is the same as UpdateGatewayInformation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGatewayInformation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) UpdateGatewayInformationWithContext(ctx aws.Context, input *UpdateGatewayInformationInput, opts ...request.Option) (*UpdateGatewayInformationOutput, error) {
	req, out := c.UpdateGatewayInformationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGatewaySoftwareNow = "UpdateGatewaySoftwareNow"

// UpdateGatewaySoftwareNowRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGatewaySoftwareNow operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateGatewaySoftwareNow for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateGatewaySoftwareNow method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateGatewaySoftwareNowRequest method.
//    req, resp := client.UpdateGatewaySoftwareNowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateGatewaySoftwareNow
func (c *StorageGateway) UpdateGatewaySoftwareNowRequest(input *UpdateGatewaySoftwareNowInput) (req *request.Request, output *UpdateGatewaySoftwareNowOutput) {
	op := &request.Operation{
		Name:       opUpdateGatewaySoftwareNow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGatewaySoftwareNowInput{}
	}

	output = &UpdateGatewaySoftwareNowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGatewaySoftwareNow API operation for AWS Storage Gateway.
//
// Updates the gateway virtual machine (VM) software. The request immediately
// triggers the software update.
//
// When you make this request, you get a 200 OK success response immediately.
// However, it might take some time for the update to complete. You can call
// DescribeGatewayInformation to verify the gateway is in the STATE_RUNNING
// state.
//
// A software update forces a system restart of your gateway. You can minimize
// the chance of any disruption to your applications by increasing your iSCSI
// Initiators' timeouts. For more information about increasing iSCSI Initiator
// timeouts for Windows and Linux, see Customizing Your Windows iSCSI Settings
// (http://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorWindowsClient.html#CustomizeWindowsiSCSISettings)
// and Customizing Your Linux iSCSI Settings (http://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorRedHatClient.html#CustomizeLinuxiSCSISettings),
// respectively.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateGatewaySoftwareNow for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateGatewaySoftwareNow
func (c *StorageGateway) UpdateGatewaySoftwareNow(input *UpdateGatewaySoftwareNowInput) (*UpdateGatewaySoftwareNowOutput, error) {
	req, out := c.UpdateGatewaySoftwareNowRequest(input)
	return out, req.Send()
}

// UpdateGatewaySoftwareNowWithContext is the same as UpdateGatewaySoftwareNow with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGatewaySoftwareNow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) UpdateGatewaySoftwareNowWithContext(ctx aws.Context, input *UpdateGatewaySoftwareNowInput, opts ...request.Option) (*UpdateGatewaySoftwareNowOutput, error) {
	req, out := c.UpdateGatewaySoftwareNowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMaintenanceStartTime = "UpdateMaintenanceStartTime"

// UpdateMaintenanceStartTimeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMaintenanceStartTime operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateMaintenanceStartTime for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateMaintenanceStartTime method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateMaintenanceStartTimeRequest method.
//    req, resp := client.UpdateMaintenanceStartTimeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateMaintenanceStartTime
func (c *StorageGateway) UpdateMaintenanceStartTimeRequest(input *UpdateMaintenanceStartTimeInput) (req *request.Request, output *UpdateMaintenanceStartTimeOutput) {
	op := &request.Operation{
		Name:       opUpdateMaintenanceStartTime,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMaintenanceStartTimeInput{}
	}

	output = &UpdateMaintenanceStartTimeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMaintenanceStartTime API operation for AWS Storage Gateway.
//
// Updates a gateway's weekly maintenance start time information, including
// day and time of the week. The maintenance time is the time in your gateway's
// time zone.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateMaintenanceStartTime for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateMaintenanceStartTime
func (c *StorageGateway) UpdateMaintenanceStartTime(input *UpdateMaintenanceStartTimeInput) (*UpdateMaintenanceStartTimeOutput, error) {
	req, out := c.UpdateMaintenanceStartTimeRequest(input)
	return out, req.Send()
}

// UpdateMaintenanceStartTimeWithContext is the same as UpdateMaintenanceStartTime with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMaintenanceStartTime for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) UpdateMaintenanceStartTimeWithContext(ctx aws.Context, input *UpdateMaintenanceStartTimeInput, opts ...request.Option) (*UpdateMaintenanceStartTimeOutput, error) {
	req, out := c.UpdateMaintenanceStartTimeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNFSFileShare = "UpdateNFSFileShare"

// UpdateNFSFileShareRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNFSFileShare operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateNFSFileShare for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateNFSFileShare method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateNFSFileShareRequest method.
//    req, resp := client.UpdateNFSFileShareRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateNFSFileShare
func (c *StorageGateway) UpdateNFSFileShareRequest(input *UpdateNFSFileShareInput) (req *request.Request, output *UpdateNFSFileShareOutput) {
	op := &request.Operation{
		Name:       opUpdateNFSFileShare,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateNFSFileShareInput{}
	}

	output = &UpdateNFSFileShareOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateNFSFileShare API operation for AWS Storage Gateway.
//
// Updates a file share.
//
// To leave a file share field unchanged, set the corresponding input field
// to null.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateNFSFileShare for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateNFSFileShare
func (c *StorageGateway) UpdateNFSFileShare(input *UpdateNFSFileShareInput) (*UpdateNFSFileShareOutput, error) {
	req, out := c.UpdateNFSFileShareRequest(input)
	return out, req.Send()
}

// UpdateNFSFileShareWithContext is the same as UpdateNFSFileShare with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNFSFileShare for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) UpdateNFSFileShareWithContext(ctx aws.Context, input *UpdateNFSFileShareInput, opts ...request.Option) (*UpdateNFSFileShareOutput, error) {
	req, out := c.UpdateNFSFileShareRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSnapshotSchedule = "UpdateSnapshotSchedule"

// UpdateSnapshotScheduleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSnapshotSchedule operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateSnapshotSchedule for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateSnapshotSchedule method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateSnapshotScheduleRequest method.
//    req, resp := client.UpdateSnapshotScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSnapshotSchedule
func (c *StorageGateway) UpdateSnapshotScheduleRequest(input *UpdateSnapshotScheduleInput) (req *request.Request, output *UpdateSnapshotScheduleOutput) {
	op := &request.Operation{
		Name:       opUpdateSnapshotSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSnapshotScheduleInput{}
	}

	output = &UpdateSnapshotScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSnapshotSchedule API operation for AWS Storage Gateway.
//
// Updates a snapshot schedule configured for a gateway volume.
//
// The default snapshot schedule for volume is once every 24 hours, starting
// at the creation time of the volume. You can use this API to change the snapshot
// schedule configured for the volume.
//
// In the request you must identify the gateway volume whose snapshot schedule
// you want to update, and the schedule information, including when you want
// the snapshot to begin on a day and the frequency (in hours) of snapshots.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateSnapshotSchedule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSnapshotSchedule
func (c *StorageGateway) UpdateSnapshotSchedule(input *UpdateSnapshotScheduleInput) (*UpdateSnapshotScheduleOutput, error) {
	req, out := c.UpdateSnapshotScheduleRequest(input)
	return out, req.Send()
}

// UpdateSnapshotScheduleWithContext is the same as UpdateSnapshotSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSnapshotSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) UpdateSnapshotScheduleWithContext(ctx aws.Context, input *UpdateSnapshotScheduleInput, opts ...request.Option) (*UpdateSnapshotScheduleOutput, error) {
	req, out := c.UpdateSnapshotScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVTLDeviceType = "UpdateVTLDeviceType"

// UpdateVTLDeviceTypeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVTLDeviceType operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateVTLDeviceType for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateVTLDeviceType method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateVTLDeviceTypeRequest method.
//    req, resp := client.UpdateVTLDeviceTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateVTLDeviceType
func (c *StorageGateway) UpdateVTLDeviceTypeRequest(input *UpdateVTLDeviceTypeInput) (req *request.Request, output *UpdateVTLDeviceTypeOutput) {
	op := &request.Operation{
		Name:       opUpdateVTLDeviceType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateVTLDeviceTypeInput{}
	}

	output = &UpdateVTLDeviceTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVTLDeviceType API operation for AWS Storage Gateway.
//
// Updates the type of medium changer in a gateway-VTL. When you activate a
// gateway-VTL, you select a medium changer type for the gateway-VTL. This operation
// enables you to select a different type of medium changer after a gateway-VTL
// is activated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Storage Gateway's
// API operation UpdateVTLDeviceType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidGatewayRequestException "InvalidGatewayRequestException"
//   An exception occurred because an invalid gateway request was issued to the
//   service. For more information, see the error and message fields.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An internal server error has occurred during the request. For more information,
//   see the error and message fields.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateVTLDeviceType
func (c *StorageGateway) UpdateVTLDeviceType(input *UpdateVTLDeviceTypeInput) (*UpdateVTLDeviceTypeOutput, error) {
	req, out := c.UpdateVTLDeviceTypeRequest(input)
	return out, req.Send()
}

// UpdateVTLDeviceTypeWithContext is the same as UpdateVTLDeviceType with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVTLDeviceType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *StorageGateway) UpdateVTLDeviceTypeWithContext(ctx aws.Context, input *UpdateVTLDeviceTypeInput, opts ...request.Option) (*UpdateVTLDeviceTypeOutput, error) {
	req, out := c.UpdateVTLDeviceTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A JSON object containing one or more of the following fields:
//
//    * ActivateGatewayInput$ActivationKey
//
//    * ActivateGatewayInput$GatewayName
//
//    * ActivateGatewayInput$GatewayRegion
//
//    * ActivateGatewayInput$GatewayTimezone
//
//    * ActivateGatewayInput$GatewayType
//
//    * ActivateGatewayInput$TapeDriveType
//
//    * ActivateGatewayInput$MediumChangerType
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ActivateGatewayInput
type ActivateGatewayInput struct {
	_ struct{} `type:"structure"`

	// Your gateway activation key. You can obtain the activation key by sending
	// an HTTP GET request with redirects enabled to the gateway IP address (port
	// 80). The redirect URL returned in the response provides you the activation
	// key for your gateway in the query string parameter activationKey. It may
	// also include other activation-related parameters, however, these are merely
	// defaults -- the arguments you pass to the ActivateGateway API call determine
	// the actual configuration of your gateway.
	//
	// ActivationKey is a required field
	ActivationKey *string `min:"1" type:"string" required:"true"`

	// The name you configured for your gateway.
	//
	// GatewayName is a required field
	GatewayName *string `min:"2" type:"string" required:"true"`

	// A value that indicates the region where you want to store the snapshot backups.
	// The gateway region specified must be the same region as the region in your
	// Host header in the request. For more information about available regions
	// and endpoints for AWS Storage Gateway, see Regions and Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html#sg_region)
	// in the Amazon Web Services Glossary.
	//
	// Valid Values: "us-east-1", "us-west-1", "us-west-2", "eu-west-1", "eu-central-1",
	// "ap-northeast-1", "ap-northeast-2", "ap-southeast-1", "ap-southeast-2", "sa-east-1"
	//
	// GatewayRegion is a required field
	GatewayRegion *string `min:"1" type:"string" required:"true"`

	// A value that indicates the time zone you want to set for the gateway. The
	// time zone is used, for example, for scheduling snapshots and your gateway's
	// maintenance schedule.
	//
	// GatewayTimezone is a required field
	GatewayTimezone *string `min:"3" type:"string" required:"true"`

	// A value that defines the type of gateway to activate. The type specified
	// is critical to all later functions of the gateway and cannot be changed after
	// activation. The default value is STORED.
	GatewayType *string `min:"2" type:"string"`

	// The value that indicates the type of medium changer to use for gateway-VTL.
	// This field is optional.
	//
	// Valid Values: "STK-L700", "AWS-Gateway-VTL"
	MediumChangerType *string `min:"2" type:"string"`

	// The value that indicates the type of tape drive to use for gateway-VTL. This
	// field is optional.
	//
	// Valid Values: "IBM-ULT3580-TD5"
	TapeDriveType *string `min:"2" type:"string"`
}

// String returns the string representation
func (s ActivateGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivateGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActivateGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActivateGatewayInput"}
	if s.ActivationKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivationKey"))
	}
	if s.ActivationKey != nil && len(*s.ActivationKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActivationKey", 1))
	}
	if s.GatewayName == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayName"))
	}
	if s.GatewayName != nil && len(*s.GatewayName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayName", 2))
	}
	if s.GatewayRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayRegion"))
	}
	if s.GatewayRegion != nil && len(*s.GatewayRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayRegion", 1))
	}
	if s.GatewayTimezone == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayTimezone"))
	}
	if s.GatewayTimezone != nil && len(*s.GatewayTimezone) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayTimezone", 3))
	}
	if s.GatewayType != nil && len(*s.GatewayType) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayType", 2))
	}
	if s.MediumChangerType != nil && len(*s.MediumChangerType) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("MediumChangerType", 2))
	}
	if s.TapeDriveType != nil && len(*s.TapeDriveType) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("TapeDriveType", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivationKey sets the ActivationKey field's value.
func (s *ActivateGatewayInput) SetActivationKey(v string) *ActivateGatewayInput {
	s.ActivationKey = &v
	return s
}

// SetGatewayName sets the GatewayName field's value.
func (s *ActivateGatewayInput) SetGatewayName(v string) *ActivateGatewayInput {
	s.GatewayName = &v
	return s
}

// SetGatewayRegion sets the GatewayRegion field's value.
func (s *ActivateGatewayInput) SetGatewayRegion(v string) *ActivateGatewayInput {
	s.GatewayRegion = &v
	return s
}

// SetGatewayTimezone sets the GatewayTimezone field's value.
func (s *ActivateGatewayInput) SetGatewayTimezone(v string) *ActivateGatewayInput {
	s.GatewayTimezone = &v
	return s
}

// SetGatewayType sets the GatewayType field's value.
func (s *ActivateGatewayInput) SetGatewayType(v string) *ActivateGatewayInput {
	s.GatewayType = &v
	return s
}

// SetMediumChangerType sets the MediumChangerType field's value.
func (s *ActivateGatewayInput) SetMediumChangerType(v string) *ActivateGatewayInput {
	s.MediumChangerType = &v
	return s
}

// SetTapeDriveType sets the TapeDriveType field's value.
func (s *ActivateGatewayInput) SetTapeDriveType(v string) *ActivateGatewayInput {
	s.TapeDriveType = &v
	return s
}

// AWS Storage Gateway returns the Amazon Resource Name (ARN) of the activated
// gateway. It is a string made of information such as your account, gateway
// name, and region. This ARN is used to reference the gateway in other API
// operations as well as resource-based authorization.
//
// For gateways activated prior to September 02, 2015 the gateway ARN contains
// the gateway name rather than the gateway id. Changing the name of the gateway
// has no effect on the gateway ARN.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ActivateGatewayOutput
type ActivateGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s ActivateGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivateGatewayOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ActivateGatewayOutput) SetGatewayARN(v string) *ActivateGatewayOutput {
	s.GatewayARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddCacheInput
type AddCacheInput struct {
	_ struct{} `type:"structure"`

	// DiskIds is a required field
	DiskIds []*string `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s AddCacheInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCacheInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddCacheInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddCacheInput"}
	if s.DiskIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskIds"))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskIds sets the DiskIds field's value.
func (s *AddCacheInput) SetDiskIds(v []*string) *AddCacheInput {
	s.DiskIds = v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *AddCacheInput) SetGatewayARN(v string) *AddCacheInput {
	s.GatewayARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddCacheOutput
type AddCacheOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s AddCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCacheOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *AddCacheOutput) SetGatewayARN(v string) *AddCacheOutput {
	s.GatewayARN = &v
	return s
}

// AddTagsToResourceInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddTagsToResourceInput
type AddTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource you want to add tags to.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"50" type:"string" required:"true"`

	// The key-value pair that represents the tag you want to add to the resource.
	// The value can be an empty string.
	//
	// Valid characters for key and value are letters, spaces, and numbers representable
	// in UTF-8 format, and the following special characters: + - = . _ : / @.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 50))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *AddTagsToResourceInput) SetResourceARN(v string) *AddTagsToResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsToResourceInput) SetTags(v []*Tag) *AddTagsToResourceInput {
	s.Tags = v
	return s
}

// AddTagsToResourceOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddTagsToResourceOutput
type AddTagsToResourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource you want to add tags to.
	ResourceARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s AddTagsToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceOutput) GoString() string {
	return s.String()
}

// SetResourceARN sets the ResourceARN field's value.
func (s *AddTagsToResourceOutput) SetResourceARN(v string) *AddTagsToResourceOutput {
	s.ResourceARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddUploadBufferInput
type AddUploadBufferInput struct {
	_ struct{} `type:"structure"`

	// DiskIds is a required field
	DiskIds []*string `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s AddUploadBufferInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddUploadBufferInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddUploadBufferInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddUploadBufferInput"}
	if s.DiskIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskIds"))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskIds sets the DiskIds field's value.
func (s *AddUploadBufferInput) SetDiskIds(v []*string) *AddUploadBufferInput {
	s.DiskIds = v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *AddUploadBufferInput) SetGatewayARN(v string) *AddUploadBufferInput {
	s.GatewayARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddUploadBufferOutput
type AddUploadBufferOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s AddUploadBufferOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddUploadBufferOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *AddUploadBufferOutput) SetGatewayARN(v string) *AddUploadBufferOutput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing one or more of the following fields:
//
//    * AddWorkingStorageInput$DiskIds
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddWorkingStorageInput
type AddWorkingStorageInput struct {
	_ struct{} `type:"structure"`

	// An array of strings that identify disks that are to be configured as working
	// storage. Each string have a minimum length of 1 and maximum length of 300.
	// You can get the disk IDs from the ListLocalDisks API.
	//
	// DiskIds is a required field
	DiskIds []*string `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s AddWorkingStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddWorkingStorageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddWorkingStorageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddWorkingStorageInput"}
	if s.DiskIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskIds"))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskIds sets the DiskIds field's value.
func (s *AddWorkingStorageInput) SetDiskIds(v []*string) *AddWorkingStorageInput {
	s.DiskIds = v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *AddWorkingStorageInput) SetGatewayARN(v string) *AddWorkingStorageInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the of the gateway for which working storage was
// configured.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/AddWorkingStorageOutput
type AddWorkingStorageOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s AddWorkingStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddWorkingStorageOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *AddWorkingStorageOutput) SetGatewayARN(v string) *AddWorkingStorageOutput {
	s.GatewayARN = &v
	return s
}

// Describes an iSCSI cached volume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CachediSCSIVolume
type CachediSCSIVolume struct {
	_ struct{} `type:"structure"`

	CreatedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// If the cached volume was created from a snapshot, this field contains the
	// snapshot ID used, e.g. snap-78e22663. Otherwise, this field is not included.
	SourceSnapshotId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the storage volume.
	VolumeARN *string `min:"50" type:"string"`

	// The unique identifier of the volume, e.g. vol-AE4B946D.
	VolumeId *string `min:"12" type:"string"`

	// Represents the percentage complete if the volume is restoring or bootstrapping
	// that represents the percent of data transferred. This field does not appear
	// in the response if the cached volume is not restoring or bootstrapping.
	VolumeProgress *float64 `type:"double"`

	// The size of the volume in bytes.
	VolumeSizeInBytes *int64 `type:"long"`

	// One of the VolumeStatus values that indicates the state of the storage volume.
	VolumeStatus *string `min:"3" type:"string"`

	// One of the VolumeType enumeration values that describes the type of the volume.
	VolumeType *string `min:"3" type:"string"`

	// An VolumeiSCSIAttributes object that represents a collection of iSCSI attributes
	// for one stored volume.
	VolumeiSCSIAttributes *VolumeiSCSIAttributes `type:"structure"`
}

// String returns the string representation
func (s CachediSCSIVolume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CachediSCSIVolume) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *CachediSCSIVolume) SetCreatedDate(v time.Time) *CachediSCSIVolume {
	s.CreatedDate = &v
	return s
}

// SetSourceSnapshotId sets the SourceSnapshotId field's value.
func (s *CachediSCSIVolume) SetSourceSnapshotId(v string) *CachediSCSIVolume {
	s.SourceSnapshotId = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *CachediSCSIVolume) SetVolumeARN(v string) *CachediSCSIVolume {
	s.VolumeARN = &v
	return s
}

// SetVolumeId sets the VolumeId field's value.
func (s *CachediSCSIVolume) SetVolumeId(v string) *CachediSCSIVolume {
	s.VolumeId = &v
	return s
}

// SetVolumeProgress sets the VolumeProgress field's value.
func (s *CachediSCSIVolume) SetVolumeProgress(v float64) *CachediSCSIVolume {
	s.VolumeProgress = &v
	return s
}

// SetVolumeSizeInBytes sets the VolumeSizeInBytes field's value.
func (s *CachediSCSIVolume) SetVolumeSizeInBytes(v int64) *CachediSCSIVolume {
	s.VolumeSizeInBytes = &v
	return s
}

// SetVolumeStatus sets the VolumeStatus field's value.
func (s *CachediSCSIVolume) SetVolumeStatus(v string) *CachediSCSIVolume {
	s.VolumeStatus = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *CachediSCSIVolume) SetVolumeType(v string) *CachediSCSIVolume {
	s.VolumeType = &v
	return s
}

// SetVolumeiSCSIAttributes sets the VolumeiSCSIAttributes field's value.
func (s *CachediSCSIVolume) SetVolumeiSCSIAttributes(v *VolumeiSCSIAttributes) *CachediSCSIVolume {
	s.VolumeiSCSIAttributes = v
	return s
}

// CancelArchivalInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CancelArchivalInput
type CancelArchivalInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape you want to cancel archiving
	// for.
	//
	// TapeARN is a required field
	TapeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelArchivalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelArchivalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelArchivalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelArchivalInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.TapeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeARN"))
	}
	if s.TapeARN != nil && len(*s.TapeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TapeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *CancelArchivalInput) SetGatewayARN(v string) *CancelArchivalInput {
	s.GatewayARN = &v
	return s
}

// SetTapeARN sets the TapeARN field's value.
func (s *CancelArchivalInput) SetTapeARN(v string) *CancelArchivalInput {
	s.TapeARN = &v
	return s
}

// CancelArchivalOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CancelArchivalOutput
type CancelArchivalOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the virtual tape for which archiving was
	// canceled.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s CancelArchivalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelArchivalOutput) GoString() string {
	return s.String()
}

// SetTapeARN sets the TapeARN field's value.
func (s *CancelArchivalOutput) SetTapeARN(v string) *CancelArchivalOutput {
	s.TapeARN = &v
	return s
}

// CancelRetrievalInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CancelRetrievalInput
type CancelRetrievalInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape you want to cancel retrieval
	// for.
	//
	// TapeARN is a required field
	TapeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelRetrievalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelRetrievalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelRetrievalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelRetrievalInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.TapeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeARN"))
	}
	if s.TapeARN != nil && len(*s.TapeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TapeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *CancelRetrievalInput) SetGatewayARN(v string) *CancelRetrievalInput {
	s.GatewayARN = &v
	return s
}

// SetTapeARN sets the TapeARN field's value.
func (s *CancelRetrievalInput) SetTapeARN(v string) *CancelRetrievalInput {
	s.TapeARN = &v
	return s
}

// CancelRetrievalOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CancelRetrievalOutput
type CancelRetrievalOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the virtual tape for which retrieval was
	// canceled.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s CancelRetrievalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelRetrievalOutput) GoString() string {
	return s.String()
}

// SetTapeARN sets the TapeARN field's value.
func (s *CancelRetrievalOutput) SetTapeARN(v string) *CancelRetrievalOutput {
	s.TapeARN = &v
	return s
}

// Describes Challenge-Handshake Authentication Protocol (CHAP) information
// that supports authentication between your gateway and iSCSI initiators.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ChapInfo
type ChapInfo struct {
	_ struct{} `type:"structure"`

	// The iSCSI initiator that connects to the target.
	InitiatorName *string `min:"1" type:"string"`

	// The secret key that the initiator (for example, the Windows client) must
	// provide to participate in mutual CHAP with the target.
	SecretToAuthenticateInitiator *string `min:"1" type:"string"`

	// The secret key that the target must provide to participate in mutual CHAP
	// with the initiator (e.g. Windows client).
	SecretToAuthenticateTarget *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the volume.
	//
	// Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens
	// (-).
	TargetARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s ChapInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChapInfo) GoString() string {
	return s.String()
}

// SetInitiatorName sets the InitiatorName field's value.
func (s *ChapInfo) SetInitiatorName(v string) *ChapInfo {
	s.InitiatorName = &v
	return s
}

// SetSecretToAuthenticateInitiator sets the SecretToAuthenticateInitiator field's value.
func (s *ChapInfo) SetSecretToAuthenticateInitiator(v string) *ChapInfo {
	s.SecretToAuthenticateInitiator = &v
	return s
}

// SetSecretToAuthenticateTarget sets the SecretToAuthenticateTarget field's value.
func (s *ChapInfo) SetSecretToAuthenticateTarget(v string) *ChapInfo {
	s.SecretToAuthenticateTarget = &v
	return s
}

// SetTargetARN sets the TargetARN field's value.
func (s *ChapInfo) SetTargetARN(v string) *ChapInfo {
	s.TargetARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateCachediSCSIVolumeInput
type CreateCachediSCSIVolumeInput struct {
	_ struct{} `type:"structure"`

	// ClientToken is a required field
	ClientToken *string `min:"5" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// NetworkInterfaceId is a required field
	NetworkInterfaceId *string `type:"string" required:"true"`

	SnapshotId *string `type:"string"`

	// The ARN for an existing volume. Specifying this ARN makes the new volume
	// into an exact copy of the specified existing volume's latest recovery point.
	// The VolumeSizeInBytes value for this new volume must be equal to or larger
	// than the size of the existing volume, in bytes.
	SourceVolumeARN *string `min:"50" type:"string"`

	// TargetName is a required field
	TargetName *string `min:"1" type:"string" required:"true"`

	// VolumeSizeInBytes is a required field
	VolumeSizeInBytes *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s CreateCachediSCSIVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCachediSCSIVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCachediSCSIVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCachediSCSIVolumeInput"}
	if s.ClientToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 5))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.NetworkInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkInterfaceId"))
	}
	if s.SourceVolumeARN != nil && len(*s.SourceVolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("SourceVolumeARN", 50))
	}
	if s.TargetName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetName"))
	}
	if s.TargetName != nil && len(*s.TargetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetName", 1))
	}
	if s.VolumeSizeInBytes == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeSizeInBytes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateCachediSCSIVolumeInput) SetClientToken(v string) *CreateCachediSCSIVolumeInput {
	s.ClientToken = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *CreateCachediSCSIVolumeInput) SetGatewayARN(v string) *CreateCachediSCSIVolumeInput {
	s.GatewayARN = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *CreateCachediSCSIVolumeInput) SetNetworkInterfaceId(v string) *CreateCachediSCSIVolumeInput {
	s.NetworkInterfaceId = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *CreateCachediSCSIVolumeInput) SetSnapshotId(v string) *CreateCachediSCSIVolumeInput {
	s.SnapshotId = &v
	return s
}

// SetSourceVolumeARN sets the SourceVolumeARN field's value.
func (s *CreateCachediSCSIVolumeInput) SetSourceVolumeARN(v string) *CreateCachediSCSIVolumeInput {
	s.SourceVolumeARN = &v
	return s
}

// SetTargetName sets the TargetName field's value.
func (s *CreateCachediSCSIVolumeInput) SetTargetName(v string) *CreateCachediSCSIVolumeInput {
	s.TargetName = &v
	return s
}

// SetVolumeSizeInBytes sets the VolumeSizeInBytes field's value.
func (s *CreateCachediSCSIVolumeInput) SetVolumeSizeInBytes(v int64) *CreateCachediSCSIVolumeInput {
	s.VolumeSizeInBytes = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateCachediSCSIVolumeOutput
type CreateCachediSCSIVolumeOutput struct {
	_ struct{} `type:"structure"`

	TargetARN *string `min:"50" type:"string"`

	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s CreateCachediSCSIVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCachediSCSIVolumeOutput) GoString() string {
	return s.String()
}

// SetTargetARN sets the TargetARN field's value.
func (s *CreateCachediSCSIVolumeOutput) SetTargetARN(v string) *CreateCachediSCSIVolumeOutput {
	s.TargetARN = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *CreateCachediSCSIVolumeOutput) SetVolumeARN(v string) *CreateCachediSCSIVolumeOutput {
	s.VolumeARN = &v
	return s
}

// CreateNFSFileShareInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateNFSFileShareInput
type CreateNFSFileShareInput struct {
	_ struct{} `type:"structure"`

	// The list of clients that are allowed to access the file gateway. The list
	// must contain either valid IP addresses or valid CIDR blocks.
	ClientList []*string `min:"1" type:"list"`

	// A unique string value that you supply that is used by file gateway to ensure
	// idempotent file share creation.
	//
	// ClientToken is a required field
	ClientToken *string `min:"5" type:"string" required:"true"`

	// The default storage class for objects put into an Amazon S3 bucket by file
	// gateway. Possible values are S3_STANDARD or S3_STANDARD_IA. If this field
	// is not populated, the default value S3_STANDARD is used. Optional.
	DefaultStorageClass *string `min:"5" type:"string"`

	// The Amazon Resource Name (ARN) of the file gateway on which you want to create
	// a file share.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// True to use Amazon S3 server side encryption with your own AWS KMS key, or
	// false to use a key managed by Amazon S3. Optional.
	KMSEncrypted *bool `type:"boolean"`

	// The KMS key used for Amazon S3 server side encryption. This value can only
	// be set when KmsEncrypted is true. Optional.
	KMSKey *string `min:"20" type:"string"`

	// The ARN of the backend storage used for storing file data.
	//
	// LocationARN is a required field
	LocationARN *string `min:"16" type:"string" required:"true"`

	// File share default values. Optional.
	NFSFileShareDefaults *NFSFileShareDefaults `type:"structure"`

	// The ARN of the AWS Identity and Access Management (IAM) role that a file
	// gateway assumes when it accesses the underlying storage.
	//
	// Role is a required field
	Role *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateNFSFileShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNFSFileShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNFSFileShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNFSFileShareInput"}
	if s.ClientList != nil && len(s.ClientList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientList", 1))
	}
	if s.ClientToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 5))
	}
	if s.DefaultStorageClass != nil && len(*s.DefaultStorageClass) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultStorageClass", 5))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.KMSKey != nil && len(*s.KMSKey) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KMSKey", 20))
	}
	if s.LocationARN == nil {
		invalidParams.Add(request.NewErrParamRequired("LocationARN"))
	}
	if s.LocationARN != nil && len(*s.LocationARN) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("LocationARN", 16))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.Role != nil && len(*s.Role) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Role", 20))
	}
	if s.NFSFileShareDefaults != nil {
		if err := s.NFSFileShareDefaults.Validate(); err != nil {
			invalidParams.AddNested("NFSFileShareDefaults", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientList sets the ClientList field's value.
func (s *CreateNFSFileShareInput) SetClientList(v []*string) *CreateNFSFileShareInput {
	s.ClientList = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateNFSFileShareInput) SetClientToken(v string) *CreateNFSFileShareInput {
	s.ClientToken = &v
	return s
}

// SetDefaultStorageClass sets the DefaultStorageClass field's value.
func (s *CreateNFSFileShareInput) SetDefaultStorageClass(v string) *CreateNFSFileShareInput {
	s.DefaultStorageClass = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *CreateNFSFileShareInput) SetGatewayARN(v string) *CreateNFSFileShareInput {
	s.GatewayARN = &v
	return s
}

// SetKMSEncrypted sets the KMSEncrypted field's value.
func (s *CreateNFSFileShareInput) SetKMSEncrypted(v bool) *CreateNFSFileShareInput {
	s.KMSEncrypted = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *CreateNFSFileShareInput) SetKMSKey(v string) *CreateNFSFileShareInput {
	s.KMSKey = &v
	return s
}

// SetLocationARN sets the LocationARN field's value.
func (s *CreateNFSFileShareInput) SetLocationARN(v string) *CreateNFSFileShareInput {
	s.LocationARN = &v
	return s
}

// SetNFSFileShareDefaults sets the NFSFileShareDefaults field's value.
func (s *CreateNFSFileShareInput) SetNFSFileShareDefaults(v *NFSFileShareDefaults) *CreateNFSFileShareInput {
	s.NFSFileShareDefaults = v
	return s
}

// SetRole sets the Role field's value.
func (s *CreateNFSFileShareInput) SetRole(v string) *CreateNFSFileShareInput {
	s.Role = &v
	return s
}

// CreateNFSFileShareOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateNFSFileShareOutput
type CreateNFSFileShareOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the newly created file share.
	FileShareARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s CreateNFSFileShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNFSFileShareOutput) GoString() string {
	return s.String()
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *CreateNFSFileShareOutput) SetFileShareARN(v string) *CreateNFSFileShareOutput {
	s.FileShareARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSnapshotFromVolumeRecoveryPointInput
type CreateSnapshotFromVolumeRecoveryPointInput struct {
	_ struct{} `type:"structure"`

	// SnapshotDescription is a required field
	SnapshotDescription *string `min:"1" type:"string" required:"true"`

	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSnapshotFromVolumeRecoveryPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotFromVolumeRecoveryPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSnapshotFromVolumeRecoveryPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSnapshotFromVolumeRecoveryPointInput"}
	if s.SnapshotDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotDescription"))
	}
	if s.SnapshotDescription != nil && len(*s.SnapshotDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotDescription", 1))
	}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnapshotDescription sets the SnapshotDescription field's value.
func (s *CreateSnapshotFromVolumeRecoveryPointInput) SetSnapshotDescription(v string) *CreateSnapshotFromVolumeRecoveryPointInput {
	s.SnapshotDescription = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *CreateSnapshotFromVolumeRecoveryPointInput) SetVolumeARN(v string) *CreateSnapshotFromVolumeRecoveryPointInput {
	s.VolumeARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSnapshotFromVolumeRecoveryPointOutput
type CreateSnapshotFromVolumeRecoveryPointOutput struct {
	_ struct{} `type:"structure"`

	SnapshotId *string `type:"string"`

	VolumeARN *string `min:"50" type:"string"`

	VolumeRecoveryPointTime *string `type:"string"`
}

// String returns the string representation
func (s CreateSnapshotFromVolumeRecoveryPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotFromVolumeRecoveryPointOutput) GoString() string {
	return s.String()
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *CreateSnapshotFromVolumeRecoveryPointOutput) SetSnapshotId(v string) *CreateSnapshotFromVolumeRecoveryPointOutput {
	s.SnapshotId = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *CreateSnapshotFromVolumeRecoveryPointOutput) SetVolumeARN(v string) *CreateSnapshotFromVolumeRecoveryPointOutput {
	s.VolumeARN = &v
	return s
}

// SetVolumeRecoveryPointTime sets the VolumeRecoveryPointTime field's value.
func (s *CreateSnapshotFromVolumeRecoveryPointOutput) SetVolumeRecoveryPointTime(v string) *CreateSnapshotFromVolumeRecoveryPointOutput {
	s.VolumeRecoveryPointTime = &v
	return s
}

// A JSON object containing one or more of the following fields:
//
//    * CreateSnapshotInput$SnapshotDescription
//
//    * CreateSnapshotInput$VolumeARN
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSnapshotInput
type CreateSnapshotInput struct {
	_ struct{} `type:"structure"`

	// Textual description of the snapshot that appears in the Amazon EC2 console,
	// Elastic Block Store snapshots panel in the Description field, and in the
	// AWS Storage Gateway snapshot Details pane, Description field
	//
	// SnapshotDescription is a required field
	SnapshotDescription *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes.
	//
	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSnapshotInput"}
	if s.SnapshotDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotDescription"))
	}
	if s.SnapshotDescription != nil && len(*s.SnapshotDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotDescription", 1))
	}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnapshotDescription sets the SnapshotDescription field's value.
func (s *CreateSnapshotInput) SetSnapshotDescription(v string) *CreateSnapshotInput {
	s.SnapshotDescription = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *CreateSnapshotInput) SetVolumeARN(v string) *CreateSnapshotInput {
	s.VolumeARN = &v
	return s
}

// A JSON object containing the following fields:
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateSnapshotOutput
type CreateSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The snapshot ID that is used to refer to the snapshot in future operations
	// such as describing snapshots (Amazon Elastic Compute Cloud API DescribeSnapshots)
	// or creating a volume from a snapshot (CreateStorediSCSIVolume).
	SnapshotId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the volume of which the snapshot was taken.
	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s CreateSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *CreateSnapshotOutput) SetSnapshotId(v string) *CreateSnapshotOutput {
	s.SnapshotId = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *CreateSnapshotOutput) SetVolumeARN(v string) *CreateSnapshotOutput {
	s.VolumeARN = &v
	return s
}

// A JSON object containing one or more of the following fields:
//
//    * CreateStorediSCSIVolumeInput$DiskId
//
//    * CreateStorediSCSIVolumeInput$NetworkInterfaceId
//
//    * CreateStorediSCSIVolumeInput$PreserveExistingData
//
//    * CreateStorediSCSIVolumeInput$SnapshotId
//
//    * CreateStorediSCSIVolumeInput$TargetName
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateStorediSCSIVolumeInput
type CreateStorediSCSIVolumeInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the gateway local disk that is configured as a
	// stored volume. Use ListLocalDisks (http://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html)
	// to list disk IDs for a gateway.
	//
	// DiskId is a required field
	DiskId *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The network interface of the gateway on which to expose the iSCSI target.
	// Only IPv4 addresses are accepted. Use DescribeGatewayInformation to get a
	// list of the network interfaces available on a gateway.
	//
	// Valid Values: A valid IP address.
	//
	// NetworkInterfaceId is a required field
	NetworkInterfaceId *string `type:"string" required:"true"`

	// Specify this field as true if you want to preserve the data on the local
	// disk. Otherwise, specifying this field as false creates an empty volume.
	//
	// Valid Values: true, false
	//
	// PreserveExistingData is a required field
	PreserveExistingData *bool `type:"boolean" required:"true"`

	// The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the
	// new stored volume. Specify this field if you want to create the iSCSI storage
	// volume from a snapshot otherwise do not include this field. To list snapshots
	// for your account use DescribeSnapshots (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html)
	// in the Amazon Elastic Compute Cloud API Reference.
	SnapshotId *string `type:"string"`

	// The name of the iSCSI target used by initiators to connect to the target
	// and as a suffix for the target ARN. For example, specifying TargetName as
	// myvolume results in the target ARN of arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume.
	// The target name must be unique across all volumes of a gateway.
	//
	// TargetName is a required field
	TargetName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateStorediSCSIVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStorediSCSIVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStorediSCSIVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStorediSCSIVolumeInput"}
	if s.DiskId == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskId"))
	}
	if s.DiskId != nil && len(*s.DiskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DiskId", 1))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.NetworkInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkInterfaceId"))
	}
	if s.PreserveExistingData == nil {
		invalidParams.Add(request.NewErrParamRequired("PreserveExistingData"))
	}
	if s.TargetName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetName"))
	}
	if s.TargetName != nil && len(*s.TargetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskId sets the DiskId field's value.
func (s *CreateStorediSCSIVolumeInput) SetDiskId(v string) *CreateStorediSCSIVolumeInput {
	s.DiskId = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *CreateStorediSCSIVolumeInput) SetGatewayARN(v string) *CreateStorediSCSIVolumeInput {
	s.GatewayARN = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *CreateStorediSCSIVolumeInput) SetNetworkInterfaceId(v string) *CreateStorediSCSIVolumeInput {
	s.NetworkInterfaceId = &v
	return s
}

// SetPreserveExistingData sets the PreserveExistingData field's value.
func (s *CreateStorediSCSIVolumeInput) SetPreserveExistingData(v bool) *CreateStorediSCSIVolumeInput {
	s.PreserveExistingData = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *CreateStorediSCSIVolumeInput) SetSnapshotId(v string) *CreateStorediSCSIVolumeInput {
	s.SnapshotId = &v
	return s
}

// SetTargetName sets the TargetName field's value.
func (s *CreateStorediSCSIVolumeInput) SetTargetName(v string) *CreateStorediSCSIVolumeInput {
	s.TargetName = &v
	return s
}

// A JSON object containing the following fields:
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateStorediSCSIVolumeOutput
type CreateStorediSCSIVolumeOutput struct {
	_ struct{} `type:"structure"`

	// he Amazon Resource Name (ARN) of the volume target that includes the iSCSI
	// name that initiators can use to connect to the target.
	TargetARN *string `min:"50" type:"string"`

	// The Amazon Resource Name (ARN) of the configured volume.
	VolumeARN *string `min:"50" type:"string"`

	// The size of the volume in bytes.
	VolumeSizeInBytes *int64 `type:"long"`
}

// String returns the string representation
func (s CreateStorediSCSIVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStorediSCSIVolumeOutput) GoString() string {
	return s.String()
}

// SetTargetARN sets the TargetARN field's value.
func (s *CreateStorediSCSIVolumeOutput) SetTargetARN(v string) *CreateStorediSCSIVolumeOutput {
	s.TargetARN = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *CreateStorediSCSIVolumeOutput) SetVolumeARN(v string) *CreateStorediSCSIVolumeOutput {
	s.VolumeARN = &v
	return s
}

// SetVolumeSizeInBytes sets the VolumeSizeInBytes field's value.
func (s *CreateStorediSCSIVolumeOutput) SetVolumeSizeInBytes(v int64) *CreateStorediSCSIVolumeOutput {
	s.VolumeSizeInBytes = &v
	return s
}

// CreateTapeWithBarcodeInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapeWithBarcodeInput
type CreateTapeWithBarcodeInput struct {
	_ struct{} `type:"structure"`

	// The unique Amazon Resource Name (ARN) that represents the gateway to associate
	// the virtual tape with. Use the ListGateways operation to return a list of
	// gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The barcode that you want to assign to the tape.
	//
	// TapeBarcode is a required field
	TapeBarcode *string `min:"7" type:"string" required:"true"`

	// The size, in bytes, of the virtual tape that you want to create.
	//
	// The size must be aligned by gigabyte (1024*1024*1024 byte).
	//
	// TapeSizeInBytes is a required field
	TapeSizeInBytes *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s CreateTapeWithBarcodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTapeWithBarcodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTapeWithBarcodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTapeWithBarcodeInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.TapeBarcode == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeBarcode"))
	}
	if s.TapeBarcode != nil && len(*s.TapeBarcode) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("TapeBarcode", 7))
	}
	if s.TapeSizeInBytes == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeSizeInBytes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *CreateTapeWithBarcodeInput) SetGatewayARN(v string) *CreateTapeWithBarcodeInput {
	s.GatewayARN = &v
	return s
}

// SetTapeBarcode sets the TapeBarcode field's value.
func (s *CreateTapeWithBarcodeInput) SetTapeBarcode(v string) *CreateTapeWithBarcodeInput {
	s.TapeBarcode = &v
	return s
}

// SetTapeSizeInBytes sets the TapeSizeInBytes field's value.
func (s *CreateTapeWithBarcodeInput) SetTapeSizeInBytes(v int64) *CreateTapeWithBarcodeInput {
	s.TapeSizeInBytes = &v
	return s
}

// CreateTapeOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapeWithBarcodeOutput
type CreateTapeWithBarcodeOutput struct {
	_ struct{} `type:"structure"`

	// A unique Amazon Resource Name (ARN) that represents the virtual tape that
	// was created.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s CreateTapeWithBarcodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTapeWithBarcodeOutput) GoString() string {
	return s.String()
}

// SetTapeARN sets the TapeARN field's value.
func (s *CreateTapeWithBarcodeOutput) SetTapeARN(v string) *CreateTapeWithBarcodeOutput {
	s.TapeARN = &v
	return s
}

// CreateTapesInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapesInput
type CreateTapesInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier that you use to retry a request. If you retry a request,
	// use the same ClientToken you specified in the initial request.
	//
	// Using the same ClientToken prevents creating the tape multiple times.
	//
	// ClientToken is a required field
	ClientToken *string `min:"5" type:"string" required:"true"`

	// The unique Amazon Resource Name (ARN) that represents the gateway to associate
	// the virtual tapes with. Use the ListGateways operation to return a list of
	// gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The number of virtual tapes that you want to create.
	//
	// NumTapesToCreate is a required field
	NumTapesToCreate *int64 `min:"1" type:"integer" required:"true"`

	// A prefix that you append to the barcode of the virtual tape you are creating.
	// This prefix makes the barcode unique.
	//
	// The prefix must be 1 to 4 characters in length and must be one of the uppercase
	// letters from A to Z.
	//
	// TapeBarcodePrefix is a required field
	TapeBarcodePrefix *string `min:"1" type:"string" required:"true"`

	// The size, in bytes, of the virtual tapes that you want to create.
	//
	// The size must be aligned by gigabyte (1024*1024*1024 byte).
	//
	// TapeSizeInBytes is a required field
	TapeSizeInBytes *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s CreateTapesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTapesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTapesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTapesInput"}
	if s.ClientToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 5))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.NumTapesToCreate == nil {
		invalidParams.Add(request.NewErrParamRequired("NumTapesToCreate"))
	}
	if s.NumTapesToCreate != nil && *s.NumTapesToCreate < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumTapesToCreate", 1))
	}
	if s.TapeBarcodePrefix == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeBarcodePrefix"))
	}
	if s.TapeBarcodePrefix != nil && len(*s.TapeBarcodePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TapeBarcodePrefix", 1))
	}
	if s.TapeSizeInBytes == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeSizeInBytes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateTapesInput) SetClientToken(v string) *CreateTapesInput {
	s.ClientToken = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *CreateTapesInput) SetGatewayARN(v string) *CreateTapesInput {
	s.GatewayARN = &v
	return s
}

// SetNumTapesToCreate sets the NumTapesToCreate field's value.
func (s *CreateTapesInput) SetNumTapesToCreate(v int64) *CreateTapesInput {
	s.NumTapesToCreate = &v
	return s
}

// SetTapeBarcodePrefix sets the TapeBarcodePrefix field's value.
func (s *CreateTapesInput) SetTapeBarcodePrefix(v string) *CreateTapesInput {
	s.TapeBarcodePrefix = &v
	return s
}

// SetTapeSizeInBytes sets the TapeSizeInBytes field's value.
func (s *CreateTapesInput) SetTapeSizeInBytes(v int64) *CreateTapesInput {
	s.TapeSizeInBytes = &v
	return s
}

// CreateTapeOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/CreateTapesOutput
type CreateTapesOutput struct {
	_ struct{} `type:"structure"`

	// A list of unique Amazon Resource Names (ARNs) that represents the virtual
	// tapes that were created.
	TapeARNs []*string `type:"list"`
}

// String returns the string representation
func (s CreateTapesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTapesOutput) GoString() string {
	return s.String()
}

// SetTapeARNs sets the TapeARNs field's value.
func (s *CreateTapesOutput) SetTapeARNs(v []*string) *CreateTapesOutput {
	s.TapeARNs = v
	return s
}

// A JSON object containing the following fields:
//
//    * DeleteBandwidthRateLimitInput$BandwidthType
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteBandwidthRateLimitInput
type DeleteBandwidthRateLimitInput struct {
	_ struct{} `type:"structure"`

	// One of the BandwidthType values that indicates the gateway bandwidth rate
	// limit to delete.
	//
	// Valid Values: Upload, Download, All.
	//
	// BandwidthType is a required field
	BandwidthType *string `min:"3" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBandwidthRateLimitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBandwidthRateLimitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBandwidthRateLimitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBandwidthRateLimitInput"}
	if s.BandwidthType == nil {
		invalidParams.Add(request.NewErrParamRequired("BandwidthType"))
	}
	if s.BandwidthType != nil && len(*s.BandwidthType) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BandwidthType", 3))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidthType sets the BandwidthType field's value.
func (s *DeleteBandwidthRateLimitInput) SetBandwidthType(v string) *DeleteBandwidthRateLimitInput {
	s.BandwidthType = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DeleteBandwidthRateLimitInput) SetGatewayARN(v string) *DeleteBandwidthRateLimitInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the of the gateway whose bandwidth rate information
// was deleted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteBandwidthRateLimitOutput
type DeleteBandwidthRateLimitOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteBandwidthRateLimitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBandwidthRateLimitOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DeleteBandwidthRateLimitOutput) SetGatewayARN(v string) *DeleteBandwidthRateLimitOutput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing one or more of the following fields:
//
//    * DeleteChapCredentialsInput$InitiatorName
//
//    * DeleteChapCredentialsInput$TargetARN
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteChapCredentialsInput
type DeleteChapCredentialsInput struct {
	_ struct{} `type:"structure"`

	// The iSCSI initiator that connects to the target.
	//
	// InitiatorName is a required field
	InitiatorName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes
	// operation to return to retrieve the TargetARN for specified VolumeARN.
	//
	// TargetARN is a required field
	TargetARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteChapCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChapCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteChapCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteChapCredentialsInput"}
	if s.InitiatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("InitiatorName"))
	}
	if s.InitiatorName != nil && len(*s.InitiatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InitiatorName", 1))
	}
	if s.TargetARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetARN"))
	}
	if s.TargetARN != nil && len(*s.TargetARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TargetARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInitiatorName sets the InitiatorName field's value.
func (s *DeleteChapCredentialsInput) SetInitiatorName(v string) *DeleteChapCredentialsInput {
	s.InitiatorName = &v
	return s
}

// SetTargetARN sets the TargetARN field's value.
func (s *DeleteChapCredentialsInput) SetTargetARN(v string) *DeleteChapCredentialsInput {
	s.TargetARN = &v
	return s
}

// A JSON object containing the following fields:
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteChapCredentialsOutput
type DeleteChapCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// The iSCSI initiator that connects to the target.
	InitiatorName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the target.
	TargetARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteChapCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChapCredentialsOutput) GoString() string {
	return s.String()
}

// SetInitiatorName sets the InitiatorName field's value.
func (s *DeleteChapCredentialsOutput) SetInitiatorName(v string) *DeleteChapCredentialsOutput {
	s.InitiatorName = &v
	return s
}

// SetTargetARN sets the TargetARN field's value.
func (s *DeleteChapCredentialsOutput) SetTargetARN(v string) *DeleteChapCredentialsOutput {
	s.TargetARN = &v
	return s
}

// DeleteFileShareInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteFileShareInput
type DeleteFileShareInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the file share to be deleted.
	//
	// FileShareARN is a required field
	FileShareARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFileShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFileShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFileShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFileShareInput"}
	if s.FileShareARN == nil {
		invalidParams.Add(request.NewErrParamRequired("FileShareARN"))
	}
	if s.FileShareARN != nil && len(*s.FileShareARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("FileShareARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *DeleteFileShareInput) SetFileShareARN(v string) *DeleteFileShareInput {
	s.FileShareARN = &v
	return s
}

// DeleteFileShareOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteFileShareOutput
type DeleteFileShareOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted file share.
	FileShareARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteFileShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFileShareOutput) GoString() string {
	return s.String()
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *DeleteFileShareOutput) SetFileShareARN(v string) *DeleteFileShareOutput {
	s.FileShareARN = &v
	return s
}

// A JSON object containing the id of the gateway to delete.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteGatewayInput
type DeleteGatewayInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGatewayInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DeleteGatewayInput) SetGatewayARN(v string) *DeleteGatewayInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the id of the deleted gateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteGatewayOutput
type DeleteGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGatewayOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DeleteGatewayOutput) SetGatewayARN(v string) *DeleteGatewayOutput {
	s.GatewayARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteSnapshotScheduleInput
type DeleteSnapshotScheduleInput struct {
	_ struct{} `type:"structure"`

	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSnapshotScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSnapshotScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSnapshotScheduleInput"}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *DeleteSnapshotScheduleInput) SetVolumeARN(v string) *DeleteSnapshotScheduleInput {
	s.VolumeARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteSnapshotScheduleOutput
type DeleteSnapshotScheduleOutput struct {
	_ struct{} `type:"structure"`

	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteSnapshotScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotScheduleOutput) GoString() string {
	return s.String()
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *DeleteSnapshotScheduleOutput) SetVolumeARN(v string) *DeleteSnapshotScheduleOutput {
	s.VolumeARN = &v
	return s
}

// DeleteTapeArchiveInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTapeArchiveInput
type DeleteTapeArchiveInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual
	// tape shelf (VTS).
	//
	// TapeARN is a required field
	TapeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTapeArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTapeArchiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTapeArchiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTapeArchiveInput"}
	if s.TapeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeARN"))
	}
	if s.TapeARN != nil && len(*s.TapeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TapeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTapeARN sets the TapeARN field's value.
func (s *DeleteTapeArchiveInput) SetTapeARN(v string) *DeleteTapeArchiveInput {
	s.TapeARN = &v
	return s
}

// DeleteTapeArchiveOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTapeArchiveOutput
type DeleteTapeArchiveOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the virtual tape that was deleted from
	// the virtual tape shelf (VTS).
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteTapeArchiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTapeArchiveOutput) GoString() string {
	return s.String()
}

// SetTapeARN sets the TapeARN field's value.
func (s *DeleteTapeArchiveOutput) SetTapeARN(v string) *DeleteTapeArchiveOutput {
	s.TapeARN = &v
	return s
}

// DeleteTapeInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTapeInput
type DeleteTapeInput struct {
	_ struct{} `type:"structure"`

	// The unique Amazon Resource Name (ARN) of the gateway that the virtual tape
	// to delete is associated with. Use the ListGateways operation to return a
	// list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape to delete.
	//
	// TapeARN is a required field
	TapeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTapeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTapeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTapeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTapeInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.TapeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeARN"))
	}
	if s.TapeARN != nil && len(*s.TapeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TapeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DeleteTapeInput) SetGatewayARN(v string) *DeleteTapeInput {
	s.GatewayARN = &v
	return s
}

// SetTapeARN sets the TapeARN field's value.
func (s *DeleteTapeInput) SetTapeARN(v string) *DeleteTapeInput {
	s.TapeARN = &v
	return s
}

// DeleteTapeOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteTapeOutput
type DeleteTapeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted virtual tape.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteTapeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTapeOutput) GoString() string {
	return s.String()
}

// SetTapeARN sets the TapeARN field's value.
func (s *DeleteTapeOutput) SetTapeARN(v string) *DeleteTapeOutput {
	s.TapeARN = &v
	return s
}

// A JSON object containing the DeleteVolumeInput$VolumeARN to delete.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteVolumeInput
type DeleteVolumeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes.
	//
	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVolumeInput"}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *DeleteVolumeInput) SetVolumeARN(v string) *DeleteVolumeInput {
	s.VolumeARN = &v
	return s
}

// A JSON object containing the of the storage volume that was deleted
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeleteVolumeOutput
type DeleteVolumeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the storage volume that was deleted. It
	// is the same ARN you provided in the request.
	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeleteVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVolumeOutput) GoString() string {
	return s.String()
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *DeleteVolumeOutput) SetVolumeARN(v string) *DeleteVolumeOutput {
	s.VolumeARN = &v
	return s
}

// A JSON object containing the of the gateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeBandwidthRateLimitInput
type DescribeBandwidthRateLimitInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeBandwidthRateLimitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBandwidthRateLimitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBandwidthRateLimitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBandwidthRateLimitInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeBandwidthRateLimitInput) SetGatewayARN(v string) *DescribeBandwidthRateLimitInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the following fields:
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeBandwidthRateLimitOutput
type DescribeBandwidthRateLimitOutput struct {
	_ struct{} `type:"structure"`

	// The average download bandwidth rate limit in bits per second. This field
	// does not appear in the response if the download rate limit is not set.
	AverageDownloadRateLimitInBitsPerSec *int64 `min:"102400" type:"long"`

	// The average upload bandwidth rate limit in bits per second. This field does
	// not appear in the response if the upload rate limit is not set.
	AverageUploadRateLimitInBitsPerSec *int64 `min:"51200" type:"long"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DescribeBandwidthRateLimitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBandwidthRateLimitOutput) GoString() string {
	return s.String()
}

// SetAverageDownloadRateLimitInBitsPerSec sets the AverageDownloadRateLimitInBitsPerSec field's value.
func (s *DescribeBandwidthRateLimitOutput) SetAverageDownloadRateLimitInBitsPerSec(v int64) *DescribeBandwidthRateLimitOutput {
	s.AverageDownloadRateLimitInBitsPerSec = &v
	return s
}

// SetAverageUploadRateLimitInBitsPerSec sets the AverageUploadRateLimitInBitsPerSec field's value.
func (s *DescribeBandwidthRateLimitOutput) SetAverageUploadRateLimitInBitsPerSec(v int64) *DescribeBandwidthRateLimitOutput {
	s.AverageUploadRateLimitInBitsPerSec = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeBandwidthRateLimitOutput) SetGatewayARN(v string) *DescribeBandwidthRateLimitOutput {
	s.GatewayARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeCacheInput
type DescribeCacheInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCacheInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCacheInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCacheInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeCacheInput) SetGatewayARN(v string) *DescribeCacheInput {
	s.GatewayARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeCacheOutput
type DescribeCacheOutput struct {
	_ struct{} `type:"structure"`

	CacheAllocatedInBytes *int64 `type:"long"`

	CacheDirtyPercentage *float64 `type:"double"`

	CacheHitPercentage *float64 `type:"double"`

	CacheMissPercentage *float64 `type:"double"`

	CacheUsedPercentage *float64 `type:"double"`

	DiskIds []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DescribeCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheOutput) GoString() string {
	return s.String()
}

// SetCacheAllocatedInBytes sets the CacheAllocatedInBytes field's value.
func (s *DescribeCacheOutput) SetCacheAllocatedInBytes(v int64) *DescribeCacheOutput {
	s.CacheAllocatedInBytes = &v
	return s
}

// SetCacheDirtyPercentage sets the CacheDirtyPercentage field's value.
func (s *DescribeCacheOutput) SetCacheDirtyPercentage(v float64) *DescribeCacheOutput {
	s.CacheDirtyPercentage = &v
	return s
}

// SetCacheHitPercentage sets the CacheHitPercentage field's value.
func (s *DescribeCacheOutput) SetCacheHitPercentage(v float64) *DescribeCacheOutput {
	s.CacheHitPercentage = &v
	return s
}

// SetCacheMissPercentage sets the CacheMissPercentage field's value.
func (s *DescribeCacheOutput) SetCacheMissPercentage(v float64) *DescribeCacheOutput {
	s.CacheMissPercentage = &v
	return s
}

// SetCacheUsedPercentage sets the CacheUsedPercentage field's value.
func (s *DescribeCacheOutput) SetCacheUsedPercentage(v float64) *DescribeCacheOutput {
	s.CacheUsedPercentage = &v
	return s
}

// SetDiskIds sets the DiskIds field's value.
func (s *DescribeCacheOutput) SetDiskIds(v []*string) *DescribeCacheOutput {
	s.DiskIds = v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeCacheOutput) SetGatewayARN(v string) *DescribeCacheOutput {
	s.GatewayARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeCachediSCSIVolumesInput
type DescribeCachediSCSIVolumesInput struct {
	_ struct{} `type:"structure"`

	// VolumeARNs is a required field
	VolumeARNs []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeCachediSCSIVolumesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCachediSCSIVolumesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCachediSCSIVolumesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCachediSCSIVolumesInput"}
	if s.VolumeARNs == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARNs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVolumeARNs sets the VolumeARNs field's value.
func (s *DescribeCachediSCSIVolumesInput) SetVolumeARNs(v []*string) *DescribeCachediSCSIVolumesInput {
	s.VolumeARNs = v
	return s
}

// A JSON object containing the following fields:
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeCachediSCSIVolumesOutput
type DescribeCachediSCSIVolumesOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects where each object contains metadata about one cached
	// volume.
	CachediSCSIVolumes []*CachediSCSIVolume `type:"list"`
}

// String returns the string representation
func (s DescribeCachediSCSIVolumesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCachediSCSIVolumesOutput) GoString() string {
	return s.String()
}

// SetCachediSCSIVolumes sets the CachediSCSIVolumes field's value.
func (s *DescribeCachediSCSIVolumesOutput) SetCachediSCSIVolumes(v []*CachediSCSIVolume) *DescribeCachediSCSIVolumesOutput {
	s.CachediSCSIVolumes = v
	return s
}

// A JSON object containing the Amazon Resource Name (ARN) of the iSCSI volume
// target.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeChapCredentialsInput
type DescribeChapCredentialsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes
	// operation to return to retrieve the TargetARN for specified VolumeARN.
	//
	// TargetARN is a required field
	TargetARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeChapCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChapCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeChapCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeChapCredentialsInput"}
	if s.TargetARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetARN"))
	}
	if s.TargetARN != nil && len(*s.TargetARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TargetARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTargetARN sets the TargetARN field's value.
func (s *DescribeChapCredentialsInput) SetTargetARN(v string) *DescribeChapCredentialsInput {
	s.TargetARN = &v
	return s
}

// A JSON object containing a .
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeChapCredentialsOutput
type DescribeChapCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// An array of ChapInfo objects that represent CHAP credentials. Each object
	// in the array contains CHAP credential information for one target-initiator
	// pair. If no CHAP credentials are set, an empty array is returned. CHAP credential
	// information is provided in a JSON object with the following fields:
	//
	//    * InitiatorName: The iSCSI initiator that connects to the target.
	//
	//    * SecretToAuthenticateInitiator: The secret key that the initiator (for
	//    example, the Windows client) must provide to participate in mutual CHAP
	//    with the target.
	//
	//    * SecretToAuthenticateTarget: The secret key that the target must provide
	//    to participate in mutual CHAP with the initiator (e.g. Windows client).
	//
	//    * TargetARN: The Amazon Resource Name (ARN) of the storage volume.
	ChapCredentials []*ChapInfo `type:"list"`
}

// String returns the string representation
func (s DescribeChapCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChapCredentialsOutput) GoString() string {
	return s.String()
}

// SetChapCredentials sets the ChapCredentials field's value.
func (s *DescribeChapCredentialsOutput) SetChapCredentials(v []*ChapInfo) *DescribeChapCredentialsOutput {
	s.ChapCredentials = v
	return s
}

// A JSON object containing the id of the gateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeGatewayInformationInput
type DescribeGatewayInformationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeGatewayInformationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGatewayInformationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGatewayInformationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGatewayInformationInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeGatewayInformationInput) SetGatewayARN(v string) *DescribeGatewayInformationInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the following fields:
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeGatewayInformationOutput
type DescribeGatewayInformationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	// The unique identifier assigned to your gateway during activation. This ID
	// becomes part of the gateway Amazon Resource Name (ARN), which you use as
	// input for other operations.
	GatewayId *string `min:"12" type:"string"`

	// The name you configured for your gateway.
	GatewayName *string `type:"string"`

	// A NetworkInterface array that contains descriptions of the gateway network
	// interfaces.
	GatewayNetworkInterfaces []*NetworkInterface `type:"list"`

	// A value that indicates the operating state of the gateway.
	GatewayState *string `min:"2" type:"string"`

	// A value that indicates the time zone configured for the gateway.
	GatewayTimezone *string `min:"3" type:"string"`

	// The type of the gateway.
	GatewayType *string `min:"2" type:"string"`

	// The date on which the last software update was applied to the gateway. If
	// the gateway has never been updated, this field does not return a value in
	// the response.
	LastSoftwareUpdate *string `min:"1" type:"string"`

	// The date on which an update to the gateway is available. This date is in
	// the time zone of the gateway. If the gateway is not available for an update
	// this field is not returned in the response.
	NextUpdateAvailabilityDate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeGatewayInformationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGatewayInformationOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeGatewayInformationOutput) SetGatewayARN(v string) *DescribeGatewayInformationOutput {
	s.GatewayARN = &v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *DescribeGatewayInformationOutput) SetGatewayId(v string) *DescribeGatewayInformationOutput {
	s.GatewayId = &v
	return s
}

// SetGatewayName sets the GatewayName field's value.
func (s *DescribeGatewayInformationOutput) SetGatewayName(v string) *DescribeGatewayInformationOutput {
	s.GatewayName = &v
	return s
}

// SetGatewayNetworkInterfaces sets the GatewayNetworkInterfaces field's value.
func (s *DescribeGatewayInformationOutput) SetGatewayNetworkInterfaces(v []*NetworkInterface) *DescribeGatewayInformationOutput {
	s.GatewayNetworkInterfaces = v
	return s
}

// SetGatewayState sets the GatewayState field's value.
func (s *DescribeGatewayInformationOutput) SetGatewayState(v string) *DescribeGatewayInformationOutput {
	s.GatewayState = &v
	return s
}

// SetGatewayTimezone sets the GatewayTimezone field's value.
func (s *DescribeGatewayInformationOutput) SetGatewayTimezone(v string) *DescribeGatewayInformationOutput {
	s.GatewayTimezone = &v
	return s
}

// SetGatewayType sets the GatewayType field's value.
func (s *DescribeGatewayInformationOutput) SetGatewayType(v string) *DescribeGatewayInformationOutput {
	s.GatewayType = &v
	return s
}

// SetLastSoftwareUpdate sets the LastSoftwareUpdate field's value.
func (s *DescribeGatewayInformationOutput) SetLastSoftwareUpdate(v string) *DescribeGatewayInformationOutput {
	s.LastSoftwareUpdate = &v
	return s
}

// SetNextUpdateAvailabilityDate sets the NextUpdateAvailabilityDate field's value.
func (s *DescribeGatewayInformationOutput) SetNextUpdateAvailabilityDate(v string) *DescribeGatewayInformationOutput {
	s.NextUpdateAvailabilityDate = &v
	return s
}

// A JSON object containing the of the gateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeMaintenanceStartTimeInput
type DescribeMaintenanceStartTimeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMaintenanceStartTimeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceStartTimeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMaintenanceStartTimeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMaintenanceStartTimeInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeMaintenanceStartTimeInput) SetGatewayARN(v string) *DescribeMaintenanceStartTimeInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the following fields:
//
//    * DescribeMaintenanceStartTimeOutput$DayOfWeek
//
//    * DescribeMaintenanceStartTimeOutput$HourOfDay
//
//    * DescribeMaintenanceStartTimeOutput$MinuteOfHour
//
//    * DescribeMaintenanceStartTimeOutput$Timezone
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeMaintenanceStartTimeOutput
type DescribeMaintenanceStartTimeOutput struct {
	_ struct{} `type:"structure"`

	// An ordinal number between 0 and 6 that represents the day of the week, where
	// 0 represents Sunday and 6 represents Saturday. The day of week is in the
	// time zone of the gateway.
	DayOfWeek *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	// The hour component of the maintenance start time represented as hh, where
	// hh is the hour (0 to 23). The hour of the day is in the time zone of the
	// gateway.
	HourOfDay *int64 `type:"integer"`

	// The minute component of the maintenance start time represented as mm, where
	// mm is the minute (0 to 59). The minute of the hour is in the time zone of
	// the gateway.
	MinuteOfHour *int64 `type:"integer"`

	Timezone *string `min:"3" type:"string"`
}

// String returns the string representation
func (s DescribeMaintenanceStartTimeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceStartTimeOutput) GoString() string {
	return s.String()
}

// SetDayOfWeek sets the DayOfWeek field's value.
func (s *DescribeMaintenanceStartTimeOutput) SetDayOfWeek(v int64) *DescribeMaintenanceStartTimeOutput {
	s.DayOfWeek = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeMaintenanceStartTimeOutput) SetGatewayARN(v string) *DescribeMaintenanceStartTimeOutput {
	s.GatewayARN = &v
	return s
}

// SetHourOfDay sets the HourOfDay field's value.
func (s *DescribeMaintenanceStartTimeOutput) SetHourOfDay(v int64) *DescribeMaintenanceStartTimeOutput {
	s.HourOfDay = &v
	return s
}

// SetMinuteOfHour sets the MinuteOfHour field's value.
func (s *DescribeMaintenanceStartTimeOutput) SetMinuteOfHour(v int64) *DescribeMaintenanceStartTimeOutput {
	s.MinuteOfHour = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *DescribeMaintenanceStartTimeOutput) SetTimezone(v string) *DescribeMaintenanceStartTimeOutput {
	s.Timezone = &v
	return s
}

// DescribeNFSFileSharesInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeNFSFileSharesInput
type DescribeNFSFileSharesInput struct {
	_ struct{} `type:"structure"`

	// An array containing the Amazon Resource Name (ARN) of each file share to
	// be described.
	//
	// FileShareARNList is a required field
	FileShareARNList []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeNFSFileSharesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNFSFileSharesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNFSFileSharesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeNFSFileSharesInput"}
	if s.FileShareARNList == nil {
		invalidParams.Add(request.NewErrParamRequired("FileShareARNList"))
	}
	if s.FileShareARNList != nil && len(s.FileShareARNList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileShareARNList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileShareARNList sets the FileShareARNList field's value.
func (s *DescribeNFSFileSharesInput) SetFileShareARNList(v []*string) *DescribeNFSFileSharesInput {
	s.FileShareARNList = v
	return s
}

// DescribeNFSFileSharesOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeNFSFileSharesOutput
type DescribeNFSFileSharesOutput struct {
	_ struct{} `type:"structure"`

	// An array containing a description for each requested file share.
	NFSFileShareInfoList []*NFSFileShareInfo `type:"list"`
}

// String returns the string representation
func (s DescribeNFSFileSharesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNFSFileSharesOutput) GoString() string {
	return s.String()
}

// SetNFSFileShareInfoList sets the NFSFileShareInfoList field's value.
func (s *DescribeNFSFileSharesOutput) SetNFSFileShareInfoList(v []*NFSFileShareInfo) *DescribeNFSFileSharesOutput {
	s.NFSFileShareInfoList = v
	return s
}

// A JSON object containing the DescribeSnapshotScheduleInput$VolumeARN of the
// volume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeSnapshotScheduleInput
type DescribeSnapshotScheduleInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes.
	//
	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSnapshotScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSnapshotScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSnapshotScheduleInput"}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *DescribeSnapshotScheduleInput) SetVolumeARN(v string) *DescribeSnapshotScheduleInput {
	s.VolumeARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeSnapshotScheduleOutput
type DescribeSnapshotScheduleOutput struct {
	_ struct{} `type:"structure"`

	Description *string `min:"1" type:"string"`

	RecurrenceInHours *int64 `min:"1" type:"integer"`

	StartAt *int64 `type:"integer"`

	Timezone *string `min:"3" type:"string"`

	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DescribeSnapshotScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotScheduleOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *DescribeSnapshotScheduleOutput) SetDescription(v string) *DescribeSnapshotScheduleOutput {
	s.Description = &v
	return s
}

// SetRecurrenceInHours sets the RecurrenceInHours field's value.
func (s *DescribeSnapshotScheduleOutput) SetRecurrenceInHours(v int64) *DescribeSnapshotScheduleOutput {
	s.RecurrenceInHours = &v
	return s
}

// SetStartAt sets the StartAt field's value.
func (s *DescribeSnapshotScheduleOutput) SetStartAt(v int64) *DescribeSnapshotScheduleOutput {
	s.StartAt = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *DescribeSnapshotScheduleOutput) SetTimezone(v string) *DescribeSnapshotScheduleOutput {
	s.Timezone = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *DescribeSnapshotScheduleOutput) SetVolumeARN(v string) *DescribeSnapshotScheduleOutput {
	s.VolumeARN = &v
	return s
}

// A JSON object containing a list of DescribeStorediSCSIVolumesInput$VolumeARNs.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeStorediSCSIVolumesInput
type DescribeStorediSCSIVolumesInput struct {
	_ struct{} `type:"structure"`

	// An array of strings where each string represents the Amazon Resource Name
	// (ARN) of a stored volume. All of the specified stored volumes must from the
	// same gateway. Use ListVolumes to get volume ARNs for a gateway.
	//
	// VolumeARNs is a required field
	VolumeARNs []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeStorediSCSIVolumesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStorediSCSIVolumesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStorediSCSIVolumesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStorediSCSIVolumesInput"}
	if s.VolumeARNs == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARNs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVolumeARNs sets the VolumeARNs field's value.
func (s *DescribeStorediSCSIVolumesInput) SetVolumeARNs(v []*string) *DescribeStorediSCSIVolumesInput {
	s.VolumeARNs = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeStorediSCSIVolumesOutput
type DescribeStorediSCSIVolumesOutput struct {
	_ struct{} `type:"structure"`

	StorediSCSIVolumes []*StorediSCSIVolume `type:"list"`
}

// String returns the string representation
func (s DescribeStorediSCSIVolumesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStorediSCSIVolumesOutput) GoString() string {
	return s.String()
}

// SetStorediSCSIVolumes sets the StorediSCSIVolumes field's value.
func (s *DescribeStorediSCSIVolumesOutput) SetStorediSCSIVolumes(v []*StorediSCSIVolume) *DescribeStorediSCSIVolumesOutput {
	s.StorediSCSIVolumes = v
	return s
}

// DescribeTapeArchivesInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeArchivesInput
type DescribeTapeArchivesInput struct {
	_ struct{} `type:"structure"`

	// Specifies that the number of virtual tapes descried be limited to the specified
	// number.
	Limit *int64 `min:"1" type:"integer"`

	// An opaque string that indicates the position at which to begin describing
	// virtual tapes.
	Marker *string `min:"1" type:"string"`

	// Specifies one or more unique Amazon Resource Names (ARNs) that represent
	// the virtual tapes you want to describe.
	TapeARNs []*string `type:"list"`
}

// String returns the string representation
func (s DescribeTapeArchivesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapeArchivesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTapeArchivesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTapeArchivesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *DescribeTapeArchivesInput) SetLimit(v int64) *DescribeTapeArchivesInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeTapeArchivesInput) SetMarker(v string) *DescribeTapeArchivesInput {
	s.Marker = &v
	return s
}

// SetTapeARNs sets the TapeARNs field's value.
func (s *DescribeTapeArchivesInput) SetTapeARNs(v []*string) *DescribeTapeArchivesInput {
	s.TapeARNs = v
	return s
}

// DescribeTapeArchivesOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeArchivesOutput
type DescribeTapeArchivesOutput struct {
	_ struct{} `type:"structure"`

	// An opaque string that indicates the position at which the virtual tapes that
	// were fetched for description ended. Use this marker in your next request
	// to fetch the next set of virtual tapes in the virtual tape shelf (VTS). If
	// there are no more virtual tapes to describe, this field does not appear in
	// the response.
	Marker *string `min:"1" type:"string"`

	// An array of virtual tape objects in the virtual tape shelf (VTS). The description
	// includes of the Amazon Resource Name(ARN) of the virtual tapes. The information
	// returned includes the Amazon Resource Names (ARNs) of the tapes, size of
	// the tapes, status of the tapes, progress of the description and tape barcode.
	TapeArchives []*TapeArchive `type:"list"`
}

// String returns the string representation
func (s DescribeTapeArchivesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapeArchivesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeTapeArchivesOutput) SetMarker(v string) *DescribeTapeArchivesOutput {
	s.Marker = &v
	return s
}

// SetTapeArchives sets the TapeArchives field's value.
func (s *DescribeTapeArchivesOutput) SetTapeArchives(v []*TapeArchive) *DescribeTapeArchivesOutput {
	s.TapeArchives = v
	return s
}

// DescribeTapeRecoveryPointsInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeRecoveryPointsInput
type DescribeTapeRecoveryPointsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// Specifies that the number of virtual tape recovery points that are described
	// be limited to the specified number.
	Limit *int64 `min:"1" type:"integer"`

	// An opaque string that indicates the position at which to begin describing
	// the virtual tape recovery points.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeTapeRecoveryPointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapeRecoveryPointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTapeRecoveryPointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTapeRecoveryPointsInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeTapeRecoveryPointsInput) SetGatewayARN(v string) *DescribeTapeRecoveryPointsInput {
	s.GatewayARN = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeTapeRecoveryPointsInput) SetLimit(v int64) *DescribeTapeRecoveryPointsInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeTapeRecoveryPointsInput) SetMarker(v string) *DescribeTapeRecoveryPointsInput {
	s.Marker = &v
	return s
}

// DescribeTapeRecoveryPointsOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapeRecoveryPointsOutput
type DescribeTapeRecoveryPointsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	// An opaque string that indicates the position at which the virtual tape recovery
	// points that were listed for description ended.
	//
	// Use this marker in your next request to list the next set of virtual tape
	// recovery points in the list. If there are no more recovery points to describe,
	// this field does not appear in the response.
	Marker *string `min:"1" type:"string"`

	// An array of TapeRecoveryPointInfos that are available for the specified gateway.
	TapeRecoveryPointInfos []*TapeRecoveryPointInfo `type:"list"`
}

// String returns the string representation
func (s DescribeTapeRecoveryPointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapeRecoveryPointsOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeTapeRecoveryPointsOutput) SetGatewayARN(v string) *DescribeTapeRecoveryPointsOutput {
	s.GatewayARN = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeTapeRecoveryPointsOutput) SetMarker(v string) *DescribeTapeRecoveryPointsOutput {
	s.Marker = &v
	return s
}

// SetTapeRecoveryPointInfos sets the TapeRecoveryPointInfos field's value.
func (s *DescribeTapeRecoveryPointsOutput) SetTapeRecoveryPointInfos(v []*TapeRecoveryPointInfo) *DescribeTapeRecoveryPointsOutput {
	s.TapeRecoveryPointInfos = v
	return s
}

// DescribeTapesInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapesInput
type DescribeTapesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// Specifies that the number of virtual tapes described be limited to the specified
	// number.
	//
	// Amazon Web Services may impose its own limit, if this field is not set.
	Limit *int64 `min:"1" type:"integer"`

	// A marker value, obtained in a previous call to DescribeTapes. This marker
	// indicates which page of results to retrieve.
	//
	// If not specified, the first page of results is retrieved.
	Marker *string `min:"1" type:"string"`

	// Specifies one or more unique Amazon Resource Names (ARNs) that represent
	// the virtual tapes you want to describe. If this parameter is not specified,
	// AWS Storage Gateway returns a description of all virtual tapes associated
	// with the specified gateway.
	TapeARNs []*string `type:"list"`
}

// String returns the string representation
func (s DescribeTapesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTapesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTapesInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeTapesInput) SetGatewayARN(v string) *DescribeTapesInput {
	s.GatewayARN = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeTapesInput) SetLimit(v int64) *DescribeTapesInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeTapesInput) SetMarker(v string) *DescribeTapesInput {
	s.Marker = &v
	return s
}

// SetTapeARNs sets the TapeARNs field's value.
func (s *DescribeTapesInput) SetTapeARNs(v []*string) *DescribeTapesInput {
	s.TapeARNs = v
	return s
}

// DescribeTapesOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeTapesOutput
type DescribeTapesOutput struct {
	_ struct{} `type:"structure"`

	// An opaque string which can be used as part of a subsequent DescribeTapes
	// call to retrieve the next page of results.
	//
	// If a response does not contain a marker, then there are no more results to
	// be retrieved.
	Marker *string `min:"1" type:"string"`

	// An array of virtual tape descriptions.
	Tapes []*Tape `type:"list"`
}

// String returns the string representation
func (s DescribeTapesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeTapesOutput) SetMarker(v string) *DescribeTapesOutput {
	s.Marker = &v
	return s
}

// SetTapes sets the Tapes field's value.
func (s *DescribeTapesOutput) SetTapes(v []*Tape) *DescribeTapesOutput {
	s.Tapes = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeUploadBufferInput
type DescribeUploadBufferInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUploadBufferInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUploadBufferInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUploadBufferInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUploadBufferInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeUploadBufferInput) SetGatewayARN(v string) *DescribeUploadBufferInput {
	s.GatewayARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeUploadBufferOutput
type DescribeUploadBufferOutput struct {
	_ struct{} `type:"structure"`

	DiskIds []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	UploadBufferAllocatedInBytes *int64 `type:"long"`

	UploadBufferUsedInBytes *int64 `type:"long"`
}

// String returns the string representation
func (s DescribeUploadBufferOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUploadBufferOutput) GoString() string {
	return s.String()
}

// SetDiskIds sets the DiskIds field's value.
func (s *DescribeUploadBufferOutput) SetDiskIds(v []*string) *DescribeUploadBufferOutput {
	s.DiskIds = v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeUploadBufferOutput) SetGatewayARN(v string) *DescribeUploadBufferOutput {
	s.GatewayARN = &v
	return s
}

// SetUploadBufferAllocatedInBytes sets the UploadBufferAllocatedInBytes field's value.
func (s *DescribeUploadBufferOutput) SetUploadBufferAllocatedInBytes(v int64) *DescribeUploadBufferOutput {
	s.UploadBufferAllocatedInBytes = &v
	return s
}

// SetUploadBufferUsedInBytes sets the UploadBufferUsedInBytes field's value.
func (s *DescribeUploadBufferOutput) SetUploadBufferUsedInBytes(v int64) *DescribeUploadBufferOutput {
	s.UploadBufferUsedInBytes = &v
	return s
}

// DescribeVTLDevicesInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeVTLDevicesInput
type DescribeVTLDevicesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// Specifies that the number of VTL devices described be limited to the specified
	// number.
	Limit *int64 `min:"1" type:"integer"`

	// An opaque string that indicates the position at which to begin describing
	// the VTL devices.
	Marker *string `min:"1" type:"string"`

	// An array of strings, where each string represents the Amazon Resource Name
	// (ARN) of a VTL device.
	//
	// All of the specified VTL devices must be from the same gateway. If no VTL
	// devices are specified, the result will contain all devices on the specified
	// gateway.
	VTLDeviceARNs []*string `type:"list"`
}

// String returns the string representation
func (s DescribeVTLDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVTLDevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVTLDevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeVTLDevicesInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeVTLDevicesInput) SetGatewayARN(v string) *DescribeVTLDevicesInput {
	s.GatewayARN = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeVTLDevicesInput) SetLimit(v int64) *DescribeVTLDevicesInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeVTLDevicesInput) SetMarker(v string) *DescribeVTLDevicesInput {
	s.Marker = &v
	return s
}

// SetVTLDeviceARNs sets the VTLDeviceARNs field's value.
func (s *DescribeVTLDevicesInput) SetVTLDeviceARNs(v []*string) *DescribeVTLDevicesInput {
	s.VTLDeviceARNs = v
	return s
}

// DescribeVTLDevicesOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeVTLDevicesOutput
type DescribeVTLDevicesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	// An opaque string that indicates the position at which the VTL devices that
	// were fetched for description ended. Use the marker in your next request to
	// fetch the next set of VTL devices in the list. If there are no more VTL devices
	// to describe, this field does not appear in the response.
	Marker *string `min:"1" type:"string"`

	// An array of VTL device objects composed of the Amazon Resource Name(ARN)
	// of the VTL devices.
	VTLDevices []*VTLDevice `type:"list"`
}

// String returns the string representation
func (s DescribeVTLDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVTLDevicesOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeVTLDevicesOutput) SetGatewayARN(v string) *DescribeVTLDevicesOutput {
	s.GatewayARN = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeVTLDevicesOutput) SetMarker(v string) *DescribeVTLDevicesOutput {
	s.Marker = &v
	return s
}

// SetVTLDevices sets the VTLDevices field's value.
func (s *DescribeVTLDevicesOutput) SetVTLDevices(v []*VTLDevice) *DescribeVTLDevicesOutput {
	s.VTLDevices = v
	return s
}

// A JSON object containing the of the gateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeWorkingStorageInput
type DescribeWorkingStorageInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeWorkingStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkingStorageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkingStorageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkingStorageInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeWorkingStorageInput) SetGatewayARN(v string) *DescribeWorkingStorageInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the following fields:
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DescribeWorkingStorageOutput
type DescribeWorkingStorageOutput struct {
	_ struct{} `type:"structure"`

	// An array of the gateway's local disk IDs that are configured as working storage.
	// Each local disk ID is specified as a string (minimum length of 1 and maximum
	// length of 300). If no local disks are configured as working storage, then
	// the DiskIds array is empty.
	DiskIds []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	// The total working storage in bytes allocated for the gateway. If no working
	// storage is configured for the gateway, this field returns 0.
	WorkingStorageAllocatedInBytes *int64 `type:"long"`

	// The total working storage in bytes in use by the gateway. If no working storage
	// is configured for the gateway, this field returns 0.
	WorkingStorageUsedInBytes *int64 `type:"long"`
}

// String returns the string representation
func (s DescribeWorkingStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkingStorageOutput) GoString() string {
	return s.String()
}

// SetDiskIds sets the DiskIds field's value.
func (s *DescribeWorkingStorageOutput) SetDiskIds(v []*string) *DescribeWorkingStorageOutput {
	s.DiskIds = v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DescribeWorkingStorageOutput) SetGatewayARN(v string) *DescribeWorkingStorageOutput {
	s.GatewayARN = &v
	return s
}

// SetWorkingStorageAllocatedInBytes sets the WorkingStorageAllocatedInBytes field's value.
func (s *DescribeWorkingStorageOutput) SetWorkingStorageAllocatedInBytes(v int64) *DescribeWorkingStorageOutput {
	s.WorkingStorageAllocatedInBytes = &v
	return s
}

// SetWorkingStorageUsedInBytes sets the WorkingStorageUsedInBytes field's value.
func (s *DescribeWorkingStorageOutput) SetWorkingStorageUsedInBytes(v int64) *DescribeWorkingStorageOutput {
	s.WorkingStorageUsedInBytes = &v
	return s
}

// Lists iSCSI information about a VTL device.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DeviceiSCSIAttributes
type DeviceiSCSIAttributes struct {
	_ struct{} `type:"structure"`

	// Indicates whether mutual CHAP is enabled for the iSCSI target.
	ChapEnabled *bool `type:"boolean"`

	// The network interface identifier of the VTL device.
	NetworkInterfaceId *string `type:"string"`

	// The port used to communicate with iSCSI VTL device targets.
	NetworkInterfacePort *int64 `type:"integer"`

	// Specifies the unique Amazon Resource Name(ARN) that encodes the iSCSI qualified
	// name(iqn) of a tape drive or media changer target.
	TargetARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DeviceiSCSIAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceiSCSIAttributes) GoString() string {
	return s.String()
}

// SetChapEnabled sets the ChapEnabled field's value.
func (s *DeviceiSCSIAttributes) SetChapEnabled(v bool) *DeviceiSCSIAttributes {
	s.ChapEnabled = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *DeviceiSCSIAttributes) SetNetworkInterfaceId(v string) *DeviceiSCSIAttributes {
	s.NetworkInterfaceId = &v
	return s
}

// SetNetworkInterfacePort sets the NetworkInterfacePort field's value.
func (s *DeviceiSCSIAttributes) SetNetworkInterfacePort(v int64) *DeviceiSCSIAttributes {
	s.NetworkInterfacePort = &v
	return s
}

// SetTargetARN sets the TargetARN field's value.
func (s *DeviceiSCSIAttributes) SetTargetARN(v string) *DeviceiSCSIAttributes {
	s.TargetARN = &v
	return s
}

// DisableGatewayInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DisableGatewayInput
type DisableGatewayInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableGatewayInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DisableGatewayInput) SetGatewayARN(v string) *DisableGatewayInput {
	s.GatewayARN = &v
	return s
}

// DisableGatewayOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/DisableGatewayOutput
type DisableGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The unique Amazon Resource Name of the disabled gateway.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s DisableGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableGatewayOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *DisableGatewayOutput) SetGatewayARN(v string) *DisableGatewayOutput {
	s.GatewayARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/Disk
type Disk struct {
	_ struct{} `type:"structure"`

	DiskAllocationResource *string `type:"string"`

	DiskAllocationType *string `min:"3" type:"string"`

	DiskId *string `min:"1" type:"string"`

	DiskNode *string `type:"string"`

	DiskPath *string `type:"string"`

	DiskSizeInBytes *int64 `type:"long"`

	DiskStatus *string `type:"string"`
}

// String returns the string representation
func (s Disk) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Disk) GoString() string {
	return s.String()
}

// SetDiskAllocationResource sets the DiskAllocationResource field's value.
func (s *Disk) SetDiskAllocationResource(v string) *Disk {
	s.DiskAllocationResource = &v
	return s
}

// SetDiskAllocationType sets the DiskAllocationType field's value.
func (s *Disk) SetDiskAllocationType(v string) *Disk {
	s.DiskAllocationType = &v
	return s
}

// SetDiskId sets the DiskId field's value.
func (s *Disk) SetDiskId(v string) *Disk {
	s.DiskId = &v
	return s
}

// SetDiskNode sets the DiskNode field's value.
func (s *Disk) SetDiskNode(v string) *Disk {
	s.DiskNode = &v
	return s
}

// SetDiskPath sets the DiskPath field's value.
func (s *Disk) SetDiskPath(v string) *Disk {
	s.DiskPath = &v
	return s
}

// SetDiskSizeInBytes sets the DiskSizeInBytes field's value.
func (s *Disk) SetDiskSizeInBytes(v int64) *Disk {
	s.DiskSizeInBytes = &v
	return s
}

// SetDiskStatus sets the DiskStatus field's value.
func (s *Disk) SetDiskStatus(v string) *Disk {
	s.DiskStatus = &v
	return s
}

// Provides additional information about an error that was returned by the service
// as an or. See the errorCode and errorDetails members for more information
// about the error.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/StorageGatewayError
type Error struct {
	_ struct{} `type:"structure"`

	// Additional information about the error.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"ErrorCode"`

	// Human-readable text that provides detail about the error that occurred.
	ErrorDetails map[string]*string `locationName:"errorDetails" type:"map"`
}

// String returns the string representation
func (s Error) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Error) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *Error) SetErrorCode(v string) *Error {
	s.ErrorCode = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *Error) SetErrorDetails(v map[string]*string) *Error {
	s.ErrorDetails = v
	return s
}

// Describes a file share.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/FileShareInfo
type FileShareInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the file share.
	FileShareARN *string `min:"50" type:"string"`

	// The ID of the file share.
	FileShareId *string `min:"12" type:"string"`

	// The status of the file share. Possible values are CREATING, UPDATING, AVAILABLE
	// and DELETING.
	FileShareStatus *string `min:"3" type:"string"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s FileShareInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FileShareInfo) GoString() string {
	return s.String()
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *FileShareInfo) SetFileShareARN(v string) *FileShareInfo {
	s.FileShareARN = &v
	return s
}

// SetFileShareId sets the FileShareId field's value.
func (s *FileShareInfo) SetFileShareId(v string) *FileShareInfo {
	s.FileShareId = &v
	return s
}

// SetFileShareStatus sets the FileShareStatus field's value.
func (s *FileShareInfo) SetFileShareStatus(v string) *FileShareInfo {
	s.FileShareStatus = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *FileShareInfo) SetGatewayARN(v string) *FileShareInfo {
	s.GatewayARN = &v
	return s
}

// Describes a gateway object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/GatewayInfo
type GatewayInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	// The unique identifier assigned to your gateway during activation. This ID
	// becomes part of the gateway Amazon Resource Name (ARN), which you use as
	// input for other operations.
	GatewayId *string `min:"12" type:"string"`

	// The name of the gateway.
	GatewayName *string `type:"string"`

	// The state of the gateway.
	//
	// Valid Values: DISABLED or ACTIVE
	GatewayOperationalState *string `min:"2" type:"string"`

	// The type of the gateway.
	GatewayType *string `min:"2" type:"string"`
}

// String returns the string representation
func (s GatewayInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GatewayInfo) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *GatewayInfo) SetGatewayARN(v string) *GatewayInfo {
	s.GatewayARN = &v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *GatewayInfo) SetGatewayId(v string) *GatewayInfo {
	s.GatewayId = &v
	return s
}

// SetGatewayName sets the GatewayName field's value.
func (s *GatewayInfo) SetGatewayName(v string) *GatewayInfo {
	s.GatewayName = &v
	return s
}

// SetGatewayOperationalState sets the GatewayOperationalState field's value.
func (s *GatewayInfo) SetGatewayOperationalState(v string) *GatewayInfo {
	s.GatewayOperationalState = &v
	return s
}

// SetGatewayType sets the GatewayType field's value.
func (s *GatewayInfo) SetGatewayType(v string) *GatewayInfo {
	s.GatewayType = &v
	return s
}

// ListFileShareInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListFileSharesInput
type ListFileSharesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource Name (ARN) of the gateway whose file shares you want
	// to list. If this field is not present, all file shares under your account
	// are listed.
	GatewayARN *string `min:"50" type:"string"`

	// The maximum number of file shares to return in the response. The value must
	// be an integer with a value greater than zero. Optional.
	Limit *int64 `min:"1" type:"integer"`

	// Opaque pagination token returned from a previous ListFileShares operation.
	// If present, Marker specifies where to continue the list from after a previous
	// call to ListFileShares. Optional.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListFileSharesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFileSharesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFileSharesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFileSharesInput"}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ListFileSharesInput) SetGatewayARN(v string) *ListFileSharesInput {
	s.GatewayARN = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListFileSharesInput) SetLimit(v int64) *ListFileSharesInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListFileSharesInput) SetMarker(v string) *ListFileSharesInput {
	s.Marker = &v
	return s
}

// ListFileShareOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListFileSharesOutput
type ListFileSharesOutput struct {
	_ struct{} `type:"structure"`

	// An array of information about the file gateway's file shares.
	FileShareInfoList []*FileShareInfo `type:"list"`

	// If the request includes Marker, the response returns that value in this field.
	Marker *string `min:"1" type:"string"`

	// If a value is present, there are more file shares to return. In a subsequent
	// request, use NextMarker as the value for Marker to retrieve the next set
	// of file shares.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListFileSharesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFileSharesOutput) GoString() string {
	return s.String()
}

// SetFileShareInfoList sets the FileShareInfoList field's value.
func (s *ListFileSharesOutput) SetFileShareInfoList(v []*FileShareInfo) *ListFileSharesOutput {
	s.FileShareInfoList = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListFileSharesOutput) SetMarker(v string) *ListFileSharesOutput {
	s.Marker = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListFileSharesOutput) SetNextMarker(v string) *ListFileSharesOutput {
	s.NextMarker = &v
	return s
}

// A JSON object containing zero or more of the following fields:
//
//    * ListGatewaysInput$Limit
//
//    * ListGatewaysInput$Marker
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListGatewaysInput
type ListGatewaysInput struct {
	_ struct{} `type:"structure"`

	// Specifies that the list of gateways returned be limited to the specified
	// number of items.
	Limit *int64 `min:"1" type:"integer"`

	// An opaque string that indicates the position at which to begin the returned
	// list of gateways.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGatewaysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGatewaysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGatewaysInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListGatewaysInput) SetLimit(v int64) *ListGatewaysInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListGatewaysInput) SetMarker(v string) *ListGatewaysInput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListGatewaysOutput
type ListGatewaysOutput struct {
	_ struct{} `type:"structure"`

	Gateways []*GatewayInfo `type:"list"`

	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGatewaysOutput) GoString() string {
	return s.String()
}

// SetGateways sets the Gateways field's value.
func (s *ListGatewaysOutput) SetGateways(v []*GatewayInfo) *ListGatewaysOutput {
	s.Gateways = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListGatewaysOutput) SetMarker(v string) *ListGatewaysOutput {
	s.Marker = &v
	return s
}

// A JSON object containing the of the gateway.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListLocalDisksInput
type ListLocalDisksInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s ListLocalDisksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLocalDisksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLocalDisksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLocalDisksInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ListLocalDisksInput) SetGatewayARN(v string) *ListLocalDisksInput {
	s.GatewayARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListLocalDisksOutput
type ListLocalDisksOutput struct {
	_ struct{} `type:"structure"`

	Disks []*Disk `type:"list"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s ListLocalDisksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLocalDisksOutput) GoString() string {
	return s.String()
}

// SetDisks sets the Disks field's value.
func (s *ListLocalDisksOutput) SetDisks(v []*Disk) *ListLocalDisksOutput {
	s.Disks = v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ListLocalDisksOutput) SetGatewayARN(v string) *ListLocalDisksOutput {
	s.GatewayARN = &v
	return s
}

// ListTagsForResourceInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTagsForResourceInput
type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Specifies that the list of tags returned be limited to the specified number
	// of items.
	Limit *int64 `min:"1" type:"integer"`

	// An opaque string that indicates the position at which to begin returning
	// the list of tags.
	Marker *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the resource for which you want to list
	// tags.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListTagsForResourceInput) SetLimit(v int64) *ListTagsForResourceInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListTagsForResourceInput) SetMarker(v string) *ListTagsForResourceInput {
	s.Marker = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

// ListTagsForResourceOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTagsForResourceOutput
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// An opaque string that indicates the position at which to stop returning the
	// list of tags.
	Marker *string `min:"1" type:"string"`

	// he Amazon Resource Name (ARN) of the resource for which you want to list
	// tags.
	ResourceARN *string `min:"50" type:"string"`

	// An array that contains the tags for the specified resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListTagsForResourceOutput) SetMarker(v string) *ListTagsForResourceOutput {
	s.Marker = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceOutput) SetResourceARN(v string) *ListTagsForResourceOutput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A JSON object that contains one or more of the following fields:
//
//    * ListTapesInput$Limit
//
//    * ListTapesInput$Marker
//
//    * ListTapesInput$TapeARNs
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapesInput
type ListTapesInput struct {
	_ struct{} `type:"structure"`

	// An optional number limit for the tapes in the list returned by this call.
	Limit *int64 `min:"1" type:"integer"`

	// A string that indicates the position at which to begin the returned list
	// of tapes.
	Marker *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of each of the tapes you want to list. If
	// you don't specify a tape ARN, the response lists all tapes in both your VTL
	// and VTS.
	TapeARNs []*string `type:"list"`
}

// String returns the string representation
func (s ListTapesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTapesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTapesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTapesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListTapesInput) SetLimit(v int64) *ListTapesInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListTapesInput) SetMarker(v string) *ListTapesInput {
	s.Marker = &v
	return s
}

// SetTapeARNs sets the TapeARNs field's value.
func (s *ListTapesInput) SetTapeARNs(v []*string) *ListTapesInput {
	s.TapeARNs = v
	return s
}

// A JSON object containing the following fields:
//
//    * ListTapesOutput$Marker
//
//    * ListTapesOutput$VolumeInfos
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListTapesOutput
type ListTapesOutput struct {
	_ struct{} `type:"structure"`

	// A string that indicates the position at which to begin returning the next
	// list of tapes. Use the marker in your next request to continue pagination
	// of tapes. If there are no more tapes to list, this element does not appear
	// in the response body.
	Marker *string `min:"1" type:"string"`

	// An array of TapeInfo objects, where each object describes an a single tape.
	// If there not tapes in the tape library or VTS, then the TapeInfos is an empty
	// array.
	TapeInfos []*TapeInfo `type:"list"`
}

// String returns the string representation
func (s ListTapesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTapesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *ListTapesOutput) SetMarker(v string) *ListTapesOutput {
	s.Marker = &v
	return s
}

// SetTapeInfos sets the TapeInfos field's value.
func (s *ListTapesOutput) SetTapeInfos(v []*TapeInfo) *ListTapesOutput {
	s.TapeInfos = v
	return s
}

// ListVolumeInitiatorsInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumeInitiatorsInput
type ListVolumeInitiatorsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes for the gateway.
	//
	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s ListVolumeInitiatorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumeInitiatorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVolumeInitiatorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVolumeInitiatorsInput"}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *ListVolumeInitiatorsInput) SetVolumeARN(v string) *ListVolumeInitiatorsInput {
	s.VolumeARN = &v
	return s
}

// ListVolumeInitiatorsOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumeInitiatorsOutput
type ListVolumeInitiatorsOutput struct {
	_ struct{} `type:"structure"`

	// The host names and port numbers of all iSCSI initiators that are connected
	// to the gateway.
	Initiators []*string `type:"list"`
}

// String returns the string representation
func (s ListVolumeInitiatorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumeInitiatorsOutput) GoString() string {
	return s.String()
}

// SetInitiators sets the Initiators field's value.
func (s *ListVolumeInitiatorsOutput) SetInitiators(v []*string) *ListVolumeInitiatorsOutput {
	s.Initiators = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumeRecoveryPointsInput
type ListVolumeRecoveryPointsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s ListVolumeRecoveryPointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumeRecoveryPointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVolumeRecoveryPointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVolumeRecoveryPointsInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ListVolumeRecoveryPointsInput) SetGatewayARN(v string) *ListVolumeRecoveryPointsInput {
	s.GatewayARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumeRecoveryPointsOutput
type ListVolumeRecoveryPointsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	VolumeRecoveryPointInfos []*VolumeRecoveryPointInfo `type:"list"`
}

// String returns the string representation
func (s ListVolumeRecoveryPointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumeRecoveryPointsOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ListVolumeRecoveryPointsOutput) SetGatewayARN(v string) *ListVolumeRecoveryPointsOutput {
	s.GatewayARN = &v
	return s
}

// SetVolumeRecoveryPointInfos sets the VolumeRecoveryPointInfos field's value.
func (s *ListVolumeRecoveryPointsOutput) SetVolumeRecoveryPointInfos(v []*VolumeRecoveryPointInfo) *ListVolumeRecoveryPointsOutput {
	s.VolumeRecoveryPointInfos = v
	return s
}

// A JSON object that contains one or more of the following fields:
//
//    * ListVolumesInput$Limit
//
//    * ListVolumesInput$Marker
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumesInput
type ListVolumesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	// Specifies that the list of volumes returned be limited to the specified number
	// of items.
	Limit *int64 `min:"1" type:"integer"`

	// A string that indicates the position at which to begin the returned list
	// of volumes. Obtain the marker from the response of a previous List iSCSI
	// Volumes request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListVolumesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVolumesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVolumesInput"}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ListVolumesInput) SetGatewayARN(v string) *ListVolumesInput {
	s.GatewayARN = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListVolumesInput) SetLimit(v int64) *ListVolumesInput {
	s.Limit = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListVolumesInput) SetMarker(v string) *ListVolumesInput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumesOutput
type ListVolumesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	Marker *string `min:"1" type:"string"`

	VolumeInfos []*VolumeInfo `type:"list"`
}

// String returns the string representation
func (s ListVolumesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumesOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ListVolumesOutput) SetGatewayARN(v string) *ListVolumesOutput {
	s.GatewayARN = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListVolumesOutput) SetMarker(v string) *ListVolumesOutput {
	s.Marker = &v
	return s
}

// SetVolumeInfos sets the VolumeInfos field's value.
func (s *ListVolumesOutput) SetVolumeInfos(v []*VolumeInfo) *ListVolumesOutput {
	s.VolumeInfos = v
	return s
}

// Describes file share default values. Files and folders stored as Amazon S3
// objects in S3 buckets don't, by default, have Unix file permissions assigned
// to them. Upon discovery in an S3 bucket by Storage Gateway, the S3 objects
// that represent files and folders are assigned these default Unix permissions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/NFSFileShareDefaults
type NFSFileShareDefaults struct {
	_ struct{} `type:"structure"`

	// The Unix directory mode in the form "nnnn". For example, "0666" represents
	// the default access mode for all directories inside the file share. The default
	// value is 0777.
	DirectoryMode *string `min:"1" type:"string"`

	// The Unix file mode in the form "nnnn". For example, "0666" represents the
	// default file mode inside the file share. The default value is 0666.
	FileMode *string `min:"1" type:"string"`

	// The default group ID for the file share (unless the files have another group
	// ID specified). The default value is nfsnobody.
	GroupId *int64 `type:"long"`

	// The default owner ID for files in the file share (unless the files have another
	// owner ID specified). The default value is nfsnobody.
	OwnerId *int64 `type:"long"`
}

// String returns the string representation
func (s NFSFileShareDefaults) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NFSFileShareDefaults) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NFSFileShareDefaults) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NFSFileShareDefaults"}
	if s.DirectoryMode != nil && len(*s.DirectoryMode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryMode", 1))
	}
	if s.FileMode != nil && len(*s.FileMode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileMode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryMode sets the DirectoryMode field's value.
func (s *NFSFileShareDefaults) SetDirectoryMode(v string) *NFSFileShareDefaults {
	s.DirectoryMode = &v
	return s
}

// SetFileMode sets the FileMode field's value.
func (s *NFSFileShareDefaults) SetFileMode(v string) *NFSFileShareDefaults {
	s.FileMode = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *NFSFileShareDefaults) SetGroupId(v int64) *NFSFileShareDefaults {
	s.GroupId = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *NFSFileShareDefaults) SetOwnerId(v int64) *NFSFileShareDefaults {
	s.OwnerId = &v
	return s
}

// The Unix file permissions and ownership information assigned, by default,
// to native S3 objects when Storage Gateway discovers them in S3 buckets.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/NFSFileShareInfo
type NFSFileShareInfo struct {
	_ struct{} `type:"structure"`

	// The list of clients that are allowed to access the file gateway. The list
	// must contain either valid IP addresses or valid CIDR blocks.
	ClientList []*string `min:"1" type:"list"`

	// The default storage class for objects put into an Amazon S3 bucket by file
	// gateway. Possible values are S3_STANDARD or S3_STANDARD_IA. If this field
	// is not populated, the default value S3_STANDARD is used. Optional.
	DefaultStorageClass *string `min:"5" type:"string"`

	// The Amazon Resource Name (ARN) of the file share.
	FileShareARN *string `min:"50" type:"string"`

	// The ID of the file share.
	FileShareId *string `min:"12" type:"string"`

	// The status of the file share. Possible values are CREATING, UPDATING, AVAILABLE
	// and DELETING.
	FileShareStatus *string `min:"3" type:"string"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	// True to use Amazon S3 server side encryption with your own KMS key, or false
	// to use a key managed by Amazon S3. Optional.
	KMSEncrypted *bool `type:"boolean"`

	// The ARN of the KMS key used for Amazon S3 server side encryption.
	KMSKey *string `min:"20" type:"string"`

	// The ARN of the backend storage used for storing file data.
	LocationARN *string `min:"16" type:"string"`

	// Describes file share default values. Files and folders stored as Amazon S3
	// objects in S3 buckets don't, by default, have Unix file permissions assigned
	// to them. Upon discovery in an S3 bucket by Storage Gateway, the S3 objects
	// that represent files and folders are assigned these default Unix permissions.
	NFSFileShareDefaults *NFSFileShareDefaults `type:"structure"`

	// The file share path used by the NFS client to identify the mount point.
	Path *string `type:"string"`

	// The ARN of the IAM role that file gateway assumes when it accesses the underlying
	// storage.
	Role *string `min:"20" type:"string"`
}

// String returns the string representation
func (s NFSFileShareInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NFSFileShareInfo) GoString() string {
	return s.String()
}

// SetClientList sets the ClientList field's value.
func (s *NFSFileShareInfo) SetClientList(v []*string) *NFSFileShareInfo {
	s.ClientList = v
	return s
}

// SetDefaultStorageClass sets the DefaultStorageClass field's value.
func (s *NFSFileShareInfo) SetDefaultStorageClass(v string) *NFSFileShareInfo {
	s.DefaultStorageClass = &v
	return s
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *NFSFileShareInfo) SetFileShareARN(v string) *NFSFileShareInfo {
	s.FileShareARN = &v
	return s
}

// SetFileShareId sets the FileShareId field's value.
func (s *NFSFileShareInfo) SetFileShareId(v string) *NFSFileShareInfo {
	s.FileShareId = &v
	return s
}

// SetFileShareStatus sets the FileShareStatus field's value.
func (s *NFSFileShareInfo) SetFileShareStatus(v string) *NFSFileShareInfo {
	s.FileShareStatus = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *NFSFileShareInfo) SetGatewayARN(v string) *NFSFileShareInfo {
	s.GatewayARN = &v
	return s
}

// SetKMSEncrypted sets the KMSEncrypted field's value.
func (s *NFSFileShareInfo) SetKMSEncrypted(v bool) *NFSFileShareInfo {
	s.KMSEncrypted = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *NFSFileShareInfo) SetKMSKey(v string) *NFSFileShareInfo {
	s.KMSKey = &v
	return s
}

// SetLocationARN sets the LocationARN field's value.
func (s *NFSFileShareInfo) SetLocationARN(v string) *NFSFileShareInfo {
	s.LocationARN = &v
	return s
}

// SetNFSFileShareDefaults sets the NFSFileShareDefaults field's value.
func (s *NFSFileShareInfo) SetNFSFileShareDefaults(v *NFSFileShareDefaults) *NFSFileShareInfo {
	s.NFSFileShareDefaults = v
	return s
}

// SetPath sets the Path field's value.
func (s *NFSFileShareInfo) SetPath(v string) *NFSFileShareInfo {
	s.Path = &v
	return s
}

// SetRole sets the Role field's value.
func (s *NFSFileShareInfo) SetRole(v string) *NFSFileShareInfo {
	s.Role = &v
	return s
}

// Describes a gateway's network interface.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/NetworkInterface
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// The Internet Protocol version 4 (IPv4) address of the interface.
	Ipv4Address *string `type:"string"`

	// The Internet Protocol version 6 (IPv6) address of the interface. Currently
	// not supported.
	Ipv6Address *string `type:"string"`

	// The Media Access Control (MAC) address of the interface.
	//
	// This is currently unsupported and will not be returned in output.
	MacAddress *string `type:"string"`
}

// String returns the string representation
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkInterface) GoString() string {
	return s.String()
}

// SetIpv4Address sets the Ipv4Address field's value.
func (s *NetworkInterface) SetIpv4Address(v string) *NetworkInterface {
	s.Ipv4Address = &v
	return s
}

// SetIpv6Address sets the Ipv6Address field's value.
func (s *NetworkInterface) SetIpv6Address(v string) *NetworkInterface {
	s.Ipv6Address = &v
	return s
}

// SetMacAddress sets the MacAddress field's value.
func (s *NetworkInterface) SetMacAddress(v string) *NetworkInterface {
	s.MacAddress = &v
	return s
}

// RemoveTagsFromResourceInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RemoveTagsFromResourceInput
type RemoveTagsFromResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource you want to remove the tags
	// from.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"50" type:"string" required:"true"`

	// The keys of the tags you want to remove from the specified resource. A tag
	// is composed of a key/value pair.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 50))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *RemoveTagsFromResourceInput) SetResourceARN(v string) *RemoveTagsFromResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *RemoveTagsFromResourceInput) SetTagKeys(v []*string) *RemoveTagsFromResourceInput {
	s.TagKeys = v
	return s
}

// RemoveTagsFromResourceOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RemoveTagsFromResourceOutput
type RemoveTagsFromResourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that the tags were removed
	// from.
	ResourceARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s RemoveTagsFromResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceOutput) GoString() string {
	return s.String()
}

// SetResourceARN sets the ResourceARN field's value.
func (s *RemoveTagsFromResourceOutput) SetResourceARN(v string) *RemoveTagsFromResourceOutput {
	s.ResourceARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ResetCacheInput
type ResetCacheInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s ResetCacheInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetCacheInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetCacheInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetCacheInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ResetCacheInput) SetGatewayARN(v string) *ResetCacheInput {
	s.GatewayARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ResetCacheOutput
type ResetCacheOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s ResetCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetCacheOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ResetCacheOutput) SetGatewayARN(v string) *ResetCacheOutput {
	s.GatewayARN = &v
	return s
}

// RetrieveTapeArchiveInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RetrieveTapeArchiveInput
type RetrieveTapeArchiveInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway you want to retrieve the virtual
	// tape to. Use the ListGateways operation to return a list of gateways for
	// your account and region.
	//
	// You retrieve archived virtual tapes to only one gateway and the gateway must
	// be a gateway-VTL.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from
	// the virtual tape shelf (VTS).
	//
	// TapeARN is a required field
	TapeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s RetrieveTapeArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveTapeArchiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieveTapeArchiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrieveTapeArchiveInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.TapeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeARN"))
	}
	if s.TapeARN != nil && len(*s.TapeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TapeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *RetrieveTapeArchiveInput) SetGatewayARN(v string) *RetrieveTapeArchiveInput {
	s.GatewayARN = &v
	return s
}

// SetTapeARN sets the TapeARN field's value.
func (s *RetrieveTapeArchiveInput) SetTapeARN(v string) *RetrieveTapeArchiveInput {
	s.TapeARN = &v
	return s
}

// RetrieveTapeArchiveOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RetrieveTapeArchiveOutput
type RetrieveTapeArchiveOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the retrieved virtual tape.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s RetrieveTapeArchiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveTapeArchiveOutput) GoString() string {
	return s.String()
}

// SetTapeARN sets the TapeARN field's value.
func (s *RetrieveTapeArchiveOutput) SetTapeARN(v string) *RetrieveTapeArchiveOutput {
	s.TapeARN = &v
	return s
}

// RetrieveTapeRecoveryPointInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RetrieveTapeRecoveryPointInput
type RetrieveTapeRecoveryPointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape for which you want to
	// retrieve the recovery point.
	//
	// TapeARN is a required field
	TapeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s RetrieveTapeRecoveryPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveTapeRecoveryPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieveTapeRecoveryPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrieveTapeRecoveryPointInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.TapeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TapeARN"))
	}
	if s.TapeARN != nil && len(*s.TapeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TapeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *RetrieveTapeRecoveryPointInput) SetGatewayARN(v string) *RetrieveTapeRecoveryPointInput {
	s.GatewayARN = &v
	return s
}

// SetTapeARN sets the TapeARN field's value.
func (s *RetrieveTapeRecoveryPointInput) SetTapeARN(v string) *RetrieveTapeRecoveryPointInput {
	s.TapeARN = &v
	return s
}

// RetrieveTapeRecoveryPointOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/RetrieveTapeRecoveryPointOutput
type RetrieveTapeRecoveryPointOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the virtual tape for which the recovery
	// point was retrieved.
	TapeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s RetrieveTapeRecoveryPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveTapeRecoveryPointOutput) GoString() string {
	return s.String()
}

// SetTapeARN sets the TapeARN field's value.
func (s *RetrieveTapeRecoveryPointOutput) SetTapeARN(v string) *RetrieveTapeRecoveryPointOutput {
	s.TapeARN = &v
	return s
}

// SetLocalConsolePasswordInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/SetLocalConsolePasswordInput
type SetLocalConsolePasswordInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The password you want to set for your VM local console.
	//
	// LocalConsolePassword is a required field
	LocalConsolePassword *string `min:"6" type:"string" required:"true"`
}

// String returns the string representation
func (s SetLocalConsolePasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetLocalConsolePasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetLocalConsolePasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetLocalConsolePasswordInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.LocalConsolePassword == nil {
		invalidParams.Add(request.NewErrParamRequired("LocalConsolePassword"))
	}
	if s.LocalConsolePassword != nil && len(*s.LocalConsolePassword) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("LocalConsolePassword", 6))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *SetLocalConsolePasswordInput) SetGatewayARN(v string) *SetLocalConsolePasswordInput {
	s.GatewayARN = &v
	return s
}

// SetLocalConsolePassword sets the LocalConsolePassword field's value.
func (s *SetLocalConsolePasswordInput) SetLocalConsolePassword(v string) *SetLocalConsolePasswordInput {
	s.LocalConsolePassword = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/SetLocalConsolePasswordOutput
type SetLocalConsolePasswordOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s SetLocalConsolePasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetLocalConsolePasswordOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *SetLocalConsolePasswordOutput) SetGatewayARN(v string) *SetLocalConsolePasswordOutput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the of the gateway to shut down.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ShutdownGatewayInput
type ShutdownGatewayInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s ShutdownGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ShutdownGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ShutdownGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ShutdownGatewayInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ShutdownGatewayInput) SetGatewayARN(v string) *ShutdownGatewayInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the of the gateway that was shut down.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ShutdownGatewayOutput
type ShutdownGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s ShutdownGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ShutdownGatewayOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *ShutdownGatewayOutput) SetGatewayARN(v string) *ShutdownGatewayOutput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the of the gateway to start.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/StartGatewayInput
type StartGatewayInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s StartGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartGatewayInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartGatewayInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartGatewayInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *StartGatewayInput) SetGatewayARN(v string) *StartGatewayInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the of the gateway that was restarted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/StartGatewayOutput
type StartGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s StartGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartGatewayOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *StartGatewayOutput) SetGatewayARN(v string) *StartGatewayOutput {
	s.GatewayARN = &v
	return s
}

// Describes an iSCSI stored volume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/StorediSCSIVolume
type StorediSCSIVolume struct {
	_ struct{} `type:"structure"`

	CreatedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Indicates if when the stored volume was created, existing data on the underlying
	// local disk was preserved.
	//
	// Valid Values: true, false
	PreservedExistingData *bool `type:"boolean"`

	// If the stored volume was created from a snapshot, this field contains the
	// snapshot ID used, e.g. snap-78e22663. Otherwise, this field is not included.
	SourceSnapshotId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the storage volume.
	VolumeARN *string `min:"50" type:"string"`

	// The ID of the local disk that was specified in the CreateStorediSCSIVolume
	// operation.
	VolumeDiskId *string `min:"1" type:"string"`

	// The unique identifier of the volume, e.g. vol-AE4B946D.
	VolumeId *string `min:"12" type:"string"`

	// Represents the percentage complete if the volume is restoring or bootstrapping
	// that represents the percent of data transferred. This field does not appear
	// in the response if the stored volume is not restoring or bootstrapping.
	VolumeProgress *float64 `type:"double"`

	// The size of the volume in bytes.
	VolumeSizeInBytes *int64 `type:"long"`

	// One of the VolumeStatus values that indicates the state of the storage volume.
	VolumeStatus *string `min:"3" type:"string"`

	// One of the VolumeType enumeration values describing the type of the volume.
	VolumeType *string `min:"3" type:"string"`

	// An VolumeiSCSIAttributes object that represents a collection of iSCSI attributes
	// for one stored volume.
	VolumeiSCSIAttributes *VolumeiSCSIAttributes `type:"structure"`
}

// String returns the string representation
func (s StorediSCSIVolume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorediSCSIVolume) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *StorediSCSIVolume) SetCreatedDate(v time.Time) *StorediSCSIVolume {
	s.CreatedDate = &v
	return s
}

// SetPreservedExistingData sets the PreservedExistingData field's value.
func (s *StorediSCSIVolume) SetPreservedExistingData(v bool) *StorediSCSIVolume {
	s.PreservedExistingData = &v
	return s
}

// SetSourceSnapshotId sets the SourceSnapshotId field's value.
func (s *StorediSCSIVolume) SetSourceSnapshotId(v string) *StorediSCSIVolume {
	s.SourceSnapshotId = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *StorediSCSIVolume) SetVolumeARN(v string) *StorediSCSIVolume {
	s.VolumeARN = &v
	return s
}

// SetVolumeDiskId sets the VolumeDiskId field's value.
func (s *StorediSCSIVolume) SetVolumeDiskId(v string) *StorediSCSIVolume {
	s.VolumeDiskId = &v
	return s
}

// SetVolumeId sets the VolumeId field's value.
func (s *StorediSCSIVolume) SetVolumeId(v string) *StorediSCSIVolume {
	s.VolumeId = &v
	return s
}

// SetVolumeProgress sets the VolumeProgress field's value.
func (s *StorediSCSIVolume) SetVolumeProgress(v float64) *StorediSCSIVolume {
	s.VolumeProgress = &v
	return s
}

// SetVolumeSizeInBytes sets the VolumeSizeInBytes field's value.
func (s *StorediSCSIVolume) SetVolumeSizeInBytes(v int64) *StorediSCSIVolume {
	s.VolumeSizeInBytes = &v
	return s
}

// SetVolumeStatus sets the VolumeStatus field's value.
func (s *StorediSCSIVolume) SetVolumeStatus(v string) *StorediSCSIVolume {
	s.VolumeStatus = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *StorediSCSIVolume) SetVolumeType(v string) *StorediSCSIVolume {
	s.VolumeType = &v
	return s
}

// SetVolumeiSCSIAttributes sets the VolumeiSCSIAttributes field's value.
func (s *StorediSCSIVolume) SetVolumeiSCSIAttributes(v *VolumeiSCSIAttributes) *StorediSCSIVolume {
	s.VolumeiSCSIAttributes = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Describes a virtual tape object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/Tape
type Tape struct {
	_ struct{} `type:"structure"`

	// For archiving virtual tapes, indicates how much data remains to be uploaded
	// before archiving is complete.
	//
	// Range: 0 (not started) to 100 (complete).
	Progress *float64 `type:"double"`

	// The Amazon Resource Name (ARN) of the virtual tape.
	TapeARN *string `min:"50" type:"string"`

	// The barcode that identifies a specific virtual tape.
	TapeBarcode *string `min:"7" type:"string"`

	TapeCreatedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The size, in bytes, of the virtual tape.
	TapeSizeInBytes *int64 `type:"long"`

	// The current state of the virtual tape.
	TapeStatus *string `type:"string"`

	// The virtual tape library (VTL) device that the virtual tape is associated
	// with.
	VTLDevice *string `min:"50" type:"string"`
}

// String returns the string representation
func (s Tape) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tape) GoString() string {
	return s.String()
}

// SetProgress sets the Progress field's value.
func (s *Tape) SetProgress(v float64) *Tape {
	s.Progress = &v
	return s
}

// SetTapeARN sets the TapeARN field's value.
func (s *Tape) SetTapeARN(v string) *Tape {
	s.TapeARN = &v
	return s
}

// SetTapeBarcode sets the TapeBarcode field's value.
func (s *Tape) SetTapeBarcode(v string) *Tape {
	s.TapeBarcode = &v
	return s
}

// SetTapeCreatedDate sets the TapeCreatedDate field's value.
func (s *Tape) SetTapeCreatedDate(v time.Time) *Tape {
	s.TapeCreatedDate = &v
	return s
}

// SetTapeSizeInBytes sets the TapeSizeInBytes field's value.
func (s *Tape) SetTapeSizeInBytes(v int64) *Tape {
	s.TapeSizeInBytes = &v
	return s
}

// SetTapeStatus sets the TapeStatus field's value.
func (s *Tape) SetTapeStatus(v string) *Tape {
	s.TapeStatus = &v
	return s
}

// SetVTLDevice sets the VTLDevice field's value.
func (s *Tape) SetVTLDevice(v string) *Tape {
	s.VTLDevice = &v
	return s
}

// Represents a virtual tape that is archived in the virtual tape shelf (VTS).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/TapeArchive
type TapeArchive struct {
	_ struct{} `type:"structure"`

	// The time that the archiving of the virtual tape was completed.
	//
	// The string format of the completion time is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z'
	// format.
	CompletionTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the gateway-VTL that the virtual tape is
	// being retrieved to.
	//
	// The virtual tape is retrieved from the virtual tape shelf (VTS).
	RetrievedTo *string `min:"50" type:"string"`

	// The Amazon Resource Name (ARN) of an archived virtual tape.
	TapeARN *string `min:"50" type:"string"`

	// The barcode that identifies the archived virtual tape.
	TapeBarcode *string `min:"7" type:"string"`

	TapeCreatedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The size, in bytes, of the archived virtual tape.
	TapeSizeInBytes *int64 `type:"long"`

	// The current state of the archived virtual tape.
	TapeStatus *string `type:"string"`
}

// String returns the string representation
func (s TapeArchive) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TapeArchive) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *TapeArchive) SetCompletionTime(v time.Time) *TapeArchive {
	s.CompletionTime = &v
	return s
}

// SetRetrievedTo sets the RetrievedTo field's value.
func (s *TapeArchive) SetRetrievedTo(v string) *TapeArchive {
	s.RetrievedTo = &v
	return s
}

// SetTapeARN sets the TapeARN field's value.
func (s *TapeArchive) SetTapeARN(v string) *TapeArchive {
	s.TapeARN = &v
	return s
}

// SetTapeBarcode sets the TapeBarcode field's value.
func (s *TapeArchive) SetTapeBarcode(v string) *TapeArchive {
	s.TapeBarcode = &v
	return s
}

// SetTapeCreatedDate sets the TapeCreatedDate field's value.
func (s *TapeArchive) SetTapeCreatedDate(v time.Time) *TapeArchive {
	s.TapeCreatedDate = &v
	return s
}

// SetTapeSizeInBytes sets the TapeSizeInBytes field's value.
func (s *TapeArchive) SetTapeSizeInBytes(v int64) *TapeArchive {
	s.TapeSizeInBytes = &v
	return s
}

// SetTapeStatus sets the TapeStatus field's value.
func (s *TapeArchive) SetTapeStatus(v string) *TapeArchive {
	s.TapeStatus = &v
	return s
}

// Describes a virtual tape.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/TapeInfo
type TapeInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	// The Amazon Resource Name (ARN) of a virtual tape.
	TapeARN *string `min:"50" type:"string"`

	// The barcode that identifies a specific virtual tape.
	TapeBarcode *string `min:"7" type:"string"`

	// The size, in bytes, of a virtual tape.
	TapeSizeInBytes *int64 `type:"long"`

	// The status of the tape.
	TapeStatus *string `type:"string"`
}

// String returns the string representation
func (s TapeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TapeInfo) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *TapeInfo) SetGatewayARN(v string) *TapeInfo {
	s.GatewayARN = &v
	return s
}

// SetTapeARN sets the TapeARN field's value.
func (s *TapeInfo) SetTapeARN(v string) *TapeInfo {
	s.TapeARN = &v
	return s
}

// SetTapeBarcode sets the TapeBarcode field's value.
func (s *TapeInfo) SetTapeBarcode(v string) *TapeInfo {
	s.TapeBarcode = &v
	return s
}

// SetTapeSizeInBytes sets the TapeSizeInBytes field's value.
func (s *TapeInfo) SetTapeSizeInBytes(v int64) *TapeInfo {
	s.TapeSizeInBytes = &v
	return s
}

// SetTapeStatus sets the TapeStatus field's value.
func (s *TapeInfo) SetTapeStatus(v string) *TapeInfo {
	s.TapeStatus = &v
	return s
}

// Describes a recovery point.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/TapeRecoveryPointInfo
type TapeRecoveryPointInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the virtual tape.
	TapeARN *string `min:"50" type:"string"`

	// The time when the point-in-time view of the virtual tape was replicated for
	// later recovery.
	//
	// The string format of the tape recovery point time is in the ISO8601 extended
	// YYYY-MM-DD'T'HH:MM:SS'Z' format.
	TapeRecoveryPointTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The size, in bytes, of the virtual tapes to recover.
	TapeSizeInBytes *int64 `type:"long"`

	TapeStatus *string `type:"string"`
}

// String returns the string representation
func (s TapeRecoveryPointInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TapeRecoveryPointInfo) GoString() string {
	return s.String()
}

// SetTapeARN sets the TapeARN field's value.
func (s *TapeRecoveryPointInfo) SetTapeARN(v string) *TapeRecoveryPointInfo {
	s.TapeARN = &v
	return s
}

// SetTapeRecoveryPointTime sets the TapeRecoveryPointTime field's value.
func (s *TapeRecoveryPointInfo) SetTapeRecoveryPointTime(v time.Time) *TapeRecoveryPointInfo {
	s.TapeRecoveryPointTime = &v
	return s
}

// SetTapeSizeInBytes sets the TapeSizeInBytes field's value.
func (s *TapeRecoveryPointInfo) SetTapeSizeInBytes(v int64) *TapeRecoveryPointInfo {
	s.TapeSizeInBytes = &v
	return s
}

// SetTapeStatus sets the TapeStatus field's value.
func (s *TapeRecoveryPointInfo) SetTapeStatus(v string) *TapeRecoveryPointInfo {
	s.TapeStatus = &v
	return s
}

// A JSON object containing one or more of the following fields:
//
//    * UpdateBandwidthRateLimitInput$AverageDownloadRateLimitInBitsPerSec
//
//    * UpdateBandwidthRateLimitInput$AverageUploadRateLimitInBitsPerSec
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateBandwidthRateLimitInput
type UpdateBandwidthRateLimitInput struct {
	_ struct{} `type:"structure"`

	// The average download bandwidth rate limit in bits per second.
	AverageDownloadRateLimitInBitsPerSec *int64 `min:"102400" type:"long"`

	// The average upload bandwidth rate limit in bits per second.
	AverageUploadRateLimitInBitsPerSec *int64 `min:"51200" type:"long"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateBandwidthRateLimitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBandwidthRateLimitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBandwidthRateLimitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBandwidthRateLimitInput"}
	if s.AverageDownloadRateLimitInBitsPerSec != nil && *s.AverageDownloadRateLimitInBitsPerSec < 102400 {
		invalidParams.Add(request.NewErrParamMinValue("AverageDownloadRateLimitInBitsPerSec", 102400))
	}
	if s.AverageUploadRateLimitInBitsPerSec != nil && *s.AverageUploadRateLimitInBitsPerSec < 51200 {
		invalidParams.Add(request.NewErrParamMinValue("AverageUploadRateLimitInBitsPerSec", 51200))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAverageDownloadRateLimitInBitsPerSec sets the AverageDownloadRateLimitInBitsPerSec field's value.
func (s *UpdateBandwidthRateLimitInput) SetAverageDownloadRateLimitInBitsPerSec(v int64) *UpdateBandwidthRateLimitInput {
	s.AverageDownloadRateLimitInBitsPerSec = &v
	return s
}

// SetAverageUploadRateLimitInBitsPerSec sets the AverageUploadRateLimitInBitsPerSec field's value.
func (s *UpdateBandwidthRateLimitInput) SetAverageUploadRateLimitInBitsPerSec(v int64) *UpdateBandwidthRateLimitInput {
	s.AverageUploadRateLimitInBitsPerSec = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateBandwidthRateLimitInput) SetGatewayARN(v string) *UpdateBandwidthRateLimitInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the of the gateway whose throttle information was
// updated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateBandwidthRateLimitOutput
type UpdateBandwidthRateLimitOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateBandwidthRateLimitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBandwidthRateLimitOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateBandwidthRateLimitOutput) SetGatewayARN(v string) *UpdateBandwidthRateLimitOutput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing one or more of the following fields:
//
//    * UpdateChapCredentialsInput$InitiatorName
//
//    * UpdateChapCredentialsInput$SecretToAuthenticateInitiator
//
//    * UpdateChapCredentialsInput$SecretToAuthenticateTarget
//
//    * UpdateChapCredentialsInput$TargetARN
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateChapCredentialsInput
type UpdateChapCredentialsInput struct {
	_ struct{} `type:"structure"`

	// The iSCSI initiator that connects to the target.
	//
	// InitiatorName is a required field
	InitiatorName *string `min:"1" type:"string" required:"true"`

	// The secret key that the initiator (for example, the Windows client) must
	// provide to participate in mutual CHAP with the target.
	//
	// The secret key must be between 12 and 16 bytes when encoded in UTF-8.
	//
	// SecretToAuthenticateInitiator is a required field
	SecretToAuthenticateInitiator *string `min:"1" type:"string" required:"true"`

	// The secret key that the target must provide to participate in mutual CHAP
	// with the initiator (e.g. Windows client).
	//
	// Byte constraints: Minimum bytes of 12. Maximum bytes of 16.
	//
	// The secret key must be between 12 and 16 bytes when encoded in UTF-8.
	SecretToAuthenticateTarget *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes
	// operation to return the TargetARN for specified VolumeARN.
	//
	// TargetARN is a required field
	TargetARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateChapCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChapCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateChapCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateChapCredentialsInput"}
	if s.InitiatorName == nil {
		invalidParams.Add(request.NewErrParamRequired("InitiatorName"))
	}
	if s.InitiatorName != nil && len(*s.InitiatorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InitiatorName", 1))
	}
	if s.SecretToAuthenticateInitiator == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretToAuthenticateInitiator"))
	}
	if s.SecretToAuthenticateInitiator != nil && len(*s.SecretToAuthenticateInitiator) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretToAuthenticateInitiator", 1))
	}
	if s.SecretToAuthenticateTarget != nil && len(*s.SecretToAuthenticateTarget) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretToAuthenticateTarget", 1))
	}
	if s.TargetARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetARN"))
	}
	if s.TargetARN != nil && len(*s.TargetARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("TargetARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInitiatorName sets the InitiatorName field's value.
func (s *UpdateChapCredentialsInput) SetInitiatorName(v string) *UpdateChapCredentialsInput {
	s.InitiatorName = &v
	return s
}

// SetSecretToAuthenticateInitiator sets the SecretToAuthenticateInitiator field's value.
func (s *UpdateChapCredentialsInput) SetSecretToAuthenticateInitiator(v string) *UpdateChapCredentialsInput {
	s.SecretToAuthenticateInitiator = &v
	return s
}

// SetSecretToAuthenticateTarget sets the SecretToAuthenticateTarget field's value.
func (s *UpdateChapCredentialsInput) SetSecretToAuthenticateTarget(v string) *UpdateChapCredentialsInput {
	s.SecretToAuthenticateTarget = &v
	return s
}

// SetTargetARN sets the TargetARN field's value.
func (s *UpdateChapCredentialsInput) SetTargetARN(v string) *UpdateChapCredentialsInput {
	s.TargetARN = &v
	return s
}

// A JSON object containing the following fields:
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateChapCredentialsOutput
type UpdateChapCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// The iSCSI initiator that connects to the target. This is the same initiator
	// name specified in the request.
	InitiatorName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the target. This is the same target specified
	// in the request.
	TargetARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateChapCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChapCredentialsOutput) GoString() string {
	return s.String()
}

// SetInitiatorName sets the InitiatorName field's value.
func (s *UpdateChapCredentialsOutput) SetInitiatorName(v string) *UpdateChapCredentialsOutput {
	s.InitiatorName = &v
	return s
}

// SetTargetARN sets the TargetARN field's value.
func (s *UpdateChapCredentialsOutput) SetTargetARN(v string) *UpdateChapCredentialsOutput {
	s.TargetARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateGatewayInformationInput
type UpdateGatewayInformationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The name you configured for your gateway.
	GatewayName *string `min:"2" type:"string"`

	GatewayTimezone *string `min:"3" type:"string"`
}

// String returns the string representation
func (s UpdateGatewayInformationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGatewayInformationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGatewayInformationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGatewayInformationInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.GatewayName != nil && len(*s.GatewayName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayName", 2))
	}
	if s.GatewayTimezone != nil && len(*s.GatewayTimezone) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayTimezone", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateGatewayInformationInput) SetGatewayARN(v string) *UpdateGatewayInformationInput {
	s.GatewayARN = &v
	return s
}

// SetGatewayName sets the GatewayName field's value.
func (s *UpdateGatewayInformationInput) SetGatewayName(v string) *UpdateGatewayInformationInput {
	s.GatewayName = &v
	return s
}

// SetGatewayTimezone sets the GatewayTimezone field's value.
func (s *UpdateGatewayInformationInput) SetGatewayTimezone(v string) *UpdateGatewayInformationInput {
	s.GatewayTimezone = &v
	return s
}

// A JSON object containing the ARN of the gateway that was updated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateGatewayInformationOutput
type UpdateGatewayInformationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	GatewayName *string `type:"string"`
}

// String returns the string representation
func (s UpdateGatewayInformationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGatewayInformationOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateGatewayInformationOutput) SetGatewayARN(v string) *UpdateGatewayInformationOutput {
	s.GatewayARN = &v
	return s
}

// SetGatewayName sets the GatewayName field's value.
func (s *UpdateGatewayInformationOutput) SetGatewayName(v string) *UpdateGatewayInformationOutput {
	s.GatewayName = &v
	return s
}

// A JSON object containing the of the gateway to update.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateGatewaySoftwareNowInput
type UpdateGatewaySoftwareNowInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateGatewaySoftwareNowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGatewaySoftwareNowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGatewaySoftwareNowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGatewaySoftwareNowInput"}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateGatewaySoftwareNowInput) SetGatewayARN(v string) *UpdateGatewaySoftwareNowInput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the of the gateway that was updated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateGatewaySoftwareNowOutput
type UpdateGatewaySoftwareNowOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateGatewaySoftwareNowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGatewaySoftwareNowOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateGatewaySoftwareNowOutput) SetGatewayARN(v string) *UpdateGatewaySoftwareNowOutput {
	s.GatewayARN = &v
	return s
}

// A JSON object containing the following fields:
//
//    * UpdateMaintenanceStartTimeInput$DayOfWeek
//
//    * UpdateMaintenanceStartTimeInput$HourOfDay
//
//    * UpdateMaintenanceStartTimeInput$MinuteOfHour
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateMaintenanceStartTimeInput
type UpdateMaintenanceStartTimeInput struct {
	_ struct{} `type:"structure"`

	// The maintenance start time day of the week represented as an ordinal number
	// from 0 to 6, where 0 represents Sunday and 6 Saturday.
	//
	// DayOfWeek is a required field
	DayOfWeek *int64 `type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	//
	// GatewayARN is a required field
	GatewayARN *string `min:"50" type:"string" required:"true"`

	// The hour component of the maintenance start time represented as hh, where
	// hh is the hour (00 to 23). The hour of the day is in the time zone of the
	// gateway.
	//
	// HourOfDay is a required field
	HourOfDay *int64 `type:"integer" required:"true"`

	// The minute component of the maintenance start time represented as mm, where
	// mm is the minute (00 to 59). The minute of the hour is in the time zone of
	// the gateway.
	//
	// MinuteOfHour is a required field
	MinuteOfHour *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s UpdateMaintenanceStartTimeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMaintenanceStartTimeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMaintenanceStartTimeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMaintenanceStartTimeInput"}
	if s.DayOfWeek == nil {
		invalidParams.Add(request.NewErrParamRequired("DayOfWeek"))
	}
	if s.GatewayARN == nil {
		invalidParams.Add(request.NewErrParamRequired("GatewayARN"))
	}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.HourOfDay == nil {
		invalidParams.Add(request.NewErrParamRequired("HourOfDay"))
	}
	if s.MinuteOfHour == nil {
		invalidParams.Add(request.NewErrParamRequired("MinuteOfHour"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDayOfWeek sets the DayOfWeek field's value.
func (s *UpdateMaintenanceStartTimeInput) SetDayOfWeek(v int64) *UpdateMaintenanceStartTimeInput {
	s.DayOfWeek = &v
	return s
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateMaintenanceStartTimeInput) SetGatewayARN(v string) *UpdateMaintenanceStartTimeInput {
	s.GatewayARN = &v
	return s
}

// SetHourOfDay sets the HourOfDay field's value.
func (s *UpdateMaintenanceStartTimeInput) SetHourOfDay(v int64) *UpdateMaintenanceStartTimeInput {
	s.HourOfDay = &v
	return s
}

// SetMinuteOfHour sets the MinuteOfHour field's value.
func (s *UpdateMaintenanceStartTimeInput) SetMinuteOfHour(v int64) *UpdateMaintenanceStartTimeInput {
	s.MinuteOfHour = &v
	return s
}

// A JSON object containing the of the gateway whose maintenance start time
// is updated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateMaintenanceStartTimeOutput
type UpdateMaintenanceStartTimeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateMaintenanceStartTimeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMaintenanceStartTimeOutput) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *UpdateMaintenanceStartTimeOutput) SetGatewayARN(v string) *UpdateMaintenanceStartTimeOutput {
	s.GatewayARN = &v
	return s
}

// UpdateNFSFileShareInput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateNFSFileShareInput
type UpdateNFSFileShareInput struct {
	_ struct{} `type:"structure"`

	// The list of clients that are allowed to access the file gateway. The list
	// must contain either valid IP addresses or valid CIDR blocks.
	ClientList []*string `min:"1" type:"list"`

	// The default storage class for objects put into an Amazon S3 bucket by a file
	// gateway. Possible values are S3_STANDARD or S3_STANDARD_IA. If this field
	// is not populated, the default value S3_STANDARD is used. Optional.
	DefaultStorageClass *string `min:"5" type:"string"`

	// The Amazon Resource Name (ARN) of the file share to be updated.
	//
	// FileShareARN is a required field
	FileShareARN *string `min:"50" type:"string" required:"true"`

	// True to use Amazon S3 server side encryption with your own AWS KMS key, or
	// false to use a key managed by Amazon S3. Optional.
	KMSEncrypted *bool `type:"boolean"`

	// The KMS key used for Amazon S3 server side encryption. This value can only
	// be set when KmsEncrypted is true. Optional.
	KMSKey *string `min:"20" type:"string"`

	// The default values for the file share. Optional.
	NFSFileShareDefaults *NFSFileShareDefaults `type:"structure"`
}

// String returns the string representation
func (s UpdateNFSFileShareInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNFSFileShareInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNFSFileShareInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNFSFileShareInput"}
	if s.ClientList != nil && len(s.ClientList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientList", 1))
	}
	if s.DefaultStorageClass != nil && len(*s.DefaultStorageClass) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultStorageClass", 5))
	}
	if s.FileShareARN == nil {
		invalidParams.Add(request.NewErrParamRequired("FileShareARN"))
	}
	if s.FileShareARN != nil && len(*s.FileShareARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("FileShareARN", 50))
	}
	if s.KMSKey != nil && len(*s.KMSKey) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KMSKey", 20))
	}
	if s.NFSFileShareDefaults != nil {
		if err := s.NFSFileShareDefaults.Validate(); err != nil {
			invalidParams.AddNested("NFSFileShareDefaults", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientList sets the ClientList field's value.
func (s *UpdateNFSFileShareInput) SetClientList(v []*string) *UpdateNFSFileShareInput {
	s.ClientList = v
	return s
}

// SetDefaultStorageClass sets the DefaultStorageClass field's value.
func (s *UpdateNFSFileShareInput) SetDefaultStorageClass(v string) *UpdateNFSFileShareInput {
	s.DefaultStorageClass = &v
	return s
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *UpdateNFSFileShareInput) SetFileShareARN(v string) *UpdateNFSFileShareInput {
	s.FileShareARN = &v
	return s
}

// SetKMSEncrypted sets the KMSEncrypted field's value.
func (s *UpdateNFSFileShareInput) SetKMSEncrypted(v bool) *UpdateNFSFileShareInput {
	s.KMSEncrypted = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *UpdateNFSFileShareInput) SetKMSKey(v string) *UpdateNFSFileShareInput {
	s.KMSKey = &v
	return s
}

// SetNFSFileShareDefaults sets the NFSFileShareDefaults field's value.
func (s *UpdateNFSFileShareInput) SetNFSFileShareDefaults(v *NFSFileShareDefaults) *UpdateNFSFileShareInput {
	s.NFSFileShareDefaults = v
	return s
}

// UpdateNFSFileShareOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateNFSFileShareOutput
type UpdateNFSFileShareOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the updated file share.
	FileShareARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateNFSFileShareOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNFSFileShareOutput) GoString() string {
	return s.String()
}

// SetFileShareARN sets the FileShareARN field's value.
func (s *UpdateNFSFileShareOutput) SetFileShareARN(v string) *UpdateNFSFileShareOutput {
	s.FileShareARN = &v
	return s
}

// A JSON object containing one or more of the following fields:
//
//    * UpdateSnapshotScheduleInput$Description
//
//    * UpdateSnapshotScheduleInput$RecurrenceInHours
//
//    * UpdateSnapshotScheduleInput$StartAt
//
//    * UpdateSnapshotScheduleInput$VolumeARN
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSnapshotScheduleInput
type UpdateSnapshotScheduleInput struct {
	_ struct{} `type:"structure"`

	// Optional description of the snapshot that overwrites the existing description.
	Description *string `min:"1" type:"string"`

	// Frequency of snapshots. Specify the number of hours between snapshots.
	//
	// RecurrenceInHours is a required field
	RecurrenceInHours *int64 `min:"1" type:"integer" required:"true"`

	// The hour of the day at which the snapshot schedule begins represented as
	// hh, where hh is the hour (0 to 23). The hour of the day is in the time zone
	// of the gateway.
	//
	// StartAt is a required field
	StartAt *int64 `type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes.
	//
	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateSnapshotScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSnapshotScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSnapshotScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSnapshotScheduleInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.RecurrenceInHours == nil {
		invalidParams.Add(request.NewErrParamRequired("RecurrenceInHours"))
	}
	if s.RecurrenceInHours != nil && *s.RecurrenceInHours < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RecurrenceInHours", 1))
	}
	if s.StartAt == nil {
		invalidParams.Add(request.NewErrParamRequired("StartAt"))
	}
	if s.VolumeARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateSnapshotScheduleInput) SetDescription(v string) *UpdateSnapshotScheduleInput {
	s.Description = &v
	return s
}

// SetRecurrenceInHours sets the RecurrenceInHours field's value.
func (s *UpdateSnapshotScheduleInput) SetRecurrenceInHours(v int64) *UpdateSnapshotScheduleInput {
	s.RecurrenceInHours = &v
	return s
}

// SetStartAt sets the StartAt field's value.
func (s *UpdateSnapshotScheduleInput) SetStartAt(v int64) *UpdateSnapshotScheduleInput {
	s.StartAt = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *UpdateSnapshotScheduleInput) SetVolumeARN(v string) *UpdateSnapshotScheduleInput {
	s.VolumeARN = &v
	return s
}

// A JSON object containing the of the updated storage volume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSnapshotScheduleOutput
type UpdateSnapshotScheduleOutput struct {
	_ struct{} `type:"structure"`

	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateSnapshotScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSnapshotScheduleOutput) GoString() string {
	return s.String()
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *UpdateSnapshotScheduleOutput) SetVolumeARN(v string) *UpdateSnapshotScheduleOutput {
	s.VolumeARN = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateVTLDeviceTypeInput
type UpdateVTLDeviceTypeInput struct {
	_ struct{} `type:"structure"`

	// The type of medium changer you want to select.
	//
	// Valid Values: "STK-L700", "AWS-Gateway-VTL"
	//
	// DeviceType is a required field
	DeviceType *string `min:"2" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the medium changer you want to select.
	//
	// VTLDeviceARN is a required field
	VTLDeviceARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateVTLDeviceTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVTLDeviceTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVTLDeviceTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVTLDeviceTypeInput"}
	if s.DeviceType == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceType"))
	}
	if s.DeviceType != nil && len(*s.DeviceType) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceType", 2))
	}
	if s.VTLDeviceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("VTLDeviceARN"))
	}
	if s.VTLDeviceARN != nil && len(*s.VTLDeviceARN) < 50 {
		invalidParams.Add(request.NewErrParamMinLen("VTLDeviceARN", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceType sets the DeviceType field's value.
func (s *UpdateVTLDeviceTypeInput) SetDeviceType(v string) *UpdateVTLDeviceTypeInput {
	s.DeviceType = &v
	return s
}

// SetVTLDeviceARN sets the VTLDeviceARN field's value.
func (s *UpdateVTLDeviceTypeInput) SetVTLDeviceARN(v string) *UpdateVTLDeviceTypeInput {
	s.VTLDeviceARN = &v
	return s
}

// UpdateVTLDeviceTypeOutput
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateVTLDeviceTypeOutput
type UpdateVTLDeviceTypeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the medium changer you have selected.
	VTLDeviceARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateVTLDeviceTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVTLDeviceTypeOutput) GoString() string {
	return s.String()
}

// SetVTLDeviceARN sets the VTLDeviceARN field's value.
func (s *UpdateVTLDeviceTypeOutput) SetVTLDeviceARN(v string) *UpdateVTLDeviceTypeOutput {
	s.VTLDeviceARN = &v
	return s
}

// Represents a device object associated with a gateway-VTL.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/VTLDevice
type VTLDevice struct {
	_ struct{} `type:"structure"`

	// A list of iSCSI information about a VTL device.
	DeviceiSCSIAttributes *DeviceiSCSIAttributes `type:"structure"`

	// Specifies the unique Amazon Resource Name (ARN) of the device (tape drive
	// or media changer).
	VTLDeviceARN *string `min:"50" type:"string"`

	VTLDeviceProductIdentifier *string `type:"string"`

	VTLDeviceType *string `type:"string"`

	VTLDeviceVendor *string `type:"string"`
}

// String returns the string representation
func (s VTLDevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VTLDevice) GoString() string {
	return s.String()
}

// SetDeviceiSCSIAttributes sets the DeviceiSCSIAttributes field's value.
func (s *VTLDevice) SetDeviceiSCSIAttributes(v *DeviceiSCSIAttributes) *VTLDevice {
	s.DeviceiSCSIAttributes = v
	return s
}

// SetVTLDeviceARN sets the VTLDeviceARN field's value.
func (s *VTLDevice) SetVTLDeviceARN(v string) *VTLDevice {
	s.VTLDeviceARN = &v
	return s
}

// SetVTLDeviceProductIdentifier sets the VTLDeviceProductIdentifier field's value.
func (s *VTLDevice) SetVTLDeviceProductIdentifier(v string) *VTLDevice {
	s.VTLDeviceProductIdentifier = &v
	return s
}

// SetVTLDeviceType sets the VTLDeviceType field's value.
func (s *VTLDevice) SetVTLDeviceType(v string) *VTLDevice {
	s.VTLDeviceType = &v
	return s
}

// SetVTLDeviceVendor sets the VTLDeviceVendor field's value.
func (s *VTLDevice) SetVTLDeviceVendor(v string) *VTLDevice {
	s.VTLDeviceVendor = &v
	return s
}

// Describes a storage volume object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/VolumeInfo
type VolumeInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	// The unique identifier assigned to your gateway during activation. This ID
	// becomes part of the gateway Amazon Resource Name (ARN), which you use as
	// input for other operations.
	//
	// Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens
	// (-).
	GatewayId *string `min:"12" type:"string"`

	// The Amazon Resource Name (ARN) for the storage volume. For example, the following
	// is a valid ARN:
	//
	// arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB
	//
	// Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens
	// (-).
	VolumeARN *string `min:"50" type:"string"`

	// The unique identifier assigned to the volume. This ID becomes part of the
	// volume Amazon Resource Name (ARN), which you use as input for other operations.
	//
	// Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens
	// (-).
	VolumeId *string `min:"12" type:"string"`

	// The size of the volume in bytes.
	//
	// Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens
	// (-).
	VolumeSizeInBytes *int64 `type:"long"`

	VolumeType *string `min:"3" type:"string"`
}

// String returns the string representation
func (s VolumeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeInfo) GoString() string {
	return s.String()
}

// SetGatewayARN sets the GatewayARN field's value.
func (s *VolumeInfo) SetGatewayARN(v string) *VolumeInfo {
	s.GatewayARN = &v
	return s
}

// SetGatewayId sets the GatewayId field's value.
func (s *VolumeInfo) SetGatewayId(v string) *VolumeInfo {
	s.GatewayId = &v
	return s
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *VolumeInfo) SetVolumeARN(v string) *VolumeInfo {
	s.VolumeARN = &v
	return s
}

// SetVolumeId sets the VolumeId field's value.
func (s *VolumeInfo) SetVolumeId(v string) *VolumeInfo {
	s.VolumeId = &v
	return s
}

// SetVolumeSizeInBytes sets the VolumeSizeInBytes field's value.
func (s *VolumeInfo) SetVolumeSizeInBytes(v int64) *VolumeInfo {
	s.VolumeSizeInBytes = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *VolumeInfo) SetVolumeType(v string) *VolumeInfo {
	s.VolumeType = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/VolumeRecoveryPointInfo
type VolumeRecoveryPointInfo struct {
	_ struct{} `type:"structure"`

	VolumeARN *string `min:"50" type:"string"`

	VolumeRecoveryPointTime *string `type:"string"`

	VolumeSizeInBytes *int64 `type:"long"`

	VolumeUsageInBytes *int64 `type:"long"`
}

// String returns the string representation
func (s VolumeRecoveryPointInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeRecoveryPointInfo) GoString() string {
	return s.String()
}

// SetVolumeARN sets the VolumeARN field's value.
func (s *VolumeRecoveryPointInfo) SetVolumeARN(v string) *VolumeRecoveryPointInfo {
	s.VolumeARN = &v
	return s
}

// SetVolumeRecoveryPointTime sets the VolumeRecoveryPointTime field's value.
func (s *VolumeRecoveryPointInfo) SetVolumeRecoveryPointTime(v string) *VolumeRecoveryPointInfo {
	s.VolumeRecoveryPointTime = &v
	return s
}

// SetVolumeSizeInBytes sets the VolumeSizeInBytes field's value.
func (s *VolumeRecoveryPointInfo) SetVolumeSizeInBytes(v int64) *VolumeRecoveryPointInfo {
	s.VolumeSizeInBytes = &v
	return s
}

// SetVolumeUsageInBytes sets the VolumeUsageInBytes field's value.
func (s *VolumeRecoveryPointInfo) SetVolumeUsageInBytes(v int64) *VolumeRecoveryPointInfo {
	s.VolumeUsageInBytes = &v
	return s
}

// Lists iSCSI information about a volume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/VolumeiSCSIAttributes
type VolumeiSCSIAttributes struct {
	_ struct{} `type:"structure"`

	// Indicates whether mutual CHAP is enabled for the iSCSI target.
	ChapEnabled *bool `type:"boolean"`

	// The logical disk number.
	LunNumber *int64 `min:"1" type:"integer"`

	// The network interface identifier.
	NetworkInterfaceId *string `type:"string"`

	// The port used to communicate with iSCSI targets.
	NetworkInterfacePort *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the volume target.
	TargetARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s VolumeiSCSIAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeiSCSIAttributes) GoString() string {
	return s.String()
}

// SetChapEnabled sets the ChapEnabled field's value.
func (s *VolumeiSCSIAttributes) SetChapEnabled(v bool) *VolumeiSCSIAttributes {
	s.ChapEnabled = &v
	return s
}

// SetLunNumber sets the LunNumber field's value.
func (s *VolumeiSCSIAttributes) SetLunNumber(v int64) *VolumeiSCSIAttributes {
	s.LunNumber = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *VolumeiSCSIAttributes) SetNetworkInterfaceId(v string) *VolumeiSCSIAttributes {
	s.NetworkInterfaceId = &v
	return s
}

// SetNetworkInterfacePort sets the NetworkInterfacePort field's value.
func (s *VolumeiSCSIAttributes) SetNetworkInterfacePort(v int64) *VolumeiSCSIAttributes {
	s.NetworkInterfacePort = &v
	return s
}

// SetTargetARN sets the TargetARN field's value.
func (s *VolumeiSCSIAttributes) SetTargetARN(v string) *VolumeiSCSIAttributes {
	s.TargetARN = &v
	return s
}

const (
	// ErrorCodeActivationKeyExpired is a ErrorCode enum value
	ErrorCodeActivationKeyExpired = "ActivationKeyExpired"

	// ErrorCodeActivationKeyInvalid is a ErrorCode enum value
	ErrorCodeActivationKeyInvalid = "ActivationKeyInvalid"

	// ErrorCodeActivationKeyNotFound is a ErrorCode enum value
	ErrorCodeActivationKeyNotFound = "ActivationKeyNotFound"

	// ErrorCodeGatewayInternalError is a ErrorCode enum value
	ErrorCodeGatewayInternalError = "GatewayInternalError"

	// ErrorCodeGatewayNotConnected is a ErrorCode enum value
	ErrorCodeGatewayNotConnected = "GatewayNotConnected"

	// ErrorCodeGatewayNotFound is a ErrorCode enum value
	ErrorCodeGatewayNotFound = "GatewayNotFound"

	// ErrorCodeGatewayProxyNetworkConnectionBusy is a ErrorCode enum value
	ErrorCodeGatewayProxyNetworkConnectionBusy = "GatewayProxyNetworkConnectionBusy"

	// ErrorCodeAuthenticationFailure is a ErrorCode enum value
	ErrorCodeAuthenticationFailure = "AuthenticationFailure"

	// ErrorCodeBandwidthThrottleScheduleNotFound is a ErrorCode enum value
	ErrorCodeBandwidthThrottleScheduleNotFound = "BandwidthThrottleScheduleNotFound"

	// ErrorCodeBlocked is a ErrorCode enum value
	ErrorCodeBlocked = "Blocked"

	// ErrorCodeCannotExportSnapshot is a ErrorCode enum value
	ErrorCodeCannotExportSnapshot = "CannotExportSnapshot"

	// ErrorCodeChapCredentialNotFound is a ErrorCode enum value
	ErrorCodeChapCredentialNotFound = "ChapCredentialNotFound"

	// ErrorCodeDiskAlreadyAllocated is a ErrorCode enum value
	ErrorCodeDiskAlreadyAllocated = "DiskAlreadyAllocated"

	// ErrorCodeDiskDoesNotExist is a ErrorCode enum value
	ErrorCodeDiskDoesNotExist = "DiskDoesNotExist"

	// ErrorCodeDiskSizeGreaterThanVolumeMaxSize is a ErrorCode enum value
	ErrorCodeDiskSizeGreaterThanVolumeMaxSize = "DiskSizeGreaterThanVolumeMaxSize"

	// ErrorCodeDiskSizeLessThanVolumeSize is a ErrorCode enum value
	ErrorCodeDiskSizeLessThanVolumeSize = "DiskSizeLessThanVolumeSize"

	// ErrorCodeDiskSizeNotGigAligned is a ErrorCode enum value
	ErrorCodeDiskSizeNotGigAligned = "DiskSizeNotGigAligned"

	// ErrorCodeDuplicateCertificateInfo is a ErrorCode enum value
	ErrorCodeDuplicateCertificateInfo = "DuplicateCertificateInfo"

	// ErrorCodeDuplicateSchedule is a ErrorCode enum value
	ErrorCodeDuplicateSchedule = "DuplicateSchedule"

	// ErrorCodeEndpointNotFound is a ErrorCode enum value
	ErrorCodeEndpointNotFound = "EndpointNotFound"

	// ErrorCodeIamnotSupported is a ErrorCode enum value
	ErrorCodeIamnotSupported = "IAMNotSupported"

	// ErrorCodeInitiatorInvalid is a ErrorCode enum value
	ErrorCodeInitiatorInvalid = "InitiatorInvalid"

	// ErrorCodeInitiatorNotFound is a ErrorCode enum value
	ErrorCodeInitiatorNotFound = "InitiatorNotFound"

	// ErrorCodeInternalError is a ErrorCode enum value
	ErrorCodeInternalError = "InternalError"

	// ErrorCodeInvalidGateway is a ErrorCode enum value
	ErrorCodeInvalidGateway = "InvalidGateway"

	// ErrorCodeInvalidEndpoint is a ErrorCode enum value
	ErrorCodeInvalidEndpoint = "InvalidEndpoint"

	// ErrorCodeInvalidParameters is a ErrorCode enum value
	ErrorCodeInvalidParameters = "InvalidParameters"

	// ErrorCodeInvalidSchedule is a ErrorCode enum value
	ErrorCodeInvalidSchedule = "InvalidSchedule"

	// ErrorCodeLocalStorageLimitExceeded is a ErrorCode enum value
	ErrorCodeLocalStorageLimitExceeded = "LocalStorageLimitExceeded"

	// ErrorCodeLunAlreadyAllocated is a ErrorCode enum value
	ErrorCodeLunAlreadyAllocated = "LunAlreadyAllocated "

	// ErrorCodeLunInvalid is a ErrorCode enum value
	ErrorCodeLunInvalid = "LunInvalid"

	// ErrorCodeMaximumContentLengthExceeded is a ErrorCode enum value
	ErrorCodeMaximumContentLengthExceeded = "MaximumContentLengthExceeded"

	// ErrorCodeMaximumTapeCartridgeCountExceeded is a ErrorCode enum value
	ErrorCodeMaximumTapeCartridgeCountExceeded = "MaximumTapeCartridgeCountExceeded"

	// ErrorCodeMaximumVolumeCountExceeded is a ErrorCode enum value
	ErrorCodeMaximumVolumeCountExceeded = "MaximumVolumeCountExceeded"

	// ErrorCodeNetworkConfigurationChanged is a ErrorCode enum value
	ErrorCodeNetworkConfigurationChanged = "NetworkConfigurationChanged"

	// ErrorCodeNoDisksAvailable is a ErrorCode enum value
	ErrorCodeNoDisksAvailable = "NoDisksAvailable"

	// ErrorCodeNotImplemented is a ErrorCode enum value
	ErrorCodeNotImplemented = "NotImplemented"

	// ErrorCodeNotSupported is a ErrorCode enum value
	ErrorCodeNotSupported = "NotSupported"

	// ErrorCodeOperationAborted is a ErrorCode enum value
	ErrorCodeOperationAborted = "OperationAborted"

	// ErrorCodeOutdatedGateway is a ErrorCode enum value
	ErrorCodeOutdatedGateway = "OutdatedGateway"

	// ErrorCodeParametersNotImplemented is a ErrorCode enum value
	ErrorCodeParametersNotImplemented = "ParametersNotImplemented"

	// ErrorCodeRegionInvalid is a ErrorCode enum value
	ErrorCodeRegionInvalid = "RegionInvalid"

	// ErrorCodeRequestTimeout is a ErrorCode enum value
	ErrorCodeRequestTimeout = "RequestTimeout"

	// ErrorCodeServiceUnavailable is a ErrorCode enum value
	ErrorCodeServiceUnavailable = "ServiceUnavailable"

	// ErrorCodeSnapshotDeleted is a ErrorCode enum value
	ErrorCodeSnapshotDeleted = "SnapshotDeleted"

	// ErrorCodeSnapshotIdInvalid is a ErrorCode enum value
	ErrorCodeSnapshotIdInvalid = "SnapshotIdInvalid"

	// ErrorCodeSnapshotInProgress is a ErrorCode enum value
	ErrorCodeSnapshotInProgress = "SnapshotInProgress"

	// ErrorCodeSnapshotNotFound is a ErrorCode enum value
	ErrorCodeSnapshotNotFound = "SnapshotNotFound"

	// ErrorCodeSnapshotScheduleNotFound is a ErrorCode enum value
	ErrorCodeSnapshotScheduleNotFound = "SnapshotScheduleNotFound"

	// ErrorCodeStagingAreaFull is a ErrorCode enum value
	ErrorCodeStagingAreaFull = "StagingAreaFull"

	// ErrorCodeStorageFailure is a ErrorCode enum value
	ErrorCodeStorageFailure = "StorageFailure"

	// ErrorCodeTapeCartridgeNotFound is a ErrorCode enum value
	ErrorCodeTapeCartridgeNotFound = "TapeCartridgeNotFound"

	// ErrorCodeTargetAlreadyExists is a ErrorCode enum value
	ErrorCodeTargetAlreadyExists = "TargetAlreadyExists"

	// ErrorCodeTargetInvalid is a ErrorCode enum value
	ErrorCodeTargetInvalid = "TargetInvalid"

	// ErrorCodeTargetNotFound is a ErrorCode enum value
	ErrorCodeTargetNotFound = "TargetNotFound"

	// ErrorCodeUnauthorizedOperation is a ErrorCode enum value
	ErrorCodeUnauthorizedOperation = "UnauthorizedOperation"

	// ErrorCodeVolumeAlreadyExists is a ErrorCode enum value
	ErrorCodeVolumeAlreadyExists = "VolumeAlreadyExists"

	// ErrorCodeVolumeIdInvalid is a ErrorCode enum value
	ErrorCodeVolumeIdInvalid = "VolumeIdInvalid"

	// ErrorCodeVolumeInUse is a ErrorCode enum value
	ErrorCodeVolumeInUse = "VolumeInUse"

	// ErrorCodeVolumeNotFound is a ErrorCode enum value
	ErrorCodeVolumeNotFound = "VolumeNotFound"

	// ErrorCodeVolumeNotReady is a ErrorCode enum value
	ErrorCodeVolumeNotReady = "VolumeNotReady"
)
