/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.navigation.views;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.navigation.views.FocusTracker;
import com.jgoodies.navigation.views.View;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public abstract class AbstractViewModel<V extends View>
extends Bean {
    public static final String PROPERTY_VIEWS = "views";
    public static final String PROPERTY_SELECTED_INDEX = "selectedIndex";
    public static final String PROPERTY_SELECTED_VIEW = "selectedView";
    private final List<V> views = new ArrayList<V>();
    private int selectedIndex = -1;

    protected void add(V view) {
        this.add(this.insertionIndex(), view);
    }

    protected void add(int index, V view) {
        Preconditions.checkNotNull(view, "The %s must not be null.", "view");
        this.views.add(index, view);
        int oldSelectedIndex = this.selectedIndex;
        if (index <= this.selectedIndex) {
            ++this.selectedIndex;
            this.firePropertyChange(PROPERTY_SELECTED_INDEX, oldSelectedIndex, this.selectedIndex);
            this.firePropertyChange(PROPERTY_SELECTED_VIEW, null, this.getSelectedView());
        }
        if (this.size() == 1) {
            this.setSelectedIndex(0);
        }
        this.firePropertyChange(PROPERTY_VIEWS, null, this.getViews());
        this.updateIndicesOnAdd(index);
    }

    protected void remove(V view) {
        Preconditions.checkNotNull(view, "The %s must not be null.", "view");
        int oldViewIndex = this.views.indexOf(view);
        if (oldViewIndex == -1) {
            return;
        }
        this.updateIndicesOnRemove(oldViewIndex);
        int oldSelectedIndex = this.selectedIndex--;
        if (oldViewIndex < oldSelectedIndex) {
            this.views.remove(view);
        } else if (oldViewIndex == oldSelectedIndex) {
            this.views.remove(view);
            this.selectedIndex = this.selectionIndexAfterRemove(oldSelectedIndex, view);
            this.firePropertyChange(PROPERTY_SELECTED_VIEW, view, this.getSelectedView());
            this.requestInitialFocus();
        } else {
            this.views.remove(view);
        }
        this.firePropertyChange(PROPERTY_VIEWS, null, this.getViews());
    }

    protected void clear() {
        this.views.clear();
        this.selectedIndex = -1;
        this.updateIndicesOnClear();
        this.firePropertyChange(PROPERTY_SELECTED_VIEW, null, this.getSelectedView());
        this.firePropertyChange(PROPERTY_VIEWS, null, this.getViews());
    }

    protected int size() {
        return this.views.size();
    }

    protected boolean isEmpty() {
        return this.views.isEmpty();
    }

    protected V get(int index) {
        return (V)((View)this.views.get(index));
    }

    protected int indexOf(V view) {
        return view == null ? -1 : this.views.indexOf(view);
    }

    protected int getSelectedIndex() {
        return this.selectedIndex;
    }

    protected void setSelectedIndex(int newValue) {
        if (newValue == this.selectedIndex) {
            return;
        }
        V oldView = this.getSelectedView();
        int viewCount = this.views.size();
        if (newValue < -1 || newValue >= viewCount) {
            throw new IndexOutOfBoundsException(String.format("The index %1$s is invalid for %2$s views.", newValue, viewCount));
        }
        this.selectedIndex = newValue;
        this.firePropertyChange(PROPERTY_SELECTED_INDEX, this.selectedIndex, this.selectedIndex);
        this.firePropertyChange(PROPERTY_SELECTED_VIEW, oldView, this.getSelectedView());
        this.requestInitialFocus();
        this.updateIndicesOnSelect(this.selectedIndex);
    }

    protected V getSelectedView() {
        return (V)(this.selectedIndex == -1 ? null : (View)this.views.get(this.selectedIndex));
    }

    protected final void setSelectedView(V newValue) {
        this.setSelectedIndex(this.indexOf(newValue));
    }

    protected boolean selectByParameter(Object parameter) {
        if (parameter instanceof Integer) {
            this.setSelectedIndex((Integer)parameter);
            return true;
        }
        return false;
    }

    protected final List<V> getViews() {
        return Collections.unmodifiableList(this.views);
    }

    public final void requestInitialFocus() {
        if (this.getSelectedView() instanceof FocusTracker) {
            ((FocusTracker)this.getSelectedView()).requestInitialFocus();
        }
    }

    protected int insertionIndex() {
        return this.size();
    }

    protected int selectionIndexAfterRemove(int oldSelectedIndex, V oldView) {
        return Math.min(this.size() - 1, oldSelectedIndex);
    }

    protected void updateIndicesOnAdd(int index) {
    }

    protected void updateIndicesOnRemove(int oldViewIndex) {
    }

    protected void updateIndicesOnClear() {
    }

    protected void updateIndicesOnSelect(int index) {
    }

    protected final int indexOf(Object id, Function<V, Object> idGetter) {
        if (id != null) {
            int index = 0;
            for (View view : this.views) {
                if (id.equals(idGetter.apply(view))) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public static abstract class AbstractBuilder<V extends View, M extends AbstractViewModel<V>, B extends AbstractBuilder<V, M, B>> {
        private final M target;

        public AbstractBuilder() {
            this.target = this.createTarget();
        }

        public AbstractBuilder(M target) {
            this.target = target;
        }

        public final B add(V view) {
            Preconditions.checkNotNull(view, "The %s must not be null.", "view");
            ((AbstractViewModel)this.target).add(view);
            return (B)this;
        }

        public final B add(V ... views) {
            Preconditions.checkNotNull(views, "The %s must not be null.", AbstractViewModel.PROPERTY_VIEWS);
            return this.add(Arrays.asList(views));
        }

        public final B add(List<V> views) {
            Preconditions.checkNotNull(views, "The %s must not be null.", AbstractViewModel.PROPERTY_VIEWS);
            for (View view : views) {
                ((AbstractViewModel)this.target).add((View)view);
            }
            return (B)this;
        }

        public final B select(int index) {
            ((AbstractViewModel)this.target).setSelectedIndex(index);
            return (B)this;
        }

        public final B select(V view) {
            ((AbstractViewModel)this.target).setSelectedView(view);
            return (B)this;
        }

        protected final M getTarget() {
            return this.target;
        }

        protected abstract M createTarget();
    }
}

