/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.layout.internal;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.swing.focus.FocusTraversalUtils;
import com.jgoodies.layout.internal.AbstractBuilder;
import com.jgoodies.layout.layout.ColumnSpec;
import com.jgoodies.layout.layout.FormLayout;
import com.jgoodies.layout.layout.FormSpecs;
import com.jgoodies.layout.layout.RowSpec;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class AbstractButtonPanelBuilder<B extends AbstractButtonPanelBuilder<B>>
extends AbstractBuilder<B> {
    private boolean leftToRight;
    protected boolean focusGrouped = false;

    protected AbstractButtonPanelBuilder(FormLayout layout, JPanel container) {
        super(layout, container);
        this.opaque(false);
        ComponentOrientation orientation = container.getComponentOrientation();
        this.leftToRight = orientation.isLeftToRight() || !orientation.isHorizontal();
    }

    @Override
    public final JPanel build() {
        if (!this.focusGrouped) {
            ArrayList<AbstractButton> buttons = new ArrayList<AbstractButton>();
            for (Component component : this.getPanel().getComponents()) {
                if (!(component instanceof AbstractButton)) continue;
                buttons.add((AbstractButton)component);
            }
            FocusTraversalUtils.group(buttons);
            this.focusGrouped = true;
        }
        return this.getPanel();
    }

    public final boolean isLeftToRight() {
        return this.leftToRight;
    }

    public final void setLeftToRight(boolean b) {
        this.leftToRight = b;
    }

    protected final void nextColumn() {
        this.nextColumn(1);
    }

    private void nextColumn(int columns) {
        this.currentCellConstraints.gridX += columns * this.getColumnIncrementSign();
    }

    protected final int getColumn() {
        return this.currentCellConstraints.gridX;
    }

    protected final int getRow() {
        return this.currentCellConstraints.gridY;
    }

    protected final void nextRow() {
        this.nextRow(1);
    }

    private void nextRow(int rows) {
        this.currentCellConstraints.gridY += rows;
    }

    protected final void appendColumn(ColumnSpec columnSpec) {
        this.getLayout().appendColumn(columnSpec);
    }

    protected final void appendGrowingGapColumn() {
        this.appendColumn(FormSpecs.GROWING_GAP_COLSPEC);
    }

    protected final void appendRelatedComponentsGapColumn() {
        this.appendColumn(FormSpecs.RELATED_GAP_COLSPEC);
    }

    protected final void appendUnrelatedComponentsGapColumn() {
        this.appendColumn(FormSpecs.UNRELATED_GAP_COLSPEC);
    }

    protected final void appendRow(RowSpec rowSpec) {
        this.getLayout().appendRow(rowSpec);
    }

    protected final void appendGrowingGapRow() {
        this.appendRow(FormSpecs.GROWING_GAP_ROWSPEC);
    }

    protected final void appendRelatedComponentsGapRow() {
        this.appendRow(FormSpecs.RELATED_GAP_ROWSPEC);
    }

    protected final void appendUnrelatedComponentsGapRow() {
        this.appendRow(FormSpecs.UNRELATED_GAP_ROWSPEC);
    }

    protected final Component add(Component component) {
        this.getPanel().add(component, this.currentCellConstraints);
        this.focusGrouped = false;
        return component;
    }

    protected abstract AbstractButtonPanelBuilder<B> addButton(JComponent var1);

    protected AbstractButtonPanelBuilder<B> addButton(JComponent ... buttons) {
        Preconditions.checkNotNullOrEmpty(buttons, "The %s must not be null or empty.", "button array");
        boolean needsGap = false;
        for (JComponent button : buttons) {
            if (button == null) {
                this.addUnrelatedGap();
                needsGap = false;
                continue;
            }
            if (needsGap) {
                this.addRelatedGap();
            }
            this.addButton(button);
            needsGap = true;
        }
        return this;
    }

    protected AbstractButtonPanelBuilder<B> addButton(Action ... actions) {
        Preconditions.checkNotNullOrEmpty(actions, "The %s must not be null or empty.", "Action array");
        int length = actions.length;
        JComponent[] buttons = new JButton[length];
        for (int i = 0; i < length; ++i) {
            Action action = actions[i];
            buttons[i] = action == null ? null : this.createButton(action);
        }
        return this.addButton(buttons);
    }

    protected abstract AbstractButtonPanelBuilder<B> addRelatedGap();

    protected abstract AbstractButtonPanelBuilder<B> addUnrelatedGap();

    protected JButton createButton(Action action) {
        return this.getComponentFactory().createButton(action);
    }

    private int getColumnIncrementSign() {
        return this.isLeftToRight() ? 1 : -1;
    }
}

