/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.layout.factories;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.layout.layout.ConstantSize;
import com.jgoodies.layout.layout.Sizes;
import com.jgoodies.layout.util.LayoutStyle;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.border.EmptyBorder;

public final class Paddings {
    public static final Padding EMPTY = Paddings.createPadding(Sizes.ZERO, Sizes.ZERO, Sizes.ZERO, Sizes.ZERO);
    public static final Padding DLU2 = Paddings.createPadding(Sizes.DLU2, Sizes.DLU2, Sizes.DLU2, Sizes.DLU2);
    public static final Padding DLU4 = Paddings.createPadding(Sizes.DLU4, Sizes.DLU4, Sizes.DLU4, Sizes.DLU4);
    public static final Padding DLU7 = Paddings.createPadding(Sizes.DLU7, Sizes.DLU7, Sizes.DLU7, Sizes.DLU7);
    public static final Padding DLU9 = Paddings.createPadding(Sizes.DLU9, Sizes.DLU9, Sizes.DLU9, Sizes.DLU9);
    public static final Padding DLU14 = Paddings.createPadding(Sizes.DLU14, Sizes.DLU14, Sizes.DLU14, Sizes.DLU14);
    public static final Padding DLU21 = Paddings.createPadding(Sizes.DLU21, Sizes.DLU21, Sizes.DLU21, Sizes.DLU21);
    public static final Padding EPX4 = Paddings.createPadding(Sizes.EPX4, Sizes.EPX4, Sizes.EPX4, Sizes.EPX4);
    public static final Padding EPX8 = Paddings.createPadding(Sizes.EPX8, Sizes.EPX8, Sizes.EPX8, Sizes.EPX8);
    public static final Padding EPX12 = Paddings.createPadding(Sizes.EPX12, Sizes.EPX12, Sizes.EPX12, Sizes.EPX12);
    public static final Padding EPX16 = Paddings.createPadding(Sizes.EPX16, Sizes.EPX16, Sizes.EPX16, Sizes.EPX16);
    public static final Padding EPX24 = Paddings.createPadding(Sizes.EPX24, Sizes.EPX24, Sizes.EPX24, Sizes.EPX24);
    public static final Padding EPX48 = Paddings.createPadding(Sizes.EPX48, Sizes.EPX48, Sizes.EPX48, Sizes.EPX48);
    public static final Padding BUTTON_BAR_PAD = Paddings.createPadding(LayoutStyle.getCurrent().getButtonBarPad(), Sizes.ZERO, Sizes.ZERO, Sizes.ZERO);
    public static final Padding DIALOG = Paddings.createPadding(LayoutStyle.getCurrent().getDialogMarginY(), LayoutStyle.getCurrent().getDialogMarginX(), LayoutStyle.getCurrent().getDialogMarginY(), LayoutStyle.getCurrent().getDialogMarginX());
    public static final Padding TABBED_DIALOG = Paddings.createPadding(LayoutStyle.getCurrent().getTabbedDialogMarginY(), LayoutStyle.getCurrent().getTabbedDialogMarginX(), LayoutStyle.getCurrent().getTabbedDialogMarginY(), LayoutStyle.getCurrent().getTabbedDialogMarginX());

    private Paddings() {
    }

    public static Padding createPadding(ConstantSize top, ConstantSize left, ConstantSize bottom, ConstantSize right) {
        return new Padding(top, left, bottom, right);
    }

    public static Padding createPadding(String encodedSizes, Object ... args) {
        String formattedSizes = Strings.get(encodedSizes, args);
        String[] token = formattedSizes.split("\\s*,\\s*");
        int tokenCount = token.length;
        Preconditions.checkArgument(token.length == 4, "The padding requires 4 sizes, but \"%s\" has %d.", formattedSizes, tokenCount);
        ConstantSize top = Sizes.constant(token[0]);
        ConstantSize left = Sizes.constant(token[1]);
        ConstantSize bottom = Sizes.constant(token[2]);
        ConstantSize right = Sizes.constant(token[3]);
        return Paddings.createPadding(top, left, bottom, right);
    }

    public static final class Padding
    extends EmptyBorder {
        private final ConstantSize topMargin;
        private final ConstantSize leftMargin;
        private final ConstantSize bottomMargin;
        private final ConstantSize rightMargin;

        private Padding(ConstantSize top, ConstantSize left, ConstantSize bottom, ConstantSize right) {
            super(0, 0, 0, 0);
            this.topMargin = Preconditions.checkNotNull(top, "The %s must not be null.", "top");
            this.leftMargin = Preconditions.checkNotNull(left, "The %s must not be null.", "left");
            this.bottomMargin = Preconditions.checkNotNull(bottom, "The %s must not be null.", "bottom");
            this.rightMargin = Preconditions.checkNotNull(right, "The %s must not be null.", "right");
        }

        @Override
        public Insets getBorderInsets() {
            return this.getBorderInsets(null);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = this.topMargin.getPixelSize(c, false);
            insets.left = this.leftMargin.getPixelSize(c, true);
            insets.bottom = this.bottomMargin.getPixelSize(c, false);
            insets.right = this.rightMargin.getPixelSize(c, true);
            return insets;
        }

        public ConstantSize getTop() {
            return this.topMargin;
        }

        public ConstantSize getLeft() {
            return this.leftMargin;
        }

        public ConstantSize getBottom() {
            return this.bottomMargin;
        }

        public ConstantSize getRight() {
            return this.rightMargin;
        }

        public String toString() {
            return String.format("Padding[top=%s, left=%s, bottom=%s, right=%s]", this.getTop(), this.getLeft(), this.getBottom(), this.getRight());
        }
    }
}

