/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.pane.task;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.swing.MnemonicUtils;
import com.jgoodies.common.swing.focus.FocusTraversalUtils;
import com.jgoodies.components.JGCommandLink;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.dialogs.core.CloseRequestHandler;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.IconType;
import com.jgoodies.dialogs.core.MessageType;
import com.jgoodies.dialogs.core.Verification;
import com.jgoodies.dialogs.core.internal.CommandValueCommitAction;
import com.jgoodies.dialogs.core.internal.JSDLAccessibleRole;
import com.jgoodies.dialogs.core.internal.JSDLCoreStyleChecker;
import com.jgoodies.dialogs.core.pane.AbstractStyledPane;
import com.jgoodies.dialogs.core.pane.task.TaskPaneVisualConfiguration;
import com.jgoodies.layout.factories.CC;
import com.jgoodies.layout.layout.CellConstraints;
import com.jgoodies.layout.layout.FormLayout;
import com.jgoodies.layout.layout.FormSpecs;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public final class TaskPane
extends AbstractStyledPane<TaskPaneVisualConfiguration> {
    public static final String PROPERTY_MAIN_INSTRUCTION_ICON = "mainInstructionIcon";
    public static final String PROPERTY_MAIN_INSTRUCTION_TEXT = "mainInstructionText";
    public static final String PROPERTY_MAIN_INSTRUCTION_LABELS_CONTENT = "mainInstructionLabelsContent";
    public static final String PROPERTY_CONTENT_TEXT = "contentText";
    public static final String PROPERTY_COMMANDLINK_ICONS_VISIBLE = "commandLinkIcons";
    public static final String PROPERTY_PROGRESS_VISIBLE = "progressVisible";
    public static final String PROPERTY_PROGRESS_VALUE = "progressValue";
    public static final String PROPERTY_PROGRESS_INDETERMINATE = "progressIndeterminate";
    public static final String PROPERTY_RADIO_VALUE = "radioValue";
    public static final String PROPERTY_EXPANDED = "expanded";
    public static final String PROPERTY_EXPANDED_TEXT = "expandedText";
    public static final String PROPERTY_EXPANDED_CONTROL_TEXT = "expandedControlText";
    public static final String PROPERTY_COLLAPSED_CONTROL_TEXT = "collapsedControlText";
    public static final String PROPERTY_EXPAND_FOOTER = "expandFooter";
    public static final String PROPERTY_VERIFICATION_SELECTED = "verificationSelected";
    public static final String PROPERTY_VERIFICATION_TEXT = "verificationText";
    private static final String UI_CLASS_ID = "JSDL.TaskPaneUI";
    private Icon mainInstructionIcon;
    private String mainInstructionText;
    private boolean mainInstructionLabelsContent;
    private String contentText;
    private boolean progressVisible = false;
    private boolean progressIndeterminate = false;
    private int progressValue = 0;
    private boolean expanded = false;
    private String expandedText;
    private String expandedControlText;
    private String collapsedControlText;
    private boolean verificationSelected = true;
    private String verificationText;
    private Verification verification;
    private Object radioValue;
    private JPanel radioButtonPanel;
    private final List<JRadioButton> radioButtons = new ArrayList<JRadioButton>();
    private JPanel commandLinkPanel;
    private boolean commandLinkIconsVisible = true;
    private final List<JButton> commandLinks = new ArrayList<JButton>();

    public TaskPane() {
        super(MessageType.PLAIN, null, CommandValue.CLOSE);
        this.setMainInstructionText("<Main Instruction>");
        this.setContentText("<Content Text>");
        this.updateUI();
    }

    public TaskPane(IconType mainInstructionIconType, String mainInstructionText, Object ... commitObjects) {
        this(mainInstructionIconType, mainInstructionText, (JComponent)null, commitObjects);
    }

    public TaskPane(IconType mainInstructionIconType, String mainInstructionText, String contentText, Object ... commitObjects) {
        super(MessageType.PLAIN, null, commitObjects);
        this.setMainInstructionIconType(mainInstructionIconType);
        this.setMainInstructionText(mainInstructionText);
        this.setContentText(contentText);
        this.updateUI();
    }

    public TaskPane(IconType mainInstructionIconType, String mainInstructionText, JComponent content, Object ... commitObjects) {
        super(MessageType.PLAIN, content, commitObjects);
        this.setMainInstructionIconType(mainInstructionIconType);
        this.setMainInstructionText(mainInstructionText);
        this.updateUI();
    }

    @Override
    public void setMessageType(MessageType newType) {
        super.setMessageType(newType);
        this.setMainInstructionIconType(newType.iconType());
    }

    public Icon getMainInstructionIcon() {
        return this.mainInstructionIcon;
    }

    public void setMainInstructionIcon(Icon newIcon) {
        Icon oldIcon = this.getMainInstructionIcon();
        this.mainInstructionIcon = newIcon;
        this.firePropertyChange(PROPERTY_MAIN_INSTRUCTION_ICON, oldIcon, newIcon);
    }

    public void setMainInstructionIconType(IconType iconType) {
        if (iconType == null || iconType.getKey() == null) {
            this.setMainInstructionIcon(null);
            return;
        }
        this.setMainInstructionIcon(UIManager.getIcon("OptionPane." + iconType.getKey()));
    }

    public String getMainInstructionText() {
        return this.mainInstructionText;
    }

    public void setMainInstructionText(String mayBeMarkedText) {
        JSDLCoreStyleChecker.getInstance().checkMainInstruction(mayBeMarkedText, this.getMessageType());
        String oldText = this.getMainInstructionText();
        this.mainInstructionText = mayBeMarkedText;
        this.firePropertyChange(PROPERTY_MAIN_INSTRUCTION_TEXT, oldText, mayBeMarkedText);
    }

    public boolean getMainInstructionLabelsContent() {
        return this.mainInstructionLabelsContent;
    }

    public void setMainInstructionLabelsContent(boolean newValue) {
        if (newValue) {
            JSDLCoreStyleChecker.getInstance().checkLabelingMainInstructionHasMnemonic(this.getMainInstructionText());
        }
        boolean oldValue = this.getMainInstructionLabelsContent();
        this.mainInstructionLabelsContent = newValue;
        this.firePropertyChange(PROPERTY_MAIN_INSTRUCTION_LABELS_CONTENT, oldValue, newValue);
    }

    @Override
    public void setContent(JComponent content) {
        super.setContent(content);
    }

    public String getContentText() {
        return this.contentText;
    }

    public void setContentText(String newText) {
        String oldText = this.getContentText();
        this.contentText = newText;
        this.firePropertyChange(PROPERTY_CONTENT_TEXT, oldText, newText);
    }

    public boolean isProgressVisible() {
        return this.progressVisible;
    }

    public void setProgressVisible(boolean newValue) {
        boolean oldValue = this.isProgressVisible();
        this.progressVisible = newValue;
        this.firePropertyChange(PROPERTY_PROGRESS_VISIBLE, oldValue, newValue);
    }

    public int getProgressValue() {
        return this.progressValue;
    }

    public void setProgressValue(int newValue) {
        Preconditions.checkArgument(newValue >= 0 && newValue <= 100, "The progress int value must be in [0, 100].");
        int oldValue = this.getProgressValue();
        this.progressValue = newValue;
        this.firePropertyChange(PROPERTY_PROGRESS_VALUE, oldValue, newValue);
    }

    public void setProgressValue(float newValue) {
        Preconditions.checkArgument(newValue >= 0.0f && newValue <= 1.0f, "The progress float value must be in [0.0f, 1.0f]");
        this.setProgressValue((int)(newValue * 100.0f));
    }

    public boolean isProgressIndeterminate() {
        return this.progressIndeterminate;
    }

    public void setProgressIndeterminate(boolean newValue) {
        boolean oldValue = this.isProgressIndeterminate();
        this.progressIndeterminate = newValue;
        this.firePropertyChange(PROPERTY_PROGRESS_INDETERMINATE, oldValue, newValue);
    }

    public Object getRadioValue() {
        return this.radioValue;
    }

    public void setRadioValue(Object newValue) {
        Object oldValue = this.getRadioValue();
        this.radioValue = newValue;
        this.firePropertyChange(PROPERTY_RADIO_VALUE, oldValue, newValue);
    }

    public JRadioButton addRadioButton(Object choice, String markedText) {
        FormLayout layout;
        JGComponentFactory factory = JGComponentFactory.getCurrent();
        JRadioButton button = factory.createRadioButton(markedText);
        button.setModel(new RadioButtonAdapter(this, choice));
        MnemonicUtils.configure(button, markedText);
        if (this.radioButtonPanel == null) {
            layout = new FormLayout("fill:default:grow", "7dlu");
            this.radioButtonPanel = new JPanel(layout);
            this.radioButtonPanel.setOpaque(false);
        }
        layout = (FormLayout)this.radioButtonPanel.getLayout();
        layout.appendRow(FormSpecs.PREF_ROWSPEC);
        int row = this.radioButtonPanel.getComponentCount() + 2;
        this.radioButtonPanel.add((Component)button, CC.xy(1, row));
        this.radioButtons.add(button);
        FocusTraversalUtils.group(this.radioButtons);
        return button;
    }

    public JPanel getRadioButtonPanel() {
        return this.radioButtonPanel;
    }

    public void setCommandLinks(CommandLinkValue ... commandLinkValues) {
        if (this.commandLinkPanel != null) {
            this.commandLinkPanel.removeAll();
            this.commandLinkPanel = null;
        }
        for (CommandLinkValue commandLinkValue : commandLinkValues) {
            this.addCommandLink(commandLinkValue.getValue(), commandLinkValue.getIcon(), commandLinkValue.getText(), commandLinkValue.getDescription());
        }
    }

    public void addCommandLink(Object value, String text, String description) {
        this.addCommandLink(value, null, text, description);
    }

    public void addCommandLink(Object value, Icon icon, String text, String description) {
        CommandValueCommitAction action = new CommandValueCommitAction(value, text);
        action.putValue("SmallIcon", icon);
        action.putValue("LongDescription", description);
        this.addCommandLink(action, false);
    }

    public void addCommandLink(CommandValue value, String description) {
        this.addCommandLink(value, null, value.getMarkedText(), description);
    }

    public void addCommandLink(Action action, boolean forceStandardIcon) {
        FormLayout layout;
        JGCommandLink commandLink = new JGCommandLink(action, this.getCommandLinkIconsVisible(), forceStandardIcon);
        if (this.commandLinkPanel == null) {
            layout = new FormLayout("fill:default:grow", "7dlu");
            this.commandLinkPanel = new JPanel(layout);
            this.commandLinkPanel.setOpaque(false);
        }
        layout = (FormLayout)this.commandLinkPanel.getLayout();
        layout.appendRow(FormSpecs.PREF_ROWSPEC);
        CellConstraints cc = CC.xy(1, this.commandLinkPanel.getComponentCount() + 2);
        this.commandLinkPanel.add((Component)commandLink, cc);
        this.commandLinks.add(commandLink);
        FocusTraversalUtils.group(this.commandLinks);
    }

    public JPanel getCommandLinkPanel() {
        return this.commandLinkPanel;
    }

    public boolean getCommandLinkIconsVisible() {
        return this.commandLinkIconsVisible;
    }

    public void setCommandLinkIconsVisible(boolean newValue) {
        boolean oldValue = this.getCommandLinkIconsVisible();
        this.commandLinkIconsVisible = newValue;
        if (this.commandLinkPanel != null) {
            for (int i = 0; i < this.commandLinkPanel.getComponentCount(); ++i) {
                JGCommandLink commandLink = (JGCommandLink)this.commandLinkPanel.getComponent(i);
                commandLink.setIconVisible(newValue);
            }
        }
        this.firePropertyChange(PROPERTY_COMMANDLINK_ICONS_VISIBLE, oldValue, newValue);
    }

    @Override
    public void setCommandContentVisible(boolean b) {
        super.setCommandContentVisible(b);
    }

    @Override
    public void setCommitCommands(Object ... commitObjects) {
        super.setCommitCommands(commitObjects);
    }

    @Override
    public void setAdditionalCommands(Action ... commandActions) {
        super.setAdditionalCommands(commandActions);
    }

    @Override
    public void setAdditionalCommandButtons(JButton ... commandButtons) {
        super.setAdditionalCommandButtons(commandButtons);
    }

    @Override
    public void setDefaultCommand(Object buttonOrActionOrCommandValue) {
        super.setDefaultCommand(buttonOrActionOrCommandValue);
    }

    @Override
    public void setDefaultCommandIndex(int index) {
        super.setDefaultCommandIndex(index);
    }

    @Override
    public void setCancelCommand(Object cancelObject) {
        super.setCancelCommand(cancelObject);
    }

    @Override
    protected List<JButton> commandButtons() {
        ArrayList<JButton> buttons = new ArrayList<JButton>(super.commandButtons());
        buttons.addAll(this.commandLinks);
        return buttons;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean newValue) {
        boolean oldValue = this.isExpanded();
        this.expanded = newValue;
        this.firePropertyChange(PROPERTY_EXPANDED, oldValue, newValue);
    }

    public String getExpandedText() {
        return this.expandedText;
    }

    public void setExpandedText(String newText) {
        String oldText = this.getExpandedText();
        this.expandedText = newText;
        this.firePropertyChange(PROPERTY_EXPANDED_TEXT, oldText, newText);
    }

    public String getExpandedControlText() {
        return this.expandedControlText;
    }

    public void setExpandedControlText(String markedText) {
        String oldText = this.getExpandedControlText();
        this.expandedControlText = markedText;
        this.firePropertyChange(PROPERTY_EXPANDED_CONTROL_TEXT, oldText, markedText);
    }

    public String getCollapsedControlText() {
        return this.collapsedControlText;
    }

    public void setCollapsedControlText(String markedText) {
        String oldText = this.getCollapsedControlText();
        this.collapsedControlText = markedText;
        this.firePropertyChange(PROPERTY_COLLAPSED_CONTROL_TEXT, oldText, markedText);
    }

    public boolean isVerificationSelected() {
        return this.verificationSelected;
    }

    public void setVerificationSelected(boolean newValue) {
        boolean oldValue = this.isVerificationSelected();
        this.verificationSelected = newValue;
        this.firePropertyChange(PROPERTY_VERIFICATION_SELECTED, oldValue, newValue);
        if (this.verification != null) {
            this.verification.setSelected(newValue);
        }
    }

    public String getVerificationText() {
        return this.verificationText;
    }

    public void setVerificationText(String markedText) {
        String oldText = this.getVerificationText();
        this.verificationText = markedText;
        this.firePropertyChange(PROPERTY_VERIFICATION_TEXT, oldText, markedText);
    }

    public void setVerification(Verification newVerification) {
        this.verification = newVerification;
        if (this.verification != null) {
            this.setVerificationText(newVerification.getMarkedText());
            this.setVerificationSelected(newVerification.isSelected());
        } else {
            this.setVerificationText(null);
        }
    }

    @Override
    public CloseRequestHandler getCloseRequestHandler() {
        return super.getCloseRequestHandler();
    }

    @Override
    public void setCloseRequestHandler(CloseRequestHandler closeRequestHandler) {
        super.setCloseRequestHandler(closeRequestHandler);
    }

    @Override
    protected String layoutGroup() {
        return "TaskPane";
    }

    @Override
    protected TaskPaneVisualConfiguration createVisualConfiguration() {
        return new TaskPaneVisualConfiguration(this);
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    @Override
    protected void checkWindowTitle(String title) {
        super.checkWindowTitle(title);
        JSDLCoreStyleChecker.getInstance().checkMainInstructionDoesNotRepeatWindowTitle(this.mainInstructionText, title);
    }

    @Override
    protected AccessibleRole getAccessibleRole() {
        switch (this.getMessageType()) {
            case ERROR: 
            case WARNING: {
                return AccessibleRole.ALERT;
            }
        }
        return JSDLAccessibleRole.TASK_PANE;
    }

    public static final class CommandLinkValue {
        private final Object commitValue;
        private final Icon icon;
        private final String text;
        private final String description;

        public CommandLinkValue(Object commitValue, String text) {
            this(commitValue, null, text, null);
        }

        public CommandLinkValue(Object commitValue, Icon icon, String text) {
            this(commitValue, icon, text, null);
        }

        public CommandLinkValue(Object commitValue, String text, String description) {
            this(commitValue, null, text, description);
        }

        public CommandLinkValue(Object commitValue, Icon icon, String text, String description) {
            this.commitValue = commitValue;
            this.icon = icon;
            this.text = text;
            this.description = description;
        }

        public Object getValue() {
            return this.commitValue;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getText() {
            return this.text;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private static final class RadioButtonAdapter
    extends JToggleButton.ToggleButtonModel {
        private final TaskPane taskPane;
        private final Object choice;

        RadioButtonAdapter(TaskPane taskPane, Object choice) {
            this.taskPane = Preconditions.checkNotNull(taskPane, "The %s must not be null.", "task pane");
            this.choice = choice;
            taskPane.addPropertyChangeListener(TaskPane.PROPERTY_RADIO_VALUE, evt -> this.updateSelectedState());
            this.updateSelectedState();
        }

        @Override
        public void setSelected(boolean b) {
            if (!b || this.isSelected()) {
                return;
            }
            this.taskPane.setRadioValue(this.choice);
            this.updateSelectedState();
        }

        @Override
        public void setGroup(ButtonGroup group) {
            if (group != null) {
                throw new UnsupportedOperationException("You need not and must not use a ButtonGroup with a set of RadioButtonAdapters. These form a group by sharing the same subject ValueModel.");
            }
        }

        private void updateSelectedState() {
            boolean subjectHoldsChoiceValue = Objects.equals(this.choice, this.taskPane.getRadioValue());
            super.setSelected(subjectHoldsChoiceValue);
        }
    }
}

