/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.pane;

import com.jgoodies.common.base.Strings;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.MessageType;
import com.jgoodies.dialogs.core.internal.BasicStyledPaneBuilder;
import com.jgoodies.dialogs.core.pane.TabbedStyledPane;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public final class TabbedStyledPaneBuilder
extends BasicStyledPaneBuilder<TabbedStyledPane, TabbedStyledPaneBuilder> {
    public Adder beginTab() {
        return new Adder(this);
    }

    @Override
    protected TabbedStyledPane createPane() {
        return new TabbedStyledPane(MessageType.PLAIN, null, CommandValue.CLOSE);
    }

    void addTab(String tabTitle, JComponent tabComponent) {
        ((TabbedStyledPane)this.pane).addTab(tabTitle, tabComponent);
    }

    public static final class Adder {
        private final TabbedStyledPaneBuilder builder;
        private final JGComponentFactory factory = JGComponentFactory.getCurrent();
        private String title;
        private EmptyBorder padding;
        private boolean paddingSet;
        private JComponent content;

        Adder(TabbedStyledPaneBuilder builder) {
            this.builder = builder;
        }

        public Adder title(String plainTitle, Object ... args) {
            this.title = Strings.get(plainTitle, args);
            return this;
        }

        public Adder padding(EmptyBorder padding) {
            this.padding = padding;
            this.paddingSet = true;
            return this;
        }

        public Adder content(JComponent tabContent) {
            this.content = tabContent;
            return this;
        }

        public Adder scrolledContent(JComponent tabContent) {
            JScrollPane scrollPane = this.factory.createStrippedScrollPane(this.content);
            scrollPane.setOpaque(false);
            scrollPane.getViewport().setOpaque(false);
            return this.content(scrollPane);
        }

        public TabbedStyledPaneBuilder endTab() {
            if (this.paddingSet) {
                this.content.setBorder(this.padding);
            }
            this.builder.addTab(this.title, this.content);
            return this.builder;
        }
    }

    public static final class TabAdder {
        private final TabbedStyledPaneBuilder builder;
        private final String tabTitle;
        private EmptyBorder padding;
        private boolean paddingSet;

        TabAdder(TabbedStyledPaneBuilder builder, String tabTitle) {
            this.builder = builder;
            this.tabTitle = tabTitle;
        }

        public TabAdder padding(EmptyBorder padding) {
            this.padding = padding;
            this.paddingSet = true;
            return this;
        }

        public TabbedStyledPaneBuilder content(JComponent tabContent) {
            if (this.paddingSet) {
                tabContent.setBorder(this.padding);
            }
            this.builder.addTab(this.tabTitle, tabContent);
            return this.builder;
        }
    }
}

