/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics.choice;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.swing.Listeners;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.components.renderer.JGDefaultListCellRenderer;
import com.jgoodies.dialogs.basics.ReturnValue;
import com.jgoodies.dialogs.basics.internal.JSDLBasicsUtils;
import com.jgoodies.dialogs.core.AspectRatio;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.CoreDialogResources;
import com.jgoodies.dialogs.core.PreferredWidth;
import com.jgoodies.dialogs.core.Verification;
import com.jgoodies.dialogs.core.internal.AbstractPaneBuilder;
import com.jgoodies.dialogs.core.internal.JSDLCoreStyleChecker;
import com.jgoodies.dialogs.core.pane.task.TaskPane;
import com.jgoodies.dialogs.core.pane.task.TaskPaneBuilder;
import com.jgoodies.dialogs.core.util.JSDLUtils;
import com.jgoodies.layout.builder.FormBuilder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;

public final class SingleSelectionPaneBuilder<V>
extends AbstractPaneBuilder<TaskPane, SingleSelectionPaneBuilder<V>> {
    private final TaskPaneBuilder builder = new TaskPaneBuilder();
    private String supplementalInstructionText;
    private ListCellRenderer<? super V> cellRenderer;
    private List<V> options;
    private V defaultOption;
    private boolean withNullOption;
    private String nullOptionText;
    private JList<V> list;
    private JComponent listView;

    public SingleSelectionPaneBuilder() {
        this.builder.internalPreferredWidth(PreferredWidth.MEDIUM);
        this.nullOptionText = CoreDialogResources.getString("common.meta_option.none");
    }

    public SingleSelectionPaneBuilder<V> mainInstructionText(String text, Object ... args) {
        this.builder.mainInstructionText(text, args);
        return this;
    }

    public SingleSelectionPaneBuilder<V> supplementalInstructionText(String text, Object ... args) {
        this.supplementalInstructionText = Strings.get(text, args);
        Preconditions.checkNotBlank(this.supplementalInstructionText, "The %s must not be null, empty, or whitespace.", "supplemental instruction");
        return this;
    }

    public SingleSelectionPaneBuilder<V> verificationText(String text, Object ... args) {
        this.builder.verificationText(text, args);
        return this;
    }

    public SingleSelectionPaneBuilder<V> verificationSelected(boolean b) {
        this.builder.verificationSelected(b);
        return this;
    }

    public SingleSelectionPaneBuilder<V> verification(Verification verification) {
        this.builder.verification(verification);
        return this;
    }

    public SingleSelectionPaneBuilder<V> preferredWidth(int customValue) {
        this.builder.preferredWidth(customValue);
        return this;
    }

    public SingleSelectionPaneBuilder<V> preferredWidth(PreferredWidth standardizedValue) {
        this.builder.preferredWidth(standardizedValue);
        return this;
    }

    public SingleSelectionPaneBuilder<V> aspectRatio(double customValue) {
        this.builder.aspectRatio(customValue);
        return this;
    }

    public SingleSelectionPaneBuilder<V> aspectRatio(AspectRatio standardizedValue) {
        this.builder.aspectRatio(standardizedValue);
        return this;
    }

    @Override
    public SingleSelectionPaneBuilder<V> resizable(boolean resizable) {
        return (SingleSelectionPaneBuilder)super.resizable(resizable);
    }

    @Override
    public SingleSelectionPaneBuilder<V> minimumSize(Dimension minimumSize) {
        return (SingleSelectionPaneBuilder)super.minimumSize(minimumSize);
    }

    @Override
    public SingleSelectionPaneBuilder<V> minimumSize(int minimumWidth, int minimumHeight) {
        return (SingleSelectionPaneBuilder)super.minimumSize(minimumWidth, minimumHeight);
    }

    @Override
    public SingleSelectionPaneBuilder<V> maximumSize(Dimension minimumSize) {
        return (SingleSelectionPaneBuilder)super.maximumSize(minimumSize);
    }

    @Override
    public SingleSelectionPaneBuilder<V> maximumSize(int maximumWidth, int maximumHeight) {
        return (SingleSelectionPaneBuilder)super.maximumSize(maximumWidth, maximumHeight);
    }

    public SingleSelectionPaneBuilder<V> options(List<V> options) {
        this.options = options;
        return this;
    }

    public SingleSelectionPaneBuilder<V> options(V ... options) {
        this.options = Arrays.asList(options);
        return this;
    }

    public SingleSelectionPaneBuilder<V> defaultOption(V defaultOption) {
        this.defaultOption = defaultOption;
        return this;
    }

    public SingleSelectionPaneBuilder<V> nullOptionEnabled(boolean b) {
        this.withNullOption = b;
        return this;
    }

    public SingleSelectionPaneBuilder<V> nullOptionText(String text, Object ... args) {
        this.nullOptionText = Strings.get(text, args);
        Preconditions.checkNotBlank(this.nullOptionText, "The %s must not be null, empty, or whitespace.", this.nullOptionText);
        return this;
    }

    public SingleSelectionPaneBuilder<V> cellFormatter(Function<? super V, String> formatter) {
        return this.cellRenderer(new JGDefaultListCellRenderer<V>(formatter));
    }

    public SingleSelectionPaneBuilder<V> cellRenderer(ListCellRenderer<? super V> renderer) {
        this.cellRenderer = renderer;
        return this;
    }

    private TaskPane build() {
        SingleSelectionPaneBuilder.checkMainInstructionNotBlank(this.builder.build().getMainInstructionText());
        JGComponentFactory factory = JGComponentFactory.getCurrent();
        this.list = factory.createList(this.buildChoices());
        ListCellRenderer<Object> delegateRenderer = this.cellRenderer != null ? this.cellRenderer : this.list.getCellRenderer();
        NullOptionListCellRenderer renderer = this.withNullOption ? new NullOptionListCellRenderer(delegateRenderer, this.nullOptionText) : delegateRenderer;
        this.list.setCellRenderer(renderer);
        this.list.setSelectionMode(0);
        this.list.addMouseListener(Listeners.mouseDoubleClicked(SingleSelectionPaneBuilder::onMouseDoubleClicked));
        JScrollPane scrollPane = new JScrollPane(this.list);
        if (this.defaultOption == null && this.withNullOption) {
            this.list.setSelectedIndex(0);
        } else {
            this.list.setSelectedValue(this.defaultOption, true);
        }
        this.listView = scrollPane;
        this.builder.mainInstructionLabelsContent(true);
        this.builder.marginContentTop(0);
        this.builder.content(this.buildContent());
        this.builder.commitCommands(CommandValue.OK, CommandValue.CANCEL);
        this.checkStyle();
        return this.builder.build();
    }

    private JComponent buildContent() {
        if (this.supplementalInstructionText == null) {
            return this.listView;
        }
        JTextComponent instruction = JGComponentFactory.getCurrent().createStaticText(this.supplementalInstructionText, new Object[0]);
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("fill:default:grow", new Object[0])).rows("fill:default:grow, $ug, p", new Object[0])).add(this.listView).xy(1, 1)).add(instruction).xy(1, 3)).build();
    }

    private List<V> buildChoices() {
        ArrayList<V> choices = new ArrayList<V>();
        if (!this.options.contains(null)) {
            choices.addAll(this.options);
        } else {
            for (V option : this.options) {
                if (option == null) continue;
                choices.add(option);
            }
        }
        if (this.withNullOption) {
            choices.add(0, null);
        }
        return choices;
    }

    public ReturnValue<V> showDialog() {
        TaskPane pane = this.build();
        JDialog dialog = this.createDialog(pane);
        dialog.addWindowListener(new OnWindowOpenedEnsureSelectedListIndexVisibleHandler(this.list));
        dialog.setVisible(true);
        return new ReturnValue<V>(pane.isCancelled(), this.list.getSelectedValue());
    }

    @Override
    protected String getTitle() {
        if (this.title == null) {
            this.title = JSDLBasicsUtils.getApplicationTitle();
        }
        return this.title;
    }

    private void checkStyle() {
        SingleSelectionPaneBuilder.checkMainInstructionNotBlank(this.builder.build().getMainInstructionText());
        SingleSelectionPaneBuilder.checkSupplementalInstructionNullOrNotBlank(this.builder.build().getContentText());
        if (this.withNullOption) {
            this.checkNullOptionEnclosedInParentheses();
        }
    }

    private static void checkMainInstructionNotBlank(String mainInstruction) {
        Preconditions.checkNotBlank(mainInstruction, "The %s must not be null, empty, or whitespace.", "main instruction");
    }

    private static void checkSupplementalInstructionNullOrNotBlank(String supplementalInstruction) {
        if (supplementalInstruction != null) {
            Preconditions.checkNotBlank(supplementalInstruction, "The supplemental instruction must not be empty, or whitespace.");
        }
        JSDLCoreStyleChecker.getInstance().checkSupplementalInstructionIsTrimmed(supplementalInstruction);
    }

    private void checkNullOptionEnclosedInParentheses() {
        JSDLCoreStyleChecker.getInstance().checkMetaOptionEnclosedInParentheses(this.nullOptionText);
    }

    private static void onMouseDoubleClicked(MouseEvent evt) {
        JSDLUtils.closePaneFor(evt);
    }

    private static final class NullOptionListCellRenderer
    extends DefaultListCellRenderer {
        private final ListCellRenderer delegate;
        private final String nullText;

        NullOptionListCellRenderer(ListCellRenderer<?> delegate, String nullText) {
            this.delegate = Preconditions.checkNotNull(delegate, "The %s must not be null.", "wrapped ListCellRenderer");
            this.nullText = Preconditions.checkNotBlank(nullText, "The %s must not be null, empty, or whitespace.", "null text");
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return value == null ? super.getListCellRendererComponent(list, this.nullText, index, isSelected, cellHasFocus) : this.delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    private static final class OnWindowOpenedEnsureSelectedListIndexVisibleHandler
    extends WindowAdapter {
        private final JList<?> list;

        OnWindowOpenedEnsureSelectedListIndexVisibleHandler(JList<?> list) {
            this.list = list;
        }

        @Override
        public void windowOpened(WindowEvent evt) {
            this.list.ensureIndexIsVisible(this.list.getMinSelectionIndex());
        }
    }
}

