/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.gui.pages.preferences;

import com.jgoodies.app.gui.basics.format.AppFormats;
import com.jgoodies.app.gui.content.preferences.AppPreferencesModel;
import com.jgoodies.app.gui.content.preferences.AppPreferencesView;
import com.jgoodies.app.gui.pages.preferences.PreferencesPageResources;
import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.common.jsdl.i18n.Resources;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.fluent.Theme;
import com.jgoodies.fluent.internal.FluentResources;
import com.jgoodies.fluent.navigation.NavigationBar;
import com.jgoodies.fluent.pages.PivotPage;
import com.jgoodies.fluent.pivots.Pivot;
import com.jgoodies.fluent.pivots.PivotModel;
import com.jgoodies.framework.setup.BasicApplicationPreferences;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.layout.factories.Paddings;
import com.jgoodies.navigation.NavigationEventArgs;
import jakarta.inject.Inject;
import java.time.LocalDate;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;

public final class PreferencesPage
extends PivotPage {
    public static final int INDEX_SETTINGS = 0;
    public static final int INDEX_LICENSE = 1;
    public static final int INDEX_ABOUT = 2;
    private static final ResourceMap APP_RESOURCES = Application.getResourceMap(PreferencesPage.class);
    private static PreferencesPageResources resources = Resources.get(PreferencesPageResources.class);
    private final BasicApplicationPreferences prefs;
    private final JGComponentFactory factory;
    private String licenseText;
    private boolean navigationBarVisible = true;

    @Inject
    public PreferencesPage(BasicApplicationPreferences prefs, JGComponentFactory factory) {
        this.prefs = prefs;
        this.factory = factory;
        this.setDisplayString(PreferencesPage.resources.pageName, new Object[0]);
        this.setTabs(this::buildTabs);
        this.setLicenseText(PreferencesPage.defaultLicenseText());
    }

    public void setNavigationBarVisible(boolean visible) {
        this.navigationBarVisible = visible;
    }

    public void setLicenseText(String licenseText) {
        this.licenseText = licenseText;
    }

    @Override
    public boolean isPinEnabled() {
        return false;
    }

    @Override
    public void onNavigatedTo(NavigationEventArgs args) {
        super.onNavigatedTo(args);
        if (this.navigationBarVisible) {
            this.setTopAppBar(new NavigationBar.Builder().pageModel(this.getPageModel()).theme(this.theme).backButtonVisible(this.isBackButtonVisible()).build());
        }
    }

    private PivotModel buildTabs() {
        return ((PivotModel.Builder)((Pivot.Adder)((Pivot.Adder)((PivotModel.Builder)((Pivot.Adder)((Pivot.Adder)((PivotModel.Builder)((Pivot.Adder)((Pivot.Adder)new PivotModel.Builder().beginPivot().text(PreferencesPage.resources.general, new Object[0])).content(this.buildGeneralContent())).endPivot()).beginPivot().text(PreferencesPage.resources.licenseAgreement, new Object[0])).content(this.licenseText, new Object[0])).endPivot()).beginPivot().text(PreferencesPage.resources.about, new Object[0])).content(this.buildAboutContent())).endPivot()).build();
    }

    private JComponent buildGeneralContent() {
        AppPreferencesModel model = AppPreferencesModel.direct(this.prefs);
        AppPreferencesView view = new AppPreferencesView(model);
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("pref:grow", new Object[0])).rows("f:p", new Object[0])).padding(Paddings.DLU14)).add(view.buildContent()).xy(1, 1)).build();
    }

    private static String defaultLicenseText() {
        return "Copyright \u00a9 2023 JGoodies Software GmbH. All rights reserved.\n\nPermission is granted to licensees of the JGoodies Smart Client\nto use this software, subject to the following restrictions:\n\no The origin of this software must not be misrepresented;\n    you must not claim to be the author of the software.\n\no You must redistribute the software only in binary form.\n\no You may not reverse engineer, or decompile binary portions\n    of it, or otherwise attempt to derive the source code from\n    such portions.\n\no You may not sell, rent, loan or otherwise encumber\n    this software in whole or in part, to any third party.";
    }

    private JComponent buildAboutContent() {
        String applicationName = APP_RESOURCES.getString("application.name", new Object[0]);
        String buildNo = APP_RESOURCES.getString("application.buildNo", new Object[0]);
        LocalDate buildDate = APP_RESOURCES.getLocalDate("application.buildDate");
        String copyright = APP_RESOURCES.getString("application.copyright", new Object[0]);
        String detailsText = APP_RESOURCES.getString("dialogs.about.content", new Object[0]);
        String title = String.format("%s %s \u2013 %s", applicationName, buildNo, AppFormats.formatTypoDate(buildDate));
        JLabel titleLabel = this.factory.createLabel(title);
        titleLabel.setFont(FluentResources.getInstance().getBodyStrongFont());
        JLabel subtitleLabel = this.factory.createLabel(copyright);
        subtitleLabel.setFont(FluentResources.getInstance().getCaptionFont());
        JTextComponent textComponent = this.factory.createStaticText(detailsText, new Object[0]);
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("0px, 7dlu, default:grow", new Object[0])).rows("8epx, pref, 0dlu, pref, 0dlu, fill:pref:grow", new Object[0])).padding("12epx, 7dlu, 14epx, 14epx", new Object[0])).add(titleLabel).xy(3, 2)).add(subtitleLabel).xy(3, 4)).add(textComponent).xy(3, 6)).build();
    }

    public static final class Builder {
        private PreferencesPage target;
        private BasicApplicationPreferences prefs;
        private JGComponentFactory factory = JGComponentFactory.getCurrent();

        public Builder prefs(BasicApplicationPreferences prefs) {
            this.prefs = prefs;
            return this;
        }

        public Builder factory(JGComponentFactory factory) {
            this.factory = factory;
            return this;
        }

        public Builder theme(Theme theme) {
            this.getTarget().setTheme(theme);
            return this;
        }

        public Builder licenseText(String text) {
            this.getTarget().setLicenseText(text);
            return this;
        }

        public Builder navigationBarVisible(boolean visible) {
            this.getTarget().setNavigationBarVisible(visible);
            return this;
        }

        public Builder backButtonVisible(boolean visible) {
            this.getTarget().setBackButtonVisible(visible);
            return this;
        }

        public PreferencesPage build() {
            return this.getTarget();
        }

        private PreferencesPage getTarget() {
            if (this.target == null) {
                this.target = new PreferencesPage(this.prefs, this.factory);
            }
            return this.target;
        }
    }
}

