---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie, références, 
              liens, backref
---

# Comment obtenir des liens de la bibliographie vers les références dans le texte ?

Un lien (ou au moins une référence de page) permettant de passer d'un ouvrage
de la bibliographie à son évocation dans le texte principal d'un document est
souvent utile dans les documents volumineux. Voici différentes méthodes 
qui permettent d'obtenir cette fonctionnalité.

## Avec l'extension <ctanpkg:backref>

L'extension <ctanpkg:backref> fait partie de l'ensemble <ctanpkg:hyperref> 
et prend en charge les hyperliens de la bibliographie vers les zones de texte
des commandes `\cite`, en indiquant par défaut les numéros de page où sont
citées les références.

Cette extension n'agrége pas les listes de pages ("5, 6, 7" apparaît
comme tel, plutôt que "5--7") mais elle ne répète pas la référence 
à une page contenant plusieurs fois une référence.


### Avec BibTeX et <ctanpkg:backref>

Voici un exemple d'utilisation de cette extension avec BibTeX. 

```
% Un fichier .bib créé par le document avec l'environnement filecontents
\begin{filecontents}{\jobname.bib}
  @book{dyna,
    author = {Moriarty, James},
    year = {1871},
    title = {La dynamique d'un astéroïde},
  }
  @book{apic,
    author = {Holmes, Sherlock},
    year = {1909},
    title = {Manuel pratique d'apiculture,
             avec quelques observations sur la ségrégation de la reine},
  }
\end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{backref}

\begin{document}
(\dots) Toute bonne bibliothèque de curiosités se devrait de compter 
\cite{dyna,apic}. (\dots)
\clearpage
(\dots) Certains notent d'ailleurs le tour de force intellectuel que 
constitue \cite{dyna}. (\dots)
\bibliographystyle{plain}
\bibliography{\jobname}
\end{document}
```

:::{todo} Ajouter la méthode pour ne pas avoir de pluriel à page
lorsqu'il n'y en a qu'une.
:::


### Avec BibTeX, <ctanpkg:natbib> et <ctanpkg:backref>

:::{todo} Exemple à ajouter.
:::


### Avec <ctanpkg:biblatex> et <ctanpkg:backref>

Une solution avec <ctanpkg:biblatex> permet d'obtenir un résultat similaire
avec l'option d'extension `backref=true`. L'exemple ci-dessous présente 
dans ses commentaires un code permettant de rendre le résultat 
encore plus proche de ce que font les exemples suivants.

```
% Un fichier .bib créé par le document avec l'environnement filecontents
\begin{filecontents}{\jobname.bib}
  @book{dyna,
    author = {Moriarty, James},
    year = {1871},
    title = {La dynamique d'un astéroïde},
  }
  @book{apic,
    author = {Holmes, Sherlock},
    year = {1909},
    title = {Manuel pratique d'apiculture,
             avec quelques observations sur la ségrégation de la reine},
  }
\end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage[backref=true]{biblatex}
  \usepackage{hyperref}

  % Rédéfinition des termes pour biblatex 
  %\DefineBibliographyStrings{english}{%
  %  backrefpage = {page},     % initialement "cf. p."
  %  backrefpages = {pages},   % initialement "cf. p."
  %}

  \addbibresource{\jobname.bib}

\begin{document}
(\dots) Toute bonne bibliothèque de curiosités se devrait de compter 
\cite{dyna,apic}. (\dots)
\clearpage
(\dots) Certains notent d'ailleurs le tour de force intellectuel que 
constitue \cite{dyna}. (\dots)
\printbibliography
\end{document}
```


## Avec l'extension <ctanpkg:citeref>

L'extension <ctanpkg:citeref> est plus ancienne et repose sur un code 
plutôt simple : elle produit uniquement une liste de pages où figure 
chaque référence après chacune des références de la bibliographie.
Elle n'interagit pas bien avec d'autres extensions jouant sur les références
(par exemple, <ctanpkg:cite>), ce qui reflète son ancienneté. Elle dérive
en effet d'une extension LaTeX 2.09.

Tout comme <ctanpkg:backref>, elle n'agrége pas les listes de pages 
mais ne répète pas la référence à une page contenant plusieurs fois 
une référence.

Voici un exemple (où est affichée la seule page de la bibliographie) :

```
% Un fichier .bib créé par le document avec l'environnement filecontents
\begin{filecontents}{\jobname.bib}
  @book{dyna,
    author = {Moriarty, James},
    year = {1871},
    title = {La dynamique d'un astéroïde},
  }
  @book{apic,
    author = {Holmes, Sherlock},
    year = {1909},
    title = {Manuel pratique d'apiculture,
             avec quelques observations sur la ségrégation de la reine},
  }
\end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{citeref}

\begin{document}
(\dots) Toute bonne bibliothèque de curiosités se devrait de compter 
\cite{dyna,apic}. (\dots)
\clearpage
(\dots) Certains notent d'ailleurs le tour de force intellectuel que 
constitue \cite{dyna}. (\dots)
\bibliographystyle{plain}
\bibliography{\jobname}
\end{document}
```


:::{sources}
- [References from the bibliography to the citation](faquk:FAQ-backref)
- [Formatting back references in bibliography](https://tex.stackexchange.com/q/36307), 
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::