---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures, 
              matrice, tableau
---

# Comment composer une matrice ?

## Avec les commandes de base

Il suffit de construire un tableau sans lignes avec l'environnement `array`
comme dans cet exemple :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\[
  \begin{array}{ccc}
    x_{11} & \cdots & x_{1p} \\
    \vdots & \ddots & \vdots \\
    x_{n1} & \cdots & x_{np}
  \end{array}
\]
\end{document}
```

Pour savoir comment encadrer cette matrice avec des délimiteurs, 
vous pouvez consulter la question 
"[](/4_domaines_specialises/mathematiques/structures/delimiteurs/ajuster_la_taille_des_delimiteurs)".


## Avec l'extension <ctanpkg:mathtools>

L'extension <ctanpkg:mathtools> (ou <ctanpkg:amsmath>) permet de définir 
une matrice de manière plus rapide qu'avec l'environnement `array`. 
Les environnements disponibles sont :
- `matrix` pour une matrice sans éléments encadrants ;
- `pmatrix` pour une matrice encadrée par des parenthèses ;
- `bmatrix` pour une matrice encadrée par des crochets ;
- `vmatrix` pour une matrice encadrée par des lignes verticales ;
- `Vmatrix` pour une matrice encadrée par des doubles lignes verticales.

En voici un exemple d'utilisation :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\[
  \begin{pmatrix}
    a & b \\
    c & d
  \end{pmatrix}
\]
\end{document}
```


## Avec l'extension <ctanpkg:easymat> 

L'extension <ctanpkg:easymat> aide également à l'écriture de matrices.

```{todo}
Compléter avec un exemple.
```


## Avec l'extension <ctanpkg:easybmat> 

L'extension <ctanpkg:easybmat> fournit des éléments pour écrire des matrices
par bloc.

```{todo}
Compléter avec un exemple.
```