/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.ArrayDescriptor;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.SQLName;
import oracle.sql.StructDescriptor;

public abstract class TypeDescriptor
implements Serializable {
    public static boolean DEBUG_SERIALIZATION = false;
    static final long serialVersionUID = 2022598722047823723L;
    SQLName m_sqlName;
    OracleNamedType m_pickler;
    transient oracle.jdbc.internal.OracleConnection m_conn;

    protected TypeDescriptor() {
    }

    protected TypeDescriptor(String string, Connection connection) throws SQLException {
        if (string == null || connection == null) {
            DBError.check_error(60, "Invalid arguments");
        }
        this.setPhysicalConnectionOf(connection);
        this.m_sqlName = new SQLName(string, this.getInternalConnection());
    }

    protected TypeDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        if (sQLName == null || connection == null) {
            DBError.check_error(60, "Invalid arguments");
        }
        this.m_sqlName = sQLName;
        this.setPhysicalConnectionOf(connection);
    }

    protected TypeDescriptor(SQLName sQLName, OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        if (sQLName == null || oracleTypeADT == null || connection == null) {
            DBError.check_error(60, "Invalid arguments");
        }
        this.m_sqlName = sQLName;
        this.setPhysicalConnectionOf(connection);
        this.m_pickler = oracleTypeADT;
        this.m_pickler.setDescriptor(this);
    }

    protected TypeDescriptor(OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        if (oracleTypeADT == null || connection == null) {
            DBError.check_error(60, "Invalid arguments");
        }
        this.setPhysicalConnectionOf(connection);
        this.m_sqlName = null;
        this.m_pickler = oracleTypeADT;
        this.m_pickler.setDescriptor(this);
    }

    public synchronized String getName() throws SQLException {
        if (this.m_sqlName == null) {
            this.initSQLName();
        }
        String string = this.m_sqlName.getName();
        return string;
    }

    public synchronized SQLName getSQLName() throws SQLException {
        if (this.m_sqlName == null) {
            this.initSQLName();
        }
        return this.m_sqlName;
    }

    void initSQLName() throws SQLException {
        if (this.m_pickler == null || this.getInternalConnection() == null) {
            DBError.throwSqlException(1);
        }
        this.m_sqlName = new SQLName(this.m_pickler.getFullName(), this.getInternalConnection());
    }

    public String getSchemaName() throws SQLException {
        String string = this.getSQLName().getSchema();
        return string;
    }

    public String getTypeName() throws SQLException {
        String string = this.getSQLName().getSimpleName();
        return string;
    }

    public OracleNamedType getPickler() {
        return this.m_pickler;
    }

    public oracle.jdbc.internal.OracleConnection getInternalConnection() {
        return this.m_conn;
    }

    public void setPhysicalConnectionOf(Connection connection) {
        this.m_conn = OracleConnection.physicalConnectionWithin(connection);
    }

    public abstract int getTypeCode() throws SQLException;

    public static TypeDescriptor getTypeDescriptor(String string, oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        TypeDescriptor typeDescriptor = null;
        try {
            SQLName sQLName = new SQLName(string, oracleConnection);
            String string2 = sQLName.getName();
            typeDescriptor = (TypeDescriptor)oracleConnection.getDescriptor(string2);
            if (typeDescriptor == null) {
                OracleTypeADT oracleTypeADT = new OracleTypeADT(string2, oracleConnection);
                ((OracleConnection)oracleConnection).db_access.getOracleTypeADT(oracleTypeADT);
                oracleTypeADT.init((OracleConnection)oracleConnection);
                OracleNamedType oracleNamedType = oracleTypeADT.cleanup();
                switch (oracleNamedType.getTypeCode()) {
                    case 2002: 
                    case 2008: {
                        typeDescriptor = new StructDescriptor(sQLName, (OracleTypeADT)oracleNamedType, oracleConnection);
                        break;
                    }
                    case 2003: {
                        typeDescriptor = new ArrayDescriptor(sQLName, (OracleTypeCOLLECTION)oracleNamedType, (Connection)oracleConnection);
                        break;
                    }
                    case 2007: {
                        typeDescriptor = new OpaqueDescriptor(sQLName, (OracleTypeOPAQUE)oracleNamedType, (Connection)oracleConnection);
                        break;
                    }
                    default: {
                        DBError.throwSqlException(1);
                    }
                }
                oracleConnection.putDescriptor(string2, typeDescriptor);
                oracleNamedType.setDescriptor(typeDescriptor);
            }
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                DBError.throwSqlException((SQLException)exception, 60, "Unable to resolve type \"" + string + "\"");
            }
            DBError.throwSqlException(60, "Unable to resolve type \"" + string + "\"");
        }
        return typeDescriptor;
    }

    public static TypeDescriptor getTypeDescriptor(String string, oracle.jdbc.OracleConnection oracleConnection, byte[] byArray, long l) throws SQLException {
        TypeDescriptor typeDescriptor = null;
        byte[][] byArrayArray = new byte[1][];
        String string2 = TypeDescriptor.getSubtypeName(oracleConnection, byArray, l);
        if (string2 == null) {
            string2 = string;
        }
        if ((typeDescriptor = (TypeDescriptor)oracleConnection.getDescriptor(string2)) == null) {
            SQLName sQLName = new SQLName(string2, oracleConnection);
            OracleTypeADT oracleTypeADT = new OracleTypeADT(string2, oracleConnection);
            ((OracleConnection)oracleConnection).db_access.getOracleTypeADT(oracleTypeADT);
            oracleTypeADT.init((OracleConnection)oracleConnection);
            OracleNamedType oracleNamedType = oracleTypeADT.cleanup();
            switch (oracleNamedType.getTypeCode()) {
                case 2002: 
                case 2008: {
                    typeDescriptor = new StructDescriptor(sQLName, (OracleTypeADT)oracleNamedType, oracleConnection);
                    break;
                }
                case 2003: {
                    typeDescriptor = new ArrayDescriptor(sQLName, (OracleTypeCOLLECTION)oracleNamedType, (Connection)oracleConnection);
                    break;
                }
                case 2007: {
                    typeDescriptor = new OpaqueDescriptor(sQLName, (OracleTypeOPAQUE)oracleNamedType, (Connection)oracleConnection);
                    break;
                }
                default: {
                    DBError.throwSqlException(1);
                }
            }
            oracleConnection.putDescriptor(string2, typeDescriptor);
        }
        return typeDescriptor;
    }

    public boolean isInHierarchyOf(String string) throws SQLException {
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            if (this.m_sqlName == null) {
                this.initSQLName();
            }
        }
        catch (SQLException sQLException) {
            DBError.SQLToIOException(sQLException);
        }
        objectOutputStream.writeObject(this.m_sqlName);
        objectOutputStream.writeObject(this.m_pickler);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.m_sqlName = (SQLName)objectInputStream.readObject();
        this.m_pickler = (OracleNamedType)objectInputStream.readObject();
    }

    public void setConnection(Connection connection) throws SQLException {
        this.setPhysicalConnectionOf(connection);
        this.m_pickler.setConnection(this.getInternalConnection());
    }

    public static String getSubtypeName(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray, long l) throws SQLException {
        if (byArray == null || byArray.length == 0 || oracleConnection == null) {
            DBError.throwSqlException(68);
        }
        String string = OracleTypeADT.getSubtypeName(oracleConnection, byArray, l);
        return string;
    }
}

