/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.base.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.dbuml.base.database.DBMetadata;
import org.dbuml.base.i18n.Translator;
import org.dbuml.base.model.Column;
import org.dbuml.base.model.DBElement;
import org.dbuml.base.model.Database;
import org.dbuml.base.model.FKey;
import org.dbuml.base.model.PKey;
import org.dbuml.base.model.PKeyInterface;
import org.dbuml.base.model.Table;
import org.dbuml.base.model.View;

public class GenericDBMetadata
extends DBMetadata {
    private static final Logger LOG = Logger.getLogger(GenericDBMetadata.class);

    public GenericDBMetadata(DBElement database, Object connection) throws SQLException, ClassNotFoundException, IllegalArgumentException {
        super(database, connection);
        this.dbmd = ((Connection)connection).getMetaData();
        if (database instanceof Database) {
            this.initDatabase((Database)database);
        }
        if (this.supportsSchemaInTableDefinitions() ? !database.getProperty("Supports_schema").equals("true") : !database.getProperty("Supports_schema").equals("false")) {
            throw new IllegalArgumentException(Translator.getInstance().localize("SCHEMA_MATCH"));
        }
    }

    public Object[] getTablesInSchema(String sSchema) throws SQLException {
        return this.getTablesInSchema(sSchema, new String[]{"TABLE"});
    }

    public Object[] getViewsInSchema(String sSchema) throws SQLException {
        return this.getTablesInSchema(sSchema, new String[]{"VIEW"});
    }

    private Object[] getTablesInSchema(String sSchema, String[] type) throws SQLException {
        ArrayList<String> alNames = new ArrayList<String>();
        ResultSet rs = null;
        if (((Database)this.repository).isDefaultSchema(sSchema)) {
            rs = ((DatabaseMetaData)this.dbmd).getTables(null, null, "%", type);
        } else if (((DatabaseMetaData)this.dbmd).supportsSchemasInTableDefinitions()) {
            rs = ((DatabaseMetaData)this.dbmd).getTables(null, sSchema, null, type);
        }
        Object[] sNames = null;
        if (rs == null) {
            sNames = new String[]{};
        } else {
            while (rs.next()) {
                alNames.add(((Database)this.repository).fixName(rs.getString("TABLE_NAME"), true));
            }
            rs.close();
            sNames = alNames.toArray(new String[0]);
            if (!((DatabaseMetaData)this.dbmd).supportsSchemasInTableDefinitions() && !((Database)this.repository).isDefaultSchema(sSchema)) {
                for (int i = 0; i < sNames.length; ++i) {
                    sNames[i] = ((String)sNames[i]).substring(sSchema.length());
                }
            }
        }
        return sNames;
    }

    public Object[] getSchemas() throws SQLException {
        ArrayList<String> alNames = new ArrayList<String>();
        ResultSet rs = ((DatabaseMetaData)this.dbmd).getSchemas();
        while (rs.next()) {
            alNames.add(rs.getString("TABLE_SCHEM"));
        }
        rs.close();
        Object[] sNames = alNames.toArray(new String[0]);
        return sNames;
    }

    public Object[] getDatabases() throws Exception {
        throw new Exception("Get databases not implemented for JDBC metadata");
    }

    public Database getDatabase(String name) throws Exception {
        throw new Exception("Get database not implemented for JDBC metadata");
    }

    public Table getTable(String tableName, String schema) throws SQLException {
        String mdTableName = ((Database)this.repository).removeQuote(tableName);
        Column[] cols = this.getColumns(tableName, schema);
        Table table = this.newTable(tableName);
        table.setColumns(cols);
        if (((Database)this.repository).isDefaultSchema(schema)) {
            schema = null;
        }
        ResultSet rs = null;
        try {
            try {
                rs = ((DatabaseMetaData)this.dbmd).getPrimaryKeys(null, schema, mdTableName);
            }
            catch (SQLException ignore) {
                rs = ((DatabaseMetaData)this.dbmd).getPrimaryKeys(null, schema, tableName);
            }
            this.setPrimaryKeys(tableName, schema, cols, rs);
        }
        catch (SQLException e) {
            LOG.error((Object)("Table = " + tableName + ": Metadata.getPrimaryKeys() " + e.getMessage()));
        }
        try {
            try {
                rs = ((DatabaseMetaData)this.dbmd).getImportedKeys(null, schema, mdTableName);
            }
            catch (SQLException ignore) {
                rs = ((DatabaseMetaData)this.dbmd).getImportedKeys(null, schema, tableName);
            }
            this.setForeignKeys(table, schema, cols, rs);
        }
        catch (SQLException e) {
            LOG.error((Object)("Table = " + tableName + ": Metadata.getImportedKeys() " + e.getMessage()));
        }
        try {
            try {
                rs = ((DatabaseMetaData)this.dbmd).getIndexInfo(null, schema, mdTableName, true, false);
            }
            catch (SQLException ignore) {
                rs = ((DatabaseMetaData)this.dbmd).getIndexInfo(null, schema, tableName, true, false);
            }
            this.setIndexInfo(table, cols, rs);
        }
        catch (SQLException e) {
            LOG.error((Object)("Table = " + tableName + ": Metadata.getIndexInfo " + e.getMessage()));
        }
        return table;
    }

    public View getView(String viewName, String schema) throws SQLException {
        View view = this.newView(viewName);
        Column[] cols = this.getColumns(viewName, schema);
        view.setColumns(cols);
        return view;
    }

    protected Table newTable(String name) {
        return new Table(name);
    }

    protected View newView(String name) {
        return new View(name);
    }

    protected Column newColumn(String name) {
        return new Column(name);
    }

    protected void setPrimaryKeys(String tableName, String schema, Column[] cols, ResultSet rs) throws SQLException {
        if (rs != null) {
            while (rs.next()) {
                String colName = rs.getString("COLUMN_NAME");
                short seq = rs.getShort("KEY_SEQ");
                String keyName = rs.getString("PK_NAME");
                PKey key = new PKey(schema, tableName, colName, seq, keyName);
                this.setKey(cols, colName, key);
            }
            rs.close();
        }
    }

    private void setKey(Column[] cols, String colName, PKeyInterface key) {
        if (key != null && cols != null) {
            for (int i = 0; i < cols.length; ++i) {
                if (!cols[i].getName().equalsIgnoreCase(colName)) continue;
                cols[i].setKey(key);
                if (!cols[i].isForeignKey()) break;
                if (cols[i].isUnique()) {
                    if (cols[i].allowsNulls()) {
                        ((FKey)key).setSourceMultiplicityAtMostOne();
                        break;
                    }
                    ((FKey)key).setSourceMultiplicityExactlyOne();
                    break;
                }
                if (cols[i].allowsNulls()) {
                    ((FKey)key).setSourceMultiplicityZeroOrMore();
                    break;
                }
                ((FKey)key).setSourceMultiplicityAtLeastOne();
                break;
            }
        }
    }

    protected void setForeignKeys(Table table, String schema, Column[] cols, ResultSet rs) throws SQLException {
        if (rs != null) {
            while (rs.next()) {
                String colName = rs.getString("FKCOLUMN_NAME");
                short seq = rs.getShort("KEY_SEQ");
                String keyName = rs.getString("FK_NAME");
                FKey key = new FKey(schema, table.getName(), colName, seq, keyName);
                String nativeSchema = rs.getString("PKTABLE_SCHEM");
                String nativeTable = rs.getString("PKTABLE_NAME");
                String nativeCol = rs.getString("PKCOLUMN_NAME");
                String nativeName = rs.getString("PK_NAME");
                key.setNativeData(nativeSchema, nativeTable, nativeCol, nativeName);
                key.setUpdateRule(this.getReferentialAction(rs.getShort("UPDATE_RULE")));
                key.setDeleteRule(this.getReferentialAction(rs.getShort("DELETE_RULE")));
                this.setKey(cols, colName, key);
            }
        }
    }

    private String getReferentialAction(short action) {
        String sAction = null;
        switch (action) {
            case 0: {
                sAction = "CASCADE";
                break;
            }
            case 2: {
                sAction = "SET NULL";
                break;
            }
            case 4: {
                sAction = "SET DEFAULT";
                break;
            }
            case 1: {
                sAction = "RESTRICT";
                break;
            }
            case 3: {
                sAction = "NO ACTION";
                break;
            }
        }
        return sAction;
    }

    protected void setIndexInfo(Table table, Column[] cols, ResultSet rs) throws SQLException {
        if (rs != null) {
            block0: while (rs.next()) {
                String colName = rs.getString("COLUMN_NAME");
                for (int i = 0; i < cols.length; ++i) {
                    if (!cols[i].getName().equalsIgnoreCase(colName)) continue;
                    if (cols[i].isPrimaryKey()) continue block0;
                    cols[i].setIndexInfo(rs.getString("INDEX_NAME"));
                    continue block0;
                }
            }
            table.markUniqueColumns();
        }
    }

    protected Column[] getColumns(String name, String schema) throws SQLException {
        ResultSet rs = null;
        if (((Database)this.repository).isDefaultSchema(schema) || !((DatabaseMetaData)this.dbmd).supportsSchemasInTableDefinitions()) {
            schema = null;
        }
        rs = ((DatabaseMetaData)this.dbmd).getColumns(null, schema, ((Database)this.repository).removeQuote(name), null);
        return this.makeColumns(rs);
    }

    protected Column[] makeColumns(Object resultset) throws SQLException {
        Column[] columns = null;
        if (resultset != null) {
            ResultSet rs = (ResultSet)resultset;
            ArrayList<Column> alColumns = new ArrayList<Column>();
            while (rs.next()) {
                Column column = this.newColumn(rs.getString("COLUMN_NAME"));
                String colDef = rs.getString("COLUMN_DEF");
                if (colDef != null) {
                    if (colDef.indexOf(39) < 0 && colDef.length() >= 0) {
                        column.setDefault(colDef);
                    }
                    if (colDef.length() >= 0 && colDef.indexOf(39) >= 0) {
                        int beginIndex = colDef.indexOf(39);
                        int lastIndex = colDef.lastIndexOf(39);
                        colDef = colDef.substring(beginIndex + 1, lastIndex);
                        column.setDefault(colDef);
                    }
                }
                this.setJDBCType(rs, column);
                column.setLength(rs.getInt("COLUMN_SIZE"));
                column.setScale(rs.getInt("DECIMAL_DIGITS"));
                alColumns.add(column);
            }
            rs.close();
            columns = alColumns.toArray(new Column[0]);
        }
        return columns;
    }

    protected void setJDBCType(Object resultset, Column column) throws SQLException {
        ResultSet rs = (ResultSet)resultset;
        column.setAllowsNulls(!"NO".equals(rs.getString("IS_NULLABLE")));
        column.setTypeName(rs.getString("TYPE_NAME"));
        short jdbcType = rs.getShort("DATA_TYPE");
        column.setJdbcType(jdbcType);
        column.setTypeNameJdbc(GenericDBMetadata.getPrimitiveTypeName(jdbcType));
    }

    public boolean supportsSchemaInTableDefinitions() throws SQLException {
        return ((DatabaseMetaData)this.dbmd).supportsSchemasInTableDefinitions();
    }

    protected String[] getNewTypes(ResultSet typeInfoRs) throws SQLException {
        String[] retTypes = null;
        if (typeInfoRs != null) {
            Vector<String> sqlTypes = new Vector<String>();
            String[] aSQLTypes = GenericDBMetadata.getPrimitiveTypes();
            for (int i = 0; i < aSQLTypes.length; ++i) {
                sqlTypes.add(aSQLTypes[i]);
            }
            ArrayList<String> newTypes = new ArrayList<String>();
            while (typeInfoRs.next()) {
                String name = typeInfoRs.getString("TYPE_NAME").toUpperCase();
                if (sqlTypes.contains(name)) continue;
                newTypes.add(name);
            }
            typeInfoRs.close();
            typeInfoRs = null;
            retTypes = newTypes.toArray(new String[newTypes.size()]);
        }
        return retTypes;
    }
}

