package sas_api

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeHitRatePie invokes the sas_api.DescribeHitRatePie API synchronously
// api document: https://help.aliyun.com/api/sas-api/describehitratepie.html
func (client *Client) DescribeHitRatePie(request *DescribeHitRatePieRequest) (response *DescribeHitRatePieResponse, err error) {
	response = CreateDescribeHitRatePieResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeHitRatePieWithChan invokes the sas_api.DescribeHitRatePie API asynchronously
// api document: https://help.aliyun.com/api/sas-api/describehitratepie.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeHitRatePieWithChan(request *DescribeHitRatePieRequest) (<-chan *DescribeHitRatePieResponse, <-chan error) {
	responseChan := make(chan *DescribeHitRatePieResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeHitRatePie(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeHitRatePieWithCallback invokes the sas_api.DescribeHitRatePie API asynchronously
// api document: https://help.aliyun.com/api/sas-api/describehitratepie.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeHitRatePieWithCallback(request *DescribeHitRatePieRequest, callback func(response *DescribeHitRatePieResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeHitRatePieResponse
		var err error
		defer close(result)
		response, err = client.DescribeHitRatePie(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeHitRatePieRequest is the request struct for api DescribeHitRatePie
type DescribeHitRatePieRequest struct {
	*requests.RpcRequest
	EndDate   string           `position:"Query" name:"EndDate"`
	SourceIp  string           `position:"Query" name:"SourceIp"`
	StartDate string           `position:"Query" name:"StartDate"`
	HitDay    requests.Integer `position:"Query" name:"HitDay"`
	ApiType   requests.Integer `position:"Query" name:"ApiType"`
}

// DescribeHitRatePieResponse is the response struct for api DescribeHitRatePie
type DescribeHitRatePieResponse struct {
	*responses.BaseResponse
	RequestId string                     `json:"RequestId" xml:"RequestId"`
	Items     []ItemInDescribeHitRatePie `json:"Items" xml:"Items"`
}

// CreateDescribeHitRatePieRequest creates a request to invoke DescribeHitRatePie API
func CreateDescribeHitRatePieRequest() (request *DescribeHitRatePieRequest) {
	request = &DescribeHitRatePieRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas-api", "2017-07-05", "DescribeHitRatePie", "sas-api", "openAPI")
	return
}

// CreateDescribeHitRatePieResponse creates a response to parse from DescribeHitRatePie response
func CreateDescribeHitRatePieResponse() (response *DescribeHitRatePieResponse) {
	response = &DescribeHitRatePieResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
