package market

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRate invokes the market.CreateRate API synchronously
// api document: https://help.aliyun.com/api/market/createrate.html
func (client *Client) CreateRate(request *CreateRateRequest) (response *CreateRateResponse, err error) {
	response = CreateCreateRateResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRateWithChan invokes the market.CreateRate API asynchronously
// api document: https://help.aliyun.com/api/market/createrate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateRateWithChan(request *CreateRateRequest) (<-chan *CreateRateResponse, <-chan error) {
	responseChan := make(chan *CreateRateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRateWithCallback invokes the market.CreateRate API asynchronously
// api document: https://help.aliyun.com/api/market/createrate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateRateWithCallback(request *CreateRateRequest, callback func(response *CreateRateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRateResponse
		var err error
		defer close(result)
		response, err = client.CreateRate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRateRequest is the request struct for api CreateRate
type CreateRateRequest struct {
	*requests.RpcRequest
	Score     string `position:"Query" name:"Score"`
	OrderId   string `position:"Query" name:"OrderId"`
	RequestId string `position:"Query" name:"RequestId"`
	Content   string `position:"Query" name:"Content"`
}

// CreateRateResponse is the response struct for api CreateRate
type CreateRateResponse struct {
	*responses.BaseResponse
	Id        int64  `json:"Id" xml:"Id"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateRateRequest creates a request to invoke CreateRate API
func CreateCreateRateRequest() (request *CreateRateRequest) {
	request = &CreateRateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Market", "2015-11-01", "CreateRate", "yunmarket", "openAPI")
	return
}

// CreateCreateRateResponse creates a response to parse from CreateRate response
func CreateCreateRateResponse() (response *CreateRateResponse) {
	response = &CreateRateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
