package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateJob invokes the iot.UpdateJob API synchronously
func (client *Client) UpdateJob(request *UpdateJobRequest) (response *UpdateJobResponse, err error) {
	response = CreateUpdateJobResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateJobWithChan invokes the iot.UpdateJob API asynchronously
func (client *Client) UpdateJobWithChan(request *UpdateJobRequest) (<-chan *UpdateJobResponse, <-chan error) {
	responseChan := make(chan *UpdateJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateJobWithCallback invokes the iot.UpdateJob API asynchronously
func (client *Client) UpdateJobWithCallback(request *UpdateJobRequest, callback func(response *UpdateJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateJobResponse
		var err error
		defer close(result)
		response, err = client.UpdateJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateJobRequest is the request struct for api UpdateJob
type UpdateJobRequest struct {
	*requests.RpcRequest
	Description   string `position:"Query" name:"Description"`
	RolloutConfig string `position:"Query" name:"RolloutConfig"`
	JobId         string `position:"Query" name:"JobId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	TimeoutConfig string `position:"Query" name:"TimeoutConfig"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// UpdateJobResponse is the response struct for api UpdateJob
type UpdateJobResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateUpdateJobRequest creates a request to invoke UpdateJob API
func CreateUpdateJobRequest() (request *UpdateJobRequest) {
	request = &UpdateJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "UpdateJob", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateJobResponse creates a response to parse from UpdateJob response
func CreateUpdateJobResponse() (response *UpdateJobResponse) {
	response = &UpdateJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
