package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUserIntentions invokes the companyreg.ListUserIntentions API synchronously
func (client *Client) ListUserIntentions(request *ListUserIntentionsRequest) (response *ListUserIntentionsResponse, err error) {
	response = CreateListUserIntentionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListUserIntentionsWithChan invokes the companyreg.ListUserIntentions API asynchronously
func (client *Client) ListUserIntentionsWithChan(request *ListUserIntentionsRequest) (<-chan *ListUserIntentionsResponse, <-chan error) {
	responseChan := make(chan *ListUserIntentionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUserIntentions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUserIntentionsWithCallback invokes the companyreg.ListUserIntentions API asynchronously
func (client *Client) ListUserIntentionsWithCallback(request *ListUserIntentionsRequest, callback func(response *ListUserIntentionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUserIntentionsResponse
		var err error
		defer close(result)
		response, err = client.ListUserIntentions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUserIntentionsRequest is the request struct for api ListUserIntentions
type ListUserIntentionsRequest struct {
	*requests.RpcRequest
	Area           string           `position:"Query" name:"Area"`
	BizTypes       string           `position:"Query" name:"BizTypes"`
	IntentionBizId string           `position:"Query" name:"IntentionBizId"`
	PageNum        requests.Integer `position:"Query" name:"PageNum"`
	SortFiled      string           `position:"Query" name:"SortFiled"`
	BizType        string           `position:"Query" name:"BizType"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	SortOrder      string           `position:"Query" name:"SortOrder"`
	Status         requests.Integer `position:"Query" name:"Status"`
}

// ListUserIntentionsResponse is the response struct for api ListUserIntentions
type ListUserIntentionsResponse struct {
	*responses.BaseResponse
	CurrentPageNum int         `json:"CurrentPageNum" xml:"CurrentPageNum"`
	TotalPageNum   int         `json:"TotalPageNum" xml:"TotalPageNum"`
	PageSize       int         `json:"PageSize" xml:"PageSize"`
	RequestId      string      `json:"RequestId" xml:"RequestId"`
	TotalItemNum   int         `json:"TotalItemNum" xml:"TotalItemNum"`
	Data           []Intention `json:"Data" xml:"Data"`
}

// CreateListUserIntentionsRequest creates a request to invoke ListUserIntentions API
func CreateListUserIntentionsRequest() (request *ListUserIntentionsRequest) {
	request = &ListUserIntentionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-03-06", "ListUserIntentions", "", "")
	request.Method = requests.POST
	return
}

// CreateListUserIntentionsResponse creates a response to parse from ListUserIntentions response
func CreateListUserIntentionsResponse() (response *ListUserIntentionsResponse) {
	response = &ListUserIntentionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
