package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetApRunHistoryTimeSer invokes the cloudwf.GetApRunHistoryTimeSer API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getaprunhistorytimeser.html
func (client *Client) GetApRunHistoryTimeSer(request *GetApRunHistoryTimeSerRequest) (response *GetApRunHistoryTimeSerResponse, err error) {
	response = CreateGetApRunHistoryTimeSerResponse()
	err = client.DoAction(request, response)
	return
}

// GetApRunHistoryTimeSerWithChan invokes the cloudwf.GetApRunHistoryTimeSer API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getaprunhistorytimeser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetApRunHistoryTimeSerWithChan(request *GetApRunHistoryTimeSerRequest) (<-chan *GetApRunHistoryTimeSerResponse, <-chan error) {
	responseChan := make(chan *GetApRunHistoryTimeSerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetApRunHistoryTimeSer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetApRunHistoryTimeSerWithCallback invokes the cloudwf.GetApRunHistoryTimeSer API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getaprunhistorytimeser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetApRunHistoryTimeSerWithCallback(request *GetApRunHistoryTimeSerRequest, callback func(response *GetApRunHistoryTimeSerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetApRunHistoryTimeSerResponse
		var err error
		defer close(result)
		response, err = client.GetApRunHistoryTimeSer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetApRunHistoryTimeSerRequest is the request struct for api GetApRunHistoryTimeSer
type GetApRunHistoryTimeSerRequest struct {
	*requests.RpcRequest
	Start requests.Integer `position:"Query" name:"Start"`
	End   requests.Integer `position:"Query" name:"End"`
	Id    requests.Integer `position:"Query" name:"Id"`
}

// GetApRunHistoryTimeSerResponse is the response struct for api GetApRunHistoryTimeSer
type GetApRunHistoryTimeSerResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetApRunHistoryTimeSerRequest creates a request to invoke GetApRunHistoryTimeSer API
func CreateGetApRunHistoryTimeSerRequest() (request *GetApRunHistoryTimeSerRequest) {
	request = &GetApRunHistoryTimeSerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetApRunHistoryTimeSer", "cloudwf", "openAPI")
	return
}

// CreateGetApRunHistoryTimeSerResponse creates a response to parse from GetApRunHistoryTimeSer response
func CreateGetApRunHistoryTimeSerResponse() (response *GetApRunHistoryTimeSerResponse) {
	response = &GetApRunHistoryTimeSerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
