/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.binding.xml;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jupnp.binding.xml.DescriptorBindingException;
import org.jupnp.binding.xml.UDA10DeviceDescriptorBinderImpl;
import org.jupnp.model.ValidationException;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.util.SpecificationViolationReporter;
import org.jupnp.xml.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

public class RecoveringUDA10DeviceDescriptorBinderImpl
extends UDA10DeviceDescriptorBinderImpl {
    private final Logger logger = LoggerFactory.getLogger(RecoveringUDA10DeviceDescriptorBinderImpl.class);

    @Override
    public <D extends Device> D describe(D undescribedDevice, String descriptorXml) throws DescriptorBindingException, ValidationException {
        block16: {
            D device = null;
            DescriptorBindingException originalException = null;
            try {
                try {
                    if (descriptorXml != null) {
                        descriptorXml = descriptorXml.trim();
                    }
                    String fixedXml = this.fixMimeTypes(descriptorXml);
                    fixedXml = this.fixWrongNamespaces(fixedXml);
                    device = super.describe(undescribedDevice, fixedXml = this.fixWemoMakerUDN(fixedXml));
                    if (this.isSonosGroupDevice(device)) {
                        throw new IllegalArgumentException("Ignore Sonos group devices due to invalid descriptor content.");
                    }
                    return device;
                }
                catch (DescriptorBindingException e) {
                    this.logger.warn("Regular parsing failed", (Throwable)e);
                    originalException = e;
                }
                catch (IllegalArgumentException e) {
                    this.handleInvalidDescriptor(descriptorXml, new DescriptorBindingException(e.getMessage()));
                }
                String fixedXml = this.fixGarbageLeadingChars(descriptorXml);
                if (fixedXml != null) {
                    try {
                        device = super.describe(undescribedDevice, fixedXml);
                        return device;
                    }
                    catch (DescriptorBindingException e) {
                        this.logger.warn("Removing leading garbage didn't work", (Throwable)e);
                    }
                }
                if ((fixedXml = this.fixGarbageTrailingChars(descriptorXml, originalException)) != null) {
                    try {
                        device = super.describe(undescribedDevice, fixedXml);
                        return device;
                    }
                    catch (DescriptorBindingException e) {
                        this.logger.warn("Removing trailing garbage didn't work", (Throwable)e);
                    }
                }
                DescriptorBindingException lastException = originalException;
                fixedXml = descriptorXml;
                int retryCount = 0;
                while (retryCount < 5) {
                    if ((fixedXml = this.fixMissingNamespaces(fixedXml, lastException)) == null) break;
                    try {
                        device = super.describe(undescribedDevice, fixedXml);
                        return device;
                    }
                    catch (DescriptorBindingException e) {
                        this.logger.warn("Fixing namespace prefix didn't work", (Throwable)e);
                        lastException = e;
                        ++retryCount;
                    }
                }
                this.handleInvalidDescriptor(descriptorXml, originalException);
            }
            catch (ValidationException e) {
                device = this.handleInvalidDevice(descriptorXml, device, e);
                if (device == null) break block16;
                return device;
            }
        }
        throw new IllegalStateException("No device produced, did you swallow exceptions in your subclass?");
    }

    private String fixGarbageLeadingChars(String descriptorXml) {
        int index = descriptorXml.indexOf("<?xml");
        if (index == -1) {
            return descriptorXml;
        }
        return descriptorXml.substring(index);
    }

    protected String fixGarbageTrailingChars(String descriptorXml, DescriptorBindingException e) {
        int index = descriptorXml.indexOf("</root>");
        if (index == -1) {
            SpecificationViolationReporter.report("No closing </root> element in descriptor", new Object[0]);
            return null;
        }
        if (descriptorXml.length() != index + "</root>".length()) {
            SpecificationViolationReporter.report("Detected garbage characters after <root> node, removing", new Object[0]);
            return descriptorXml.substring(0, index) + "</root>";
        }
        return null;
    }

    protected String fixMimeTypes(String descriptorXml) {
        if (descriptorXml.contains("<mimetype>jpg</mimetype>")) {
            SpecificationViolationReporter.report("Detected invalid mimetype 'jpg', replacing it with 'image/jpeg'", new Object[0]);
            return descriptorXml.replaceAll("<mimetype>jpg</mimetype>", "<mimetype>image/jpeg</mimetype>");
        }
        return descriptorXml;
    }

    protected String fixWrongNamespaces(String descriptorXml) {
        if (descriptorXml.contains("<root xmlns=\"urn:Belkin:device-1-0\">")) {
            SpecificationViolationReporter.report("Detected invalid root namespace 'urn:Belkin', replacing it with 'urn:schemas-upnp-org'", new Object[0]);
            return descriptorXml.replaceAll("<root xmlns=\"urn:Belkin:device-1-0\">", "<root xmlns=\"urn:schemas-upnp-org:device-1-0\">");
        }
        return descriptorXml;
    }

    protected String fixMissingNamespaces(String descriptorXml, DescriptorBindingException e) {
        Throwable cause = e.getCause();
        if (!(cause instanceof SAXParseException) && !(cause instanceof ParserException)) {
            return null;
        }
        String message = cause.getMessage();
        if (message == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("The prefix \"(.*)\" for element");
        Matcher matcher = pattern.matcher(message);
        if (!(matcher.find() && matcher.groupCount() == 1 || (matcher = (pattern = Pattern.compile("undefined prefix: ([^ ]*)")).matcher(message)).find() && matcher.groupCount() == 1)) {
            return null;
        }
        String missingNS = matcher.group(1);
        SpecificationViolationReporter.report("Fixing missing namespace declaration for: {}", missingNS);
        pattern = Pattern.compile("<root([^>]*)");
        matcher = pattern.matcher(descriptorXml);
        if (!matcher.find() || matcher.groupCount() != 1) {
            this.logger.trace("Could not find <root> element attributes");
            return null;
        }
        String rootAttributes = matcher.group(1);
        this.logger.trace("Preserving existing <root> element attributes/namespace declarations: {}", (Object)matcher.group(0));
        pattern = Pattern.compile("<root[^>]*>(.*)</root>", 32);
        matcher = pattern.matcher(descriptorXml);
        if (!matcher.find() || matcher.groupCount() != 1) {
            this.logger.trace("Could not extract body of <root> element");
            return null;
        }
        String rootBody = matcher.group(1);
        return "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><root " + String.format("xmlns:%s=\"urn:schemas-dlna-org:device-1-0\"", missingNS) + rootAttributes + ">" + rootBody + "</root>";
    }

    protected String fixWemoMakerUDN(String descriptorXml) {
        if (descriptorXml.contains(":sensor:switch")) {
            SpecificationViolationReporter.report("Detected invalid UDN value ':sensor:switch', replacing it", new Object[0]);
            descriptorXml = descriptorXml.replaceAll(":sensor:switch", "");
            return descriptorXml.replaceAll(":sensor:switch", "");
        }
        return descriptorXml;
    }

    protected void handleInvalidDescriptor(String xml, DescriptorBindingException exception) throws DescriptorBindingException {
        throw exception;
    }

    protected <D extends Device> D handleInvalidDevice(String xml, D device, ValidationException exception) throws ValidationException {
        throw exception;
    }

    private <D extends Device> boolean isSonosGroupDevice(D device) {
        if (device instanceof RemoteDevice) {
            RemoteDevice rd = (RemoteDevice)device;
            return this.isGroupInformationAvailable(rd) && rd.getDetails().getManufacturerDetails().getManufacturer().toLowerCase().contains("sonos") && rd.getType().toString().contains("urn:smartspeaker-audio:device:SpeakerGroup") && ((RemoteDeviceIdentity)rd.getIdentity()).getDescriptorURL().toString().endsWith("group_description.xml");
        }
        return false;
    }

    private boolean isGroupInformationAvailable(RemoteDevice rd) {
        return rd != null && rd.getType() != null && rd.getIdentity() != null && rd.getDetails() != null && rd.getDetails().getManufacturerDetails() != null && rd.getDetails().getManufacturerDetails().getManufacturer() != null && ((RemoteDeviceIdentity)rd.getIdentity()).getDescriptorURL() != null;
    }
}

