// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::rename_object::_rename_object_output::RenameObjectOutputBuilder;

pub use crate::operation::rename_object::_rename_object_input::RenameObjectInputBuilder;

impl crate::operation::rename_object::builders::RenameObjectInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::rename_object::RenameObjectOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::rename_object::RenameObjectError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.rename_object();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `RenameObject`.
///
/// <p>Renames an existing object in a directory bucket that uses the S3 Express One Zone storage class. You can use <code>RenameObject</code> by specifying an existing object’s name as the source and the new name of the object as the destination within the same directory bucket.</p><note>
/// <p><code>RenameObject</code> is only supported for objects stored in the S3 Express One Zone storage class.</p>
/// </note>
/// <p>To prevent overwriting an object, you can use the <code>If-None-Match</code> conditional header.</p>
/// <ul>
/// <li>
/// <p><b>If-None-Match</b> - Renames the object only if an object with the specified name does not already exist in the directory bucket. If you don't want to overwrite an existing object, you can add the <code>If-None-Match</code> conditional header with the value <code>‘*’</code> in the <code>RenameObject</code> request. Amazon S3 then returns a <code>412 Precondition Failed</code> error if the object with the specified name already exists. For more information, see <a href="https://datatracker.ietf.org/doc/rfc7232/">RFC 7232</a>.</p></li>
/// </ul>
/// <dl>
/// <dt>
/// Permissions
/// </dt>
/// <dd>
/// <p>To grant access to the <code>RenameObject</code> operation on a directory bucket, we recommend that you use the <code>CreateSession</code> operation for session-based authorization. Specifically, you grant the <code>s3express:CreateSession</code> permission to the directory bucket in a bucket policy or an IAM identity-based policy. Then, you make the <code>CreateSession</code> API call on the directory bucket to obtain a session token. With the session token in your request header, you can make API requests to this operation. After the session token expires, you make another <code>CreateSession</code> API call to generate a new session token for use. The Amazon Web Services CLI and SDKs will create and manage your session including refreshing the session token automatically to avoid service interruptions when a session expires. In your bucket policy, you can specify the <code>s3express:SessionMode</code> condition key to control who can create a <code>ReadWrite</code> or <code>ReadOnly</code> session. A <code>ReadWrite</code> session is required for executing all the Zonal endpoint API operations, including <code>RenameObject</code>. For more information about authorization, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateSession.html"> <code>CreateSession</code> </a>. To learn more about Zonal endpoint API operations, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-express-create-session.html">Authorizing Zonal endpoint API operations with CreateSession</a> in the <i>Amazon S3 User Guide</i>.</p>
/// </dd>
/// <dt>
/// HTTP Host header syntax
/// </dt>
/// <dd>
/// <p><b>Directory buckets </b> - The HTTP Host header syntax is <code> <i>Bucket-name</i>.s3express-<i>zone-id</i>.<i>region-code</i>.amazonaws.com</code>.</p>
/// </dd>
/// </dl>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct RenameObjectFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::rename_object::builders::RenameObjectInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::rename_object::RenameObjectOutput,
        crate::operation::rename_object::RenameObjectError,
    > for RenameObjectFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::rename_object::RenameObjectOutput,
            crate::operation::rename_object::RenameObjectError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl RenameObjectFluentBuilder {
    /// Creates a new `RenameObjectFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the RenameObject as a reference.
    pub fn as_input(&self) -> &crate::operation::rename_object::builders::RenameObjectInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::rename_object::RenameObjectOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::rename_object::RenameObjectError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::rename_object::RenameObject::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::rename_object::RenameObject::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::rename_object::RenameObjectOutput,
        crate::operation::rename_object::RenameObjectError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The bucket name of the directory bucket containing the object.</p>
    /// <p>You must use virtual-hosted-style requests in the format <code>Bucket-name.s3express-zone-id.region-code.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code>bucket-base-name--zone-id--x-s3 </code> (for example, <code>amzn-s3-demo-bucket--usw2-az1--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn bucket(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.bucket(input.into());
        self
    }
    /// <p>The bucket name of the directory bucket containing the object.</p>
    /// <p>You must use virtual-hosted-style requests in the format <code>Bucket-name.s3express-zone-id.region-code.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code>bucket-base-name--zone-id--x-s3 </code> (for example, <code>amzn-s3-demo-bucket--usw2-az1--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn set_bucket(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_bucket(input);
        self
    }
    /// <p>The bucket name of the directory bucket containing the object.</p>
    /// <p>You must use virtual-hosted-style requests in the format <code>Bucket-name.s3express-zone-id.region-code.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format <code>bucket-base-name--zone-id--x-s3 </code> (for example, <code>amzn-s3-demo-bucket--usw2-az1--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn get_bucket(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_bucket()
    }
    /// <p>Key name of the object to rename.</p>
    pub fn key(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.key(input.into());
        self
    }
    /// <p>Key name of the object to rename.</p>
    pub fn set_key(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_key(input);
        self
    }
    /// <p>Key name of the object to rename.</p>
    pub fn get_key(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_key()
    }
    /// <p>Specifies the source for the rename operation. The value must be URL encoded.</p>
    pub fn rename_source(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.rename_source(input.into());
        self
    }
    /// <p>Specifies the source for the rename operation. The value must be URL encoded.</p>
    pub fn set_rename_source(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_rename_source(input);
        self
    }
    /// <p>Specifies the source for the rename operation. The value must be URL encoded.</p>
    pub fn get_rename_source(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_rename_source()
    }
    /// <p>Renames the object only if the ETag (entity tag) value provided during the operation matches the ETag of the object in S3. The <code>If-Match</code> header field makes the request method conditional on ETags. If the ETag values do not match, the operation returns a <code>412 Precondition Failed</code> error.</p>
    /// <p>Expects the ETag value as a string.</p>
    pub fn destination_if_match(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.destination_if_match(input.into());
        self
    }
    /// <p>Renames the object only if the ETag (entity tag) value provided during the operation matches the ETag of the object in S3. The <code>If-Match</code> header field makes the request method conditional on ETags. If the ETag values do not match, the operation returns a <code>412 Precondition Failed</code> error.</p>
    /// <p>Expects the ETag value as a string.</p>
    pub fn set_destination_if_match(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_destination_if_match(input);
        self
    }
    /// <p>Renames the object only if the ETag (entity tag) value provided during the operation matches the ETag of the object in S3. The <code>If-Match</code> header field makes the request method conditional on ETags. If the ETag values do not match, the operation returns a <code>412 Precondition Failed</code> error.</p>
    /// <p>Expects the ETag value as a string.</p>
    pub fn get_destination_if_match(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_destination_if_match()
    }
    /// <p>Renames the object only if the destination does not already exist in the specified directory bucket. If the object does exist when you send a request with <code>If-None-Match:*</code>, the S3 API will return a <code>412 Precondition Failed</code> error, preventing an overwrite. The <code>If-None-Match</code> header prevents overwrites of existing data by validating that there's not an object with the same key name already in your directory bucket.</p>
    /// <p>Expects the <code>*</code> character (asterisk).</p>
    pub fn destination_if_none_match(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.destination_if_none_match(input.into());
        self
    }
    /// <p>Renames the object only if the destination does not already exist in the specified directory bucket. If the object does exist when you send a request with <code>If-None-Match:*</code>, the S3 API will return a <code>412 Precondition Failed</code> error, preventing an overwrite. The <code>If-None-Match</code> header prevents overwrites of existing data by validating that there's not an object with the same key name already in your directory bucket.</p>
    /// <p>Expects the <code>*</code> character (asterisk).</p>
    pub fn set_destination_if_none_match(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_destination_if_none_match(input);
        self
    }
    /// <p>Renames the object only if the destination does not already exist in the specified directory bucket. If the object does exist when you send a request with <code>If-None-Match:*</code>, the S3 API will return a <code>412 Precondition Failed</code> error, preventing an overwrite. The <code>If-None-Match</code> header prevents overwrites of existing data by validating that there's not an object with the same key name already in your directory bucket.</p>
    /// <p>Expects the <code>*</code> character (asterisk).</p>
    pub fn get_destination_if_none_match(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_destination_if_none_match()
    }
    /// <p>Renames the object if the destination exists and if it has been modified since the specified time.</p>
    pub fn destination_if_modified_since(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.inner = self.inner.destination_if_modified_since(input);
        self
    }
    /// <p>Renames the object if the destination exists and if it has been modified since the specified time.</p>
    pub fn set_destination_if_modified_since(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.inner = self.inner.set_destination_if_modified_since(input);
        self
    }
    /// <p>Renames the object if the destination exists and if it has been modified since the specified time.</p>
    pub fn get_destination_if_modified_since(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        self.inner.get_destination_if_modified_since()
    }
    /// <p>Renames the object if it hasn't been modified since the specified time.</p>
    pub fn destination_if_unmodified_since(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.inner = self.inner.destination_if_unmodified_since(input);
        self
    }
    /// <p>Renames the object if it hasn't been modified since the specified time.</p>
    pub fn set_destination_if_unmodified_since(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.inner = self.inner.set_destination_if_unmodified_since(input);
        self
    }
    /// <p>Renames the object if it hasn't been modified since the specified time.</p>
    pub fn get_destination_if_unmodified_since(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        self.inner.get_destination_if_unmodified_since()
    }
    /// <p>Renames the object if the source exists and if its entity tag (ETag) matches the specified ETag.</p>
    pub fn source_if_match(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.source_if_match(input.into());
        self
    }
    /// <p>Renames the object if the source exists and if its entity tag (ETag) matches the specified ETag.</p>
    pub fn set_source_if_match(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_source_if_match(input);
        self
    }
    /// <p>Renames the object if the source exists and if its entity tag (ETag) matches the specified ETag.</p>
    pub fn get_source_if_match(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_source_if_match()
    }
    /// <p>Renames the object if the source exists and if its entity tag (ETag) is different than the specified ETag. If an asterisk (<code>*</code>) character is provided, the operation will fail and return a <code>412 Precondition Failed</code> error.</p>
    pub fn source_if_none_match(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.source_if_none_match(input.into());
        self
    }
    /// <p>Renames the object if the source exists and if its entity tag (ETag) is different than the specified ETag. If an asterisk (<code>*</code>) character is provided, the operation will fail and return a <code>412 Precondition Failed</code> error.</p>
    pub fn set_source_if_none_match(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_source_if_none_match(input);
        self
    }
    /// <p>Renames the object if the source exists and if its entity tag (ETag) is different than the specified ETag. If an asterisk (<code>*</code>) character is provided, the operation will fail and return a <code>412 Precondition Failed</code> error.</p>
    pub fn get_source_if_none_match(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_source_if_none_match()
    }
    /// <p>Renames the object if the source exists and if it has been modified since the specified time.</p>
    pub fn source_if_modified_since(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.inner = self.inner.source_if_modified_since(input);
        self
    }
    /// <p>Renames the object if the source exists and if it has been modified since the specified time.</p>
    pub fn set_source_if_modified_since(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.inner = self.inner.set_source_if_modified_since(input);
        self
    }
    /// <p>Renames the object if the source exists and if it has been modified since the specified time.</p>
    pub fn get_source_if_modified_since(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        self.inner.get_source_if_modified_since()
    }
    /// <p>Renames the object if the source exists and hasn't been modified since the specified time.</p>
    pub fn source_if_unmodified_since(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.inner = self.inner.source_if_unmodified_since(input);
        self
    }
    /// <p>Renames the object if the source exists and hasn't been modified since the specified time.</p>
    pub fn set_source_if_unmodified_since(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.inner = self.inner.set_source_if_unmodified_since(input);
        self
    }
    /// <p>Renames the object if the source exists and hasn't been modified since the specified time.</p>
    pub fn get_source_if_unmodified_since(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        self.inner.get_source_if_unmodified_since()
    }
    /// <p>A unique string with a max of 64 ASCII characters in the ASCII range of 33 - 126.</p><note>
    /// <p><code>RenameObject</code> supports idempotency using a client token. To make an idempotent API request using <code>RenameObject</code>, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails and an <code>IdempotentParameterMismatch</code> error is returned.</p>
    /// </note>
    pub fn client_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.client_token(input.into());
        self
    }
    /// <p>A unique string with a max of 64 ASCII characters in the ASCII range of 33 - 126.</p><note>
    /// <p><code>RenameObject</code> supports idempotency using a client token. To make an idempotent API request using <code>RenameObject</code>, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails and an <code>IdempotentParameterMismatch</code> error is returned.</p>
    /// </note>
    pub fn set_client_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_client_token(input);
        self
    }
    /// <p>A unique string with a max of 64 ASCII characters in the ASCII range of 33 - 126.</p><note>
    /// <p><code>RenameObject</code> supports idempotency using a client token. To make an idempotent API request using <code>RenameObject</code>, specify a client token in the request. You should not reuse the same client token for other API requests. If you retry a request that completed successfully using the same client token and the same parameters, the retry succeeds without performing any further actions. If you retry a successful request using the same client token, but one or more of the parameters are different, the retry fails and an <code>IdempotentParameterMismatch</code> error is returned.</p>
    /// </note>
    pub fn get_client_token(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_client_token()
    }
}
