/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.helper;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.asamk.signal.manager.api.PhoneNumberSharingMode;
import org.asamk.signal.manager.api.Profile;
import org.asamk.signal.manager.helper.Context;
import org.asamk.signal.manager.internal.SignalDependencies;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.util.Utils;
import org.jetbrains.annotations.Nullable;
import org.signal.libsignal.metadata.certificate.InvalidCertificateException;
import org.signal.libsignal.metadata.certificate.SenderCertificate;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.crypto.SealedSenderAccess;
import org.whispersystems.signalservice.api.crypto.UnidentifiedAccess;

public class UnidentifiedAccessHelper {
    private static final Logger logger = LoggerFactory.getLogger(UnidentifiedAccessHelper.class);
    private static final long CERTIFICATE_EXPIRATION_BUFFER = TimeUnit.DAYS.toMillis(1L);
    private static final byte[] UNRESTRICTED_KEY = new byte[16];
    private final SignalAccount account;
    private final SignalDependencies dependencies;
    private final Context context;
    private SenderCertificate privacySenderCertificate;
    private SenderCertificate senderCertificate;

    public UnidentifiedAccessHelper(Context context) {
        this.account = context.getAccount();
        this.dependencies = context.getDependencies();
        this.context = context;
    }

    public void rotateSenderCertificates() {
        this.privacySenderCertificate = null;
        this.senderCertificate = null;
    }

    public List<SealedSenderAccess> getSealedSenderAccessFor(List<RecipientId> recipients) {
        return recipients.stream().map(this::getAccessFor).map(SealedSenderAccess::forIndividual).toList();
    }

    @Nullable
    public SealedSenderAccess getSealedSenderAccessFor(RecipientId recipient) {
        return this.getSealedSenderAccessFor(recipient, false);
    }

    @Nullable
    public SealedSenderAccess getSealedSenderAccessFor(RecipientId recipient, boolean noRefresh) {
        return SealedSenderAccess.forIndividual((UnidentifiedAccess)this.getAccessFor(recipient, noRefresh));
    }

    public Map<RecipientId, UnidentifiedAccess> getAccessFor(Collection<RecipientId> recipients) {
        HashMap<RecipientId, UnidentifiedAccess> result = new HashMap<RecipientId, UnidentifiedAccess>();
        for (RecipientId recipient : recipients) {
            UnidentifiedAccess access = this.getAccessFor(recipient);
            if (access == null) continue;
            result.put(recipient, access);
        }
        return result;
    }

    @Nullable
    private UnidentifiedAccess getAccessFor(RecipientId recipient) {
        return this.getAccessFor(recipient, false);
    }

    @Nullable
    private UnidentifiedAccess getAccessFor(RecipientId recipientId, boolean noRefresh) {
        byte[] recipientUnidentifiedAccessKey = this.getTargetUnidentifiedAccessKey(recipientId, noRefresh);
        if (recipientUnidentifiedAccessKey == null) {
            logger.trace("Unidentified access not available for {}", (Object)recipientId);
            return null;
        }
        byte[] selfUnidentifiedAccessKey = this.getSelfUnidentifiedAccessKey(noRefresh);
        if (selfUnidentifiedAccessKey == null) {
            logger.trace("Unidentified access not available for self");
            return null;
        }
        SenderCertificate senderCertificate = this.getSenderCertificateFor(recipientId);
        if (senderCertificate == null) {
            logger.trace("Unidentified access not available due to missing sender certificate");
            return null;
        }
        try {
            return new UnidentifiedAccess(recipientUnidentifiedAccessKey, senderCertificate.getSerialized(), false);
        }
        catch (InvalidCertificateException e) {
            return null;
        }
    }

    public SenderCertificate getSenderCertificateFor(RecipientId recipientId) {
        PhoneNumberSharingMode sharingMode = this.account.getConfigurationStore().getPhoneNumberSharingMode();
        if (sharingMode == PhoneNumberSharingMode.EVERYBODY || recipientId != null && sharingMode == PhoneNumberSharingMode.CONTACTS && this.account.getContactStore().getContact(recipientId) != null) {
            logger.trace("Using normal sender certificate for message to {}", (Object)recipientId);
            return this.getSenderCertificate();
        }
        logger.trace("Using phone number privacy sender certificate for message to {}", (Object)recipientId);
        return this.getSenderCertificateForPhoneNumberPrivacy();
    }

    private SenderCertificate getSenderCertificateForPhoneNumberPrivacy() {
        if (this.privacySenderCertificate != null && System.currentTimeMillis() < this.privacySenderCertificate.getExpiration() - CERTIFICATE_EXPIRATION_BUFFER) {
            return this.privacySenderCertificate;
        }
        try {
            byte[] certificate = (byte[])Utils.handleResponseException(this.dependencies.getCertificateApi().getSenderCertificateForPhoneNumberPrivacy());
            this.privacySenderCertificate = new SenderCertificate(certificate);
            return this.privacySenderCertificate;
        }
        catch (IOException | InvalidCertificateException e) {
            logger.warn("Failed to get sender certificate (pnp), ignoring: {}", (Object)e.getMessage());
            return null;
        }
    }

    private SenderCertificate getSenderCertificate() {
        if (this.senderCertificate != null && System.currentTimeMillis() < this.senderCertificate.getExpiration() - CERTIFICATE_EXPIRATION_BUFFER) {
            return this.senderCertificate;
        }
        try {
            byte[] certificate = (byte[])Utils.handleResponseException(this.dependencies.getCertificateApi().getSenderCertificate());
            this.senderCertificate = new SenderCertificate(certificate);
            return this.senderCertificate;
        }
        catch (IOException | InvalidCertificateException e) {
            logger.warn("Failed to get sender certificate, ignoring: {}", (Object)e.getMessage());
            return null;
        }
    }

    private byte[] getSelfUnidentifiedAccessKey(boolean noRefresh) {
        Profile selfProfile;
        Profile profile = selfProfile = noRefresh ? this.account.getProfileStore().getProfile(this.account.getSelfRecipientId()) : this.context.getProfileHelper().getSelfProfile();
        if (selfProfile != null && selfProfile.getUnidentifiedAccessMode() == Profile.UnidentifiedAccessMode.UNRESTRICTED) {
            return UnidentifiedAccessHelper.createUnrestrictedUnidentifiedAccess();
        }
        return UnidentifiedAccess.deriveAccessKeyFrom((ProfileKey)this.account.getProfileKey());
    }

    private byte[] getTargetUnidentifiedAccessKey(RecipientId recipientId, boolean noRefresh) {
        Profile targetProfile;
        Profile profile = targetProfile = noRefresh ? this.account.getProfileStore().getProfile(recipientId) : this.context.getProfileHelper().getRecipientProfile(recipientId);
        if (targetProfile == null) {
            return null;
        }
        ProfileKey theirProfileKey = this.account.getProfileStore().getProfileKey(recipientId);
        return UnidentifiedAccessHelper.getTargetUnidentifiedAccessKey(targetProfile, theirProfileKey);
    }

    private static byte[] getTargetUnidentifiedAccessKey(Profile targetProfile, ProfileKey theirProfileKey) {
        return switch (targetProfile.getUnidentifiedAccessMode()) {
            case Profile.UnidentifiedAccessMode.ENABLED -> {
                if (theirProfileKey == null) {
                    yield null;
                }
                yield UnidentifiedAccess.deriveAccessKeyFrom((ProfileKey)theirProfileKey);
            }
            case Profile.UnidentifiedAccessMode.UNRESTRICTED -> UnidentifiedAccessHelper.createUnrestrictedUnidentifiedAccess();
            default -> null;
        };
    }

    private static byte[] createUnrestrictedUnidentifiedAccess() {
        return UNRESTRICTED_KEY;
    }
}

