/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.dbus;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeoutException;
import org.asamk.SignalControl;
import org.asamk.signal.manager.ProvisioningManager;
import org.asamk.signal.manager.api.UserAlreadyExistsException;
import org.freedesktop.dbus.connections.impl.DBusConnection;

public class DbusProvisioningManagerImpl
implements ProvisioningManager {
    private final SignalControl signalControl;
    private final DBusConnection connection;
    private URI deviceLinkUri;

    public DbusProvisioningManagerImpl(SignalControl signalControl, DBusConnection connection) {
        this.signalControl = signalControl;
        this.connection = connection;
    }

    public DbusProvisioningManagerImpl(SignalControl signalControl, DBusConnection connection, URI deviceLinkUri) {
        this.signalControl = signalControl;
        this.connection = connection;
        this.deviceLinkUri = deviceLinkUri;
    }

    public URI getDeviceLinkUri() throws TimeoutException, IOException {
        try {
            this.deviceLinkUri = new URI(this.signalControl.startLink());
            return this.deviceLinkUri;
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public String finishDeviceLink(String deviceName) throws IOException, TimeoutException, UserAlreadyExistsException {
        return this.signalControl.finishLink(this.deviceLinkUri.toString(), deviceName);
    }
}

