/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.Base64;
import java.util.Objects;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.UnexpectedErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.json.JsonAttachmentData;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.UnregisteredRecipientException;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.output.PlainTextWriter;
import org.asamk.signal.util.CommandUtil;

public class GetAvatarCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "getAvatar";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Retrieve the avatar of a contact, contact's profile or group base64 encoded.");
        MutuallyExclusiveGroup mut = subparser.addMutuallyExclusiveGroup().required(true);
        mut.addArgument(new String[]{"-c", "--contact"}).help("Get a contact avatar");
        mut.addArgument(new String[]{"-p", "--profile"}).help("Get a profile avatar");
        mut.addArgument(new String[]{"-g", "--group-id"}).help("Get a group avatar");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        InputStream data;
        String contactRecipient = ns.getString("contact");
        String profileRecipient = ns.getString("profile");
        String groupId = ns.getString("group-id");
        try {
            data = contactRecipient != null ? m.retrieveContactAvatar(CommandUtil.getSingleRecipientIdentifier(contactRecipient, m.getSelfNumber())) : (profileRecipient != null ? m.retrieveProfileAvatar(CommandUtil.getSingleRecipientIdentifier(profileRecipient, m.getSelfNumber())) : m.retrieveGroupAvatar(CommandUtil.getGroupId(groupId)));
        }
        catch (FileNotFoundException ex) {
            throw new UserErrorException("Could not find avatar", ex);
        }
        catch (IOException ex) {
            throw new UnexpectedErrorException("An error occurred reading avatar", ex);
        }
        catch (UnregisteredRecipientException e) {
            throw new UserErrorException("The user " + e.getSender().getIdentifier() + " is not registered.");
        }
        try (InputStream e = data;){
            byte[] bytes = data.readAllBytes();
            String base64 = Base64.getEncoder().encodeToString(bytes);
            OutputWriter outputWriter2 = outputWriter;
            Objects.requireNonNull(outputWriter2);
            OutputWriter outputWriter3 = outputWriter2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlainTextWriter.class, JsonWriter.class}, (Object)outputWriter3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    PlainTextWriter writer = (PlainTextWriter)outputWriter3;
                    writer.println(base64, new Object[0]);
                    return;
                }
                case 1: {
                    JsonWriter writer = (JsonWriter)outputWriter3;
                    writer.write(new JsonAttachmentData(base64));
                    return;
                }
            }
        }
        catch (IOException ex) {
            throw new UnexpectedErrorException("An error occurred reading avatar", ex);
        }
    }
}

