/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup.calllinks;

import java.security.SecureRandom;
import java.time.Instant;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.zkgroup.GenericServerSecretParams;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.calllinks.CreateCallLinkCredentialResponse;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class CreateCallLinkCredentialRequest
extends ByteArray {
    public CreateCallLinkCredentialRequest(byte[] contents) throws InvalidInputException {
        super(contents);
        FilterExceptions.filterExceptions(InvalidInputException.class, () -> Native.CreateCallLinkCredentialRequest_CheckValidContents(contents));
    }

    public CreateCallLinkCredentialResponse issueCredential(ServiceId.Aci userId, Instant timestamp, GenericServerSecretParams params) {
        return this.issueCredential(userId, timestamp, params, new SecureRandom());
    }

    public CreateCallLinkCredentialResponse issueCredential(ServiceId.Aci userId, Instant timestamp, GenericServerSecretParams params, SecureRandom secureRandom) {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = Native.CreateCallLinkCredentialRequest_IssueDeterministic(this.getInternalContentsForJNI(), userId.toServiceIdFixedWidthBinary(), timestamp.getEpochSecond(), params.getInternalContentsForJNI(), random);
        try {
            return new CreateCallLinkCredentialResponse(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }
}

